/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import oracle.help.common.IndirectTarget;
import oracle.help.common.Target;
import oracle.help.common.Topic;
import oracle.help.common.TopicTree;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.View;
import oracle.help.common.xml.Parser;
import oracle.help.common.xml.ParserFactory;
import oracle.help.common.xml.XMLNode;
import oracle.help.common.xml.XMLParseException;
import oracle.help.engine.DataEngine;
import oracle.help.library.Book;
import oracle.jdevimpl.help.MultipleTypeTopic;

public class JDevXMLTOCEngine
extends DataEngine {
    private Book _book;
    private String _basePath;
    private static final String TAG_TOC = "toc";
    private static final String TAG_TOCITEM = "tocitem";
    private static final String PROP_ID = "target";
    private static final String PROP_TEXT = "text";
    private static final String PROP_IMAGE = "image";
    private static final String PROP_ID_TYPE = "topicType";

    public Object createDataObject(View view, String string, URL uRL, String string2) throws IOException {
        if (uRL == null) {
            throw new IllegalArgumentException("Null parameter passed to DataEngine constructor");
        }
        BufferedReader bufferedReader = this._getBufferedReader(uRL, string2);
        return this.createDataObject(view, string, bufferedReader);
    }

    public Object createDataObject(View view, String string, BufferedReader bufferedReader) throws IOException {
        this._book = null;
        this._basePath = string;
        if (view != null) {
            this._book = view.getBook();
        }
        TopicTree topicTree = new TopicTree(this._book, string);
        TopicTreeNode topicTreeNode = topicTree.getRoot();
        Parser parser = ParserFactory.createParser((Reader)bufferedReader);
        XMLNode xMLNode = parser.getRoot();
        this._handleToc(xMLNode.getFirstChild(), topicTreeNode, view);
        return topicTree;
    }

    private void _handleToc(XMLNode xMLNode, TopicTreeNode topicTreeNode, View view) throws XMLParseException {
        if (xMLNode == null) {
            throw new XMLParseException("No toplevel tag");
        }
        if (!xMLNode.getTokenValue().equalsIgnoreCase(TAG_TOC)) {
            throw new XMLParseException("Toplevel tag is not TOC: " + xMLNode.getTokenValue());
        }
        xMLNode = xMLNode.getFirstChild();
        while (xMLNode != null) {
            this._handleTocItem(xMLNode, topicTreeNode, view);
            xMLNode = xMLNode.getNextSibling();
        }
    }

    private void _handleTocItem(XMLNode xMLNode, TopicTreeNode topicTreeNode, View view) throws XMLParseException {
        if (!xMLNode.getTokenValue().equalsIgnoreCase(TAG_TOCITEM)) {
            throw new XMLParseException("Tag is not tocitem: " + xMLNode.getTokenValue());
        }
        String string = xMLNode.getTokenProperty(PROP_ID);
        String string2 = xMLNode.getTokenProperty(PROP_IMAGE);
        String string3 = xMLNode.getTokenProperty(PROP_TEXT);
        String string4 = xMLNode.getTokenProperty(PROP_ID_TYPE);
        MultipleTypeTopic multipleTypeTopic = null;
        if (string4 != null) {
            multipleTypeTopic = new MultipleTypeTopic(string3, string, string4);
        } else {
            multipleTypeTopic = new MultipleTypeTopic(string3, this._book);
            if (string != null) {
                IndirectTarget indirectTarget = new IndirectTarget(this._book, string);
                multipleTypeTopic.setTarget((Target)indirectTarget);
            }
        }
        if (string2 != null) {
            IndirectTarget indirectTarget = new IndirectTarget(this._book, string2);
            multipleTypeTopic.setDefaultIcon((Target)indirectTarget);
        }
        TopicTreeNode topicTreeNode2 = new TopicTreeNode(view, (Topic)multipleTypeTopic);
        topicTreeNode.addChild(topicTreeNode2);
        xMLNode = xMLNode.getFirstChild();
        while (xMLNode != null) {
            this._handleTocItem(xMLNode, topicTreeNode2, view);
            xMLNode = xMLNode.getNextSibling();
        }
    }
}

