/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import oracle.bali.ewt.util.WindowUtils;
import oracle.help.common.Topic;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.library.Library;
import oracle.ide.help.HelpSystem;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpContentPanel;
import oracle.jdevimpl.help.JDevHelpSystemImpl;

public final class ModalHelpContentDialog
extends JDialog {
    private ModalContentWindowAdapter _windowAdapter;
    private HelpContentPanel _helpContentPanel;
    private ArrayList _ownerList;
    private Library _library;

    void $init$() {
        this._ownerList = new ArrayList();
    }

    public ModalHelpContentDialog(Dialog dialog, Library library, ModalHelpContentDialog modalHelpContentDialog) {
        super(dialog);
        this.$init$();
        this._ownerList.add(dialog);
        this._commonInit(dialog, library, modalHelpContentDialog);
    }

    public ModalHelpContentDialog(Frame frame, Library library, ModalHelpContentDialog modalHelpContentDialog) {
        super(frame);
        this.$init$();
        this._commonInit(frame, library, modalHelpContentDialog);
    }

    private void _commonInit(Component component, Library library, ModalHelpContentDialog modalHelpContentDialog) {
        WindowUtils.registerWindow((Window)this);
        this._library = library;
        if (modalHelpContentDialog == null) {
            this._helpContentPanel = new HelpContentPanel(library, false, true, this);
            this.setTitle(HelpArb.getString(58));
            ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.help.resource.Defaults", StaticLocaleContext.getLocale());
            String string = resourceBundle.getString("topicwin.width");
            String string2 = resourceBundle.getString("topicwin.height");
            this.setSize(Integer.parseInt(string), Integer.parseInt(string2));
            this.setLocationRelativeTo(component);
        } else {
            this._helpContentPanel = modalHelpContentDialog._getHelpContentPanel();
            modalHelpContentDialog._clearHelpContentPanel();
            this._ownerList.addAll(modalHelpContentDialog._getOwnerList());
            WindowUtils.unregisterWindow((Window)modalHelpContentDialog);
            this.setSize(modalHelpContentDialog.getSize());
            this.setLocation(modalHelpContentDialog.getLocation());
            if (modalHelpContentDialog._getWindowAdapter() != null) {
                modalHelpContentDialog.removeWindowListener(modalHelpContentDialog._getWindowAdapter());
            }
            modalHelpContentDialog.dispose();
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this._helpContentPanel.getGUI(), "Center");
        this._windowAdapter = new ModalContentWindowAdapter(null);
        this.addWindowListener(this._windowAdapter);
    }

    public void show(Topic topic) {
        super.show();
        this._helpContentPanel.getTopicPanel().displayTopic(topic);
    }

    private HelpContentPanel _getHelpContentPanel() {
        return this._helpContentPanel;
    }

    private List _getOwnerList() {
        return this._ownerList;
    }

    private void _clearHelpContentPanel() {
        this._helpContentPanel = null;
    }

    private WindowAdapter _getWindowAdapter() {
        return this._windowAdapter;
    }

    public void cleanup(boolean bl) {
        WindowUtils.unregisterWindow((Window)this);
        if (this._windowAdapter != null) {
            this.removeWindowListener(this._windowAdapter);
            this._windowAdapter = null;
        }
        boolean bl2 = true;
        if (!bl) {
            int n = this._ownerList.size();
            if (n == 1) {
                bl2 = true;
            } else {
                boolean bl3 = false;
                int n2 = 1;
                while (n2 < n && !bl3) {
                    Dialog dialog = (Dialog)this._ownerList.get(n2);
                    if (dialog.isShowing()) {
                        bl2 = false;
                        bl3 = true;
                        this._ownerList.remove(0);
                        this._ownerList.remove(0);
                        ModalHelpContentDialog modalHelpContentDialog = new ModalHelpContentDialog(dialog, this._library, this);
                        modalHelpContentDialog.show();
                        Window window = WindowUtils.getActiveWindow();
                        window.show();
                        if (HelpSystem.getHelpSystem() instanceof JDevHelpSystemImpl) {
                            JDevHelpSystemImpl jDevHelpSystemImpl = (JDevHelpSystemImpl)HelpSystem.getHelpSystem();
                            jDevHelpSystemImpl.setModalDialog(modalHelpContentDialog);
                        }
                    }
                    ++n2;
                }
            }
        }
        if (bl2) {
            WindowListener[] windowListenerArray = this.getWindowListeners();
            if (windowListenerArray != null) {
                int n = 0;
                while (n < windowListenerArray.length) {
                    windowListenerArray[n].windowClosing(new WindowEvent(this, 201));
                    ++n;
                }
            }
            if (this._helpContentPanel != null) {
                this._helpContentPanel.dispose();
            }
            if (HelpSystem.getHelpSystem() instanceof JDevHelpSystemImpl) {
                JDevHelpSystemImpl jDevHelpSystemImpl = (JDevHelpSystemImpl)HelpSystem.getHelpSystem();
                jDevHelpSystemImpl.clearModalDialog();
            }
        }
    }

    protected JRootPane createRootPane() {
        ModalHelpContentDialog modalHelpContentDialog = this;
        1 var2_2 = new 1(this, modalHelpContentDialog);
        JRootPane jRootPane = new JRootPane();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        jRootPane.registerKeyboardAction(var2_2, keyStroke, 2);
        return jRootPane;
    }

    static ModalContentWindowAdapter ra$_windowAdapter(ModalHelpContentDialog modalHelpContentDialog) {
        return modalHelpContentDialog._windowAdapter;
    }

    public final class 1
    implements ActionListener {
        private final /* synthetic */ Window v$win;
        final /* synthetic */ ModalHelpContentDialog this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            this.this$0.hide();
            WindowEvent windowEvent = new WindowEvent(this.v$win, 201);
            ModalHelpContentDialog.ra$_windowAdapter(this.this$0).windowClosing(windowEvent);
        }

        public 1(ModalHelpContentDialog modalHelpContentDialog, Window window) {
            this.v$win = window;
            this.this$0 = modalHelpContentDialog;
        }
    }

    private static class ModalContentWindowAdapter
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            ModalHelpContentDialog modalHelpContentDialog = (ModalHelpContentDialog)windowEvent.getWindow();
            modalHelpContentDialog.cleanup(true);
        }

        public void windowClosed(WindowEvent windowEvent) {
            ModalHelpContentDialog modalHelpContentDialog = (ModalHelpContentDialog)windowEvent.getWindow();
            modalHelpContentDialog.cleanup(false);
        }

        private ModalContentWindowAdapter() {
        }

        ModalContentWindowAdapter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

