/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import oracle.help.common.SimpleTopic;
import oracle.help.common.Target;
import oracle.help.library.Book;
import oracle.jdevimpl.help.DirectURLTarget;
import oracle.jdevimpl.help.DynamicLinkTarget;

public class MultipleTypeTopic
extends SimpleTopic {
    public static final int STANDARD_HELP_TOPIC = 0;
    public static final int DYNAMIC_LINK_HELP_TOPIC = 1;
    public static final int CUE_CARD_TOPIC = 2;
    public static final int EXTERNAL_TOPIC = 3;
    public static final int LANGUAGE_TOPIC = 4;
    public static final int JAVADOC_TOPIC = 5;
    public static final String DYNAMIC_LINK_TYPE = "dynamiclink";
    public static final String CUE_CARD_TOPIC_TYPE = "cuecard";
    public static final String EXTERNAL_TOPIC_TYPE = "external";
    public static final String LANGUAGE_TOPIC_TYPE = "language";
    public static final String JAVADOC_TOPIC_TYPE = "javadoc";
    private int _topicType;
    private String _topicString;

    public MultipleTypeTopic() {
    }

    public MultipleTypeTopic(String string, String string2, String string3) {
        super.setLabel(string);
        this._topicType = MultipleTypeTopic.mapTypeToInt(string3);
        if (this._topicType == 2) {
            this._topicString = string2;
        } else if (this._topicType == 3) {
            DirectURLTarget directURLTarget = new DirectURLTarget(string2);
            super.setTarget((Target)directURLTarget);
        } else if (this._topicType == 1) {
            DynamicLinkTarget dynamicLinkTarget = new DynamicLinkTarget(string2);
            super.setTarget((Target)dynamicLinkTarget);
        } else if (this._topicType == 4) {
            this._topicString = string2;
        }
    }

    public MultipleTypeTopic(String string, Book book) {
        this();
        if (string != null) {
            super.setLabel(string);
        }
    }

    public MultipleTypeTopic(String string, Target target, Book book) {
        this(string, book);
        super.setTarget(target);
    }

    public MultipleTypeTopic(String string, Target target, Book book, Target target2, Target target3) {
        this(string, target, book);
        this.setActiveIcon(target3);
        this.setDefaultIcon(target2);
    }

    public void setTopicType(int n) {
        this._topicType = n;
    }

    public int getTopicType() {
        return this._topicType;
    }

    public void setTopicType(String string) {
        this._topicType = MultipleTypeTopic.mapTypeToInt(string);
    }

    public void setCueCardId(String string) {
        this._topicString = string;
    }

    public String getCueCardId() {
        return this._topicString;
    }

    public void setLanguageString(String string) {
        this._topicString = string;
    }

    public String getLanguageString() {
        return this._topicString;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MultipleTypeTopic)) {
            return false;
        }
        MultipleTypeTopic multipleTypeTopic = (MultipleTypeTopic)((Object)object);
        if (multipleTypeTopic.getTopicType() == 2 && this.getTopicType() == 2 || multipleTypeTopic.getTopicType() == 4 && this.getTopicType() == 4 || multipleTypeTopic.getTopicType() == 5 && this.getTopicType() == 5) {
            return multipleTypeTopic.getCueCardId().equals(this.getCueCardId());
        }
        return multipleTypeTopic.getTopicType() == this._topicType && multipleTypeTopic.getTarget().equals(this.getTarget());
    }

    public static int mapTypeToInt(String string) {
        int n = 0;
        if (string.equalsIgnoreCase(CUE_CARD_TOPIC_TYPE)) {
            n = 2;
        } else if (string.equalsIgnoreCase(DYNAMIC_LINK_TYPE)) {
            n = 1;
        } else if (string.equalsIgnoreCase(EXTERNAL_TOPIC_TYPE)) {
            n = 3;
        } else if (string.equalsIgnoreCase(LANGUAGE_TOPIC_TYPE)) {
            n = 4;
        } else if (string.equalsIgnoreCase(JAVADOC_TOPIC_TYPE)) {
            n = 5;
        }
        return n;
    }
}

