/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;

class TimedSocket {
    private static final int POLL_DELAY = 100;

    private static Socket getSocket(InetAddress inetAddress, int n, int n2) throws InterruptedIOException, IOException {
        Socket socket;
        SocketThread socketThread;
        block4: {
            socketThread = new SocketThread(inetAddress, n);
            socketThread.start();
            int n3 = 0;
            socket = null;
            do {
                if (socketThread.isConnected()) break block4;
                if (socketThread.isError()) {
                    throw socketThread.getException();
                }
                try {
                    Thread.sleep(100);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while ((n3 += 100) <= n2);
            throw new InterruptedIOException("Could not connect for " + n2 + " milliseconds");
        }
        socket = socketThread.getSocket();
        return socket;
    }

    static Socket getSocket(String string, int n, int n2) throws InterruptedIOException, IOException {
        InetAddress inetAddress = InetAddress.getByName(string);
        return TimedSocket.getSocket(inetAddress, n, n2);
    }

    static Socket getSocket(URL uRL, int n) throws InterruptedIOException, IOException {
        String string = uRL.getHost();
        if (string == null) {
            return null;
        }
        InetAddress inetAddress = InetAddress.getByName(string);
        int n2 = uRL.getPort();
        if (n2 <= 0) {
            return null;
        }
        return TimedSocket.getSocket(inetAddress, n2, n);
    }

    public static void main(String[] stringArray) throws Exception {
        try {
            Socket socket = TimedSocket.getSocket("192.168.0.3", 80, 5000);
            socket.close();
            System.out.println("connected");
        }
        catch (IOException iOException) {
            System.out.println("time out");
        }
    }

    TimedSocket() {
    }

    static class SocketThread
    extends Thread {
        private volatile Socket m_connection;
        private String m_host;
        private InetAddress m_inet;
        private int m_port;
        private IOException m_exception;

        void $init$() {
            this.m_connection = null;
            this.m_host = null;
            this.m_inet = null;
            this.m_port = 0;
            this.m_exception = null;
        }

        public SocketThread(String string, int n) {
            this.$init$();
            this.m_host = string;
            this.m_port = n;
        }

        public SocketThread(InetAddress inetAddress, int n) {
            this.$init$();
            this.m_inet = inetAddress;
            this.m_port = n;
        }

        public void run() {
            Socket socket = null;
            try {
                socket = this.m_host != null ? new Socket(this.m_host, this.m_port) : new Socket(this.m_inet, this.m_port);
            }
            catch (IOException iOException) {
                this.m_exception = iOException;
                return;
            }
            this.m_connection = socket;
        }

        public boolean isConnected() {
            return this.m_connection != null;
        }

        public boolean isError() {
            return this.m_exception != null;
        }

        public Socket getSocket() {
            return this.m_connection;
        }

        public IOException getException() {
            return this.m_exception;
        }
    }
}

