/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.help.common.IndirectTarget;
import oracle.help.common.SimpleTopic;
import oracle.help.common.Target;
import oracle.help.common.View;
import oracle.help.common.xml.Parser;
import oracle.help.common.xml.ParserFactory;
import oracle.help.common.xml.XMLNode;
import oracle.help.common.xml.XMLParseException;
import oracle.help.engine.DataEngine;
import oracle.help.library.Book;
import oracle.jdevimpl.help.CueCardCategory;
import oracle.jdevimpl.help.CueCardSet;

public class XMLCueCardEngine
extends DataEngine {
    private Book _book;
    private String _basePath;
    private List _categoryList;
    public static final String TAG_CUE_CARDS = "cueCards";
    public static final String TAG_CUE_CARD_GROUP = "cardGroup";
    public static final String TAG_CUE_CARD_LIST = "cardList";
    public static final String TAG_CARD = "card";
    public static final String TAG_ID = "id";
    public static final String TAG_STEP_LIST = "stepList";
    public static final String TAG_STEP = "step";
    public static final String TAG_TARGET = "target";
    public static final String TAG_TEXT = "text";

    void $init$() {
        this._categoryList = new ArrayList();
    }

    public XMLCueCardEngine() {
        this.$init$();
    }

    public Object createDataObject(View view, String string, URL uRL, String string2) throws IOException {
        if (uRL == null) {
            throw new IllegalArgumentException("Null parameter passed to DataEngine constructor");
        }
        BufferedReader bufferedReader = this._getBufferedReader(uRL, string2);
        return this.createDataObject(view, string, bufferedReader);
    }

    public Object createDataObject(View view, String string, BufferedReader bufferedReader) throws IOException {
        this._book = null;
        this._basePath = string;
        if (view != null) {
            this._book = view.getBook();
        }
        Parser parser = ParserFactory.createParser((Reader)bufferedReader);
        XMLNode xMLNode = parser.getRoot();
        this._handleCueCards(xMLNode.getFirstChild());
        CueCardCategory[] cueCardCategoryArray = null;
        int n = this._categoryList.size();
        if (n > 0) {
            cueCardCategoryArray = this._categoryList.toArray(new CueCardCategory[n]);
        }
        return cueCardCategoryArray;
    }

    private void _handleCueCards(XMLNode xMLNode) throws XMLParseException {
        if (xMLNode == null) {
            throw new XMLParseException("No toplevel tag");
        }
        if (!xMLNode.getTokenValue().equalsIgnoreCase(TAG_CUE_CARDS)) {
            throw new XMLParseException("Toplevel tag is not cueCards: " + xMLNode.getTokenValue());
        }
        xMLNode = xMLNode.getFirstChild();
        while (xMLNode != null) {
            if (xMLNode.getTokenValue().equalsIgnoreCase(TAG_CUE_CARD_GROUP)) {
                this._handleCueCardGroup(xMLNode);
            }
            xMLNode = xMLNode.getNextSibling();
        }
    }

    private void _handleCueCardGroup(XMLNode xMLNode) throws XMLParseException {
        if (xMLNode == null) {
            throw new XMLParseException("No cardGroup tag");
        }
        if (!xMLNode.getTokenValue().equalsIgnoreCase(TAG_CUE_CARD_GROUP)) {
            throw new XMLParseException("tag is not cueCardGroup: " + xMLNode.getTokenValue());
        }
        XMLNode xMLNode2 = xMLNode.getFirstChild();
        if (!xMLNode2.getTokenValue().equalsIgnoreCase(TAG_TEXT)) {
            throw new XMLParseException("tag is not text: " + xMLNode2.getTokenValue());
        }
        CueCardCategory cueCardCategory = new CueCardCategory(xMLNode2.getString());
        this._categoryList.add(cueCardCategory);
        XMLNode xMLNode3 = xMLNode2.getNextSibling();
        if (!xMLNode3.getTokenValue().equalsIgnoreCase(TAG_CUE_CARD_LIST)) {
            throw new XMLParseException("tag is not cardList: " + xMLNode3.getTokenValue());
        }
        this._handleCardList(xMLNode3, cueCardCategory);
    }

    private void _handleCardList(XMLNode xMLNode, CueCardCategory cueCardCategory) throws XMLParseException {
        xMLNode = xMLNode.getFirstChild();
        while (xMLNode != null) {
            if (xMLNode.getTokenValue().equalsIgnoreCase(TAG_CARD)) {
                this._handleCard(xMLNode, cueCardCategory);
            }
            xMLNode = xMLNode.getNextSibling();
        }
    }

    private void _handleCard(XMLNode xMLNode, CueCardCategory cueCardCategory) throws XMLParseException {
        String string = null;
        String string2 = null;
        List list = null;
        xMLNode = xMLNode.getFirstChild();
        while (xMLNode != null) {
            if (xMLNode.getTokenValue().equalsIgnoreCase(TAG_ID)) {
                string = xMLNode.getString();
            } else if (xMLNode.getTokenValue().equalsIgnoreCase(TAG_TEXT)) {
                string2 = xMLNode.getString();
            } else if (xMLNode.getTokenValue().equalsIgnoreCase(TAG_STEP_LIST)) {
                list = this._handleStepList(xMLNode);
            }
            xMLNode = xMLNode.getNextSibling();
        }
        CueCardSet cueCardSet = new CueCardSet(string, string2, list);
        cueCardCategory.addCueCardSet(cueCardSet);
    }

    private List _handleStepList(XMLNode xMLNode) throws XMLParseException {
        if (!xMLNode.getTokenValue().equalsIgnoreCase(TAG_STEP_LIST)) {
            throw new XMLParseException("Tag is not stepList: " + xMLNode.getTokenValue());
        }
        ArrayList arrayList = new ArrayList();
        xMLNode = xMLNode.getFirstChild();
        while (xMLNode != null) {
            if (xMLNode.getTokenValue().equalsIgnoreCase(TAG_STEP)) {
                this._handleStep(xMLNode, arrayList);
            }
            xMLNode = xMLNode.getNextSibling();
        }
        return arrayList;
    }

    private void _handleStep(XMLNode xMLNode, List list) throws XMLParseException {
        String string = null;
        String string2 = null;
        xMLNode = xMLNode.getFirstChild();
        while (xMLNode != null) {
            if (xMLNode.getTokenValue().equalsIgnoreCase(TAG_TARGET)) {
                string = xMLNode.getString();
            } else if (xMLNode.getTokenValue().equalsIgnoreCase(TAG_TEXT)) {
                string2 = xMLNode.getString();
            }
            xMLNode = xMLNode.getNextSibling();
        }
        SimpleTopic simpleTopic = new SimpleTopic(string2, this._book);
        IndirectTarget indirectTarget = new IndirectTarget(this._book, string);
        simpleTopic.setTarget((Target)indirectTarget);
        list.add(simpleTopic);
    }
}

