/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.history;

import java.net.URL;
import java.util.ArrayList;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.history.HistoryManager;
import oracle.ide.model.ContentType;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Recognizer;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.history.DefaultHistoryEntry;
import oracle.javatools.history.HistoryComponent;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.history.HistoryProperty;
import oracle.jdeveloper.compare.InputStreamTextContributor;
import oracle.jdeveloper.compare.TextNodeContributor;
import oracle.jdeveloper.history.HistoryFilter;
import oracle.jdeveloper.history.HistoryProvider;
import oracle.jdeveloper.history.RevisionIdentifier;
import oracle.jdeveloper.history.SharedProperties;
import oracle.jdeveloper.resource.CompareArb;
import oracle.jdeveloper.resource.HistoryArb;

class BufferHistoryProvider
extends HistoryProvider {
    private static BufferHistoryProvider _instance;
    private static final HistoryProperty[] _PROPERTIES;
    private static final HistoryFilter _TYPE_FILTER;
    private static final RevisionIdentifier _BUFFER_REVISION;

    static {
        _PROPERTIES = new HistoryProperty[]{SharedProperties.getDateProperty(), SharedProperties.getRevisionProperty(), SharedProperties.getDescriptionProperty()};
        _TYPE_FILTER = new 1();
        _BUFFER_REVISION = new RevisionIdentifier(HistoryArb.getIcon(15), HistoryArb.getString(14));
    }

    public static final BufferHistoryProvider getInstance() {
        if (_instance == null) {
            _instance = new BufferHistoryProvider();
        }
        return _instance;
    }

    private BufferHistoryProvider() {
    }

    public HistoryFilter getTypeFilter() {
        return _TYPE_FILTER;
    }

    public HistoryProperty[] getProperties() {
        return _PROPERTIES;
    }

    public boolean isProviderFor(URL uRL) {
        try {
            if (!URLFileSystem.isDirectory((URL)uRL)) {
                HistoryManager historyManager = HistoryManager.getHistoryManager();
                Class clazz = Recognizer.recognizeURL((URL)uRL);
                if (historyManager != null && clazz != null) {
                    boolean bl = historyManager.getRegisteredHistorian(clazz) != null;
                    return bl;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public HistoryEntry[] getEntries(URL uRL, HistoryFilter historyFilter) {
        ArrayList<BufferEntry> arrayList = new ArrayList<BufferEntry>();
        try {
            if (!URLFileSystem.isDirectory((URL)uRL)) {
                Node node = NodeFactory.findOrCreate((URL)uRL);
                if (node instanceof TextNode) {
                    arrayList.add(new BufferEntry((TextNode)node, null));
                } else if (node instanceof Node && DocumentExtensions.findContentTypeFromExtension((String)URLFileSystem.getSuffix((URL)uRL)) == ContentType.TEXT) {
                    arrayList.add(new BufferEntry(node, null));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        HistoryEntry[] historyEntryArray = new HistoryEntry[arrayList.size()];
        arrayList.toArray(historyEntryArray);
        return historyEntryArray;
    }

    static RevisionIdentifier ra$_BUFFER_REVISION() {
        return _BUFFER_REVISION;
    }

    static final class 1
    implements HistoryFilter {
        public String getShortLabel() {
            return HistoryArb.getString(14);
        }

        public boolean accept(HistoryEntry historyEntry) {
            return historyEntry instanceof BufferEntry;
        }
    }

    private static final class BufferEntry
    extends DefaultHistoryEntry {
        private final Node _node;

        private BufferEntry(TextNode textNode) {
            this((Node)textNode);
        }

        private BufferEntry(Node node) {
            this._node = node;
            this.setValue(SharedProperties.getDateProperty(), HistoryComponent.LIVE_DATE);
            this.setValue(SharedProperties.getRevisionProperty(), BufferHistoryProvider.ra$_BUFFER_REVISION());
            this.setValue(SharedProperties.getDescriptionProperty(), HistoryArb.getString(18));
        }

        public CompareContributor getCompareContributor() {
            try {
                if (this._node instanceof TextNode) {
                    TextNodeContributor textNodeContributor = new TextNodeContributor((TextNode)this._node);
                    return textNodeContributor;
                }
                URL uRL = this._node.getURL();
                InputStreamTextContributor inputStreamTextContributor = new InputStreamTextContributor(URLFileSystem.openInputStream((URL)uRL), CompareArb.format(3, URLFileSystem.getFileName((URL)uRL)), URLFileSystem.getPlatformPathName((URL)uRL), URLFileSystem.getSuffix((URL)uRL));
                inputStreamTextContributor.getTextBuffer().setReadOnly(true);
                InputStreamTextContributor inputStreamTextContributor2 = inputStreamTextContributor;
                return inputStreamTextContributor2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }

        BufferEntry(TextNode textNode, 1 var2_2) {
            this(textNode);
        }

        BufferEntry(Node node, 1 var2_2) {
            this(node);
        }

        public final class 1 {
        }
    }
}

