/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.history;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.SimpleInputDialog;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.history.HistoryProperty;
import oracle.jdeveloper.history.CustomFilter;
import oracle.jdeveloper.history.CustomFilterSubstitution;
import oracle.jdeveloper.history.DefaultHistoryProperty;
import oracle.jdeveloper.history.HistoryManager;
import oracle.jdeveloper.history.HistoryProvider;
import oracle.jdevimpl.resource.HistoryArb;

class CustomFilterPanel {
    private static final String DEFAULT_EXPRESSION = "DATE = ${system.date}";
    private JButton _addButton;
    private JButton _moveUpButton;
    private JButton _moveDownButton;
    private JButton _removeButton;
    private JButton _restoreDefaultsButton;
    private JLabel _filterListLabel;
    private JList _filterList;
    private SyntaxTextArea _filterExpressionTextArea;
    private DefaultListModel _filterListModel;
    private TitledBorder _detailBorder;
    private JPanel _detailPanel;
    private JRadioButton _simpleExpressionRadioButton;
    private JRadioButton _complexExpressionRadioButton;
    private JLabel _columnLabel;
    private JComboBox _columnComboBox;
    private JLabel _operatorLabel;
    private JComboBox _operatorComboBox;
    private JLabel _valueLabel;
    private SyntaxTextField _valueTextField;
    private JButton _insertButton;
    private Component _gui;
    private CustomFilter _editedFilter;

    private CustomFilterPanel() {
    }

    Component getGUI() {
        if (this._gui != null) {
            return this._gui;
        }
        this._moveUpButton = new JButton();
        this._moveDownButton = new JButton();
        this._removeButton = new JButton();
        this._restoreDefaultsButton = new JButton();
        this._addButton = new JButton();
        this._filterListLabel = new JLabel();
        this._filterList = new JList();
        this._filterExpressionTextArea = new SyntaxTextArea();
        this._simpleExpressionRadioButton = new JRadioButton();
        this._complexExpressionRadioButton = new JRadioButton();
        this._columnLabel = new JLabel();
        this._columnComboBox = new JComboBox();
        this._operatorLabel = new JLabel();
        this._operatorComboBox = new JComboBox();
        this._valueLabel = new JLabel();
        this._valueTextField = new SyntaxTextField();
        this._insertButton = new JButton();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._simpleExpressionRadioButton);
        buttonGroup.add(this._complexExpressionRadioButton);
        this._filterList.setSelectionMode(0);
        this._detailBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder());
        ResourceUtils.resButton((AbstractButton)this._removeButton, (String)HistoryArb.getString(28));
        ResourceUtils.resButton((AbstractButton)this._restoreDefaultsButton, (String)HistoryArb.getString(29));
        ResourceUtils.resButton((AbstractButton)this._addButton, (String)HistoryArb.getString(30));
        ResourceUtils.resLabel((JLabel)this._filterListLabel, (Component)this._filterList, (String)HistoryArb.getString(31));
        ResourceUtils.resButton((AbstractButton)this._simpleExpressionRadioButton, (String)HistoryArb.getString(32));
        ResourceUtils.resButton((AbstractButton)this._complexExpressionRadioButton, (String)HistoryArb.getString(33));
        ResourceUtils.resLabel((JLabel)this._columnLabel, (Component)this._columnComboBox, (String)HistoryArb.getString(34));
        ResourceUtils.resLabel((JLabel)this._operatorLabel, (Component)this._operatorComboBox, (String)HistoryArb.getString(35));
        ResourceUtils.resLabel((JLabel)this._valueLabel, (Component)this._valueTextField, (String)HistoryArb.getString(36));
        ResourceUtils.resButton((AbstractButton)this._insertButton, (String)HistoryArb.getString(37));
        this._moveUpButton.setIcon(HistoryArb.getIcon(41));
        this._moveDownButton.setIcon(HistoryArb.getIcon(42));
        this.initializeToolButton(this._moveUpButton);
        this.initializeToolButton(this._moveDownButton);
        int n = this._addButton.getPreferredSize().height;
        int n2 = Math.max(n, 16);
        Dimension dimension = new Dimension(n2, n);
        this._moveUpButton.setPreferredSize(dimension);
        this._moveDownButton.setPreferredSize(dimension);
        JScrollPane jScrollPane = new JScrollPane(this._filterList);
        JScrollPane jScrollPane2 = new JScrollPane(this._filterExpressionTextArea);
        this._filterExpressionTextArea.setRows(2);
        this._filterExpressionTextArea.setFont(new Font("monospaced", 0, this._filterExpressionTextArea.getFont().getSize()));
        this._filterExpressionTextArea.setLineWrap(true);
        this._filterExpressionTextArea.setWrapStyleWord(true);
        if (jScrollPane2.getBorder() != null) {
            Border border = jScrollPane2.getBorder();
            Insets insets = border.getBorderInsets(jScrollPane2);
            Dimension dimension2 = new Dimension(this._filterExpressionTextArea.getPreferredSize());
            dimension2.height = dimension2.height + (insets != null ? insets.top : 0);
            dimension2.height = dimension2.height + (insets != null ? insets.bottom : 0);
            jScrollPane2.setPreferredSize(dimension2);
        }
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(Box.createHorizontalStrut(225));
        box.add(this._addButton);
        box.add(this._removeButton);
        box.add(this._restoreDefaultsButton);
        box.add(Box.createHorizontalStrut(2));
        Box box2 = Box.createVerticalBox();
        box2.add(Box.createVerticalStrut(2));
        box2.add(box);
        box2.add(Box.createVerticalStrut(2));
        Box box3 = Box.createVerticalBox();
        box3.add(this._moveUpButton);
        box3.add(this._moveDownButton);
        box3.add(Box.createVerticalGlue());
        Box box4 = Box.createHorizontalBox();
        box4.add(Box.createHorizontalStrut(2));
        box4.add(box3);
        jScrollPane.setMinimumSize(new Dimension(jScrollPane.getPreferredSize().width, 50));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)box4, "East");
        this._filterList.setPrototypeCellValue("this is a prototype filter name");
        this._filterList.setVisibleRowCount(5);
        this._valueTextField.setColumns(40);
        Insets insets = new Insets(2, 2, 2, 2);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this._filterListLabel, "North");
        jPanel2.add((Component)jPanel, "Center");
        jPanel2.add((Component)box2, "South");
        LayoutBuilder layoutBuilder = new LayoutBuilder();
        layoutBuilder.add((Component)this._simpleExpressionRadioButton, insets, 5, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._columnLabel, insets, 1, false, false);
        layoutBuilder.add((Component)this._operatorLabel, insets, 1, false, false);
        layoutBuilder.add((Component)this._valueLabel, insets, 2, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._columnComboBox, insets, 1, false, false);
        layoutBuilder.add((Component)this._operatorComboBox, insets, 1, false, false);
        layoutBuilder.add((Component)this._valueTextField, insets, 1, false, true);
        layoutBuilder.add((Component)this._insertButton, insets, 1, false, false);
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._complexExpressionRadioButton, insets, 5, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)jScrollPane2, insets, 4, false, true);
        layoutBuilder.nl();
        this._detailPanel = new JPanel();
        layoutBuilder.addToPanel((Container)this._detailPanel);
        this._detailPanel.setBorder(this._detailBorder);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel2, "Center");
        jPanel3.add((Component)this._detailPanel, "South");
        this._gui = jPanel3;
        this._filterListModel = new DefaultListModel();
        this._filterList.setModel(this._filterListModel);
        CustomFilter[] customFilterArray = HistoryManager.getHistoryManager().getCustomFilterManager().getFilters();
        this._filterListModel.removeAllElements();
        int n3 = 0;
        while (n3 < customFilterArray.length) {
            this._filterListModel.addElement(customFilterArray[n3]);
            ++n3;
        }
        this._filterList.setCellRenderer(new 13());
        Collection collection = HistoryManager.getHistoryManager().getProviders();
        LinkedHashSet<ColumnItem> linkedHashSet = new LinkedHashSet<ColumnItem>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            HistoryProperty[] historyPropertyArray = ((HistoryProvider)iterator.next()).getProperties();
            int n4 = 0;
            while (n4 < historyPropertyArray.length) {
                String string;
                if (historyPropertyArray[n4] instanceof DefaultHistoryProperty && (string = ((DefaultHistoryProperty)historyPropertyArray[n4]).getCustomFilterId()) != null) {
                    linkedHashSet.add(new ColumnItem((DefaultHistoryProperty)historyPropertyArray[n4]));
                }
                ++n4;
            }
        }
        Object[] objectArray = linkedHashSet.toArray();
        Arrays.sort(objectArray);
        this._columnComboBox.setModel(new DefaultComboBoxModel<Object>(objectArray));
        ArrayList<OperatorItem> arrayList = new ArrayList<OperatorItem>();
        arrayList.add(new OperatorItem("="));
        arrayList.add(new OperatorItem("<>"));
        arrayList.add(new OperatorItem(">"));
        arrayList.add(new OperatorItem("<"));
        arrayList.add(new OperatorItem(">="));
        arrayList.add(new OperatorItem("<="));
        arrayList.add(new OperatorItem("MATCHES", HistoryArb.getString(38)));
        this._operatorComboBox.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        this._moveUpButton.addActionListener(new 12());
        this._moveDownButton.addActionListener(new 11());
        this._removeButton.addActionListener(new 10());
        this._restoreDefaultsButton.addActionListener(new 9());
        this._addButton.addActionListener(new 8());
        this._filterList.addListSelectionListener(new 7());
        this._filterExpressionTextArea.getDocument().addDocumentListener(new 6(this));
        this._valueTextField.getDocument().addDocumentListener(new 5(this));
        this._simpleExpressionRadioButton.addActionListener(new 4());
        this._complexExpressionRadioButton.addActionListener(new 3());
        this._insertButton.addActionListener(new 2());
        if (this._filterList.getModel().getSize() > 0) {
            this._filterList.setSelectedIndex(0);
        }
        this.listSelectionChanged();
        return this._gui;
    }

    void commitEdits() {
        if (this._editedFilter == null) {
            return;
        }
        int n = this._filterListModel.indexOf(this._editedFilter);
        CustomFilter customFilter = null;
        if (this._simpleExpressionRadioButton.isSelected()) {
            customFilter = this.createCustomFilter(this.createSimpleExpression());
        }
        if (this._complexExpressionRadioButton.isSelected()) {
            customFilter = this.createCustomFilter(this._filterExpressionTextArea.getText());
        }
        if (n < 0 || customFilter == null) {
            return;
        }
        customFilter.setName(this._editedFilter.getName());
        this._filterListModel.set(n, customFilter);
    }

    CustomFilter[] getCustomFilters() {
        Object[] objectArray = new CustomFilter[this._filterListModel.getSize()];
        this._filterListModel.copyInto(objectArray);
        return objectArray;
    }

    private void initializeToolButton(JButton jButton) {
        jButton.putClientProperty("hideActionText", Boolean.TRUE);
        jButton.setHorizontalAlignment(0);
        jButton.setFocusable(false);
        jButton.setFocusPainted(false);
        jButton.setText("");
    }

    private void listSelectionChanged() {
        this.commitEdits();
        this._editedFilter = (CustomFilter)this._filterList.getSelectedValue();
        this.updateListSelectionDependentStates();
    }

    private void updateListSelectionDependentStates() {
        int n = this._filterList.getSelectedIndex();
        this._moveUpButton.setEnabled(n <= 0 ^ true);
        this._moveDownButton.setEnabled((n < 0 || n > this._filterListModel.getSize() - 2) ^ true);
        this._removeButton.setEnabled(this._editedFilter != null);
        this._detailBorder.setTitle(HistoryArb.format(39, this._editedFilter != null ? this._editedFilter.getName() : ""));
        this._detailPanel.repaint();
        this._simpleExpressionRadioButton.setEnabled(this._editedFilter != null);
        this._complexExpressionRadioButton.setEnabled(this._editedFilter != null);
        boolean bl = false;
        if (this._editedFilter == null) {
            this.updateSimpleControlsFromExpression(DEFAULT_EXPRESSION);
            this._filterExpressionTextArea.setText("");
        } else {
            Pattern pattern;
            String string = this._editedFilter.getSource();
            String[] stringArray = string.split("\\s+");
            if (stringArray.length < 3 || !this.isRecognizedColumnId(stringArray[0])) {
                bl = true;
            }
            if ((pattern = Pattern.compile("\\s+(AND|OR)\\s+", 2)).matcher(string).find()) {
                bl = true;
            }
            if ((pattern = Pattern.compile("(\\+|^)NOT\\s+", 2)).matcher(string).find()) {
                bl = true;
            }
            this.updateSimpleControlsFromExpression(bl ? DEFAULT_EXPRESSION : string);
            this._filterExpressionTextArea.setText(string);
            this._filterExpressionTextArea.setCaretPosition(0);
        }
        this._simpleExpressionRadioButton.setSelected(bl ^ true);
        this._complexExpressionRadioButton.setSelected(bl);
        this.updateExpressionDependentStates();
    }

    private void updateSimpleControlsFromExpression(String string) {
        Pattern pattern = Pattern.compile("\\s*(.+?)\\s+(.+?)\\s+(.++)");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            return;
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        String string4 = matcher.group(3);
        int n = 0;
        int n2 = this._columnComboBox.getModel().getSize();
        while (n < n2) {
            if (((ColumnItem)this._columnComboBox.getModel().getElementAt(n)).getCustomFilterId().equals(string2)) {
                this._columnComboBox.setSelectedIndex(n);
                break;
            }
            ++n;
        }
        int n3 = 0;
        int n4 = this._operatorComboBox.getModel().getSize();
        while (n3 < n4) {
            if (((OperatorItem)this._operatorComboBox.getModel().getElementAt(n3)).getCustomFilterId().equals(string3)) {
                this._operatorComboBox.setSelectedIndex(n3);
                break;
            }
            ++n3;
        }
        this._valueTextField.setText(string4);
    }

    private void updateExpressionDependentStates() {
        boolean bl = this._simpleExpressionRadioButton.isSelected();
        this._columnLabel.setEnabled(this._editedFilter != null && bl);
        this._columnComboBox.setEnabled(this._editedFilter != null && bl);
        this._operatorLabel.setEnabled(this._editedFilter != null && bl);
        this._operatorComboBox.setEnabled(this._editedFilter != null && bl);
        this._valueLabel.setEnabled(this._editedFilter != null && bl);
        this._valueTextField.setEnabled(this._editedFilter != null && bl);
        this._insertButton.setEnabled(this._editedFilter != null && bl);
        this._filterExpressionTextArea.setEnabled(this._editedFilter != null && !bl);
    }

    private String createSimpleExpression() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(((ColumnItem)this._columnComboBox.getSelectedItem()).getCustomFilterId());
        stringBuffer.append(' ');
        stringBuffer.append(((OperatorItem)this._operatorComboBox.getSelectedItem()).getCustomFilterId());
        stringBuffer.append(' ');
        stringBuffer.append(this._valueTextField.getText());
        return stringBuffer.toString();
    }

    private boolean isRecognizedColumnId(String string) {
        int n = 0;
        int n2 = this._columnComboBox.getModel().getSize();
        while (n < n2) {
            if (((ColumnItem)this._columnComboBox.getModel().getElementAt(n)).getCustomFilterId().equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private CustomFilter createCustomFilter(String string) {
        try {
            CustomFilter customFilter = CustomFilter.parse(string);
            return customFilter;
        }
        catch (ParseException parseException) {
            CustomFilter customFilter = null;
            return customFilter;
        }
    }

    private int indexOfFilterName(String string) {
        int n = 0;
        while (n < this._filterListModel.getSize()) {
            if (((CustomFilter)this._filterListModel.get(n)).getName().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    static final CustomFilter[] runDialog() {
        CustomFilterPanel customFilterPanel = new CustomFilterPanel();
        JEWTDialog jEWTDialog = new JEWTDialog(IdeUtil.getMainWindow(), HistoryArb.getString(27), 7);
        jEWTDialog.setContent(customFilterPanel.getGUI());
        jEWTDialog.setCenterOver((Component)IdeUtil.getMainWindow());
        HelpSystem.getHelpSystem().registerTopic((JComponent)customFilterPanel.getGUI(), "f1_scscustomfilter_html");
        jEWTDialog.addVetoableChangeListener((VetoableChangeListener)new 1(customFilterPanel));
        return jEWTDialog.runDialog() ? customFilterPanel.getCustomFilters() : null;
    }

    private static final Color getSyntaxBackgroundColor(boolean bl) {
        return UIManager.getColor(bl ? "TextField.background" : "ToolTip.background");
    }

    private static final Color getSyntaxForegroundColor(boolean bl) {
        return UIManager.getColor(bl ? "TextField.foreground" : "ToolTip.foreground");
    }

    static JList ra$_filterList(CustomFilterPanel customFilterPanel) {
        return customFilterPanel._filterList;
    }

    static DefaultListModel ra$_filterListModel(CustomFilterPanel customFilterPanel) {
        return customFilterPanel._filterListModel;
    }

    static JButton ra$_removeButton(CustomFilterPanel customFilterPanel) {
        return customFilterPanel._removeButton;
    }

    static Component ra$_gui(CustomFilterPanel customFilterPanel) {
        return customFilterPanel._gui;
    }

    static int mav$indexOfFilterName(CustomFilterPanel customFilterPanel, String string) {
        return customFilterPanel.indexOfFilterName(string);
    }

    static void mav$listSelectionChanged(CustomFilterPanel customFilterPanel) {
        customFilterPanel.listSelectionChanged();
    }

    static SyntaxTextArea ra$_filterExpressionTextArea(CustomFilterPanel customFilterPanel) {
        return customFilterPanel._filterExpressionTextArea;
    }

    static CustomFilter mav$createCustomFilter(CustomFilterPanel customFilterPanel, String string) {
        return customFilterPanel.createCustomFilter(string);
    }

    static SyntaxTextField ra$_valueTextField(CustomFilterPanel customFilterPanel) {
        return customFilterPanel._valueTextField;
    }

    static String mav$createSimpleExpression(CustomFilterPanel customFilterPanel) {
        return customFilterPanel.createSimpleExpression();
    }

    static void mav$updateExpressionDependentStates(CustomFilterPanel customFilterPanel) {
        customFilterPanel.updateExpressionDependentStates();
    }

    static Color maS$getSyntaxBackgroundColor(boolean bl) {
        return CustomFilterPanel.getSyntaxBackgroundColor(bl);
    }

    static Color maS$getSyntaxForegroundColor(boolean bl) {
        return CustomFilterPanel.getSyntaxForegroundColor(bl);
    }

    final class 13
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object != null && object instanceof CustomFilter) {
                object = ((CustomFilter)object).getName();
            }
            return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        }
    }

    final class 12
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            int n = CustomFilterPanel.ra$_filterList(CustomFilterPanel.this).getSelectedIndex();
            if (n <= 0) {
                return;
            }
            Object e = CustomFilterPanel.ra$_filterListModel(CustomFilterPanel.this).remove(n);
            CustomFilterPanel.ra$_filterListModel(CustomFilterPanel.this).add(n - 1, e);
            CustomFilterPanel.ra$_filterList(CustomFilterPanel.this).grabFocus();
            CustomFilterPanel.ra$_filterList(CustomFilterPanel.this).setSelectedValue(e, true);
        }
    }

    final class 11
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            int n = CustomFilterPanel.ra$_filterList(CustomFilterPanel.this).getSelectedIndex();
            if (n < 0 || n > CustomFilterPanel.ra$_filterListModel(CustomFilterPanel.this).getSize() - 2) {
                return;
            }
            Object e = CustomFilterPanel.ra$_filterListModel(CustomFilterPanel.this).remove(n);
            CustomFilterPanel.ra$_filterListModel(CustomFilterPanel.this).add(n + 1, e);
            CustomFilterPanel.ra$_filterList(CustomFilterPanel.this).grabFocus();
            CustomFilterPanel.ra$_filterList(CustomFilterPanel.this).setSelectedValue(e, true);
        }
    }

    final class 10
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            int n = CustomFilterPanel.ra$_filterList(CustomFilterPanel.this).getSelectedIndex();
            if (n < 0) {
                return;
            }
            CustomFilterPanel.ra$_filterListModel(CustomFilterPanel.this).remove(n);
            n = Math.min(CustomFilterPanel.ra$_filterListModel(CustomFilterPanel.this).getSize() - 1, n);
            CustomFilterPanel.ra$_removeButton(CustomFilterPanel.this).grabFocus();
            if (n >= 0) {
                CustomFilterPanel.ra$_filterList(CustomFilterPanel.this).setSelectedIndex(n);
            }
        }
    }

    final class 9
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            CustomFilter[] customFilterArray = HistoryManager.getHistoryManager().getCustomFilterManager().createDefaultFilters();
            CustomFilterPanel.ra$_filterListModel(CustomFilterPanel.this).removeAllElements();
            int n = 0;
            while (n < customFilterArray.length) {
                CustomFilterPanel.ra$_filterListModel(CustomFilterPanel.this).addElement(customFilterArray[n]);
                ++n;
            }
            if (CustomFilterPanel.ra$_filterListModel(CustomFilterPanel.this).getSize() > 0) {
                CustomFilterPanel.ra$_filterList(CustomFilterPanel.this).setSelectedIndex(0);
            }
        }
    }

    final class 8
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            1 var2_2 = new 1(CustomFilterPanel.ra$_gui(CustomFilterPanel.this));
            if (!var2_2.show(HistoryArb.getString(43), HistoryArb.getString(44), null)) {
                return;
            }
            try {
                CustomFilter customFilter = CustomFilter.parse(CustomFilterPanel.DEFAULT_EXPRESSION);
                customFilter.setName(var2_2.getInputValue());
                CustomFilterPanel.ra$_filterListModel(CustomFilterPanel.this).addElement(customFilter);
                CustomFilterPanel.ra$_filterList(CustomFilterPanel.this).grabFocus();
                CustomFilterPanel.ra$_filterList(CustomFilterPanel.this).setSelectedValue(customFilter, true);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }

        final class 1
        extends SimpleInputDialog {
            protected boolean canOk() {
                return super.canOk() && !this.getInputValue().equals("") && CustomFilterPanel.mav$indexOfFilterName(CustomFilterPanel.this, this.getInputValue()) < 0;
            }

            public 1(Component component) {
                super(component);
            }
        }
    }

    final class 7
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            CustomFilterPanel.mav$listSelectionChanged(CustomFilterPanel.this);
        }
    }

    final class 6
    extends DocumentUpdateListener {
        protected void documentUpdate(DocumentEvent documentEvent) {
            EventQueue.invokeLater(new 1());
        }

        public 6(CustomFilterPanel customFilterPanel2) {
            super((6)null);
        }

        final class 1
        implements Runnable {
            public void run() {
                CustomFilterPanel.ra$_filterExpressionTextArea(CustomFilterPanel.this).setSyntaxValid(CustomFilterPanel.mav$createCustomFilter(CustomFilterPanel.this, CustomFilterPanel.ra$_filterExpressionTextArea(CustomFilterPanel.this).getText()) != null);
            }
        }
    }

    final class 5
    extends DocumentUpdateListener {
        protected void documentUpdate(DocumentEvent documentEvent) {
            EventQueue.invokeLater(new 1());
        }

        public 5(CustomFilterPanel customFilterPanel2) {
            super((5)null);
        }

        final class 1
        implements Runnable {
            public void run() {
                CustomFilterPanel.ra$_valueTextField(CustomFilterPanel.this).setSyntaxValid(CustomFilterPanel.mav$createCustomFilter(CustomFilterPanel.this, CustomFilterPanel.mav$createSimpleExpression(CustomFilterPanel.this)) != null);
            }
        }
    }

    final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            CustomFilterPanel.mav$updateExpressionDependentStates(CustomFilterPanel.this);
        }
    }

    final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            CustomFilterPanel.mav$updateExpressionDependentStates(CustomFilterPanel.this);
        }
    }

    final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            JPanel jPanel = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel();
            JList<String> jList = new JList<String>();
            jList.setSelectionMode(0);
            jList.setPrototypeCellValue("this is a prototype substitution");
            jList.setVisibleRowCount(3);
            DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
            jList.setModel(defaultListModel);
            CustomFilterSubstitution[] customFilterSubstitutionArray = HistoryManager.getHistoryManager().getCustomFilterManager().getSubstitutions();
            int n = 0;
            while (n < customFilterSubstitutionArray.length) {
                defaultListModel.addElement("${" + customFilterSubstitutionArray[n].getName() + "}");
                ++n;
            }
            ResourceUtils.resLabel((JLabel)jLabel, jList, (String)HistoryArb.getString(49));
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
            jPanel.add((Component)jLabel, "North");
            jPanel.add((Component)new JScrollPane(jList), "Center");
            JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)CustomFilterPanel.ra$_gui(CustomFilterPanel.this), (Component)jPanel, null, (String)HistoryArb.getString(48), (int)3);
            jEWTDialog.setDefaultButton(2);
            jEWTDialog.setResizable(false);
            if (jList.getModel().getSize() > 0) {
                jList.setSelectedIndex(0);
            }
            jList.addListSelectionListener(new 1(this, jEWTDialog, jList));
            jEWTDialog.setOKButtonEnabled(jList.getSelectedValue() != null);
            if (!jEWTDialog.runDialog()) {
                return;
            }
            try {
                int n2 = Math.max(0, CustomFilterPanel.ra$_valueTextField(CustomFilterPanel.this).getCaretPosition());
                CustomFilterPanel.ra$_valueTextField(CustomFilterPanel.this).getDocument().insertString(n2, jList.getSelectedValue().toString(), null);
                CustomFilterPanel.ra$_valueTextField(CustomFilterPanel.this).requestFocus();
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        final class 1
        implements ListSelectionListener {
            private final /* synthetic */ JEWTDialog v$dlg;
            private final /* synthetic */ JList v$insertList;
            final /* synthetic */ 2 this$0;

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                this.v$dlg.setOKButtonEnabled(this.v$insertList.getSelectedValue() != null);
            }

            public 1(2 var1_1, JEWTDialog jEWTDialog, JList jList) {
                this.v$insertList = jList;
                this.v$dlg = jEWTDialog;
                this.this$0 = var1_1;
            }
        }
    }

    static final class 1
    implements VetoableChangeListener {
        private final /* synthetic */ CustomFilterPanel v$panel;

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent)) {
                this.v$panel.commitEdits();
            }
        }

        public 1(CustomFilterPanel customFilterPanel) {
            this.v$panel = customFilterPanel;
        }
    }

    private abstract class DocumentUpdateListener
    implements DocumentListener {
        public void changedUpdate(DocumentEvent documentEvent) {
            this.documentUpdate(documentEvent);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.documentUpdate(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.documentUpdate(documentEvent);
        }

        protected abstract void documentUpdate(DocumentEvent var1);

        private DocumentUpdateListener() {
        }

        DocumentUpdateListener(6 var2_2) {
            this();
        }

        DocumentUpdateListener(5 var2_2) {
            this();
        }
    }

    private class ColumnItem
    implements Comparable {
        private final DefaultHistoryProperty _historyProperty;

        ColumnItem(DefaultHistoryProperty defaultHistoryProperty) {
            this._historyProperty = defaultHistoryProperty;
        }

        String getCustomFilterId() {
            return this._historyProperty.getCustomFilterId();
        }

        public boolean equals(Object object) {
            return object instanceof ColumnItem && ((ColumnItem)object).getCustomFilterId().equals(this.getCustomFilterId());
        }

        public int hashCode() {
            return this.getCustomFilterId().intern().hashCode();
        }

        public String toString() {
            return this._historyProperty.getName();
        }

        public int compareTo(Object object) {
            return this.toString().compareTo(((ColumnItem)object).toString());
        }
    }

    private class OperatorItem {
        private final String _id;
        private final String _renderedValue;

        OperatorItem(String string) {
            this(string, null);
        }

        OperatorItem(String string, String string2) {
            this._id = string;
            this._renderedValue = string2;
        }

        String getCustomFilterId() {
            return this._id;
        }

        public String toString() {
            return this._renderedValue != null ? this._renderedValue : this._id;
        }
    }

    private class SyntaxTextField
    extends JTextField {
        private boolean _syntaxValid;

        SyntaxTextField() {
            this.updateSyntaxUI();
        }

        void setSyntaxValid(boolean bl) {
            this._syntaxValid = bl;
            this.updateSyntaxUI();
        }

        public void setBackground(Color color) {
        }

        public void setForeground(Color color) {
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.updateSyntaxUI();
        }

        private void updateSyntaxUI() {
            super.setBackground(CustomFilterPanel.maS$getSyntaxBackgroundColor(this._syntaxValid));
            if (!this.isEnabled()) {
                super.setForeground(this.getDisabledTextColor());
                return;
            }
            super.setForeground(CustomFilterPanel.maS$getSyntaxForegroundColor(this._syntaxValid));
        }
    }

    private class SyntaxTextArea
    extends JTextArea {
        private boolean _syntaxValid;

        SyntaxTextArea() {
            this.updateSyntaxUI();
        }

        void setSyntaxValid(boolean bl) {
            this._syntaxValid = bl;
            this.updateSyntaxUI();
        }

        public void setBackground(Color color) {
        }

        public void setForeground(Color color) {
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            this.updateSyntaxUI();
        }

        private void updateSyntaxUI() {
            super.setBackground(CustomFilterPanel.maS$getSyntaxBackgroundColor(this._syntaxValid));
            if (!this.isEnabled()) {
                super.setForeground(this.getDisabledTextColor());
                return;
            }
            super.setForeground(CustomFilterPanel.maS$getSyntaxForegroundColor(this._syntaxValid));
        }
    }
}

