/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.history;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.checkboxlist.CheckBoxListCellData;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.SelectFilesPanel;
import oracle.ide.help.HelpSystem;
import oracle.ide.history.LocalState;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.history.HistoryEntry;
import oracle.jdeveloper.history.CustomFilter;
import oracle.jdeveloper.history.HistoryElement;
import oracle.jdeveloper.history.HistoryManager;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.compare.CompareAddin;
import oracle.jdevimpl.compare.CompareController;
import oracle.jdevimpl.history.CustomFilterPanel;
import oracle.jdevimpl.history.HistoryAddin;
import oracle.jdevimpl.history.HistoryViewer;
import oracle.jdevimpl.history.LocalHistoryEntry;
import oracle.jdevimpl.history.RestoreDeletionsPanel;
import oracle.jdevimpl.history.ViewableHistoryEntry;
import oracle.jdevimpl.resource.HistoryArb;

class HistoryController
implements Controller {
    private static HistoryController _singleton;

    static HistoryController getInstance() {
        if (_singleton == null) {
            _singleton = new HistoryController();
        }
        return _singleton;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == 22) {
            return CompareController.getDefaultController().update(ideAction, context);
        }
        if (n == 18) {
            return CompareController.getDefaultController().update(ideAction, context);
        }
        if (n == CompareAddin.GO_FIRST_CMD_ID || n == CompareAddin.GO_NEXT_CMD_ID || n == CompareAddin.GO_PREVIOUS_CMD_ID || n == CompareAddin.GO_LAST_CMD_ID) {
            return CompareController.getDefaultController().update(ideAction, context);
        }
        if (n == HistoryAddin.CUSTOMIZE_FILTERS_CMD_ID) {
            HistoryManager historyManager = HistoryManager.getHistoryManager();
            CustomFilter[] customFilterArray = historyManager.getCustomFilterManager().getFilters();
            ideAction.setEnabled(customFilterArray != null);
            return true;
        }
        if (n == 51) {
            View view = context != null ? context.getView() : null;
            ideAction.setEnabled(view instanceof HistoryViewer);
            return true;
        }
        if (n == oracle.ide.history.HistoryManager.RESTORE_HISTORY_CMD_ID) {
            Element[] elementArray;
            HistoryViewer historyViewer = context.getView() instanceof HistoryViewer ? (HistoryViewer)context.getView() : null;
            Element[] elementArray2 = elementArray = historyViewer != null ? historyViewer.getSelection() : null;
            if (elementArray == null || elementArray.length <= 0 || !(elementArray[0] instanceof HistoryElement)) {
                ideAction.setEnabled(false);
                return true;
            }
            HistoryEntry historyEntry = ((HistoryElement)elementArray[0]).getEntry();
            if (historyEntry instanceof LocalHistoryEntry) {
                oracle.ide.history.HistoryManager historyManager = oracle.ide.history.HistoryManager.getHistoryManager();
                ideAction.setEnabled(historyManager != null);
                return true;
            }
            ideAction.setEnabled(false);
            return true;
        }
        if (n == HistoryAddin.HISTORY_CMD_ID) {
            Element[] elementArray = context.getSelection();
            URL uRL = null;
            if (elementArray != null && elementArray.length > 0 && elementArray.length == 1) {
                if (elementArray[0] instanceof RelativeDirectoryContextFolder) {
                    URLPath uRLPath = ((RelativeDirectoryContextFolder)elementArray[0]).getRootDirectories();
                    uRL = uRLPath != null ? uRLPath.getFirstEntry() : null;
                } else if (elementArray[0] instanceof Project) {
                    URLPath uRLPath = PathsConfiguration.getInstance((Project)elementArray[0]).getProjectSourcePath();
                    uRL = uRLPath != null ? uRLPath.getFirstEntry() : null;
                } else if (elementArray[0] instanceof Locatable) {
                    uRL = ((Locatable)elementArray[0]).getURL();
                }
            }
            ideAction.setEnabled(uRL != null ? URLFileSystem.isDirectoryPath(uRL) : false);
            return true;
        }
        if (n == HistoryAddin.PURGE_HISTORY_CMD_ID) {
            URL uRL = null;
            if (context.getView() instanceof HistoryViewer) {
                uRL = context.getNode() != null ? context.getNode().getURL() : null;
            }
            ideAction.setEnabled(uRL != null && oracle.ide.history.HistoryManager.getHistoryManager().hasLocalHistory(uRL));
            return true;
        }
        if (n == HistoryAddin.OPEN_HISTORY_VIEWER_CMD_ID) {
            HistoryViewer historyViewer = context.getView() instanceof HistoryViewer ? (HistoryViewer)context.getView() : null;
            Element[] elementArray = historyViewer != null ? historyViewer.getSelection() : null;
            ideAction.setEnabled(elementArray != null && elementArray.length > 0 && elementArray[0] instanceof HistoryElement && ((HistoryElement)elementArray[0]).getEntry() instanceof ViewableHistoryEntry);
            return true;
        }
        return false;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == 22) {
            return CompareController.getDefaultController().handleEvent(ideAction, context);
        }
        if (n == 18) {
            return CompareController.getDefaultController().handleEvent(ideAction, context);
        }
        if (n == CompareAddin.GO_FIRST_CMD_ID || n == CompareAddin.GO_NEXT_CMD_ID || n == CompareAddin.GO_PREVIOUS_CMD_ID || n == CompareAddin.GO_LAST_CMD_ID) {
            return CompareController.getDefaultController().handleEvent(ideAction, context);
        }
        if (n == HistoryAddin.CUSTOMIZE_FILTERS_CMD_ID) {
            HistoryManager historyManager = HistoryManager.getHistoryManager();
            Object[] objectArray = historyManager.getCustomFilterManager().getFilters();
            Object[] objectArray2 = CustomFilterPanel.runDialog();
            if (objectArray2 != null && !Arrays.equals(objectArray, objectArray2)) {
                historyManager.getCustomFilterManager().setFilters((CustomFilter[])objectArray2);
            }
            return true;
        }
        if (n == 51) {
            View view;
            View view2 = view = context != null ? context.getView() : null;
            if (view instanceof HistoryViewer) {
                try {
                    ((HistoryViewer)view).refresh();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        } else {
            if (n == oracle.ide.history.HistoryManager.RESTORE_HISTORY_CMD_ID) {
                HistoryEntry historyEntry;
                Element[] elementArray;
                HistoryViewer historyViewer = context.getView() instanceof HistoryViewer ? (HistoryViewer)context.getView() : null;
                Element[] elementArray2 = elementArray = historyViewer != null ? historyViewer.getSelection() : null;
                if (elementArray != null && elementArray.length > 0 && elementArray[0] instanceof HistoryElement && (historyEntry = ((HistoryElement)elementArray[0]).getEntry()) instanceof LocalHistoryEntry) {
                    LocalState localState = ((LocalHistoryEntry)historyEntry).getState();
                    oracle.ide.history.HistoryManager historyManager = oracle.ide.history.HistoryManager.getHistoryManager();
                    if (historyManager != null && localState != null) {
                        try {
                            historyManager.restore(new LocalState[]{localState}, context);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                return true;
            }
            if (n == HistoryAddin.HISTORY_CMD_ID) {
                LocalState[] localStateArray;
                Element[] elementArray = context != null ? context.getSelection() : null;
                URLPath uRLPath = null;
                if (elementArray != null && elementArray.length > 0 && elementArray.length == 1) {
                    if (elementArray[0] instanceof RelativeDirectoryContextFolder) {
                        uRLPath = ((RelativeDirectoryContextFolder)elementArray[0]).getRootDirectories();
                    } else if (elementArray[0] instanceof Project) {
                        uRLPath = PathsConfiguration.getInstance((Project)elementArray[0]).getProjectSourcePath();
                    } else if (elementArray[0] instanceof Locatable) {
                        uRLPath = new URLPath();
                        uRLPath.add(((Locatable)elementArray[0]).getURL());
                    }
                }
                LocalState[] localStateArray2 = localStateArray = uRLPath != null ? this.getRestoreStates(uRLPath) : null;
                if (localStateArray == null || localStateArray.length == 0) {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)HistoryArb.getString(20), (String)HistoryArb.getString(21), null);
                } else {
                    try {
                        oracle.ide.history.HistoryManager.getHistoryManager().restore(localStateArray, context);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                return true;
            }
            if (n == HistoryAddin.PURGE_HISTORY_CMD_ID) {
                URL uRL = null;
                if (context.getView() instanceof HistoryViewer) {
                    URL uRL2 = uRL = context.getNode() != null ? context.getNode().getURL() : null;
                }
                if (uRL != null && MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)HistoryArb.format(17, URLFileSystem.getFileName((URL)uRL)), (String)HistoryArb.getString(18), null)) {
                    oracle.ide.history.HistoryManager.getHistoryManager().clear(new URL[]{uRL});
                    ((HistoryViewer)context.getView()).refresh();
                }
                return true;
            }
            if (n == HistoryAddin.OPEN_HISTORY_VIEWER_CMD_ID) {
                try {
                    Element[] elementArray;
                    HistoryViewer historyViewer = context.getView() instanceof HistoryViewer ? (HistoryViewer)context.getView() : null;
                    Element[] elementArray3 = elementArray = historyViewer != null ? historyViewer.getSelection() : null;
                    if (elementArray != null && elementArray.length > 0 && elementArray[0] instanceof HistoryElement && ((HistoryElement)elementArray[0]).getEntry() instanceof ViewableHistoryEntry) {
                        ((ViewableHistoryEntry)((HistoryElement)elementArray[0]).getEntry()).view(context);
                    }
                }
                catch (Exception exception) {
                    ExceptionDialog.showExceptionDialog((Window)IdeUtil.getMainWindow(), (Exception)exception);
                }
                return true;
            }
        }
        return false;
    }

    private LocalState[] getRestoreStates(URLPath uRLPath) {
        LocalState[] localStateArray = null;
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        JEWTDialog jEWTDialog = DialogUtil.createJEWTDialogOwnedBy((Component)ideMainWindow);
        if (jEWTDialog != null) {
            RestoreDeletionsPanel restoreDeletionsPanel = new RestoreDeletionsPanel();
            jEWTDialog.setCenterOver((Component)ideMainWindow);
            jEWTDialog.setContent((Component)restoreDeletionsPanel);
            jEWTDialog.setInitialFocus((Component)restoreDeletionsPanel.getObjectTree());
            jEWTDialog.setTitle(HistoryArb.getString(4));
            jEWTDialog.setButtonMask(7);
            jEWTDialog.setResizable(true);
            jEWTDialog.setPreferredSize(new Dimension(800, 600));
            jEWTDialog.setOKButtonText(HistoryArb.getString(14));
            HelpSystem.getHelpSystem().registerTopic((JComponent)restoreDeletionsPanel, "f1_scsrestorefromlocalhistory_html");
            jEWTDialog.pack();
            restoreDeletionsPanel.setModel(uRLPath);
            LocalState[] localStateArray2 = restoreDeletionsPanel.getAllLocalStates();
            if (localStateArray2 == null || localStateArray2.length == 0) {
                return null;
            }
            LocalState[] localStateArray3 = localStateArray = jEWTDialog.runDialog() ? restoreDeletionsPanel.getLocalStates() : null;
            if (localStateArray != null) {
                ArrayList<LocalState> arrayList = new ArrayList<LocalState>();
                ArrayList arrayList2 = new ArrayList();
                CheckBoxListModel checkBoxListModel = new CheckBoxListModel();
                int n = 0;
                while (n < localStateArray.length) {
                    URL uRL = localStateArray[n].getNodeURL();
                    arrayList.add(localStateArray[n]);
                    ++n;
                }
                int n2 = arrayList2.size();
                if (n2 > 0) {
                    if (n2 == 1) {
                        LocalState localState = (LocalState)arrayList2.get(0);
                        String string = URLFileSystem.getPlatformPathName((URL)localState.getNodeURL());
                        int n3 = SelectFilesPanel.showDialog((String)HistoryArb.getString(4), (String)HistoryArb.format(6, new String[]{string}), null, (CheckBoxListModel)checkBoxListModel, (boolean)true, (int)1);
                        switch (n3) {
                            case 0: {
                                break;
                            }
                            default: {
                                arrayList.clear();
                                break;
                            }
                        }
                    } else {
                        int n4 = SelectFilesPanel.showDialog((String)HistoryArb.getString(4), null, (String)HistoryArb.getString(7), (CheckBoxListModel)checkBoxListModel, (boolean)true, (int)2);
                        switch (n4) {
                            case 0: {
                                List list = checkBoxListModel.getSelectionList();
                                if (list != null) {
                                    int n5 = 0;
                                    while (n5 < n2) {
                                        CheckBoxListCellData checkBoxListCellData = (CheckBoxListCellData)checkBoxListModel.getElementAt(n5);
                                        if (!list.contains(checkBoxListCellData.getUserObject())) {
                                            arrayList.remove(arrayList2.get(n5));
                                        }
                                        ++n5;
                                    }
                                    break;
                                }
                                arrayList.removeAll(arrayList2);
                                break;
                            }
                            default: {
                                arrayList.clear();
                            }
                        }
                    }
                }
                localStateArray = new LocalState[arrayList.size()];
                arrayList.toArray(localStateArray);
            }
            jEWTDialog.dispose();
        }
        return localStateArray;
    }

    HistoryController() {
    }
}

