/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.history;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import oracle.javatools.history.HistoryComponent;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.history.HistoryModel;
import oracle.jdeveloper.history.CustomFilter;
import oracle.jdeveloper.history.HistoryFilter;
import oracle.jdeveloper.history.HistoryManager;
import oracle.jdeveloper.history.HistoryProvider;
import oracle.jdeveloper.history.RevisionIdentifier;
import oracle.jdeveloper.history.SharedProperties;

public abstract class HistoryFilterComponent
extends JComboBox {
    protected final HistoryComponent _component;
    protected final URL _url;
    private final Collection _providers;
    private final HistoryFilter _initialFilter;
    private final Observer _customFilterObserver;

    void $init$() {
        this._customFilterObserver = new 3();
    }

    public HistoryFilterComponent(HistoryComponent historyComponent, URL uRL, HistoryFilter historyFilter, Collection collection) {
        this.$init$();
        this._component = historyComponent;
        this._url = uRL;
        this._providers = collection;
        this._initialFilter = historyFilter;
        this.initializeModel(false);
        2 var5_5 = new 2();
        this.setRenderer(var5_5);
        HistoryManager.getHistoryManager().getCustomFilterManager().getFilterObservable().addObserver(this._customFilterObserver);
    }

    public HistoryComponent getHistoryComponent() {
        return this._component;
    }

    private void initializeModel() {
        this.initializeModel(true);
    }

    private void initializeModel(boolean bl) {
        MyModel myModel = new MyModel(this.getFilters(), null);
        this.setModel(myModel);
        if (this._initialFilter != null) {
            int n = 0;
            while (n < myModel.getSize()) {
                ComboItem comboItem = (ComboItem)myModel.getElementAt(n);
                if (comboItem instanceof FilterComboItem && FilterComboItem.ra$filter((FilterComboItem)comboItem).equals(this._initialFilter)) {
                    this.setSelectedIndex(n);
                    break;
                }
                ++n;
            }
            if (bl) {
                this.filter(this._initialFilter);
            }
        }
    }

    public void detachCustomFilterObserver() {
        HistoryManager.getHistoryManager().getCustomFilterManager().getFilterObservable().deleteObserver(this._customFilterObserver);
    }

    protected List getFilters() {
        ArrayList<FilterComboItem> arrayList = new ArrayList<FilterComboItem>();
        int n = 0;
        arrayList.add(new FilterComboItem(HistoryManager.getHistoryManager().getAllFilter()));
        n = arrayList.size();
        for (HistoryProvider historyProvider : this._providers) {
            arrayList.add(new FilterComboItem(historyProvider.getTypeFilter()));
        }
        for (HistoryProvider historyProvider : this._providers) {
            HistoryFilter[] historyFilterArray = historyProvider.getPredefinedFilters();
            if (historyFilterArray == null || historyFilterArray.length <= 0) continue;
            int n2 = 0;
            while (n2 < historyFilterArray.length) {
                arrayList.add(new FilterComboItem(historyFilterArray[n2]));
                ++n2;
            }
        }
        CustomFilter[] customFilterArray = HistoryManager.getHistoryManager().getCustomFilterManager().getFilters();
        if (customFilterArray == null) {
            return arrayList;
        }
        int n3 = 0;
        while (n3 < customFilterArray.length) {
            arrayList.add(new FilterComboItem(customFilterArray[n3]));
            ++n3;
        }
        return arrayList;
    }

    public HistoryFilter getSelectedFilter() {
        if (this.getSelectedItem() instanceof FilterComboItem) {
            return FilterComboItem.ra$filter((FilterComboItem)this.getSelectedItem());
        }
        return null;
    }

    public void setSelectedFilter(HistoryFilter historyFilter) {
        this.setSelectedItem(new FilterComboItem(historyFilter));
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void refilter() {
        this.filter(this.getSelectedFilter());
    }

    private void filter(HistoryFilter historyFilter) {
        HistoryModel historyModel = this.createHistoryModel(historyFilter, this._component);
        if (historyModel == null) {
            return;
        }
        HistoryEntry historyEntry = this._component.getSingleSelection();
        Date date = null;
        RevisionIdentifier revisionIdentifier = null;
        if (historyEntry != null) {
            date = (Date)historyEntry.getValue(SharedProperties.getDateProperty());
            revisionIdentifier = (RevisionIdentifier)historyEntry.getValue(SharedProperties.getRevisionProperty());
        }
        int n = this._component.getTable().getSortColumn();
        boolean bl = this._component.getTable().isSortAscending();
        this._component.setModel(historyModel);
        this._component.getTable().setSortColumn(n, bl);
        historyEntry = null;
        if (revisionIdentifier != null && date != null) {
            int n2 = 0;
            while (n2 < historyModel.getSize()) {
                HistoryEntry historyEntry2 = historyModel.getEntry(n2);
                RevisionIdentifier revisionIdentifier2 = (RevisionIdentifier)historyEntry2.getValue(SharedProperties.getRevisionProperty());
                Date date2 = (Date)historyEntry2.getValue(SharedProperties.getDateProperty());
                if (revisionIdentifier2 != null && revisionIdentifier2.equals(revisionIdentifier) && date2 != null && date2.equals(date)) {
                    historyEntry = historyEntry2;
                    break;
                }
                ++n2;
            }
        }
        if (historyEntry == null) {
            return;
        }
        HistoryEntry historyEntry3 = historyEntry;
        EventQueue.invokeLater(new 1(this, historyEntry3));
    }

    protected abstract HistoryModel createHistoryModel(HistoryFilter var1, HistoryComponent var2);

    static void mav$initializeModel(HistoryFilterComponent historyFilterComponent) {
        historyFilterComponent.initializeModel();
    }

    public final class 3
    implements Observer {
        public void update(Observable observable, Object object) {
            HistoryFilterComponent.mav$initializeModel(HistoryFilterComponent.this);
        }
    }

    public final class 2
    extends BasicComboBoxRenderer {
        private final Border _defaultBorder;

        void $init$() {
            this._defaultBorder = this.getBorder();
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof ComboItem) {
                this.setText(object.toString());
            }
            return component;
        }

        public 2() {
            this.$init$();
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ HistoryEntry v$selectedEntry0;
        final /* synthetic */ HistoryFilterComponent this$0;

        public void run() {
            this.this$0._component.setSingleSelection(this.v$selectedEntry0);
        }

        public 1(HistoryFilterComponent historyFilterComponent, HistoryEntry historyEntry) {
            this.v$selectedEntry0 = historyEntry;
            this.this$0 = historyFilterComponent;
        }
    }

    protected abstract class ComboItem {
        protected ComboItem() {
        }
    }

    protected class FilterComboItem
    extends ComboItem {
        private final HistoryFilter filter;

        FilterComboItem(HistoryFilter historyFilter) {
            this.filter = historyFilter;
        }

        public String toString() {
            return this.filter.getShortLabel();
        }

        public boolean equals(Object object) {
            return object instanceof FilterComboItem && this.filter.equals(((FilterComboItem)object).filter);
        }

        static HistoryFilter ra$filter(FilterComboItem filterComboItem) {
            return filterComboItem.filter;
        }
    }

    private class MyModel
    extends DefaultComboBoxModel {
        private final List _filters;

        private MyModel(List list) {
            this._filters = list;
        }

        public int getSize() {
            return this._filters.size();
        }

        public Object getElementAt(int n) {
            return this._filters.get(n);
        }

        MyModel(List list, 1 var3_3) {
            this(list);
        }

        public final class 1 {
        }
    }
}

