/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.history;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Context;
import oracle.ide.config.ClientSetting;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ideimpl.history.HistoryOptions;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.history.HistoryManager;
import oracle.jdeveloper.history.HistoryProvider;
import oracle.jdevimpl.history.HistoryViewer;
import oracle.jdevimpl.history.LocalHistoryProvider;

public final class HistoryManagerImpl
extends HistoryManager
implements ChangeListener {
    private ArrayList _userFilters;
    private LocalHistoryProvider _localProvider;

    void $init$() {
        this._userFilters = new ArrayList();
        this._localProvider = new LocalHistoryProvider();
    }

    HistoryManagerImpl() {
        this.$init$();
        try {
            InitialContext initialContext = new InitialContext();
            try {
                initialContext.lookup("jdeveloper");
            }
            catch (NamingException namingException) {
                initialContext.createSubcontext("jdeveloper");
            }
            initialContext.bind("jdeveloper/history-manager", (Object)this);
            ClientSetting clientSetting = ClientSetting.findOrCreate((String)"oracle.ide");
            HistoryOptions historyOptions = clientSetting != null ? (HistoryOptions)clientSetting.getData("HistoryOptions") : null;
            historyOptions.addChangeListener((ChangeListener)this);
            this.stateChanged(null);
        }
        catch (NamingException namingException) {
            ExceptionDialog.showExceptionDialog((Component)null, (Throwable)namingException);
        }
    }

    public HistoryProvider getLocalHistoryProvider() {
        return this._localProvider;
    }

    public void showHistory(Context context) {
        EditorManager editorManager = EditorManager.getEditorManager();
        if (editorManager != null) {
            HistoryViewer historyViewer = null;
            for (Object e : editorManager.findEditors(context)) {
                if (!(e instanceof HistoryViewer)) continue;
                historyViewer = (HistoryViewer)e;
                break;
            }
            if (historyViewer != null) {
                historyViewer.getLeftFilter().setSelectedFilter(this.getAllFilter());
            }
            editorManager.openEditorInFrame(HistoryViewer.class, context);
            if (historyViewer != null) {
                historyViewer.setContext(context);
                historyViewer.refresh();
            }
        }
    }

    public void showHistory(Node node) {
        EditorManager editorManager = EditorManager.getEditorManager();
        if (editorManager != null) {
            editorManager.openEditorInFrame(HistoryViewer.class, Context.newIdeContext((Node)node));
        }
    }

    public void updateHistory(URL uRL) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        HistoryOptions historyOptions;
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)"oracle.ide");
        HistoryOptions historyOptions2 = historyOptions = clientSetting != null ? (HistoryOptions)clientSetting.getData("HistoryOptions") : null;
        if (historyOptions != null && historyOptions.isEnabled()) {
            this.registerProvider(this._localProvider);
        } else {
            this.unregisterProvider(this._localProvider);
        }
    }
}

