/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.history;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.history.HistoryComponent;
import oracle.javatools.history.HistoryProperty;
import oracle.jdeveloper.history.HistoryElement;
import oracle.jdevimpl.history.HistoryViewer;
import oracle.jdevimpl.resource.HistoryArb;

public class HistoryPropertiesCommand
extends Command {
    public static final String PROPERTIES_CMD = HistoryPropertiesCommand.class.getName();
    public static final int PROPERTIES_CMD_ID = Ide.findOrCreateCmdID((String)PROPERTIES_CMD);
    private HistoryElement _historyElement;
    private HistoryProperty[] _historyProperties;
    private JLabel _revisionIconLabel;
    private JTextField _revisionNameTextField;
    private final ArrayList _propertyLabels;
    private final ArrayList _propertyComponents;

    void $init$() {
        this._propertyLabels = new ArrayList();
        this._propertyComponents = new ArrayList();
    }

    public HistoryPropertiesCommand() {
        super(PROPERTIES_CMD_ID, 0);
        this.$init$();
    }

    public int doit() throws Exception {
        HistoryElement[] historyElementArray;
        HistoryViewer historyViewer = (HistoryViewer)this.getContext().getView();
        HistoryComponent historyComponent = historyViewer.getLastActiveHistoryComponent();
        if (historyComponent == null) {
            historyComponent = historyViewer.getLeftHistoryComponent();
        }
        if ((historyElementArray = historyViewer.getSelection(historyComponent)).length <= 0) {
            return -1;
        }
        this._historyElement = historyElementArray[0];
        this._historyProperties = historyComponent.getModel().getProperties();
        this.createComponents();
        this.resComponents();
        this.initializeComponents();
        LayoutBuilder layoutBuilder = this.layoutComponents();
        JPanel jPanel = new JPanel();
        layoutBuilder.addToPanel((Container)jPanel);
        Box box = Box.createVerticalBox();
        box.add(jPanel);
        box.add(Box.createHorizontalStrut(350));
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)box, null, (String)HistoryArb.getString(24));
        int n = 1;
        jEWTDialog.setButtonMask(n);
        jEWTDialog.setResizable(false);
        return WizardLauncher.runDialog((JDialog)jEWTDialog) ? 0 : 1;
    }

    private void createComponents() {
        this._revisionIconLabel = new JLabel();
        this._revisionNameTextField = new JTextField();
        int n = 0;
        while (n < this._historyProperties.length) {
            JLabel jLabel = null;
            JTextComponent jTextComponent = null;
            Object object = this._historyElement.getEntry().getValue(this._historyProperties[n]);
            if (!(object == null || object instanceof String && object.toString().trim().equals(""))) {
                String string;
                jLabel = new JLabel();
                jTextComponent = object instanceof String ? ((string = object.toString().trim()).indexOf(10) < 0 && string.indexOf(13) < 0 && string.indexOf(12) < 0 ? (JTextComponent)new JTextField() : new JTextArea()) : new JTextField();
            }
            this._propertyLabels.add(jLabel);
            this._propertyComponents.add(jTextComponent);
            ++n;
        }
    }

    private void resComponents() {
        Icon icon = this._historyElement.getIcon();
        if (icon != null && icon instanceof ImageIcon) {
            icon = new ImageIcon(((ImageIcon)icon).getImage().getScaledInstance(48, 48, 4));
        }
        this._revisionIconLabel.setIcon(icon);
        if (this._historyElement.getShortLabel() != null) {
            this._revisionNameTextField.setText(HistoryArb.format(25, this._historyElement.getShortLabel()));
        } else {
            this._revisionNameTextField.setText("");
        }
        int n = 0;
        while (n < this._historyProperties.length) {
            JLabel jLabel = (JLabel)this._propertyLabels.get(n);
            JTextComponent jTextComponent = (JTextComponent)this._propertyComponents.get(n);
            if (jLabel != null) {
                jLabel.setText(HistoryArb.format(26, this._historyProperties[n].getName()));
                Object object = this._historyElement.getEntry().getValue(this._historyProperties[n]);
                if (object instanceof Date) {
                    object = DateFormat.getDateTimeInstance().format((Date)object);
                }
                jTextComponent.setText(object.toString());
            }
            ++n;
        }
    }

    private void initializeComponents() {
        this.initializePropertyComponents(null, this._revisionNameTextField);
        int n = 0;
        while (n < this._historyProperties.length) {
            this.initializePropertyComponents((JLabel)this._propertyLabels.get(n), (JComponent)this._propertyComponents.get(n));
            ++n;
        }
    }

    private LayoutBuilder layoutComponents() {
        LayoutBuilder layoutBuilder = new LayoutBuilder();
        Insets insets = new Insets(2, 2, 2, 2);
        layoutBuilder.add((Component)this._revisionIconLabel, insets, 1, false, false);
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._revisionNameTextField, insets, 1, false, true);
        layoutBuilder.nl();
        Iterator iterator = this._propertyLabels.iterator();
        Iterator iterator2 = this._propertyComponents.iterator();
        while (iterator.hasNext()) {
            JLabel jLabel = (JLabel)iterator.next();
            JComponent jComponent = (JComponent)iterator2.next();
            if (jLabel == null) continue;
            layoutBuilder.addVGap(8);
            layoutBuilder.nl();
            if (jComponent instanceof JTextArea) {
                layoutBuilder.add((Component)jLabel, insets, 1, false, false);
                layoutBuilder.addHGap();
                layoutBuilder.add(Box.createHorizontalGlue(), insets, 1, false, true);
                layoutBuilder.nl();
                layoutBuilder.add((Component)new JScrollPane(jComponent), insets, 3, false, true);
                layoutBuilder.nl();
                continue;
            }
            layoutBuilder.add((Component)jLabel, insets, 1, false, false);
            layoutBuilder.addHGap();
            layoutBuilder.add((Component)jComponent, insets, 1, false, true);
            layoutBuilder.nl();
        }
        return layoutBuilder;
    }

    private void initializePropertyComponents(JLabel jLabel, JComponent jComponent) {
        if (jComponent instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            jTextComponent.setBorder(BorderFactory.createEmptyBorder());
            jTextComponent.setBackground(UIManager.getColor("control"));
            jTextComponent.setEditable(false);
        }
        if (jComponent instanceof JTextArea) {
            ((JTextArea)jComponent).setRows(3);
            ((JTextArea)jComponent).setCaretPosition(0);
        }
        if (jLabel == null || jComponent instanceof JTextArea) {
            return;
        }
        int n = Math.max(jLabel.getPreferredSize().height, jComponent.getPreferredSize().height);
        jLabel.setPreferredSize(new Dimension(jLabel.getPreferredSize().width, n));
        jComponent.setPreferredSize(new Dimension(jComponent.getPreferredSize().width, n));
    }
}

