/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.ceditor.NodeUpdater;
import oracle.ide.ceditor.UndoWrapperCommand;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.FocusableLabel;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.ExceptionDialog;
import oracle.ide.editor.Editor;
import oracle.ide.help.HelpInfo;
import oracle.ide.history.HistoryManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.DynamicStatusProvider;
import oracle.ide.view.View;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareModelFactory;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.CompareViewFactory;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.view.CustomHorizontalScrollView;
import oracle.javatools.compare.view.EditorPaneView;
import oracle.javatools.compare.view.NavigableView;
import oracle.javatools.compare.view.wedge.WedgeCompareView;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.PopupManager;
import oracle.javatools.history.HistoryComponent;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.history.HistoryModel;
import oracle.javatools.history.HistoryModelEvent;
import oracle.javatools.history.HistoryModelListener;
import oracle.javatools.history.HistoryProperty;
import oracle.jdeveloper.compare.CompareViewer;
import oracle.jdeveloper.history.DefaultHistoryModel;
import oracle.jdeveloper.history.HistoryContext;
import oracle.jdeveloper.history.HistoryElement;
import oracle.jdeveloper.history.HistoryEntrySelector;
import oracle.jdeveloper.history.HistoryFilter;
import oracle.jdeveloper.history.HistoryProvider;
import oracle.jdeveloper.history.SharedProperties;
import oracle.jdeveloper.resource.HistoryArb;
import oracle.jdeveloper.vcs.patch.CreatePatchCommand;
import oracle.jdevimpl.compare.CompareViewOwner;
import oracle.jdevimpl.history.BufferHistoryProvider;
import oracle.jdevimpl.history.HistoryAddin;
import oracle.jdevimpl.history.HistoryController;
import oracle.jdevimpl.history.HistoryFilterComponent;
import oracle.jdevimpl.history.HistoryManagerImpl;
import oracle.jdevimpl.resource.CompareArb;

public class HistoryViewer
extends Editor
implements CompareViewOwner,
PopupManager,
FindableEditor,
UndoableEditListener,
DynamicStatusProvider {
    private Node _node;
    private JPanel _historyPanel;
    private JPanel _horizontalScrollWrapper;
    private Component _noHistoryPanel;
    private CompareView _compareView;
    private Toolbar _toolbar;
    private JSplitPane _splitPane;
    private HistoryComponent _leftHistoryComponent;
    private HistoryComponent _rightHistoryComponent;
    private JLabel _label;
    private HistoryFilterComponent _filter;
    private MouseListener _mouseListener;
    private JLabel _statusLabel;
    private ChangeListener _statusListener;
    private NodeUpdater _leftUpdater;
    private NodeUpdater _rightUpdater;
    private TableColumnModelListener _lhsColumnModelListener;
    private TableColumnModelListener _rhsColumnModelListener;
    private DefaultHistoryModel _currentHistoryModel;
    private ChangeListener _positionChangeListener;
    private HistorySelectionListener _historySelectionListener;
    private HistoryComponent _lastActiveHistoryComponent;

    void $init$() {
        this._statusLabel = new JLabel();
    }

    boolean isLocalHistoryView() {
        return oracle.jdeveloper.history.HistoryManager.getHistoryManager() instanceof HistoryManagerImpl && this.getHistoryProviders().contains(((HistoryManagerImpl)oracle.jdeveloper.history.HistoryManager.getHistoryManager()).getLocalHistoryProvider());
    }

    protected String getTablePersistenceKeyLHS() {
        return "HistoryViewer.LHS.DisplaySettings";
    }

    protected String getTablePersistenceKeyRHS() {
        return "HistoryViewer.RHS.DisplaySettings";
    }

    protected URL getRealURL() {
        return this._node.getURL();
    }

    private void installHistoryModel() {
        this._leftHistoryComponent = this.createHistoryComponent();
        this._rightHistoryComponent = this.createHistoryComponent();
        this._filter = this.createHistoryFilter();
        this._label = this.createHistoryFilterLabel(this._filter);
        if (this._historyPanel == null) {
            this._historyPanel = new JPanel();
        }
        this._historyPanel.removeAll();
        this.layoutHistoryPanel(this._historyPanel);
        this._splitPane.setBorder(BorderFactory.createEmptyBorder());
        this._splitPane.setTopComponent(this._historyPanel);
        this._splitPane.setResizeWeight(this.getDefaultDividerLocation());
        this.refresh();
    }

    protected Element[] getSelectionFromUI() {
        return this._lastActiveHistoryComponent != null ? this.getSelection(this._lastActiveHistoryComponent) : new HistoryElement[]{};
    }

    HistoryComponent getLastActiveHistoryComponent() {
        return this._lastActiveHistoryComponent;
    }

    boolean isCompareViewComponentFocused() {
        if (this._compareView == null || !(this._compareView instanceof EditorPaneView)) {
            return false;
        }
        BasicEditorPane basicEditorPane = ((EditorPaneView)this._compareView).getCurrentEditorPane();
        return basicEditorPane != null && basicEditorPane.isFocusOwner();
    }

    protected Component createNoHistoryPanel() {
        return new FocusableLabel(HistoryArb.getString(25));
    }

    protected HistoryComponent createHistoryComponent() {
        HistoryComponent historyComponent = oracle.jdeveloper.history.HistoryManager.getHistoryManager().createHistoryComponent();
        historyComponent.setSingleSelection(true);
        return historyComponent;
    }

    protected JLabel createToolbarLabel() {
        JLabel jLabel = new JLabel();
        jLabel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        return jLabel;
    }

    protected HistoryFilterComponent createHistoryFilter() {
        return this.createHistoryFilter(this._leftHistoryComponent);
    }

    protected HistoryFilterComponent createHistoryFilter(HistoryComponent historyComponent) {
        7 var2_2 = new 7(historyComponent, this.getRealURL(), oracle.jdeveloper.history.HistoryManager.getHistoryManager().getAllFilter(), this.getHistoryProviders());
        var2_2.addItemListener(new 6(this, var2_2));
        return var2_2;
    }

    protected void refilterModel() {
        this._filter.refilter();
    }

    protected JLabel createHistoryFilterLabel(HistoryFilterComponent historyFilterComponent) {
        JLabel jLabel = this.createToolbarLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)historyFilterComponent, (String)HistoryArb.getString(19));
        return jLabel;
    }

    protected void disposeHistoryFilters() {
        this._filter.detachCustomFilterObserver();
    }

    protected void layoutHistoryPanel(JPanel jPanel) {
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this._leftHistoryComponent, "Center");
    }

    public HistoryFilterComponent getLeftFilter() {
        return this._filter;
    }

    public HistoryComponent getLeftHistoryComponent() {
        return this._leftHistoryComponent;
    }

    public HistoryComponent getRightHistoryComponent() {
        return this._rightHistoryComponent;
    }

    public void refresh() {
        this.refresh(this.getContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Context context) {
        this.detachForPersistentSettings();
        this._currentHistoryModel = (DefaultHistoryModel)oracle.jdeveloper.history.HistoryManager.getHistoryManager().buildModel(this.getRealURL(), true, null, this.getHistoryProviders());
        HistoryModel historyModel = this.updateHistoryModel(this._leftHistoryComponent, this._filter);
        this.updateHistoryModel(this._rightHistoryComponent, null);
        HistoryEntry historyEntry = this._leftHistoryComponent.getSingleSelection();
        HistoryEntry historyEntry2 = this._rightHistoryComponent.getSingleSelection();
        HistoryEntrySelector historyEntrySelector = HistoryContext.getHistoryEntrySelectorLHS(context);
        HistoryEntrySelector historyEntrySelector2 = HistoryContext.getHistoryEntrySelectorRHS(context);
        if (context != null) {
            HistoryContext.setHistoryEntrySelectorLHS(context, null);
            HistoryContext.setHistoryEntrySelectorRHS(context, null);
        }
        HistoryModel historyModel2 = historyModel;
        synchronized (historyModel2) {
            if (historyModel.isComplete()) {
                this.sortHistoryComponentTables();
                SwingUtilities.invokeLater(new 5(this, historyEntry, historyEntry2, historyEntrySelector, historyEntrySelector2));
            } else {
                historyModel.addHistoryModelListener((HistoryModelListener)new 4(this, this, historyEntry, historyEntry2, historyEntrySelector, historyEntrySelector2));
            }
        }
    }

    protected HistoryModel updateHistoryModel(HistoryComponent historyComponent, HistoryFilterComponent historyFilterComponent) {
        if (historyComponent == this._rightHistoryComponent) {
            this._rightHistoryComponent.setModel((HistoryModel)new BufferHistoryModel(this.getRealURL(), BufferHistoryProvider.getInstance().getTypeFilter()));
            return null;
        }
        return this.updateHistoryModelImpl(historyComponent, historyFilterComponent);
    }

    protected HistoryModel updateHistoryModelImpl(HistoryComponent historyComponent, HistoryFilterComponent historyFilterComponent) {
        DefaultHistoryModel defaultHistoryModel = new DefaultHistoryModel(this._currentHistoryModel);
        this.initializeHistoryModel(defaultHistoryModel, historyComponent);
        if (historyFilterComponent != null) {
            defaultHistoryModel.applyFilter(this.getRealURL(), historyFilterComponent.getSelectedFilter());
        }
        historyComponent.setModel((HistoryModel)defaultHistoryModel);
        return defaultHistoryModel;
    }

    private void initializeHistoryModel(DefaultHistoryModel defaultHistoryModel, HistoryComponent historyComponent) {
        if (defaultHistoryModel instanceof DefaultHistoryModel) {
            if (historyComponent == this._leftHistoryComponent) {
                this.initializeDefaultProperties(this.getTablePersistenceKeyLHS(), defaultHistoryModel);
            }
            if (historyComponent == this._rightHistoryComponent) {
                this.initializeDefaultProperties(this.getTablePersistenceKeyRHS(), defaultHistoryModel);
            }
        }
    }

    private void initializeDefaultProperties(String string, DefaultHistoryModel defaultHistoryModel) {
        Collection collection = (Collection)Ide.getDTCache().getData(string);
        if (collection == null || collection.isEmpty()) {
            this.enableAllDefaultProperties(defaultHistoryModel);
            return;
        }
        ArrayList<HistoryProperty> arrayList = new ArrayList<HistoryProperty>();
        HistoryProperty[] historyPropertyArray = defaultHistoryModel.getProperties();
        int n = 0;
        while (n < historyPropertyArray.length) {
            if (!collection.contains(historyPropertyArray[n].getName())) {
                arrayList.add(historyPropertyArray[n]);
            }
            ++n;
        }
        defaultHistoryModel.setDefaultProperties(arrayList.toArray(new HistoryProperty[0]));
    }

    protected void enableAllDefaultProperties(DefaultHistoryModel defaultHistoryModel) {
        defaultHistoryModel.setDefaultProperties(defaultHistoryModel.getProperties());
    }

    protected Collection getHistoryProviders() {
        return oracle.jdeveloper.history.HistoryManager.getHistoryManager().getProviders();
    }

    private void attachForPersistentSettings() {
        if (this._leftHistoryComponent == null || this._rightHistoryComponent == null) {
            return;
        }
        this._lhsColumnModelListener = new PersistenceTableColumnModelListener(this._leftHistoryComponent, this.getTablePersistenceKeyLHS());
        this._rhsColumnModelListener = new PersistenceTableColumnModelListener(this._rightHistoryComponent, this.getTablePersistenceKeyRHS());
        this._leftHistoryComponent.getTable().getColumnModel().addColumnModelListener(this._lhsColumnModelListener);
        this._rightHistoryComponent.getTable().getColumnModel().addColumnModelListener(this._rhsColumnModelListener);
    }

    private void detachForPersistentSettings() {
        if (this._leftHistoryComponent != null && this._lhsColumnModelListener != null) {
            this._leftHistoryComponent.getTable().getColumnModel().removeColumnModelListener(this._lhsColumnModelListener);
        }
        if (this._rightHistoryComponent != null && this._rhsColumnModelListener != null) {
            this._rightHistoryComponent.getTable().getColumnModel().removeColumnModelListener(this._rhsColumnModelListener);
        }
    }

    private void updateStatusCount(HistoryEntry historyEntry, HistoryEntry historyEntry2, Object object, Object object2) {
        HistoryEntry historyEntry3;
        HistoryEntry historyEntry4;
        if (object != null && object instanceof HistoryEntrySelector && (historyEntry4 = ((HistoryEntrySelector)object).select(this._leftHistoryComponent.getModel())) != null) {
            historyEntry = historyEntry4;
        }
        if (object2 != null && object2 instanceof HistoryEntrySelector && (historyEntry3 = ((HistoryEntrySelector)object2).select(this._rightHistoryComponent.getModel())) != null) {
            historyEntry2 = historyEntry3;
        }
        this.updateStatusCount(historyEntry, historyEntry2);
    }

    private void sortHistoryComponentTables() {
        try {
            this._leftHistoryComponent.sortTableByProperty(SharedProperties.getDateProperty(), false);
            this._rightHistoryComponent.sortTableByProperty(SharedProperties.getDateProperty(), false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateStatusCount(HistoryEntry historyEntry, HistoryEntry historyEntry2) {
        if (this._leftHistoryComponent == null || this._rightHistoryComponent == null) {
            return;
        }
        this.updateStatusCount0(historyEntry, this._leftHistoryComponent);
        this.updateStatusCount0(historyEntry2, this._rightHistoryComponent);
        this.scrollToHistorySelections();
    }

    private void updateStatusCount0(HistoryEntry historyEntry, HistoryComponent historyComponent) {
        if (historyComponent == null) {
            return;
        }
        int n = historyComponent.getTable().getModel().getRowCount();
        if (n > 0) {
            if (historyEntry != null) {
                historyComponent.setSingleSelection(historyEntry);
            }
            if (historyComponent.getSingleSelection() == null) {
                historyComponent.getTable().setRowSelectionInterval(0, 0);
            }
        }
    }

    private void scrollToHistorySelections() {
        if (this._leftHistoryComponent.getTable().getModel().getRowCount() > 0) {
            this._leftHistoryComponent.getTable().scrollToSelection();
        }
        if (this._rightHistoryComponent.getTable().getModel().getRowCount() > 0) {
            this._rightHistoryComponent.getTable().scrollToSelection();
        }
    }

    public Controller getController() {
        return HistoryController.getInstance();
    }

    public Toolbar getToolbar() {
        if (this._toolbar == null) {
            this._toolbar = new Toolbar();
            this._toolbar.setMinimumSize(new Dimension(0, 0));
        }
        return this._toolbar;
    }

    public Component getFixedTopMargin() {
        return this.getToolbar();
    }

    public Component getBottomComponent() {
        return this._horizontalScrollWrapper;
    }

    public Object getEditorAttribute(String string) {
        if ("scrollable".equals(string)) {
            return Boolean.FALSE;
        }
        if ("horizontal_scrollbar_policy".equals(string)) {
            return new Integer(31);
        }
        if ("vertical_scrollbar_policy".equals(string)) {
            return new Integer(21);
        }
        if ("menu_id".equals(string)) {
            return HistoryArb.getString(26);
        }
        return super.getEditorAttribute(string);
    }

    public void update(Object object, UpdateMessage updateMessage) {
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_scslocalhistory_html");
    }

    public ContextMenu getContextMenu() {
        return oracle.jdeveloper.history.HistoryManager.getHistoryManager().getContextMenu();
    }

    public Component getGUI() {
        if (this._splitPane == null) {
            this._splitPane = new JSplitPane(0);
        }
        return this._splitPane;
    }

    public void setContext(Context context) {
        super.setContext(context);
        this._node = context.getNode();
        context.setView((View)this);
        HistoryContext.setRealURL(context, this.getRealURL());
        URL uRL = this.getRealURL();
        URL uRL2 = URLFileSystem.getParent((URL)uRL);
        String string = URLFileSystem.getFileName((URL)uRL);
        String string2 = URLFileSystem.getPlatformPathName((URL)uRL2);
        AccessibleUtils.updateAccessibleName((Accessible)((Accessible)((Object)this.getGUI())), (String)MessageFormat.format(HistoryArb.getString(9), string, string2), (boolean)true);
    }

    public Context getContext(EventObject eventObject) {
        Context context = super.getContext(eventObject);
        if (context != null) {
            context.setNode(this._node);
            context.setView((View)this);
            HistoryContext.setRealURL(context, this.getRealURL());
        }
        return context;
    }

    public void open() {
        if (this.getRealURL() != null) {
            this.getGUI();
            this.installHistoryModel();
            this.initializeToolbars();
            Ide.addIdeListener((IdeListener)new 3());
            this._mouseListener = new ContextMenuMouseListener(null);
            this._leftHistoryComponent.addMouseListener(this._mouseListener);
            this._rightHistoryComponent.addMouseListener(this._mouseListener);
            this._historySelectionListener = new HistorySelectionListener(null);
            this._leftHistoryComponent.addListSelectionListener((ListSelectionListener)this._historySelectionListener);
            this._rightHistoryComponent.addListSelectionListener((ListSelectionListener)this._historySelectionListener);
            this._leftHistoryComponent.getTable().addFocusListener((FocusListener)this._historySelectionListener);
            this._rightHistoryComponent.getTable().addFocusListener((FocusListener)this._historySelectionListener);
            this._lastActiveHistoryComponent = this._leftHistoryComponent;
            2 var1_1 = new 2();
            Timer timer = new Timer(500, var1_1);
            timer.setRepeats(false);
            timer.start();
        }
    }

    protected void initializeToolbars() {
        this.getToolbar().removeAll();
        if (this._filter != null) {
            this.addToolbarSeparator();
            this.getToolbar().add((Component)this._label);
            this.getToolbar().add((Component)this._filter);
        }
        this.addToolbarSeparator();
        this._toolbar.add((ToggleAction)this.getLocalAction(HistoryAddin.CUSTOMIZE_FILTERS_CMD_ID));
        this.getToolbar().add((ToggleAction)this.getLocalAction(51));
        this.addToolbarSeparator();
        this.getToolbar().add((ToggleAction)this.getLocalAction(Ide.findCmdID((String)"compare.navigateFirst")));
        this.getToolbar().add((ToggleAction)this.getLocalAction(Ide.findCmdID((String)"compare.navigatePrevious")));
        this.getToolbar().add((ToggleAction)this.getLocalAction(Ide.findCmdID((String)"compare.navigateNext")));
        this.getToolbar().add((ToggleAction)this.getLocalAction(Ide.findCmdID((String)"compare.navigateLast")));
        if (this.isLocalHistoryView()) {
            this.addToolbarSeparator();
            this.getToolbar().add((ToggleAction)this.getLocalAction(HistoryAddin.PURGE_HISTORY_CMD_ID));
        }
        if (this.isEditableRHS()) {
            if (!this.isLocalHistoryView()) {
                this.addToolbarSeparator();
            }
            this.getToolbar().add((ToggleAction)this.getLocalAction(HistoryManager.RESTORE_HISTORY_CMD_ID));
        }
        if (!this.isLocalHistoryView() && !this.isEditableRHS()) {
            this.addToolbarSeparator();
        }
        this.getToolbar().add((ToggleAction)this.getLocalAction(Ide.findCmdID((String)CreatePatchCommand.CREATE_PATCH_CMD)));
        this.getToolbar().repaint();
    }

    private void addToolbarSeparator() {
        if (this.getToolbar().getComponentCount() > 0) {
            this.getToolbar().addSeparator();
        }
    }

    protected boolean isEditableRHS() {
        return true;
    }

    protected double getDefaultDividerLocation() {
        return 0.25;
    }

    public void close() {
        this.detachForPersistentSettings();
        if (this._compareView instanceof WedgeCompareView) {
            HistoryViewer.deinstallUndoableEditListener(this, (WedgeCompareView)this._compareView);
        }
        this._leftUpdater = null;
        this._rightUpdater = null;
        this.disposeHistoryFilters();
        this._historyPanel = null;
        this._horizontalScrollWrapper = null;
        this._noHistoryPanel = null;
        this._compareView = null;
        this._toolbar = null;
        this._splitPane = null;
        this._label = null;
        this._filter = null;
        this._mouseListener = null;
        this._statusLabel = null;
        this._lhsColumnModelListener = null;
        this._rhsColumnModelListener = null;
        this._currentHistoryModel = null;
        if (this._historySelectionListener != null) {
            this._leftHistoryComponent.removeListSelectionListener((ListSelectionListener)this._historySelectionListener);
            this._rightHistoryComponent.removeListSelectionListener((ListSelectionListener)this._historySelectionListener);
            this._leftHistoryComponent.getTable().removeFocusListener((FocusListener)this._historySelectionListener);
            this._rightHistoryComponent.getTable().removeFocusListener((FocusListener)this._historySelectionListener);
        }
        this._historySelectionListener = null;
        this._lastActiveHistoryComponent = null;
        this._leftHistoryComponent = null;
        this._rightHistoryComponent = null;
        super.close();
    }

    public CompareView getCompareView() {
        if (this._compareView != null && this._splitPane.getBottomComponent() == this._compareView.getGUI()) {
            return this._compareView;
        }
        return null;
    }

    private void updateCompareView() throws Exception {
        HistoryEntry historyEntry = this._leftHistoryComponent.getSingleSelection();
        HistoryEntry historyEntry2 = this._rightHistoryComponent.getSingleSelection();
        int n = 0;
        CompareModel compareModel = null;
        CompareContributor compareContributor = null;
        CompareContributor compareContributor2 = null;
        if (historyEntry != null && historyEntry2 != null && CompareViewer.isContentComparable(this.getRealURL()) && (compareContributor = historyEntry.getCompareContributor()) != null) {
            compareContributor2 = historyEntry2.getCompareContributor();
        }
        if (compareContributor != null && compareContributor2 != null) {
            compareModel = CompareModelFactory.createCompareModel(compareContributor, compareContributor2);
            if (this._compareView == null) {
                this._compareView = this.createCompareView(compareModel);
                if (this._compareView instanceof WedgeCompareView) {
                    HistoryViewer.installUndoableEditListener(this, (WedgeCompareView)this._compareView);
                }
                if (this._compareView instanceof NavigableView) {
                    this._positionChangeListener = new 1();
                    ((NavigableView)this._compareView).addPositionListener(this._positionChangeListener);
                }
                this._splitPane.setBottomComponent(this._compareView.getGUI());
                if (this._compareView instanceof CustomHorizontalScrollView) {
                    this._horizontalScrollWrapper = new JPanel();
                    this._horizontalScrollWrapper.setLayout(new BorderLayout());
                    this._horizontalScrollWrapper.removeAll();
                    this._horizontalScrollWrapper.add(((CustomHorizontalScrollView)this._compareView).getHorizontalScrollComponent(), "Center");
                }
                if (this._compareView instanceof EditorPaneView) {
                    ((EditorPaneView)this._compareView).removePopupManager((PopupManager)this);
                    ((EditorPaneView)this._compareView).addPopupManager((PopupManager)this);
                }
            } else {
                if (this._compareView instanceof WedgeCompareView) {
                    HistoryViewer.deinstallUndoableEditListener(this, (WedgeCompareView)this._compareView);
                }
                if (this._compareView instanceof NavigableView) {
                    ((NavigableView)this._compareView).removePositionListener(this._positionChangeListener);
                }
                this._compareView.setModel(compareModel);
                if (this._splitPane.getBottomComponent() != this._compareView.getGUI()) {
                    int n2 = this._splitPane.getDividerLocation();
                    this._splitPane.setBottomComponent(this._compareView.getGUI());
                    this._splitPane.setDividerLocation(n2);
                }
                if (this._compareView instanceof WedgeCompareView) {
                    HistoryViewer.installUndoableEditListener(this, (WedgeCompareView)this._compareView);
                }
                if (this._compareView instanceof NavigableView) {
                    ((NavigableView)this._compareView).addPositionListener(this._positionChangeListener);
                }
            }
            int[] nArray = compareModel.getDifferenceTypeCounts();
            n = compareModel.getDifferenceCount();
            if (n == 0) {
                this._statusLabel.setText(CompareArb.getString(31));
            } else {
                this._statusLabel.setText(MessageFormat.format(CompareArb.getString(32), String.valueOf(n), String.valueOf(nArray[0]), String.valueOf(nArray[1]), String.valueOf(nArray[2])));
            }
        } else {
            if (this._compareView instanceof WedgeCompareView) {
                HistoryViewer.deinstallUndoableEditListener(this, (WedgeCompareView)this._compareView);
            }
            int n3 = this._splitPane.getDividerLocation();
            if (this._noHistoryPanel == null) {
                this._noHistoryPanel = this.createNoHistoryPanel();
            }
            this._splitPane.setBottomComponent(this._noHistoryPanel);
            this._splitPane.setDividerLocation(n3);
            this._statusLabel.setText(CompareArb.getString(31));
        }
        if (this._statusListener != null) {
            this._statusListener.stateChanged(new ChangeEvent(this));
        }
        if (this._compareView instanceof NavigableView) {
            ((NavigableView)this._compareView).goToInitialDifference();
        }
    }

    protected CompareView createCompareView(CompareModel compareModel) {
        return CompareViewFactory.createCompareView((CompareModel)compareModel);
    }

    private static final void installUndoableEditListener(HistoryViewer historyViewer, WedgeCompareView wedgeCompareView) {
        Node node;
        Node node2;
        Document document;
        Document document2 = document = wedgeCompareView != null ? wedgeCompareView.getDocument(ContributorKind.FIRST) : null;
        if (document instanceof BasicDocument && (node2 = historyViewer.getContext().getNode()) != null) {
            BasicDocument basicDocument = (BasicDocument)document;
            basicDocument.addUndoableEditListener((UndoableEditListener)historyViewer);
            historyViewer._leftUpdater = NodeUpdater.getUpdater((Subject)node2, (TextBuffer)basicDocument.getTextBuffer());
        }
        Document document3 = document = wedgeCompareView != null ? wedgeCompareView.getDocument(ContributorKind.SECOND) : null;
        if (document instanceof BasicDocument && (node = historyViewer.getContext().getNode()) != null) {
            BasicDocument basicDocument = (BasicDocument)document;
            basicDocument.addUndoableEditListener((UndoableEditListener)historyViewer);
            historyViewer._rightUpdater = NodeUpdater.getUpdater((Subject)node, (TextBuffer)basicDocument.getTextBuffer());
        }
    }

    private static final void deinstallUndoableEditListener(HistoryViewer historyViewer, WedgeCompareView wedgeCompareView) {
        Document document;
        Document document2 = document = wedgeCompareView != null ? wedgeCompareView.getDocument(ContributorKind.FIRST) : null;
        if (document instanceof BasicDocument) {
            BasicDocument basicDocument = (BasicDocument)document;
            basicDocument.removeUndoableEditListener((UndoableEditListener)historyViewer);
            historyViewer._leftUpdater = null;
        }
        Document document3 = document = wedgeCompareView != null ? wedgeCompareView.getDocument(ContributorKind.SECOND) : null;
        if (document instanceof BasicDocument) {
            BasicDocument basicDocument = (BasicDocument)document;
            basicDocument.removeUndoableEditListener((UndoableEditListener)historyViewer);
            historyViewer._rightUpdater = null;
        }
    }

    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        UndoableEdit undoableEdit = undoableEditEvent.getEdit();
        WedgeCompareView wedgeCompareView = (WedgeCompareView)this._compareView;
        NodeUpdater nodeUpdater = undoableEditEvent.getSource() == wedgeCompareView.getDocument(ContributorKind.FIRST) ? this._leftUpdater : this._rightUpdater;
        UndoWrapperCommand undoWrapperCommand = new UndoWrapperCommand(undoableEdit, (Object)nodeUpdater);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        undoWrapperCommand.setContext(this.getContext());
        try {
            commandProcessor.invoke((Command)undoWrapperCommand);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public HistoryElement[] getSelectionLHS() {
        return this.getSelection(this._leftHistoryComponent);
    }

    public HistoryElement[] getSelectionRHS() {
        return this.getSelection(this._rightHistoryComponent);
    }

    public HistoryElement[] getSelection(HistoryComponent historyComponent) {
        try {
            if (historyComponent == null) {
                HistoryElement[] historyElementArray = new HistoryElement[]{};
                return historyElementArray;
            }
            HistoryEntry[] historyEntryArray = historyComponent.getSelection();
            if (historyEntryArray == null) {
                HistoryElement[] historyElementArray = new HistoryElement[]{};
                return historyElementArray;
            }
            HistoryElement[] historyElementArray = new HistoryElement[historyEntryArray.length];
            int n = 0;
            while (n < historyEntryArray.length) {
                historyElementArray[n] = new HistoryElement(historyEntryArray[n]);
                ++n;
            }
            HistoryElement[] historyElementArray2 = historyElementArray;
            return historyElementArray2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new HistoryElement[0];
        }
    }

    public BasicEditorPane getFocusedEditorPane() {
        if (this._compareView instanceof EditorPaneView) {
            return ((EditorPaneView)this._compareView).getCurrentEditorPane();
        }
        return null;
    }

    public void showPopup(BasicEditorPane basicEditorPane, MouseEvent mouseEvent) {
        ContextMenu contextMenu = this.getContextMenu();
        if (contextMenu != null) {
            Context context = new Context(this.getContext());
            HistoryContext.setHistoryEntrySelectorLHS(context, null);
            HistoryContext.setHistoryEntrySelectorRHS(context, null);
            context.setEvent((EventObject)mouseEvent);
            contextMenu.show(context);
        }
    }

    public void hidePopup(BasicEditorPane basicEditorPane) {
    }

    public JComponent[] getCustomCells() {
        return new JComponent[]{this._statusLabel};
    }

    public boolean isExpandable(JComponent jComponent) {
        return true;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._statusListener = changeListener;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (changeListener == this._statusListener) {
            this._statusListener = null;
        }
    }

    protected IdeAction getLocalAction(int n) {
        IdeAction ideAction = IdeAction.find((int)n);
        if (ideAction != null) {
            IdeAction ideAction2 = ideAction.newLocalAction((View)this);
            return ideAction2;
        }
        throw new IllegalArgumentException("CMDID " + n + " not found");
    }

    public HistoryViewer() {
        this.$init$();
    }

    static DefaultHistoryModel ra$_currentHistoryModel(HistoryViewer historyViewer) {
        return historyViewer._currentHistoryModel;
    }

    static void mav$initializeHistoryModel(HistoryViewer historyViewer, DefaultHistoryModel defaultHistoryModel, HistoryComponent historyComponent) {
        historyViewer.initializeHistoryModel(defaultHistoryModel, historyComponent);
    }

    static void mav$updateStatusCount(HistoryViewer historyViewer, HistoryEntry historyEntry, HistoryEntry historyEntry2, Object object, Object object2) {
        historyViewer.updateStatusCount(historyEntry, historyEntry2, object, object2);
    }

    static void mav$attachForPersistentSettings(HistoryViewer historyViewer) {
        historyViewer.attachForPersistentSettings();
    }

    static void mav$sortHistoryComponentTables(HistoryViewer historyViewer) {
        historyViewer.sortHistoryComponentTables();
    }

    static void mav$detachForPersistentSettings(HistoryViewer historyViewer) {
        historyViewer.detachForPersistentSettings();
    }

    static JSplitPane ra$_splitPane(HistoryViewer historyViewer) {
        return historyViewer._splitPane;
    }

    static HistoryComponent ra$_leftHistoryComponent(HistoryViewer historyViewer) {
        return historyViewer._leftHistoryComponent;
    }

    static HistoryComponent ra$_rightHistoryComponent(HistoryViewer historyViewer) {
        return historyViewer._rightHistoryComponent;
    }

    static void mav$scrollToHistorySelections(HistoryViewer historyViewer) {
        historyViewer.scrollToHistorySelections();
    }

    static void mav$updateCompareView(HistoryViewer historyViewer) {
        historyViewer.updateCompareView();
    }

    static void wa$_lastActiveHistoryComponent(HistoryViewer historyViewer, HistoryComponent historyComponent) {
        historyViewer._lastActiveHistoryComponent = historyComponent;
    }

    public final class 7
    extends HistoryFilterComponent {
        protected HistoryModel createHistoryModel(HistoryFilter historyFilter, HistoryComponent historyComponent) {
            if (HistoryViewer.ra$_currentHistoryModel(HistoryViewer.this) == null) {
                return null;
            }
            DefaultHistoryModel defaultHistoryModel = new DefaultHistoryModel(HistoryViewer.ra$_currentHistoryModel(HistoryViewer.this));
            HistoryViewer.mav$initializeHistoryModel(HistoryViewer.this, defaultHistoryModel, historyComponent);
            if (historyFilter != null) {
                defaultHistoryModel.applyFilter(HistoryViewer.this.getRealURL(), historyFilter);
            }
            return defaultHistoryModel;
        }

        public 7(HistoryComponent historyComponent, URL uRL, HistoryFilter historyFilter, Collection collection) {
            super(historyComponent, uRL, historyFilter, collection);
        }
    }

    public final class 6
    implements ItemListener {
        private final /* synthetic */ HistoryFilterComponent v$filter;
        final /* synthetic */ HistoryViewer this$0;

        public void itemStateChanged(ItemEvent itemEvent) {
            this.v$filter.refilter();
        }

        public 6(HistoryViewer historyViewer, HistoryFilterComponent historyFilterComponent) {
            this.v$filter = historyFilterComponent;
            this.this$0 = historyViewer;
        }
    }

    public final class 5
    implements Runnable {
        private final /* synthetic */ HistoryEntry v$selectionLhs;
        private final /* synthetic */ HistoryEntry v$selectionRhs;
        private final /* synthetic */ Object v$historyEntrySelectorLhs;
        private final /* synthetic */ Object v$historyEntrySelectorRhs;
        final /* synthetic */ HistoryViewer this$0;

        public void run() {
            HistoryViewer.mav$updateStatusCount(this.this$0, this.v$selectionLhs, this.v$selectionRhs, this.v$historyEntrySelectorLhs, this.v$historyEntrySelectorRhs);
            HistoryViewer.mav$attachForPersistentSettings(this.this$0);
        }

        public 5(HistoryViewer historyViewer, HistoryEntry historyEntry, HistoryEntry historyEntry2, Object object, Object object2) {
            this.v$historyEntrySelectorRhs = object2;
            this.v$historyEntrySelectorLhs = object;
            this.v$selectionRhs = historyEntry2;
            this.v$selectionLhs = historyEntry;
            this.this$0 = historyViewer;
        }
    }

    public final class 4
    extends CompletionListener {
        private final /* synthetic */ HistoryEntry v$selectionLhs;
        private final /* synthetic */ HistoryEntry v$selectionRhs;
        private final /* synthetic */ Object v$historyEntrySelectorLhs;
        private final /* synthetic */ Object v$historyEntrySelectorRhs;
        final /* synthetic */ HistoryViewer this$0;

        protected void complete() {
            HistoryViewer.mav$sortHistoryComponentTables(this.this$0);
            HistoryViewer.mav$updateStatusCount(this.this$0, this.v$selectionLhs, this.v$selectionRhs, this.v$historyEntrySelectorLhs, this.v$historyEntrySelectorRhs);
            HistoryViewer.mav$attachForPersistentSettings(this.this$0);
        }

        public 4(HistoryViewer historyViewer, HistoryViewer historyViewer2, HistoryEntry historyEntry, HistoryEntry historyEntry2, Object object, Object object2) {
            this.v$historyEntrySelectorRhs = object2;
            this.v$historyEntrySelectorLhs = object;
            this.v$selectionRhs = historyEntry2;
            this.v$selectionLhs = historyEntry;
            this.this$0 = historyViewer;
            super(null);
        }
    }

    private class PersistenceTableColumnModelListener
    implements TableColumnModelListener {
        private final HistoryComponent _historyComponent;
        private final String _key;

        PersistenceTableColumnModelListener(HistoryComponent historyComponent, String string) {
            this._historyComponent = historyComponent;
            this._key = string;
        }

        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            this.storePersistentSettings();
        }

        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            this.storePersistentSettings();
        }

        public void columnMarginChanged(ChangeEvent changeEvent) {
        }

        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }

        private void storePersistentSettings() {
            EventQueue.invokeLater(new 1());
        }

        static HistoryComponent ra$_historyComponent(PersistenceTableColumnModelListener persistenceTableColumnModelListener) {
            return persistenceTableColumnModelListener._historyComponent;
        }

        static String ra$_key(PersistenceTableColumnModelListener persistenceTableColumnModelListener) {
            return persistenceTableColumnModelListener._key;
        }

        public final class 1
        implements Runnable {
            public void run() {
                HistoryProperty[] historyPropertyArray = PersistenceTableColumnModelListener.ra$_historyComponent(PersistenceTableColumnModelListener.this).getHiddenProperties();
                ArrayList<String> arrayList = new ArrayList<String>();
                int n = 0;
                while (n < historyPropertyArray.length) {
                    arrayList.add(historyPropertyArray[n].getName());
                    ++n;
                }
                Ide.getDTCache().putData(PersistenceTableColumnModelListener.ra$_key(PersistenceTableColumnModelListener.this), arrayList);
            }
        }
    }

    public final class 3
    extends IdeAdapter {
        public void mainWindowClosing(IdeEvent ideEvent) {
            HistoryViewer.mav$detachForPersistentSettings(HistoryViewer.this);
        }
    }

    public final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (HistoryViewer.ra$_splitPane(HistoryViewer.this) != null) {
                HistoryViewer.ra$_splitPane(HistoryViewer.this).setDividerLocation(HistoryViewer.this.getDefaultDividerLocation());
                HistoryViewer.ra$_splitPane(HistoryViewer.this).validate();
                HistoryViewer.ra$_splitPane(HistoryViewer.this).repaint();
            }
            if (HistoryViewer.ra$_leftHistoryComponent(HistoryViewer.this) != null && HistoryViewer.ra$_rightHistoryComponent(HistoryViewer.this) != null) {
                HistoryViewer.mav$scrollToHistorySelections(HistoryViewer.this);
            }
        }
    }

    private class HistorySelectionListener
    extends FocusAdapter
    implements ListSelectionListener {
        public void focusGained(FocusEvent focusEvent) {
            this.updateLastActiveHistoryComponent(focusEvent.getComponent());
            HistoryViewer.this.scheduleUpdateSelection();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.updateLastActiveHistoryComponent(focusEvent.getOppositeComponent());
            HistoryViewer.this.scheduleUpdateSelection();
        }

        private void updateLastActiveHistoryComponent(Component component) {
            if (HistoryViewer.ra$_leftHistoryComponent(HistoryViewer.this) != null && component == HistoryViewer.ra$_leftHistoryComponent(HistoryViewer.this).getTable()) {
                HistoryViewer.wa$_lastActiveHistoryComponent(HistoryViewer.this, HistoryViewer.ra$_leftHistoryComponent(HistoryViewer.this));
            }
            if (HistoryViewer.ra$_rightHistoryComponent(HistoryViewer.this) != null && component == HistoryViewer.ra$_rightHistoryComponent(HistoryViewer.this).getTable()) {
                HistoryViewer.wa$_lastActiveHistoryComponent(HistoryViewer.this, HistoryViewer.ra$_rightHistoryComponent(HistoryViewer.this));
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            try {
                try {
                    HistoryViewer.mav$updateCompareView(HistoryViewer.this);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            finally {
                HistoryViewer.this.scheduleUpdateSelection();
            }
        }

        private HistorySelectionListener() {
        }

        HistorySelectionListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    public final class 1
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            HistoryViewer.this.updateVisibleActions();
        }
    }

    private abstract class CompletionListener
    implements HistoryModelListener {
        protected abstract void complete();

        public void completenessChanged(HistoryModelEvent historyModelEvent) {
            try {
                HistoryModel historyModel = (HistoryModel)historyModelEvent.getSource();
                if (historyModel.isComplete()) {
                    SwingUtilities.invokeLater(new 1());
                    historyModel.removeHistoryModelListener((HistoryModelListener)this);
                }
            }
            catch (RuntimeException runtimeException) {
                ExceptionDialog.showExceptionDialog((Context)HistoryViewer.this.getContext(), (Throwable)runtimeException);
            }
        }

        public void entriesChanged(HistoryModelEvent historyModelEvent) {
        }

        public void entriesInserted(HistoryModelEvent historyModelEvent) {
        }

        public void entriesRemoved(HistoryModelEvent historyModelEvent) {
        }

        private CompletionListener() {
        }

        CompletionListener(4 var2_2) {
            this();
        }

        public final class 1
        implements Runnable {
            public void run() {
                CompletionListener.this.complete();
            }
        }
    }

    private class ContextMenuMouseListener
    extends MouseAdapter {
        private void doIt(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (!(object instanceof JTable)) {
                return;
            }
            JTable jTable = (JTable)object;
            ContextMenu contextMenu = HistoryViewer.this.getContextMenu();
            if (mouseEvent.isPopupTrigger()) {
                int n = jTable.rowAtPoint(mouseEvent.getPoint());
                if (n >= 0 && !jTable.isRowSelected(n)) {
                    jTable.setRowSelectionInterval(n, n);
                }
                jTable.requestFocus();
                EventQueue.invokeLater(new 1(this, contextMenu, mouseEvent));
            } else if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1 && jTable.rowAtPoint(mouseEvent.getPoint()) >= 0) {
                contextMenu.fireDefaultAction(HistoryViewer.this.getContext(mouseEvent));
                mouseEvent.consume();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.doIt(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.doIt(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.doIt(mouseEvent);
        }

        private ContextMenuMouseListener() {
        }

        ContextMenuMouseListener(1 var2_2) {
            this();
        }

        public final class 1
        implements Runnable {
            private final /* synthetic */ ContextMenu v$menu;
            private final /* synthetic */ MouseEvent v$me;
            final /* synthetic */ ContextMenuMouseListener this$0;

            public void run() {
                this.v$menu.show(this.this$0.HistoryViewer.this.getContext(this.v$me));
            }

            public 1(ContextMenuMouseListener contextMenuMouseListener, ContextMenu contextMenu, MouseEvent mouseEvent) {
                this.v$me = mouseEvent;
                this.v$menu = contextMenu;
                this.this$0 = contextMenuMouseListener;
            }
        }
    }

    private static final class BufferHistoryModel
    extends DefaultHistoryModel {
        BufferHistoryModel(URL uRL, HistoryFilter historyFilter) {
            BufferHistoryProvider bufferHistoryProvider = BufferHistoryProvider.getInstance();
            if (((HistoryProvider)bufferHistoryProvider).isProviderFor(uRL)) {
                this.addProperties(((HistoryProvider)bufferHistoryProvider).getProperties());
                HistoryEntry[] historyEntryArray = ((HistoryProvider)bufferHistoryProvider).getEntries(uRL, null);
                this.addEntries(historyEntryArray);
            }
        }
    }
}

