/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.history;

import java.io.IOException;
import java.net.URL;
import oracle.ide.history.LocalState;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.history.DefaultHistoryEntry;
import oracle.jdeveloper.compare.PatchCompareDescriptor;
import oracle.jdeveloper.compare.URLContributor;
import oracle.jdeveloper.history.RevisionIdentifier;
import oracle.jdeveloper.history.SharedProperties;
import oracle.jdeveloper.resource.HistoryArb;

final class LocalHistoryEntry
extends DefaultHistoryEntry {
    private static final RevisionIdentifier _LOCAL_REVISION = new RevisionIdentifier(HistoryArb.getIcon(13), HistoryArb.getString(12));
    private final LocalState _state;

    LocalHistoryEntry(LocalState localState) {
        this._state = localState;
        this.setValue(SharedProperties.getDateProperty(), localState.getDate());
        this.setValue(SharedProperties.getRevisionProperty(), _LOCAL_REVISION);
        this.setValue(SharedProperties.getDescriptionProperty(), localState.getDescription());
    }

    public CompareContributor getCompareContributor() {
        try {
            LocalHistoryContributor localHistoryContributor = new LocalHistoryContributor(this._state);
            return localHistoryContributor;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public LocalState getState() {
        return this._state;
    }

    private static final class LocalHistoryContributor
    extends URLContributor {
        private final LocalState _state;
        private final String _type;

        public LocalHistoryContributor(LocalState localState) throws IOException {
            super(localState.getNodeURL(), localState.getDataURL());
            this._type = LocalHistoryContributor.getPlatformPathSuffix(localState.getNodeURL());
            this._state = localState;
        }

        public String getType() {
            return this._type;
        }

        public String getShortLabel() {
            return URLFileSystem.getFileName((URL)this._state.getNodeURL());
        }

        public String getLongLabel() {
            return URLFileSystem.getPlatformPathName((URL)this._state.getNodeURL());
        }

        public PatchCompareDescriptor getPatchDescriptor() {
            PatchCompareDescriptor patchCompareDescriptor = new PatchCompareDescriptor(URLFileSystem.getFileName((URL)this._state.getNodeURL()));
            patchCompareDescriptor.setPatchParentURL(URLFileSystem.getParent((URL)this._state.getNodeURL()));
            patchCompareDescriptor.setLastModified(URLFileSystem.lastModified((URL)this._state.getNodeURL()));
            return patchCompareDescriptor;
        }
    }
}

