/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.history;

import java.net.URL;
import java.util.ArrayList;
import oracle.ide.history.HistoryManager;
import oracle.ide.history.LocalState;
import oracle.ide.model.Recognizer;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.history.HistoryProperty;
import oracle.jdeveloper.history.HistoryFilter;
import oracle.jdeveloper.history.HistoryProvider;
import oracle.jdeveloper.history.SharedProperties;
import oracle.jdeveloper.resource.HistoryArb;
import oracle.jdevimpl.history.LocalHistoryEntry;

class LocalHistoryProvider
extends HistoryProvider {
    static final HistoryProperty[] PROPERTIES = new HistoryProperty[]{SharedProperties.getDateProperty(), SharedProperties.getRevisionProperty(), SharedProperties.getDescriptionProperty()};
    private static final HistoryFilter _TYPE_FILTER = new 1();

    public HistoryFilter getTypeFilter() {
        return _TYPE_FILTER;
    }

    public HistoryProperty[] getProperties() {
        return PROPERTIES;
    }

    public boolean isProviderFor(URL uRL) {
        try {
            if (uRL.getProtocol() != null && !uRL.getProtocol().equals("file")) {
                boolean bl = false;
                return bl;
            }
            HistoryManager historyManager = HistoryManager.getHistoryManager();
            if (historyManager != null) {
                if (URLFileSystem.isDirectory((URL)uRL)) {
                    boolean bl = false;
                    return bl;
                }
                Class clazz = Recognizer.recognizeURL((URL)uRL);
                boolean bl = clazz != null && historyManager.getRegisteredHistorian(clazz) != null;
                return bl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public HistoryEntry[] getEntries(URL uRL, HistoryFilter historyFilter) {
        ArrayList<LocalHistoryEntry> arrayList = new ArrayList<LocalHistoryEntry>();
        try {
            LocalState[] localStateArray = null;
            HistoryManager historyManager = HistoryManager.getHistoryManager();
            if (historyManager != null && !URLFileSystem.isDirectory((URL)uRL) && (localStateArray = historyManager.getLocalHistory(uRL)) != null && localStateArray.length > 0) {
                int n = 0;
                while (n < localStateArray.length) {
                    arrayList.add(new LocalHistoryEntry(localStateArray[n]));
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        HistoryEntry[] historyEntryArray = new HistoryEntry[arrayList.size()];
        arrayList.toArray(historyEntryArray);
        return historyEntryArray;
    }

    static final class 1
    implements HistoryFilter {
        public String getShortLabel() {
            return HistoryArb.getString(10);
        }

        public boolean accept(HistoryEntry historyEntry) {
            return historyEntry instanceof LocalHistoryEntry;
        }
    }
}

