/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.history;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.history.LocalState;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.history.HistoryComponent;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.history.HistoryModel;
import oracle.jdeveloper.compare.StreamDecoder;
import oracle.jdeveloper.history.DefaultHistoryModel;
import oracle.jdeveloper.history.HistoryManager;
import oracle.jdeveloper.history.SharedProperties;
import oracle.jdevimpl.history.LocalHistoryEntry;
import oracle.jdevimpl.history.LocalHistoryProvider;
import oracle.jdevimpl.resource.HistoryArb;

public class RestoreDeletionsPanel
extends JPanel {
    private CardLayout mainLayout;
    private Border emptyBorder;
    private Border paddedBorder;
    private JSplitPane verticalSplit;
    private JSplitPane horizontalSplit;
    private BorderLayout objectLayout;
    private JPanel objectPanel;
    private JLabel objectLabel;
    private JScrollPane objectScroll;
    private CustomJTree objectTree;
    private DefaultMutableTreeNode objectTreeRoot;
    private JPanel historyPanel;
    private BorderLayout historyLayout;
    private JLabel historyLabel;
    private JScrollPane historyScroll;
    private HistoryComponent historyList;
    private JPanel previewPanel;
    private BorderLayout previewLayout;
    private JLabel previewLabel;
    private JScrollPane previewScroll;
    private BasicEditorPane previewEditPane;
    private HashMap objectTreeNodes;
    private HashMap revisionMappings;

    void $init$() {
        this.mainLayout = new CardLayout();
        this.emptyBorder = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        this.paddedBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        this.verticalSplit = new JSplitPane();
        this.horizontalSplit = new JSplitPane();
        this.objectLayout = new BorderLayout();
        this.objectPanel = new JPanel();
        this.objectLabel = new JLabel();
        this.objectScroll = new JScrollPane();
        this.objectTree = new CustomJTree();
        this.historyPanel = new JPanel();
        this.historyLayout = new BorderLayout();
        this.historyLabel = new JLabel();
        this.historyScroll = new JScrollPane();
        this.historyList = HistoryManager.getHistoryManager().createHistoryComponent();
        this.previewPanel = new JPanel();
        this.previewLayout = new BorderLayout();
        this.previewLabel = new JLabel();
        this.previewScroll = new JScrollPane();
        this.previewEditPane = new BasicEditorPane();
        this.objectTreeNodes = new HashMap();
        this.revisionMappings = new HashMap();
    }

    public RestoreDeletionsPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.mainLayout);
        this.verticalSplit.setOrientation(0);
        this.horizontalSplit.setBorder(this.emptyBorder);
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
        JTreeCellData jTreeCellData = new JTreeCellData(null, null, true, TriStateBoolean.TRUE);
        this.objectTreeRoot = new JMutableTreeNode(jTreeCellData);
        defaultTreeSelectionModel.setSelectionMode(1);
        this.objectLayout.setVgap(2);
        this.objectPanel.setLayout(this.objectLayout);
        this.objectPanel.setBorder(this.emptyBorder);
        this.objectLabel.setBorder(this.paddedBorder);
        ResourceUtils.resLabel((JLabel)this.objectLabel, (Component)this.objectTree, (String)HistoryArb.getString(11));
        this.objectScroll.setBorder(this.emptyBorder);
        this.objectTree.setBorder(this.emptyBorder);
        this.objectTree.setModel((TreeModel)new DefaultTreeModel(this.objectTreeRoot));
        this.objectTree.setRootVisible(false);
        this.objectTree.setScrollsOnExpand(true);
        this.objectTree.setSelectionModel((TreeSelectionModel)defaultTreeSelectionModel);
        this.objectTree.addTreeSelectionListener((TreeSelectionListener)new 2());
        this.historyLayout.setVgap(2);
        this.historyPanel.setLayout(this.historyLayout);
        this.historyPanel.setBorder(this.emptyBorder);
        this.historyLabel.setBorder(this.paddedBorder);
        ResourceUtils.resLabel((JLabel)this.historyLabel, (Component)this.historyList.getTable(), (String)HistoryArb.getString(12));
        this.historyScroll.setBorder(this.emptyBorder);
        this.historyList.setSingleSelection(true);
        this.historyList.setBorder(this.emptyBorder);
        this.historyList.addListSelectionListener((ListSelectionListener)new 1());
        this.previewLayout.setVgap(2);
        this.previewPanel.setLayout(this.previewLayout);
        this.previewPanel.setBorder(this.emptyBorder);
        this.previewLabel.setBorder(this.paddedBorder);
        ResourceUtils.resLabel((JLabel)this.previewLabel, (Component)this.previewEditPane, (String)HistoryArb.getString(13));
        this.previewScroll.setBorder(this.emptyBorder);
        this.previewEditPane.setEditable(false);
        this.previewEditPane.setBorder(this.emptyBorder);
        this.historyScroll.getViewport().add((Component)this.historyList, null);
        this.historyPanel.add((Component)this.historyLabel, "North");
        this.historyPanel.add((Component)this.historyScroll, "Center");
        this.horizontalSplit.add((Component)this.historyPanel, "right");
        this.objectScroll.getViewport().add((Component)this.objectTree, null);
        this.objectPanel.add((Component)this.objectLabel, "North");
        this.objectPanel.add((Component)this.objectScroll, "Center");
        this.horizontalSplit.add((Component)this.objectPanel, "left");
        this.verticalSplit.add((Component)this.horizontalSplit, "top");
        this.previewScroll.getViewport().add((Component)this.previewEditPane, null);
        this.previewPanel.add((Component)this.previewLabel, "North");
        this.previewPanel.add((Component)this.previewScroll, "Center");
        this.verticalSplit.add((Component)this.previewPanel, "bottom");
        this.add((Component)this.verticalSplit, "jSplitPane1");
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.objectTree);
    }

    public void setModel(URLPath uRLPath) {
        this.revisionMappings.clear();
        this.objectTreeNodes.clear();
        this.objectTreeRoot.removeAllChildren();
        if (uRLPath != null) {
            URL[] uRLArray = uRLPath.getEntries();
            int n = 0;
            int n2 = 0;
            while (n2 < uRLArray.length) {
                if (uRLArray[n2] != null) {
                    int n3 = 0;
                    while (n3 < uRLArray.length) {
                        if (n3 != n2 && uRLArray[n3] != null && URLFileSystem.isBaseURLFor((URL)uRLArray[n2], (URL)uRLArray[n3])) {
                            uRLArray[n3] = null;
                            ++n;
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            if (n > 0) {
                URL[] uRLArray2 = new URL[uRLArray.length - n];
                n = 0;
                int n4 = 0;
                while (n4 < uRLArray.length) {
                    if (uRLArray[n4] != null) {
                        uRLArray2[n++] = uRLArray[n4];
                    }
                    ++n4;
                }
                uRLArray = uRLArray2;
            }
            if (uRLArray != null) {
                int n5 = 0;
                while (n5 < uRLArray.length) {
                    Object[] objectArray;
                    URL uRL = uRLArray[n5];
                    URL uRL2 = URLFileSystem.getParent((URL)uRL);
                    if (uRL2 != null) {
                        this.objectTreeNodes.put(uRL2, this.objectTreeRoot);
                    }
                    this.addObjectTreeNode(uRL);
                    oracle.ide.history.HistoryManager historyManager = oracle.ide.history.HistoryManager.getHistoryManager();
                    Object[] objectArray2 = objectArray = historyManager != null ? historyManager.getDeletions(uRL) : null;
                    if (objectArray != null && objectArray.length > 0) {
                        this.populateObjectTree(objectArray);
                    }
                    ++n5;
                }
            }
        }
        TreePath treePath = new TreePath(this.objectTreeRoot);
        this.objectTree.collapsePath(treePath);
        this.objectTree.expandPath(treePath);
        this.objectTree.expandAllRows();
        this.objectTree.setSelectionRow(0);
        this.horizontalSplit.setDividerLocation(0.5);
        this.verticalSplit.setDividerLocation(0.33);
    }

    CustomJTree getObjectTree() {
        return this.objectTree;
    }

    LocalState[] getAllLocalStates() {
        Enumeration<TreeNode> enumeration;
        ArrayList<LocalState> arrayList = new ArrayList<LocalState>();
        oracle.ide.history.HistoryManager historyManager = oracle.ide.history.HistoryManager.getHistoryManager();
        Enumeration<TreeNode> enumeration2 = enumeration = historyManager != null ? this.objectTreeRoot.breadthFirstEnumeration() : null;
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                JMutableTreeNode jMutableTreeNode = (JMutableTreeNode)enumeration.nextElement();
                JTreeCellData jTreeCellData = (JTreeCellData)jMutableTreeNode.getUserObject();
                Object object = jTreeCellData.getUserObject();
                if (object == null) continue;
                LocalState localState = (LocalState)this.revisionMappings.get(object);
                if (localState == null) {
                    localState = historyManager.getLastState(object);
                }
                if (localState == null) continue;
                arrayList.add(localState);
            }
        }
        LocalState[] localStateArray = new LocalState[arrayList.size()];
        arrayList.toArray(localStateArray);
        return localStateArray;
    }

    public LocalState[] getLocalStates() {
        Enumeration<TreeNode> enumeration;
        ArrayList<LocalState> arrayList = new ArrayList<LocalState>();
        oracle.ide.history.HistoryManager historyManager = oracle.ide.history.HistoryManager.getHistoryManager();
        Enumeration<TreeNode> enumeration2 = enumeration = historyManager != null ? this.objectTreeRoot.breadthFirstEnumeration() : null;
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object object;
                JMutableTreeNode jMutableTreeNode = (JMutableTreeNode)enumeration.nextElement();
                JTreeCellData jTreeCellData = (JTreeCellData)jMutableTreeNode.getUserObject();
                TriStateBoolean triStateBoolean = jTreeCellData.getCheckBoxState();
                if (!triStateBoolean.isTrue() || (object = jTreeCellData.getUserObject()) == null) continue;
                LocalState localState = (LocalState)this.revisionMappings.get(object);
                if (localState == null) {
                    localState = historyManager.getLastState(object);
                }
                if (localState == null) continue;
                arrayList.add(localState);
            }
        }
        LocalState[] localStateArray = new LocalState[arrayList.size()];
        arrayList.toArray(localStateArray);
        return localStateArray;
    }

    private void populateObjectTree(Object[] objectArray) {
        oracle.ide.history.HistoryManager historyManager = oracle.ide.history.HistoryManager.getHistoryManager();
        if (objectArray != null && historyManager != null) {
            int n = 0;
            while (n < objectArray.length) {
                LocalState localState = historyManager.getLastState(objectArray[n]);
                if (localState != null) {
                    JMutableTreeNode jMutableTreeNode = this.addObjectTreeNode(localState.getStateURL());
                    JTreeCellData jTreeCellData = (JTreeCellData)jMutableTreeNode.getUserObject();
                    jTreeCellData.setUserObject(objectArray[n]);
                }
                ++n;
            }
        }
    }

    private JMutableTreeNode addObjectTreeNode(URL uRL) {
        if (uRL == null) {
            return null;
        }
        URL uRL2 = URLFileSystem.getParent((URL)uRL);
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        if (uRL2 == null) {
            defaultMutableTreeNode = this.objectTreeRoot;
        } else {
            defaultMutableTreeNode = (JMutableTreeNode)this.objectTreeNodes.get(uRL2);
            if (defaultMutableTreeNode == null) {
                defaultMutableTreeNode = this.addObjectTreeNode(uRL2);
            }
        }
        JTreeCellData jTreeCellData = new JTreeCellData(null, URLFileSystem.getFileName((URL)uRL), true, TriStateBoolean.FALSE);
        jTreeCellData.setToolTipText(URLFileSystem.getPlatformPathName((URL)uRL));
        JMutableTreeNode jMutableTreeNode = new JMutableTreeNode(jTreeCellData);
        defaultMutableTreeNode.add((MutableTreeNode)jMutableTreeNode);
        this.objectTreeNodes.put(uRL, jMutableTreeNode);
        return jMutableTreeNode;
    }

    private Object getObjectTreeSelection() {
        TreePath treePath = this.objectTree.getSelectionPath();
        JMutableTreeNode jMutableTreeNode = (JMutableTreeNode)(treePath != null ? treePath.getLastPathComponent() : null);
        JTreeCellData jTreeCellData = jMutableTreeNode != null ? (JTreeCellData)jMutableTreeNode.getUserObject() : null;
        return jTreeCellData != null ? jTreeCellData.getUserObject() : null;
    }

    private void objectSelectionChanged(TreeSelectionEvent treeSelectionEvent) {
        int n;
        Object object = this.getObjectTreeSelection();
        oracle.ide.history.HistoryManager historyManager = oracle.ide.history.HistoryManager.getHistoryManager();
        LocalState[] localStateArray = historyManager != null && object != null ? historyManager.getLocalHistory(object) : new LocalState[]{};
        this.historyList.setModel((HistoryModel)new DeletionsModel(localStateArray));
        this.historyList.sortTableByProperty(SharedProperties.getDateProperty(), false);
        Object var5_5 = object != null ? this.revisionMappings.get(object) : null;
        boolean bl = false;
        HistoryModel historyModel = this.historyList.getModel();
        int n2 = n = historyModel != null ? historyModel.getSize() : 0;
        if (var5_5 != null) {
            int n3 = 0;
            while (n3 < n) {
                LocalHistoryEntry localHistoryEntry = (LocalHistoryEntry)historyModel.getEntry(n3);
                if (localHistoryEntry.getState().equals(var5_5)) {
                    this.historyList.setSingleSelection((HistoryEntry)localHistoryEntry);
                    bl = true;
                    break;
                }
                ++n3;
            }
        }
        if (!bl && n > 0) {
            this.historyList.setSingleSelection(historyModel.getEntry(n - 1));
        }
    }

    private void historySelectionChanged(ListSelectionEvent listSelectionEvent) {
        URL uRL;
        HistoryEntry[] historyEntryArray = this.historyList.getSelection();
        LocalState localState = null;
        if (historyEntryArray != null && historyEntryArray.length == 1 && historyEntryArray[0] instanceof LocalHistoryEntry) {
            localState = ((LocalHistoryEntry)historyEntryArray[0]).getState();
            Object object = this.getObjectTreeSelection();
            if (object != null) {
                this.revisionMappings.put(object, localState);
            }
        }
        URL uRL2 = uRL = localState != null ? localState.getDataURL() : null;
        if (uRL != null) {
            try {
                InputStream inputStream = URLFileSystem.openInputStream((URL)uRL);
                URL uRL3 = localState.getStateURL();
                String string = URLFileSystem.getSuffix((URL)uRL3);
                Reader reader = StreamDecoder.getReader(string, uRL);
                TextBuffer textBuffer = TextBufferFactory.createTextBuffer();
                textBuffer.read(reader);
                this.previewEditPane.setDocument((Document)new BasicDocument(uRL3.getPath(), textBuffer));
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.previewEditPane.setText("");
    }

    static void mav$objectSelectionChanged(RestoreDeletionsPanel restoreDeletionsPanel, TreeSelectionEvent treeSelectionEvent) {
        restoreDeletionsPanel.objectSelectionChanged(treeSelectionEvent);
    }

    static void mav$historySelectionChanged(RestoreDeletionsPanel restoreDeletionsPanel, ListSelectionEvent listSelectionEvent) {
        restoreDeletionsPanel.historySelectionChanged(listSelectionEvent);
    }

    public final class 2
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            RestoreDeletionsPanel.mav$objectSelectionChanged(RestoreDeletionsPanel.this, treeSelectionEvent);
        }
    }

    public final class 1
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            RestoreDeletionsPanel.mav$historySelectionChanged(RestoreDeletionsPanel.this, listSelectionEvent);
        }
    }

    private static final class DeletionsModel
    extends DefaultHistoryModel {
        DeletionsModel(LocalState[] localStateArray) {
            this.addProperties(LocalHistoryProvider.PROPERTIES);
            if (localStateArray != null) {
                ArrayList<LocalHistoryEntry> arrayList = new ArrayList<LocalHistoryEntry>();
                int n = 0;
                while (n < localStateArray.length) {
                    arrayList.add(new LocalHistoryEntry(localStateArray[n]));
                    ++n;
                }
                HistoryEntry[] historyEntryArray = new HistoryEntry[arrayList.size()];
                arrayList.toArray(historyEntryArray);
                this.addEntries(historyEntryArray);
            }
        }
    }
}

