/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.inspector.extension;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.inspector.extension.Res;

final class BoundedRangeModelCustomEditor
extends JPanel
implements VetoableChangeListener {
    private BoundedRangeModel value;
    private JLabel minLabel;
    private JLabel valueLabel;
    private JLabel extentLabel;
    private JLabel maxLabel;
    private JTextField valueText;
    private JTextField extentText;
    private JTextField minText;
    private JTextField maxText;
    private PropertyChangeSupport support;
    private KeyListener listener;

    void $init$() {
        this.value = null;
        this.minLabel = new JLabel();
        this.valueLabel = new JLabel();
        this.extentLabel = new JLabel();
        this.maxLabel = new JLabel();
        this.valueText = new JTextField();
        this.extentText = new JTextField();
        this.minText = new JTextField();
        this.maxText = new JTextField();
        this.support = new PropertyChangeSupport(this);
        this.listener = new 1();
    }

    BoundedRangeModelCustomEditor() {
        this.$init$();
        try {
            this.jbInit();
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_guipropedbrange_html");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        BoundedRangeModel boundedRangeModel;
        this.value = boundedRangeModel = (BoundedRangeModel)object;
        if (boundedRangeModel == null) {
            boundedRangeModel = new DefaultBoundedRangeModel();
        }
        this.minText.setText("" + boundedRangeModel.getMinimum());
        this.valueText.setText("" + boundedRangeModel.getValue());
        this.extentText.setText("" + boundedRangeModel.getExtent());
        this.maxText.setText("" + boundedRangeModel.getMaximum());
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if ("closed".equals(propertyChangeEvent.getPropertyName()) && ((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
            String string = this.minText.getText().trim();
            String string2 = this.valueText.getText().trim();
            String string3 = this.extentText.getText().trim();
            String string4 = this.maxText.getText().trim();
            if (string.length() == 0) {
                string = "0";
            }
            if (string2.length() == 0) {
                string2 = "0";
            }
            if (string3.length() == 0) {
                string3 = "0";
            }
            if (string4.length() == 0) {
                string4 = "0";
            }
            try {
                int n = Integer.parseInt(string);
                int n2 = Integer.parseInt(string2);
                int n3 = Integer.parseInt(string3);
                int n4 = Integer.parseInt(string4);
                this.value = new DefaultBoundedRangeModel(n2, n3, n, n4);
                this.support.firePropertyChange(null, null, this.value);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, Res.format(1, new String[]{StringUtils.stripMnemonic((String)Res.getString(4)), StringUtils.stripMnemonic((String)Res.getString(2)), StringUtils.stripMnemonic((String)Res.getString(2)), StringUtils.stripMnemonic((String)Res.getString(3)), StringUtils.stripMnemonic((String)Res.getString(5))}), Res.getString(0), 0);
                throw new PropertyVetoException(exception.getLocalizedMessage(), propertyChangeEvent);
            }
        }
    }

    private void jbInit() throws Exception {
        ResourceUtils.resLabel((JLabel)this.minLabel, (Component)this.minText, (String)Res.getString(4));
        ResourceUtils.resLabel((JLabel)this.valueLabel, (Component)this.valueText, (String)Res.getString(2));
        ResourceUtils.resLabel((JLabel)this.extentLabel, (Component)this.extentText, (String)Res.getString(3));
        ResourceUtils.resLabel((JLabel)this.maxLabel, (Component)this.maxText, (String)Res.getString(5));
        this.minText.addKeyListener(this.listener);
        this.valueText.addKeyListener(this.listener);
        this.extentText.addKeyListener(this.listener);
        this.maxText.addKeyListener(this.listener);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.minLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.minText, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.valueLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.valueText, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.extentLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.extentText, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.maxLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.maxText, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
    }

    final class 1
    implements KeyListener {
        public void keyTyped(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            if (!Character.isISOControl(c) && c != '.' && c != '-' && !Character.isDigit(c)) {
                Toolkit.getDefaultToolkit().beep();
                keyEvent.consume();
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }
}

