/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.inspector.extension;

import javax.swing.text.DefaultEditorKit;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.rtf.RTFEditorKit;
import oracle.ideimpl.inspector.AbstractInlineExtension;

public final class EditorKitExtension
extends AbstractInlineExtension {
    private static final String DEFAULT_TAG = "DefaultEditorKit";
    private static final String HTML_TAG = "HTMLEditorKit";
    private static final String RTF_TAG = "RTFEditorKit";
    private static final String STYLED_TAG = "StyledEditorKit";
    private static final String[] TAGS = new String[]{"DefaultEditorKit", "HTMLEditorKit", "RTFEditorKit", "StyledEditorKit"};
    private static final Class[] CLASSES = new Class[]{DefaultEditorKit.class, HTMLEditorKit.class, RTFEditorKit.class, StyledEditorKit.class};

    public String getJavaInitializationString() {
        if (this.value instanceof HTMLEditorKit) {
            return "new javax.swing.text.html.HTMLEditorKit()";
        }
        if (this.value instanceof RTFEditorKit) {
            return "new javax.swing.text.rtf.RTFEditorKit()";
        }
        if (this.value instanceof StyledEditorKit) {
            return "new javax.swing.text.StyledEditorKit()";
        }
        if (this.value instanceof DefaultEditorKit) {
            return "new javax.swing.text.DefaultEditorKit()";
        }
        return "null";
    }

    public String[] getTags() {
        return TAGS;
    }

    public void setSelectedTag(String string) {
        if (DEFAULT_TAG.equals(string)) {
            this.setValue(new DefaultEditorKit());
        } else if (HTML_TAG.equals(string)) {
            this.setValue(new HTMLEditorKit());
        } else if (RTF_TAG.equals(string)) {
            this.setValue(new RTFEditorKit());
        } else if (STYLED_TAG.equals(string)) {
            this.setValue(new StyledEditorKit());
        }
    }

    public Class[] getImplementationClasses() {
        return CLASSES;
    }

    protected boolean isValid(Object object) {
        return object == null || object instanceof EditorKit;
    }
}

