/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.inspector.extension;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.VetoableChangeListener;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.inspector.extension.KeyStrokeExtension;
import oracle.jdevimpl.inspector.extension.Res;

final class KeyStrokeCustomEditor
extends JPanel
implements VetoableChangeListener {
    private PropertyChangeSupport support;
    private GridBagLayout mainLayout;
    private JLabel keysLabel;
    private JScrollPane keysScrollPane;
    private JList keysList;
    private DefaultListModel keysModel;
    private JPanel modifiersPanel;
    private TitledBorder modifiersBorder;
    private GridBagLayout modifiersLayout;
    private JCheckBox shiftCheckBox;
    private JCheckBox ctrlCheckBox;
    private JCheckBox metaCheckBox;
    private JCheckBox altCheckBox;
    private JCheckBox keyReleaseCheckBox;

    void $init$() {
        this.support = new PropertyChangeSupport(this);
        this.mainLayout = new GridBagLayout();
        this.keysLabel = new JLabel();
        this.keysScrollPane = new JScrollPane();
        this.keysList = new JList();
        this.keysModel = new 1();
        this.modifiersPanel = new JPanel();
        this.modifiersBorder = new TitledBorder(Res.getString(13));
        this.modifiersLayout = new GridBagLayout();
        this.shiftCheckBox = new JCheckBox();
        this.ctrlCheckBox = new JCheckBox();
        this.metaCheckBox = new JCheckBox();
        this.altCheckBox = new JCheckBox();
        this.keyReleaseCheckBox = new JCheckBox();
    }

    public KeyStrokeCustomEditor() {
        this.$init$();
        try {
            this.jbInit();
            Iterator iterator = KeyStrokeExtension.getKeyCodeStrings();
            if (iterator != null) {
                while (iterator.hasNext()) {
                    this.keysModel.addElement(iterator.next());
                }
            }
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_guipropedkeystroke_html");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.modifiersPanel.setBorder(this.modifiersBorder);
        ResourceUtils.resButton((AbstractButton)this.shiftCheckBox, (String)"&SHIFT_MASK");
        ResourceUtils.resButton((AbstractButton)this.ctrlCheckBox, (String)"&CTRL_MASK");
        ResourceUtils.resButton((AbstractButton)this.metaCheckBox, (String)"&META_MASK");
        ResourceUtils.resButton((AbstractButton)this.altCheckBox, (String)"&ALT_MASK");
        ResourceUtils.resLabel((JLabel)this.keysLabel, (Component)this.keysList, (String)Res.getString(14));
        this.keysList.setModel(this.keysModel);
        this.keysScrollPane.getViewport().add((Component)this.keysList, null);
        ResourceUtils.resButton((AbstractButton)this.keyReleaseCheckBox, (String)Res.getString(15));
        this.modifiersPanel.setLayout(this.modifiersLayout);
        this.modifiersPanel.add((Component)this.shiftCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.modifiersPanel.add((Component)this.ctrlCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.modifiersPanel.add((Component)this.metaCheckBox, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.modifiersPanel.add((Component)this.altCheckBox, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(this.mainLayout);
        this.add((Component)this.modifiersPanel, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.keysLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this.keysScrollPane, new GridBagConstraints(1, 1, 1, 2, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this.keyReleaseCheckBox, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 15, 2, new Insets(0, 0, 5, 5), 0, 0));
    }

    public KeyStroke getValue() {
        String string = (String)this.keysList.getSelectedValue();
        if (string != null) {
            int n = KeyStrokeExtension.getTextAsKeyCode(string);
            int n2 = 0;
            boolean bl = this.keyReleaseCheckBox.isSelected();
            if (this.shiftCheckBox.isSelected()) {
                n2 |= 1;
            }
            if (this.ctrlCheckBox.isSelected()) {
                n2 |= 2;
            }
            if (this.metaCheckBox.isSelected()) {
                n2 |= 4;
            }
            if (this.altCheckBox.isSelected()) {
                n2 |= 8;
            }
            return KeyStroke.getKeyStroke(n, n2, bl);
        }
        return null;
    }

    public void setValue(Object object) {
        if (object instanceof KeyStroke) {
            KeyStroke keyStroke = (KeyStroke)object;
            int n = keyStroke.getModifiers();
            String string = KeyStrokeExtension.getKeyCodeAsText(keyStroke.getKeyCode());
            if (string == null) {
                string = "VK_A";
            }
            this.keysList.setSelectedValue(string, true);
            this.shiftCheckBox.setSelected((n & 1) == 1);
            this.ctrlCheckBox.setSelected((n & 2) == 2);
            this.metaCheckBox.setSelected((n & 4) == 4);
            this.altCheckBox.setSelected((n & 8) == 8);
            this.keyReleaseCheckBox.setSelected(keyStroke.isOnKeyRelease());
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
        this.support.firePropertyChange(null, null, this.getValue());
    }

    final class 1
    extends DefaultListModel {
        public void addElement(Object object) {
            if (object == null) {
                return;
            }
            int n = this.getSize();
            int n2 = 0;
            while (n2 < n) {
                Object e = this.getElementAt(n2);
                if (object.toString().compareTo(e.toString()) < 0) {
                    this.insertElementAt(object, n2);
                    return;
                }
                ++n2;
            }
            super.addElement(object);
        }
    }
}

