/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.inspector.extension;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.KeyStroke;
import oracle.ideimpl.inspector.AbstractInlineExtension;
import oracle.jdevimpl.inspector.extension.KeyStrokeCustomEditor;

public final class KeyStrokeExtension
extends AbstractInlineExtension {
    private static final String[] TAGS = new String[]{"KeyStroke..."};
    private static final Class[] CLASSES = new Class[]{KeyStroke.class};
    private static final HashMap MAP = new HashMap();
    private KeyStrokeCustomEditor editor;

    static {
        MAP.put("VK_0", new Integer(48));
        MAP.put("VK_1", new Integer(49));
        MAP.put("VK_2", new Integer(50));
        MAP.put("VK_3", new Integer(51));
        MAP.put("VK_4", new Integer(52));
        MAP.put("VK_5", new Integer(53));
        MAP.put("VK_6", new Integer(54));
        MAP.put("VK_7", new Integer(55));
        MAP.put("VK_8", new Integer(56));
        MAP.put("VK_9", new Integer(57));
        MAP.put("VK_A", new Integer(65));
        MAP.put("VK_ACCEPT", new Integer(30));
        MAP.put("VK_ADD", new Integer(107));
        MAP.put("VK_AGAIN", new Integer(65481));
        MAP.put("VK_ALL_CANDIDATES", new Integer(256));
        MAP.put("VK_ALPHANUMERIC", new Integer(240));
        MAP.put("VK_ALT", new Integer(18));
        MAP.put("VK_ALT_GRAPH", new Integer(65406));
        MAP.put("VK_AMPERSAND", new Integer(150));
        MAP.put("VK_ASTERISK", new Integer(151));
        MAP.put("VK_AT", new Integer(512));
        MAP.put("VK_B", new Integer(66));
        MAP.put("VK_BACK_QUOTE", new Integer(192));
        MAP.put("VK_BACK_SLASH", new Integer(92));
        MAP.put("VK_BACK_SPACE", new Integer(8));
        MAP.put("VK_BRACELEFT", new Integer(161));
        MAP.put("VK_BRACERIGHT", new Integer(162));
        MAP.put("VK_C", new Integer(67));
        MAP.put("VK_CANCEL", new Integer(3));
        MAP.put("VK_CAPS_LOCK", new Integer(20));
        MAP.put("VK_CIRCUMFLEX", new Integer(514));
        MAP.put("VK_CLEAR", new Integer(12));
        MAP.put("VK_CLOSE_BRACKET", new Integer(93));
        MAP.put("VK_CODE_INPUT", new Integer(258));
        MAP.put("VK_COLON", new Integer(513));
        MAP.put("VK_COMMA", new Integer(44));
        MAP.put("VK_COMPOSE", new Integer(65312));
        MAP.put("VK_CONTROL", new Integer(17));
        MAP.put("VK_CONVERT", new Integer(28));
        MAP.put("VK_COPY", new Integer(65485));
        MAP.put("VK_CUT", new Integer(65489));
        MAP.put("VK_D", new Integer(68));
        MAP.put("VK_DEAD_ABOVEDOT", new Integer(134));
        MAP.put("VK_DEAD_ABOVERING", new Integer(136));
        MAP.put("VK_DEAD_ACUTE", new Integer(129));
        MAP.put("VK_DEAD_BREVE", new Integer(133));
        MAP.put("VK_DEAD_CARON", new Integer(138));
        MAP.put("VK_DEAD_CEDILLA", new Integer(139));
        MAP.put("VK_DEAD_CIRCUMFLEX", new Integer(130));
        MAP.put("VK_DEAD_DIAERESIS", new Integer(135));
        MAP.put("VK_DEAD_DOUBLEACUTE", new Integer(137));
        MAP.put("VK_DEAD_GRAVE", new Integer(128));
        MAP.put("VK_DEAD_IOTA", new Integer(141));
        MAP.put("VK_DEAD_MACRON", new Integer(132));
        MAP.put("VK_DEAD_OGONEK", new Integer(140));
        MAP.put("VK_DEAD_SEMIVOICED_SOUND", new Integer(143));
        MAP.put("VK_DEAD_TILDE", new Integer(131));
        MAP.put("VK_DEAD_VOICED_SOUND", new Integer(142));
        MAP.put("VK_DECIMAL", new Integer(110));
        MAP.put("VK_DELETE", new Integer(127));
        MAP.put("VK_DIVIDE", new Integer(111));
        MAP.put("VK_DOLLAR", new Integer(515));
        MAP.put("VK_DOWN", new Integer(40));
        MAP.put("VK_E", new Integer(69));
        MAP.put("VK_END", new Integer(35));
        MAP.put("VK_ENTER", new Integer(10));
        MAP.put("VK_EQUALS", new Integer(61));
        MAP.put("VK_ESCAPE", new Integer(27));
        MAP.put("VK_EURO_SIGN", new Integer(516));
        MAP.put("VK_EXCLAMATION_MARK", new Integer(517));
        MAP.put("VK_F", new Integer(70));
        MAP.put("VK_F1", new Integer(112));
        MAP.put("VK_F10", new Integer(121));
        MAP.put("VK_F11", new Integer(122));
        MAP.put("VK_F12", new Integer(123));
        MAP.put("VK_F13", new Integer(61440));
        MAP.put("VK_F14", new Integer(61441));
        MAP.put("VK_F15", new Integer(61442));
        MAP.put("VK_F16", new Integer(61443));
        MAP.put("VK_F17", new Integer(61444));
        MAP.put("VK_F18", new Integer(61445));
        MAP.put("VK_F19", new Integer(61446));
        MAP.put("VK_F2", new Integer(113));
        MAP.put("VK_F20", new Integer(61447));
        MAP.put("VK_F21", new Integer(61448));
        MAP.put("VK_F22", new Integer(61449));
        MAP.put("VK_F23", new Integer(61450));
        MAP.put("VK_F24", new Integer(61451));
        MAP.put("VK_F3", new Integer(114));
        MAP.put("VK_F4", new Integer(115));
        MAP.put("VK_F5", new Integer(116));
        MAP.put("VK_F6", new Integer(117));
        MAP.put("VK_F7", new Integer(118));
        MAP.put("VK_F8", new Integer(119));
        MAP.put("VK_F9", new Integer(120));
        MAP.put("VK_FINAL", new Integer(24));
        MAP.put("VK_FIND", new Integer(65488));
        MAP.put("VK_FULL_WIDTH", new Integer(243));
        MAP.put("VK_G", new Integer(71));
        MAP.put("VK_GREATER", new Integer(160));
        MAP.put("VK_H", new Integer(72));
        MAP.put("VK_HALF_WIDTH", new Integer(244));
        MAP.put("VK_HELP", new Integer(156));
        MAP.put("VK_HIRAGANA", new Integer(242));
        MAP.put("VK_HOME", new Integer(36));
        MAP.put("VK_I", new Integer(73));
        MAP.put("VK_INPUT_METHOD_ON_OFF", new Integer(263));
        MAP.put("VK_INSERT", new Integer(155));
        MAP.put("VK_INVERTED_EXCLAMATION_MARK", new Integer(518));
        MAP.put("VK_J", new Integer(74));
        MAP.put("VK_JAPANESE_HIRAGANA", new Integer(260));
        MAP.put("VK_JAPANESE_KATAKANA", new Integer(259));
        MAP.put("VK_JAPANESE_ROMAN", new Integer(261));
        MAP.put("VK_K", new Integer(75));
        MAP.put("VK_KANA", new Integer(21));
        MAP.put("VK_KANA_LOCK", new Integer(262));
        MAP.put("VK_KANJI", new Integer(25));
        MAP.put("VK_KATAKANA", new Integer(241));
        MAP.put("VK_KP_DOWN", new Integer(225));
        MAP.put("VK_KP_LEFT", new Integer(226));
        MAP.put("VK_KP_RIGHT", new Integer(227));
        MAP.put("VK_KP_UP", new Integer(224));
        MAP.put("VK_L", new Integer(76));
        MAP.put("VK_LEFT", new Integer(37));
        MAP.put("VK_LEFT_PARENTHESIS", new Integer(519));
        MAP.put("VK_LESS", new Integer(153));
        MAP.put("VK_M", new Integer(77));
        MAP.put("VK_META", new Integer(157));
        MAP.put("VK_MINUS", new Integer(45));
        MAP.put("VK_MODECHANGE", new Integer(31));
        MAP.put("VK_MULTIPLY", new Integer(106));
        MAP.put("VK_N", new Integer(78));
        MAP.put("VK_NONCONVERT", new Integer(29));
        MAP.put("VK_NUM_LOCK", new Integer(144));
        MAP.put("VK_NUMBER_SIGN", new Integer(520));
        MAP.put("VK_NUMPAD0", new Integer(96));
        MAP.put("VK_NUMPAD1", new Integer(97));
        MAP.put("VK_NUMPAD2", new Integer(98));
        MAP.put("VK_NUMPAD3", new Integer(99));
        MAP.put("VK_NUMPAD4", new Integer(100));
        MAP.put("VK_NUMPAD5", new Integer(101));
        MAP.put("VK_NUMPAD6", new Integer(102));
        MAP.put("VK_NUMPAD7", new Integer(103));
        MAP.put("VK_NUMPAD8", new Integer(104));
        MAP.put("VK_NUMPAD9", new Integer(105));
        MAP.put("VK_O", new Integer(79));
        MAP.put("VK_OPEN_BRACKET", new Integer(91));
        MAP.put("VK_P", new Integer(80));
        MAP.put("VK_PAGE_DOWN", new Integer(34));
        MAP.put("VK_PAGE_UP", new Integer(33));
        MAP.put("VK_PASTE", new Integer(65487));
        MAP.put("VK_PAUSE", new Integer(19));
        MAP.put("VK_PERIOD", new Integer(46));
        MAP.put("VK_PLUS", new Integer(521));
        MAP.put("VK_PREVIOUS_CANDIDATE", new Integer(257));
        MAP.put("VK_PRINTSCREEN", new Integer(154));
        MAP.put("VK_PROPS", new Integer(65482));
        MAP.put("VK_Q", new Integer(81));
        MAP.put("VK_QUOTE", new Integer(222));
        MAP.put("VK_QUOTEDBL", new Integer(152));
        MAP.put("VK_R", new Integer(82));
        MAP.put("VK_RIGHT", new Integer(39));
        MAP.put("VK_RIGHT_PARENTHESIS", new Integer(522));
        MAP.put("VK_ROMAN_CHARACTERS", new Integer(245));
        MAP.put("VK_S", new Integer(83));
        MAP.put("VK_SCROLL_LOCK", new Integer(145));
        MAP.put("VK_SEMICOLON", new Integer(59));
        MAP.put("VK_SEPARATER", new Integer(108));
        MAP.put("VK_SHIFT", new Integer(16));
        MAP.put("VK_SLASH", new Integer(47));
        MAP.put("VK_SPACE", new Integer(32));
        MAP.put("VK_STOP", new Integer(65480));
        MAP.put("VK_SUBTRACT", new Integer(109));
        MAP.put("VK_T", new Integer(84));
        MAP.put("VK_TAB", new Integer(9));
        MAP.put("VK_U", new Integer(85));
        MAP.put("VK_UNDEFINED", new Integer(0));
        MAP.put("VK_UNDERSCORE", new Integer(523));
        MAP.put("VK_UNDO", new Integer(65483));
        MAP.put("VK_UP", new Integer(38));
        MAP.put("VK_V", new Integer(86));
        MAP.put("VK_W", new Integer(87));
        MAP.put("VK_X", new Integer(88));
        MAP.put("VK_Y", new Integer(89));
        MAP.put("VK_Z", new Integer(90));
    }

    void $init$() {
        this.editor = null;
    }

    public String getJavaInitializationString() {
        if (this.value instanceof KeyStroke) {
            KeyStroke keyStroke = (KeyStroke)this.value;
            String string = KeyStrokeExtension.getKeyCodeAsText(keyStroke.getKeyCode());
            String string2 = "";
            String string3 = keyStroke.isOnKeyRelease() ? "true" : "false";
            string = string == null ? "java.awt.event.KeyEvent.VK_A" : "java.awt.event.KeyEvent." + string;
            int n = keyStroke.getModifiers();
            if ((n & 1) == 1) {
                string2 = "java.awt.Event.SHIFT_MASK";
            }
            if ((n & 2) == 2) {
                string2 = string2.length() > 0 ? string2 + " | java.awt.Event.CTRL_MASK" : "java.awt.Event.CTRL_MASK";
            }
            if ((n & 4) == 4) {
                string2 = string2.length() > 0 ? string2 + " | java.awt.Event.META_MASK" : "java.awt.Event.META_MASK";
            }
            if ((n & 8) == 8) {
                string2 = string2.length() > 0 ? string2 + " | java.awt.Event.ALT_MASK" : "java.awt.Event.ALT_MASK";
            }
            return "javax.swing.KeyStroke.getKeyStroke(" + string + ", " + (string2.length() > 0 ? string2 : "0") + ", " + string3 + ")";
        }
        return "null";
    }

    public String getDisplayString() {
        return this.value != null ? this.value.toString() : super.getDisplayString();
    }

    public String[] getTags() {
        return TAGS;
    }

    public void setSelectedTag(String string) {
        ((KeyStrokeCustomEditor)this.getCustomEditor()).setValue(KeyStroke.getKeyStroke('a'));
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        if (this.editor == null) {
            this.editor = new KeyStrokeCustomEditor();
            this.editor.addPropertyChangeListener(new 1());
        }
        this.editor.setValue(this.value);
        return this.editor;
    }

    public void setValue(Object object) {
        if (this.editor != null) {
            this.editor.setValue(object);
        }
        super.setValue(object);
    }

    public Class[] getImplementationClasses() {
        return CLASSES;
    }

    public static final Iterator getKeyCodeValues() {
        return MAP.values().iterator();
    }

    public static final Iterator getKeyCodeStrings() {
        return MAP.keySet().iterator();
    }

    public static final String getKeyCodeAsText(int n) {
        Iterator iterator = MAP.keySet().iterator();
        if (iterator != null) {
            Integer n2 = new Integer(n);
            while (iterator.hasNext()) {
                Object k = iterator.next();
                if (!MAP.get(k).equals(n2)) continue;
                return (String)k;
            }
        }
        return null;
    }

    public static final int getTextAsKeyCode(String string) {
        Object v = MAP.get(string);
        if (v != null) {
            return (Integer)v;
        }
        throw new IllegalArgumentException();
    }

    protected boolean isValid(Object object) {
        return object == null || object instanceof KeyStroke;
    }

    public KeyStrokeExtension() {
        this.$init$();
    }

    public final class 1
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            KeyStrokeExtension.this.setValue(propertyChangeEvent.getNewValue());
        }
    }
}

