/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.jar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.URL;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.ide.editor.EditorManager;
import oracle.ide.net.JarIndex;
import oracle.ide.net.JarIndexEntry;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.util.SwingWorker;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.controls.nicetable.NiceTableCellRenderer;
import oracle.jdeveloper.resource.ViewersArb;
import oracle.jdevimpl.jar.JarFileTableModel;
import oracle.jdevimpl.jar.JarNode;

class JarViewerContentPanel
extends JPanel {
    private final JLabel _lblHeader;
    private final JarFileTableModel _model;
    private final NiceTable _table;
    private final JScrollPane _spTable;
    private JarNode _jarNode;
    private static final NumberFormat TWO_DP_FORMAT = NumberFormat.getInstance();

    void $init$() {
        this._lblHeader = new JLabel();
        this._model = new JarFileTableModel();
        this._table = new NiceTable((TableModel)this._model);
        this._spTable = new JScrollPane((Component)this._table);
        this._jarNode = null;
    }

    static {
        TWO_DP_FORMAT.setMaximumFractionDigits(2);
        TWO_DP_FORMAT.setMinimumFractionDigits(2);
        TWO_DP_FORMAT.setParseIntegerOnly(false);
    }

    JarViewerContentPanel() {
        this.$init$();
        this._lblHeader.setHorizontalAlignment(0);
        this._lblHeader.setText(ViewersArb.getString(2));
        this._spTable.setBorder(null);
        this._table.setAutoResizeMode(0);
        this._table.setDefaultRenderer(Date.class, (TableCellRenderer)((Object)new DateRenderer(null)));
        this._table.setDefaultRenderer(Integer.class, (TableCellRenderer)((Object)new SizeRenderer(null)));
        this._table.setSorted(true);
        this._table.addMouseListener((MouseListener)new 2());
        this.setLayout(new BorderLayout());
        this.add((Component)this._lblHeader, "Center");
    }

    void setNode(JarNode jarNode) {
        if (this._jarNode != jarNode) {
            if (this._jarNode != null) {
                JarUtil.releaseJarIndex((URL)this._jarNode.getURL());
            }
            this._jarNode = jarNode;
            this.updateTable();
        }
    }

    private void updateTable() {
        JarNode jarNode = this._jarNode;
        1 var2_2 = new 1(this, jarNode);
        var2_2.start();
    }

    private static String getDisplaySize(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        if (l < 1024L) {
            stringBuffer.append(TWO_DP_FORMAT.format(l));
            stringBuffer.append(" bytes");
        } else if (l >= 1024L && l < 0x100000L) {
            stringBuffer.append(TWO_DP_FORMAT.format((double)l / 1024.0));
            stringBuffer.append(" KB");
        } else if (l >= 0x100000L && l < 0x40000000L) {
            stringBuffer.append(TWO_DP_FORMAT.format((double)l / 1048567.0));
            stringBuffer.append(" MB");
        } else {
            stringBuffer.append(TWO_DP_FORMAT.format((double)l / 1.073741824E9));
            stringBuffer.append(" GB");
        }
        return stringBuffer.toString();
    }

    static JarNode ra$_jarNode(JarViewerContentPanel jarViewerContentPanel) {
        return jarViewerContentPanel._jarNode;
    }

    static NiceTable ra$_table(JarViewerContentPanel jarViewerContentPanel) {
        return jarViewerContentPanel._table;
    }

    static JarFileTableModel ra$_model(JarViewerContentPanel jarViewerContentPanel) {
        return jarViewerContentPanel._model;
    }

    static JScrollPane ra$_spTable(JarViewerContentPanel jarViewerContentPanel) {
        return jarViewerContentPanel._spTable;
    }

    static JLabel ra$_lblHeader(JarViewerContentPanel jarViewerContentPanel) {
        return jarViewerContentPanel._lblHeader;
    }

    static String maS$getDisplaySize(long l) {
        return JarViewerContentPanel.getDisplaySize(l);
    }

    final class 2
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                URL uRL = URLFactory.newFileURL((File)JarViewerContentPanel.ra$_jarNode(JarViewerContentPanel.this).getFile());
                String string = (String)JarViewerContentPanel.ra$_table(JarViewerContentPanel.this).getModel().getValueAt(JarViewerContentPanel.ra$_table(JarViewerContentPanel.this).getSelectedRow(), 0);
                URL uRL2 = URLFactory.newJarURL((URL)uRL, (String)string);
                EditorManager.getEditorManager().openDefaultEditorInFrame(uRL2);
                mouseEvent.consume();
            }
        }
    }

    final class 1
    extends SwingWorker {
        private final /* synthetic */ JarNode v$jarNode;
        final /* synthetic */ JarViewerContentPanel this$0;

        public Object construct() {
            return this.getTableData(this.v$jarNode);
        }

        public void finished() {
            JarViewerContentPanel jarViewerContentPanel = this.this$0;
            ArrayList arrayList = (ArrayList)this.get();
            JarViewerContentPanel.ra$_model(this.this$0).setData(arrayList);
            JarViewerContentPanel.ra$_spTable(this.this$0).setSize(jarViewerContentPanel.getSize());
            JarViewerContentPanel.ra$_table(this.this$0).autoSizeColumnsToFit();
            this.this$0.remove(JarViewerContentPanel.ra$_lblHeader(this.this$0));
            this.this$0.add((Component)JarViewerContentPanel.ra$_spTable(this.this$0), "Center");
        }

        private ArrayList getTableData(JarNode jarNode) {
            try {
                ArrayList arrayList = new ArrayList();
                URL uRL = URLFactory.newFileURL((File)jarNode.getFile());
                JarIndex jarIndex = JarUtil.getJarIndex((URL)uRL);
                int n = jarIndex.getNumEntries();
                int n2 = 0;
                while (n2 < n) {
                    JarIndexEntry jarIndexEntry = jarIndex.getEntryAt(n2);
                    String string = jarIndexEntry.getName();
                    if (!string.endsWith("/")) {
                        ArrayList<Object> arrayList2 = new ArrayList<Object>();
                        arrayList2.add(string);
                        arrayList2.add(jarIndexEntry.getTime());
                        arrayList2.add(new Integer(jarIndexEntry.getSize()));
                        arrayList2.add(new Integer(jarIndexEntry.getCompressedSize()));
                        arrayList.add(arrayList2);
                    }
                    ++n2;
                }
                ArrayList arrayList3 = arrayList;
                return arrayList3;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                ArrayList arrayList = null;
                return arrayList;
            }
        }

        public 1(JarViewerContentPanel jarViewerContentPanel, JarNode jarNode) {
            this.v$jarNode = jarNode;
            this.this$0 = jarViewerContentPanel;
        }
    }

    private class SizeRenderer
    extends NiceTableCellRenderer {
        NumberFormat _defaultFormat;

        void $init$() {
            this._defaultFormat = NumberFormat.getInstance();
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            int n3 = (Integer)object;
            if (n3 < 1024) {
                this.setText(this._defaultFormat.format(n3));
            } else {
                this.setText(JarViewerContentPanel.maS$getDisplaySize(((Integer)object).intValue()));
            }
            return component;
        }

        private SizeRenderer() {
            this.$init$();
        }

        SizeRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class DateRenderer
    extends NiceTableCellRenderer {
        final SimpleDateFormat _sdf;

        void $init$() {
            this._sdf = new SimpleDateFormat();
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object != null) {
                this.setText(this._sdf.format((Date)object));
            }
            return component;
        }

        private DateRenderer() {
            this.$init$();
        }

        DateRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

