/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.java.JavaManager;

public class Context2ParserHelper {
    private Context context;
    private TextBuffer textBuffer;

    public static Context2ParserHelper createHelper(Context context) {
        if (context == null) {
            throw new NullPointerException();
        }
        return new HasContextHelper(context, null);
    }

    void $init$() {
        this.context = null;
        this.textBuffer = null;
    }

    protected Context2ParserHelper() {
        this.$init$();
    }

    public Context2ParserHelper(Context context) {
        this.$init$();
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    public TextBuffer getTextBuffer() {
        return this.textBuffer;
    }

    public Project getProject() {
        Project project;
        Context context = this.getContext();
        if (context != null && (project = context.getProject()) != null) {
            return Ide.getActiveProject();
        }
        return Ide.getDefaultProject();
    }

    public URL getURL() {
        Context context = this.getContext();
        if (context != null) {
            return context.getNode().getURL();
        }
        return null;
    }

    public JavaManager getJavaManager() {
        Project project = this.getProject();
        return JavaManager.getJavaManager(project);
    }

    public JavaProvider getJavaProvider() {
        return this.getJavaManager();
    }

    public SourceFile getSourceFile() {
        JavaManager javaManager = this.getJavaManager();
        URL uRL = this.getURL();
        if (uRL != null) {
            return javaManager.getSourceFile(uRL);
        }
        return null;
    }

    private TextNode getTextNode() {
        Context context = this.getContext();
        Node node = context.getNode();
        if (node instanceof TextNode) {
            return (TextNode)node;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireLock() {
        Context2ParserHelper context2ParserHelper = this;
        synchronized (context2ParserHelper) {
            if (this.textBuffer != null) {
                return;
            }
            TextNode textNode = this.getTextNode();
            if (textNode != null) {
                this.textBuffer = textNode.acquireTextBuffer();
                if (this.textBuffer != null) {
                    this.textBuffer.readLock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock() {
        Context2ParserHelper context2ParserHelper = this;
        synchronized (context2ParserHelper) {
            if (this.textBuffer != null) {
                this.textBuffer.readUnlock();
                TextNode textNode = this.getTextNode();
                if (textNode != null) {
                    textNode.releaseTextBuffer();
                    this.textBuffer = null;
                }
            }
        }
    }

    private static class HasContextHelper
    extends Context2ParserHelper {
        private final Context context;

        private HasContextHelper(Context context) {
            this.context = context;
        }

        public Context getContext() {
            return this.context;
        }

        HasContextHelper(Context context, 1 var2_2) {
            this(context);
        }

        public final class 1 {
        }
    }
}

