/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.util.AsyncScheduler;
import oracle.javatools.parser.util.AsyncTask;
import oracle.javatools.util.CopyOnWriteList;
import oracle.javatools.util.Log;
import oracle.javatools.util.UnexpectedExceptionError;
import oracle.jdeveloper.java.CacheSupport;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdevimpl.java.JavaProjectIndexer;

public final class JavaParserPlugin
implements Observer,
FocusListener,
EditorPlugin,
DocumentListener,
ActionListener {
    private JavaSourceNode javaNode;
    private Project project;
    private static final Log LOG;
    private static final boolean DEBUG_VERBOSE = false;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final int SMALL_FILE_SIZE = 20000;
    private static final int LARGE_FILE_SIZE = 100000;
    private static final int SMALL_FILE_DELAY;
    private static final int LARGE_FILE_DELAY;
    private CopyOnWriteList helperList;
    private static final String PLUGIN_KEY;
    private static final int LONG_TIMER_DELAY = 2000;
    private volatile int _lastDelayUsed;
    private BasicEditorPane editor;
    private Timer updateTimer;
    private SemanticTask smTask;
    private JavaManager smJavaManager;
    private SourceFile smTaskSourceFile;
    private int smTaskChangeId;
    private static AsyncScheduler smScheduler;

    static {
        int n;
        int n2;
        $assertionsDisabled = JavaParserPlugin.class.desiredAssertionStatus() ^ true;
        LOG = new Log("parser", "editor");
        int n3 = 100;
        int n4 = 300;
        int n5 = 50000;
        String string = System.getProperty("ceditor.java.parse.small");
        try {
            n2 = Integer.parseInt(string);
            n2 = Math.min(n2, 50000);
            n2 = Math.max(n2, 100);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 300;
        }
        SMALL_FILE_DELAY = n2;
        int n6 = 500;
        int n7 = 1500;
        int n8 = 50000;
        String string2 = System.getProperty("ceditor.java.parse.large");
        try {
            n = Integer.parseInt(string2);
            n = Math.min(n, 50000);
            n = Math.max(n, 500);
        }
        catch (NumberFormatException numberFormatException) {
            n = 1500;
        }
        LARGE_FILE_DELAY = n;
        PLUGIN_KEY = JavaParserPlugin.class.getName();
        smScheduler = new AsyncScheduler("SemanticChecker", 30000);
    }

    public JavaParserPlugin() {
        this.$init$();
    }

    private static final void verbosePrintln(String string) {
        if (!$assertionsDisabled && !LOG.trace(string)) {
            throw new AssertionError();
        }
    }

    private static final void verbosePrintTiming(long l, String string, String string2) {
        if (!$assertionsDisabled && !LOG.trace("[{0}ms]{1}", l, (Object)string)) {
            throw new AssertionError();
        }
    }

    private static int getCompileDelay(int n) {
        if (n <= 20000) {
            return SMALL_FILE_DELAY;
        }
        if (n >= 100000) {
            return LARGE_FILE_DELAY;
        }
        int n2 = (LARGE_FILE_DELAY - SMALL_FILE_DELAY) * (n - 20000) / 80000;
        return n2 += SMALL_FILE_DELAY;
    }

    void $init$() {
        this.helperList = new CopyOnWriteList();
        this._lastDelayUsed = SMALL_FILE_DELAY;
        this.smTask = null;
        this.smJavaManager = null;
        this.smTaskSourceFile = null;
        this.smTaskChangeId = -1;
    }

    private void notifyCompileScheduled() {
        JavaParserPlugin.verbosePrintln("CompilerHelper: notify scheduled");
        for (HelperClient helperClient : this.helperList) {
            try {
                helperClient.notifyCompileScheduled();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    private void notifyParseFinished(JavaManager javaManager, SourceFile sourceFile, int n, int n2) {
        int n3 = this._lastDelayUsed + n2;
        JavaParserPlugin.verbosePrintTiming(n2, "CompilerHelper: notify parse finished, changeId: " + n, "");
        for (HelperClient helperClient : this.helperList) {
            try {
                helperClient.notifyParseFinished(javaManager, sourceFile, n, n3);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    private void notifyCompileFinished(JavaManager javaManager, SourceFile sourceFile, int n, int n2) {
        int n3 = this._lastDelayUsed + n2;
        JavaParserPlugin.verbosePrintTiming(n2, "CompilerHelper: notify finished, changeId: " + n, "");
        for (HelperClient helperClient : this.helperList) {
            try {
                helperClient.notifyCompileFinished(javaManager, sourceFile, n, n3);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    public static void attachHelperClient(BasicEditorPane basicEditorPane, HelperClient helperClient) {
        JavaParserPlugin.verbosePrintln("CompilerHelper: attaching helper client");
        JavaParserPlugin javaParserPlugin = JavaParserPlugin.lookupOrCreatePlugin(basicEditorPane);
        javaParserPlugin.helperList.addIfAbsent((Object)helperClient);
    }

    public static void detachHelperClient(BasicEditorPane basicEditorPane, HelperClient helperClient) {
        JavaParserPlugin.verbosePrintln("CompilerHelper: detaching helper client");
        JavaParserPlugin javaParserPlugin = JavaParserPlugin.lookupPlugin(basicEditorPane);
        if (javaParserPlugin != null) {
            javaParserPlugin.helperList.remove((Object)helperClient);
        }
    }

    public static void ensureCompileScheduled(BasicEditorPane basicEditorPane) {
        JavaParserPlugin javaParserPlugin = (JavaParserPlugin)basicEditorPane.getProperty(PLUGIN_KEY);
        if (javaParserPlugin != null) {
            javaParserPlugin.ensureCompileScheduled();
        }
    }

    private void detachAllClients() {
        JavaParserPlugin.verbosePrintln("CompilerHelper: detaching all client");
        this.helperList.clear();
    }

    private static synchronized JavaParserPlugin lookupPlugin(BasicEditorPane basicEditorPane) {
        return (JavaParserPlugin)basicEditorPane.getProperty(PLUGIN_KEY);
    }

    private static synchronized JavaParserPlugin lookupOrCreatePlugin(BasicEditorPane basicEditorPane) {
        JavaParserPlugin javaParserPlugin = JavaParserPlugin.lookupPlugin(basicEditorPane);
        if (javaParserPlugin == null) {
            JavaParserPlugin.verbosePrintln("CompilerHelper: installing new helper");
            javaParserPlugin = new JavaParserPlugin();
            basicEditorPane.installPlugin((EditorPlugin)javaParserPlugin);
        }
        return javaParserPlugin;
    }

    public void install(BasicEditorPane basicEditorPane) {
        this.editor = basicEditorPane;
        basicEditorPane.addFocusListener((FocusListener)this);
        BasicDocument basicDocument = this.getDocument();
        basicDocument.addDocumentListener((DocumentListener)this);
        this.updateTimer = new Timer(2000, this);
        this.updateTimer.setRepeats(false);
        this.restartTimer();
        basicEditorPane.putProperty(PLUGIN_KEY, (Object)this);
        Context context = CodeEditor.getContext((BasicEditorPane)basicEditorPane);
        if (context == null) {
            throw new IllegalStateException("Unexpected null context");
        }
        this.updateContext(context);
    }

    private void updateContext(Context context) {
        if (this.project != null) {
            this.project.detach((Observer)this);
            this.project = null;
        }
        this.javaNode = null;
        if (context != null) {
            this.javaNode = (JavaSourceNode)context.getNode();
            this.project = context.getProject();
            LOG.trace("updating context of {0} to {1}", (Object)this, (Object)context);
            if (this.project != null) {
                this.project.attach((Observer)this);
            }
        }
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        basicEditorPane.putProperty(PLUGIN_KEY, null);
        this.cancelSemantic();
        this.updateContext(null);
        if (this.updateTimer != null) {
            this.updateTimer.stop();
            this.updateTimer = null;
        }
        this.detachAllClients();
        BasicDocument basicDocument = this.getDocument();
        if (basicDocument != null) {
            basicDocument.removeDocumentListener((DocumentListener)this);
        }
        basicEditorPane.removeFocusListener((FocusListener)this);
        this.editor = null;
    }

    public void focusGained(FocusEvent focusEvent) {
        JavaParserPlugin.verbosePrintln("CompilerHelper: focus gained, restarting");
        this.restartTimer();
    }

    public void focusLost(FocusEvent focusEvent) {
        JavaParserPlugin.verbosePrintln("CompilerHelper: focus lost");
        this.stopTimer();
    }

    public void update(Object object, UpdateMessage updateMessage) {
        if (object instanceof Project) {
            int n = updateMessage.getMessageID();
            if (n == UpdateMessage.OBJECT_RELOADED || n == UpdateMessage.PROPERTY_SET) {
                JavaParserPlugin.verbosePrintln("CompilerHelper: property updated");
                this.restartTimer(true);
            } else if (n == UpdateMessage.ATTRIBUTE_CHANGED) {
                // empty if block
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("editor-ide-context")) {
            JavaParserPlugin.verbosePrintln("CompilerHelper: editor context changed");
            this.cancelSemantic();
            Context context = CodeEditor.getContext((BasicEditorPane)this.editor);
            this.updateContext(context);
            this.restartTimer(true);
        } else if ("ancestor".equals(string)) {
            if (propertyChangeEvent.getNewValue() != null) {
                this.ensureCompileScheduled();
            } else {
                this.cancelSemantic();
            }
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        JavaParserPlugin.verbosePrintln("CompilerHelper: document modified");
        this.restartTimer();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        JavaParserPlugin.verbosePrintln("CompilerHelper: document modified");
        this.restartTimer();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    private void restartTimer() {
        this.restartTimer(false);
    }

    private void restartTimer(boolean bl) {
        if (!this.editor.isShowing()) {
            return;
        }
        int n = this.getDocument().getLength();
        int n2 = JavaParserPlugin.getCompileDelay(n);
        if (bl) {
            n2 = Math.max(n2, 2000);
        }
        this._lastDelayUsed = n2;
        this.restartTimer(n2);
    }

    private void restartTimer(int n) {
        this.notifyCompileScheduled();
        this.cancelSemantic();
        this.updateTimer.setInitialDelay(n);
        this.updateTimer.restart();
        JavaParserPlugin.verbosePrintln("CompilerHelper: timer restarted: " + n);
    }

    private void stopTimer() {
        this.updateTimer.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureCompileScheduled() {
        JavaParserPlugin javaParserPlugin = this;
        synchronized (javaParserPlugin) {
            if (this.updateTimer != null && !this.updateTimer.isRunning() && this.smTask == null) {
                this.restartTimer();
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JavaParserPlugin.verbosePrintln("CompilerHelper: timer triggered");
        this.scheduleSemantic();
    }

    private BasicDocument getDocument() {
        return (BasicDocument)this.editor.getDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleSemantic() {
        JavaParserPlugin.verbosePrintln("CompilerHelper: scheduling new task");
        SemanticTask semanticTask = new SemanticTask(null);
        JavaParserPlugin javaParserPlugin = this;
        synchronized (javaParserPlugin) {
            if (this.smTask != null) {
                JavaParserPlugin.verbosePrintln("CompilerHelper: cancelled in progress");
                smScheduler.cancelTask((AsyncTask)this.smTask);
            }
            this.smTask = semanticTask;
        }
        smScheduler.scheduleTask((AsyncTask)semanticTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelSemantic() {
        SemanticTask semanticTask;
        JavaParserPlugin javaParserPlugin = this;
        synchronized (javaParserPlugin) {
            semanticTask = this.smTask;
            this.smTask = null;
        }
        if (semanticTask != null) {
            JavaParserPlugin.verbosePrintln("CompilerHelper: cancelling task");
            smScheduler.cancelTask((AsyncTask)semanticTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishSemantic(SemanticTask semanticTask) {
        JavaParserPlugin javaParserPlugin = this;
        synchronized (javaParserPlugin) {
            if (this.smTask == semanticTask) {
                JavaParserPlugin.verbosePrintln("CompilerHelper: finishing task");
                this.smTask = null;
            }
        }
    }

    static void maS$verbosePrintln(String string) {
        JavaParserPlugin.verbosePrintln(string);
    }

    static void mav$finishSemantic(JavaParserPlugin javaParserPlugin, SemanticTask semanticTask) {
        javaParserPlugin.finishSemantic(semanticTask);
    }

    static JavaManager ra$smJavaManager(JavaParserPlugin javaParserPlugin) {
        return javaParserPlugin.smJavaManager;
    }

    static void wa$smJavaManager(JavaParserPlugin javaParserPlugin, JavaManager javaManager) {
        javaParserPlugin.smJavaManager = javaManager;
    }

    static JavaSourceNode ra$javaNode(JavaParserPlugin javaParserPlugin) {
        return javaParserPlugin.javaNode;
    }

    static Log ra$LOG() {
        return LOG;
    }

    static int ra$smTaskChangeId(JavaParserPlugin javaParserPlugin) {
        return javaParserPlugin.smTaskChangeId;
    }

    static SourceFile ra$smTaskSourceFile(JavaParserPlugin javaParserPlugin) {
        return javaParserPlugin.smTaskSourceFile;
    }

    static void wa$smTaskChangeId(JavaParserPlugin javaParserPlugin, int n) {
        javaParserPlugin.smTaskChangeId = n;
    }

    static void wa$smTaskSourceFile(JavaParserPlugin javaParserPlugin, SourceFile sourceFile) {
        javaParserPlugin.smTaskSourceFile = sourceFile;
    }

    static Project ra$project(JavaParserPlugin javaParserPlugin) {
        return javaParserPlugin.project;
    }

    static void mav$notifyParseFinished(JavaParserPlugin javaParserPlugin, JavaManager javaManager, SourceFile sourceFile, int n, int n2) {
        javaParserPlugin.notifyParseFinished(javaManager, sourceFile, n, n2);
    }

    static void mav$ensureCompileScheduled(JavaParserPlugin javaParserPlugin) {
        javaParserPlugin.ensureCompileScheduled();
    }

    static void mav$notifyCompileFinished(JavaParserPlugin javaParserPlugin, JavaManager javaManager, SourceFile sourceFile, int n, int n2) {
        javaParserPlugin.notifyCompileFinished(javaManager, sourceFile, n, n2);
    }

    public static interface HelperClient {
        public void notifyCompileScheduled();

        public void notifyParseFinished(JavaManager var1, SourceFile var2, int var3, int var4);

        public void notifyCompileFinished(JavaManager var1, SourceFile var2, int var3, int var4);
    }

    private final class SemanticTask
    extends AsyncTask {
        private Project smProject;
        private JavaSourceNode smNode;
        private boolean smCancelled;
        private volatile boolean waitingOnIndex;
        private Object waitingLock;

        void $init$() {
            this.waitingLock = new Object();
        }

        private SemanticTask() {
            this.$init$();
            this.smProject = JavaParserPlugin.ra$project(JavaParserPlugin.this);
            this.smNode = JavaParserPlugin.ra$javaNode(JavaParserPlugin.this);
            this.smCancelled = false;
        }

        protected void requestCancelImpl() {
            JavaParserPlugin.maS$verbosePrintln("requesting cancel");
            this.smCancelled = true;
            SourceFile sourceFile = JavaParserPlugin.ra$smTaskSourceFile(JavaParserPlugin.this);
            if (sourceFile != null) {
                sourceFile.cancelCompile();
            }
        }

        protected boolean isCancelledImpl() {
            return this.smCancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object runImpl() throws AsyncTask.CancelledException {
            long l = System.currentTimeMillis();
            try {
                int n;
                TextBuffer textBuffer;
                JavaParserPlugin.maS$verbosePrintln("CompilerHelper: task entry");
                if (!this.smNode.isOpen()) {
                    Object var17_2 = null;
                    JavaParserPlugin.mav$finishSemantic(JavaParserPlugin.this, this);
                    return var17_2;
                }
                if (JavaParserPlugin.ra$smJavaManager(JavaParserPlugin.this) == null) {
                    JavaParserPlugin.wa$smJavaManager(JavaParserPlugin.this, JavaManager.getJavaManager(this.smProject));
                }
                if ((textBuffer = this.smNode.acquireTextBuffer()) == null) {
                    Object var18_4 = null;
                    JavaParserPlugin.mav$finishSemantic(JavaParserPlugin.this, this);
                    return var18_4;
                }
                this.bailIfCancelled();
                JavaParserPlugin.maS$verbosePrintln("CompilerHelper: parse start");
                SourceFile sourceFile = null;
                textBuffer.readLock();
                try {
                    n = textBuffer.getChangeId();
                    textBuffer.readLock();
                    try {
                        sourceFile = JavaParserPlugin.ra$smJavaManager(JavaParserPlugin.this).getSourceFile(textBuffer);
                        if (sourceFile == null) {
                            Object var19_7 = null;
                            textBuffer.readUnlock();
                            textBuffer.readUnlock();
                            JavaParserPlugin.mav$finishSemantic(JavaParserPlugin.this, this);
                            return var19_7;
                        }
                        sourceFile.setURL(JavaParserPlugin.ra$javaNode(JavaParserPlugin.this).getURL());
                    }
                    finally {
                        textBuffer.readUnlock();
                    }
                    JavaParserPlugin.ra$LOG().trace("new source file {2} id {0}; old source file {3} id {1}", n, JavaParserPlugin.ra$smTaskChangeId(JavaParserPlugin.this), (Object)sourceFile, (Object)JavaParserPlugin.ra$smTaskSourceFile(JavaParserPlugin.this));
                    JavaParserPlugin.wa$smTaskChangeId(JavaParserPlugin.this, n);
                    JavaParserPlugin.wa$smTaskSourceFile(JavaParserPlugin.this, sourceFile);
                }
                finally {
                    textBuffer.readUnlock();
                }
                this.bailIfCancelled();
                int n2 = n;
                SourceFile sourceFile2 = sourceFile;
                3 var8_12 = new 3(this, l, sourceFile2, n2);
                SwingUtilities.invokeLater(var8_12);
                JavaParserPlugin.maS$verbosePrintln("CompilerHelper: semantic compile start");
                CacheSupport cacheSupport = JavaParserPlugin.ra$smJavaManager(JavaParserPlugin.this).getCacheSupport();
                try {
                    try {
                        cacheSupport.beginCacheUse();
                        JavaParserPlugin.ra$LOG().trace("compiling, isCompiled {0}", sourceFile.isCompiled());
                        sourceFile.compile();
                        this.bailIfCancelled();
                    }
                    catch (AsyncTask.CancelledException cancelledException) {
                        JavaParserPlugin.maS$verbosePrintln("cancelled during semantic");
                        throw cancelledException;
                    }
                    catch (ExpiredTextBufferException expiredTextBufferException) {
                        JavaParserPlugin.maS$verbosePrintln("expired during semantic");
                        throw expiredTextBufferException;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        JavaParserPlugin.maS$verbosePrintln("exception during semantic: " + throwable);
                        throw new UnexpectedExceptionError(throwable);
                    }
                }
                finally {
                    cacheSupport.endCacheUse();
                }
                JavaProjectIndexer javaProjectIndexer = JavaProjectIndexer.getJavaProjectIndexer();
                if (!javaProjectIndexer.isIndexed(this.smProject)) {
                    Object object = this.waitingLock;
                    synchronized (object) {
                        if (!this.waitingOnIndex) {
                            this.waitingOnIndex = true;
                            JavaParserPlugin.maS$verbosePrintln("CompilerHelper: begin wait for index");
                            Project project = this.smProject;
                            2 var15_21 = new 2(this, "ProjectIndexWait-" + this.smProject.getShortLabel(), javaProjectIndexer, project);
                            var15_21.start();
                        }
                    }
                }
                JavaParserPlugin.maS$verbosePrintln("CompilerHelper: scheduling notify");
                1 var16_22 = new 1(this, l, sourceFile2, n2);
                SwingUtilities.invokeLater(var16_22);
                Object var24_23 = null;
                JavaParserPlugin.mav$finishSemantic(JavaParserPlugin.this, this);
                return var24_23;
            }
            catch (Throwable throwable) {
                JavaParserPlugin.mav$finishSemantic(JavaParserPlugin.this, this);
                throw throwable;
            }
        }

        SemanticTask(1 var2_2) {
            this();
        }

        static Object ra$waitingLock(SemanticTask semanticTask) {
            return semanticTask.waitingLock;
        }

        static void wa$waitingOnIndex(SemanticTask semanticTask, boolean bl) {
            semanticTask.waitingOnIndex = bl;
        }

        public final class 3
        implements Runnable {
            private final /* synthetic */ long v$compileStart;
            private final /* synthetic */ SourceFile v$passSourceFile;
            private final /* synthetic */ int v$passChangeId;
            final /* synthetic */ SemanticTask this$0;

            public void run() {
                long l = System.currentTimeMillis() - this.v$compileStart;
                if (!this.this$0.isCancelledImpl()) {
                    JavaParserPlugin.maS$verbosePrintln("CompilerHelper: performing notify");
                    JavaParserPlugin.mav$notifyParseFinished(this.this$0.JavaParserPlugin.this, JavaParserPlugin.ra$smJavaManager(this.this$0.JavaParserPlugin.this), this.v$passSourceFile, this.v$passChangeId, (int)l);
                }
            }

            public 3(SemanticTask semanticTask, long l, SourceFile sourceFile, int n) {
                this.v$passChangeId = n;
                this.v$passSourceFile = sourceFile;
                this.v$compileStart = l;
                this.this$0 = semanticTask;
            }
        }

        public final class 2
        extends Thread {
            private final /* synthetic */ JavaProjectIndexer v$indexer;
            private final /* synthetic */ Project v$project;
            final /* synthetic */ SemanticTask this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                this.v$indexer.waitUntilIndexed(this.v$project);
                Object object = SemanticTask.ra$waitingLock(this.this$0);
                synchronized (object) {
                    SemanticTask.wa$waitingOnIndex(this.this$0, false);
                }
                JavaParserPlugin.maS$verbosePrintln("CompilerHelper: indexing completed");
                JavaParserPlugin.mav$ensureCompileScheduled(this.this$0.JavaParserPlugin.this);
            }

            public 2(SemanticTask semanticTask, String string, JavaProjectIndexer javaProjectIndexer, Project project) {
                this.v$project = project;
                this.v$indexer = javaProjectIndexer;
                this.this$0 = semanticTask;
                super(string);
            }
        }

        public final class 1
        implements Runnable {
            private final /* synthetic */ long v$compileStart;
            private final /* synthetic */ SourceFile v$passSourceFile;
            private final /* synthetic */ int v$passChangeId;
            final /* synthetic */ SemanticTask this$0;

            public void run() {
                long l = System.currentTimeMillis() - this.v$compileStart;
                if (!this.this$0.isCancelledImpl()) {
                    JavaParserPlugin.maS$verbosePrintln("CompilerHelper: performing notify");
                    JavaParserPlugin.mav$notifyCompileFinished(this.this$0.JavaParserPlugin.this, JavaParserPlugin.ra$smJavaManager(this.this$0.JavaParserPlugin.this), this.v$passSourceFile, this.v$passChangeId, (int)l);
                }
            }

            public 1(SemanticTask semanticTask, long l, SourceFile sourceFile, int n) {
                this.v$passChangeId = n;
                this.v$passSourceFile = sourceFile;
                this.v$compileStart = l;
                this.this$0 = semanticTask;
            }
        }
    }
}

