/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.config.ClientSetting;
import oracle.ide.controls.ProgressTrackedTask;
import oracle.ide.controls.ProgressTracker;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.util.AsyncScheduler;
import oracle.javatools.parser.util.AsyncTask;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.locator.ClassLocatorFactory;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.usage.keyword.KeywordIndex;
import oracle.jdeveloper.usage.util.BackgroundTask;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.editing.JavaOptions;

public final class JavaProjectIndexer
implements Observer {
    private static JavaProjectIndexer _indexer = new JavaProjectIndexer();
    private static AsyncScheduler INDEX_SCHEDULER = new AsyncScheduler("JavaProjectIndex", 5, 1);
    private static List locatorProjectList = new ArrayList(20);
    private static List keywordProjectList = new ArrayList(20);
    private Set _indexedSet;
    private int DISPLAY_DELAY;
    private int SUBSEQUENT_DELAY;
    private List _taskList;
    private boolean _trackerRunning;

    public static JavaProjectIndexer getJavaProjectIndexer() {
        return _indexer;
    }

    private JavaProjectIndexer() {
        this.$init$();
    }

    private void projectOpened(Project project) {
        if (project != null) {
            project.attach((Observer)this);
            this.projectChanged(project);
        }
    }

    private void projectChanged(Project project) {
        if (project != null) {
            this.indexProject(project);
        }
    }

    private void projectClosed(Project project) {
        if (project != null) {
            project.detach((Observer)this);
            this.clearProject(project);
        }
    }

    public void update(Object object, UpdateMessage updateMessage) {
        int n = updateMessage.getMessageID();
        if (object instanceof Project) {
            Project project = (Project)object;
            if (n == UpdateMessage.OBJECT_RELOADED) {
                this.projectChanged(project);
            } else if (n == UpdateMessage.PROPERTY_SET && (updateMessage.containsProperty("classPath") || updateMessage.containsProperty("sourcePath"))) {
                this.projectChanged(project);
            }
        }
    }

    void initialize() {
        Iterator iterator = NodeFactory.getCachedNodes();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Project)) continue;
            this.projectOpened((Project)e);
        }
        3 var3_3 = new 3();
        Node.addNodeListenerForType(Project.class, (NodeListener)var3_3);
    }

    private void indexProject(Project project) {
        LocatorTask locatorTask = this.locatorIndexProject(project);
        KeywordTask keywordTask = this.keywordIndexProject(project);
        this.trackIndex(locatorTask);
        this.trackIndex(keywordTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocatorTask locatorIndexProject(Project project) {
        this.clearIndexed(project);
        List list = locatorProjectList;
        synchronized (list) {
            locatorProjectList.add(project);
        }
        LocatorTask locatorTask = new LocatorTask(null);
        INDEX_SCHEDULER.scheduleTask((AsyncTask)locatorTask);
        return locatorTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeywordTask keywordIndexProject(Project project) {
        List list = keywordProjectList;
        synchronized (list) {
            keywordProjectList.add(project);
        }
        KeywordTask keywordTask = new KeywordTask(null);
        INDEX_SCHEDULER.scheduleTask((AsyncTask)keywordTask);
        return keywordTask;
    }

    private static void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIndexed(Project project) {
        JavaProjectIndexer javaProjectIndexer = this;
        synchronized (javaProjectIndexer) {
            boolean bl = this._indexedSet.contains(project);
            return bl;
        }
    }

    public boolean waitUntilIndexed(Project project) {
        if (this.isIndexed(project)) {
            return true;
        }
        if (!project.isOpen()) {
            return false;
        }
        this.locatorIndexProject(project);
        while (!this.isIndexed(project)) {
            JavaProjectIndexer.sleep(50);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markIndexed(Project project) {
        JavaProjectIndexer javaProjectIndexer = this;
        synchronized (javaProjectIndexer) {
            this._indexedSet.add(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearProject(Project project) {
        this.clearIndexed(project);
        List list = locatorProjectList;
        synchronized (list) {
            locatorProjectList.remove(project);
        }
        List list2 = keywordProjectList;
        synchronized (list2) {
            keywordProjectList.remove(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearIndexed(Project project) {
        JavaProjectIndexer javaProjectIndexer = this;
        synchronized (javaProjectIndexer) {
            this._indexedSet.remove(project);
        }
    }

    void $init$() {
        this._indexedSet = new HashSet(50);
        this.DISPLAY_DELAY = 6000;
        this.SUBSEQUENT_DELAY = 2000;
        this._taskList = new ArrayList();
        this._trackerRunning = false;
    }

    private boolean getShowIndexerDialog() {
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)"oracle.jdeveloper");
        JavaOptions javaOptions = (JavaOptions)clientSetting.getData("JavaEditingOptions");
        if (javaOptions == null) {
            javaOptions = new JavaOptions();
        }
        return javaOptions.getShowIndexerDialog();
    }

    private void setShowIndexerDialog(boolean bl) {
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)"oracle.jdeveloper");
        JavaOptions javaOptions = (JavaOptions)clientSetting.getData("JavaEditingOptions");
        if (javaOptions == null) {
            javaOptions = new JavaOptions();
        }
        javaOptions.setShowIndexerDialog(bl);
        clientSetting.putData("JavaEditingOptions", (Copyable)javaOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trackIndex(IndexTask indexTask) {
        boolean bl = this.getShowIndexerDialog();
        List list = this._taskList;
        synchronized (list) {
            this._taskList.add(indexTask);
            if (bl) {
                this.trackProgress();
            }
        }
    }

    private void trackProgress() {
        if (this._trackerRunning) {
            return;
        }
        this._trackerRunning = true;
        ProgressDialog progressDialog = new ProgressDialog(null);
        boolean[] blArray = new boolean[]{false};
        2 var3_3 = new 2(this, progressDialog, blArray);
        1 var4_4 = new 1(this, var3_3, blArray, progressDialog);
        Thread thread = new Thread((Runnable)var4_4, "Project Indexer Progress");
        thread.start();
    }

    static void mav$projectClosed(JavaProjectIndexer javaProjectIndexer, Project project) {
        javaProjectIndexer.projectClosed(project);
    }

    static void mav$projectOpened(JavaProjectIndexer javaProjectIndexer, Project project) {
        javaProjectIndexer.projectOpened(project);
    }

    static void mav$markIndexed(JavaProjectIndexer javaProjectIndexer, Project project) {
        javaProjectIndexer.markIndexed(project);
    }

    static List ra$locatorProjectList() {
        return locatorProjectList;
    }

    static List ra$keywordProjectList() {
        return keywordProjectList;
    }

    static void mav$setShowIndexerDialog(JavaProjectIndexer javaProjectIndexer, boolean bl) {
        javaProjectIndexer.setShowIndexerDialog(bl);
    }

    static int ra$DISPLAY_DELAY(JavaProjectIndexer javaProjectIndexer) {
        return javaProjectIndexer.DISPLAY_DELAY;
    }

    static int ra$SUBSEQUENT_DELAY(JavaProjectIndexer javaProjectIndexer) {
        return javaProjectIndexer.SUBSEQUENT_DELAY;
    }

    static void wa$DISPLAY_DELAY(JavaProjectIndexer javaProjectIndexer, int n) {
        javaProjectIndexer.DISPLAY_DELAY = n;
    }

    static List ra$_taskList(JavaProjectIndexer javaProjectIndexer) {
        return javaProjectIndexer._taskList;
    }

    static void wa$_trackerRunning(JavaProjectIndexer javaProjectIndexer, boolean bl) {
        javaProjectIndexer._trackerRunning = bl;
    }

    public final class 3
    extends NodeListener {
        public void nodeOpened(NodeEvent nodeEvent) {
            if (nodeEvent.getNode() instanceof Project) {
                JavaProjectIndexer.mav$projectOpened(JavaProjectIndexer.this, (Project)nodeEvent.getNode());
            }
        }

        public void nodeClosed(NodeEvent nodeEvent) {
            if (nodeEvent.getNode() instanceof Project) {
                JavaProjectIndexer.mav$projectClosed(JavaProjectIndexer.this, (Project)nodeEvent.getNode());
            }
        }
    }

    private static abstract class IndexTask
    extends AsyncTask {
        private Project _currentProject;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Project getQueuedProject() {
            List list;
            List list2 = list = this.getQueueList();
            synchronized (list2) {
                while (list.size() > 0) {
                    Project project = (Project)list.remove(0);
                    if (project == null) continue;
                    Project project2 = project;
                    return project2;
                }
            }
            return null;
        }

        public Project getCurrentProject() {
            return this._currentProject;
        }

        protected abstract List getQueueList();

        protected Object runImpl() {
            2 var1_1 = new 2();
            ProgressTracker progressTracker = Ide.getStatusBar().getProgressTracker();
            1 var3_3 = new 1(this, progressTracker, var1_1);
            SwingUtilities.invokeLater(var3_3);
            while (true) {
                Project project;
                this._currentProject = project = this.getQueuedProject();
                if (project == null) break;
                if (!project.isOpen()) continue;
                String string = this.getStatusBarText(project);
                if (string != null && string.length() > 0) {
                    Ide.getStatusBar().setText(string);
                }
                this.buildIndex(project);
                if (string == null || !string.equals(Ide.getStatusBar().getText())) continue;
                Ide.getStatusBar().setText("");
            }
            return Boolean.TRUE;
        }

        protected abstract void buildIndex(Project var1);

        protected abstract String getStatusBarText(Project var1);

        protected abstract String getProgressBarText(Project var1);

        protected abstract String getProgressBarTooltipText(Project var1);

        protected void requestCancelImpl() {
        }

        protected boolean isCancelledImpl() {
            return false;
        }

        private IndexTask() {
        }

        static void maS$sleep(int n) {
            AsyncTask.sleep((int)n);
        }

        static Project ra$_currentProject(IndexTask indexTask) {
            return indexTask._currentProject;
        }

        IndexTask(1 var1_1) {
            this();
        }

        public final class 2
        implements ProgressTrackedTask {
            public boolean isIndeterminate() {
                return true;
            }

            public int getCurrentValue() {
                return 0;
            }

            public int getMinimum() {
                return 0;
            }

            public int getMaximum() {
                return 100;
            }

            public String getCurrentText() {
                Project project = IndexTask.ra$_currentProject(IndexTask.this);
                return project != null ? IndexTask.this.getProgressBarText(project) : "";
            }

            public String getTaskDescription() {
                Project project = IndexTask.ra$_currentProject(IndexTask.this);
                return project != null ? IndexTask.this.getProgressBarTooltipText(project) : "";
            }

            public void run() {
                while (!IndexTask.this.isFinished()) {
                    IndexTask.maS$sleep(100);
                }
            }
        }

        public final class 1
        implements Runnable {
            private final /* synthetic */ ProgressTracker v$tracker;
            private final /* synthetic */ ProgressTrackedTask v$trackedTask;
            final /* synthetic */ IndexTask this$0;

            public void run() {
                this.v$tracker.addTask(this.v$trackedTask, "BackgroundKeywordIndexer");
            }

            public 1(IndexTask indexTask, ProgressTracker progressTracker, ProgressTrackedTask progressTrackedTask) {
                this.v$trackedTask = progressTrackedTask;
                this.v$tracker = progressTracker;
                this.this$0 = indexTask;
            }
        }
    }

    private class LocatorTask
    extends IndexTask {
        protected List getQueueList() {
            return JavaProjectIndexer.ra$locatorProjectList();
        }

        protected void buildIndex(Project project) {
            BaseClassLocator baseClassLocator = ClassLocatorFactory.getProjectLocator(project);
            baseClassLocator.buildIndex();
            JavaProjectIndexer.mav$markIndexed(JavaProjectIndexer.this, project);
        }

        protected String getStatusBarText(Project project) {
            String string = project.getShortLabel();
            String string2 = JavaArb.format(356, string);
            return string2;
        }

        protected String getProgressBarText(Project project) {
            return JavaArb.getString(357);
        }

        protected String getProgressBarTooltipText(Project project) {
            return this.getStatusBarText(project);
        }

        private LocatorTask() {
            super(null);
        }

        LocatorTask(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class KeywordTask
    extends IndexTask {
        private URL _rootURL;

        protected List getQueueList() {
            return JavaProjectIndexer.ra$keywordProjectList();
        }

        void $init$() {
            this._rootURL = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void buildIndex(Project project) {
            URLPath uRLPath = PathsConfiguration.getInstance(project).getProjectSourcePath();
            URL[] uRLArray = uRLPath.getEntries();
            int n = uRLArray == null ? 0 : uRLArray.length;
            int n2 = 0;
            while (n2 < n) {
                URL uRL = uRLArray[n2];
                KeywordTask keywordTask = this;
                synchronized (keywordTask) {
                    this._rootURL = uRL;
                }
                KeywordIndex keywordIndex = KeywordIndex.getKeywordIndex(uRL);
                BackgroundTask backgroundTask = keywordIndex.getBuildTask();
                backgroundTask.waitUntilFinished();
                ++n2;
            }
        }

        protected String getStatusBarText(Project project) {
            String string = project.getShortLabel();
            String string2 = JavaArb.format(358, string);
            return string2;
        }

        protected String getProgressBarText(Project project) {
            return JavaArb.getString(359);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String getProgressBarTooltipText(Project project) {
            URL uRL = null;
            KeywordTask keywordTask = this;
            synchronized (keywordTask) {
                uRL = this._rootURL;
            }
            if (uRL != null) {
                String string = URLFileSystem.getPlatformPathName((URL)uRL);
                return JavaArb.format(360, string);
            }
            return this.getProgressBarText(project);
        }

        private KeywordTask() {
            super(null);
            this.$init$();
        }

        KeywordTask(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    public final class 2
    implements Runnable {
        private final /* synthetic */ ProgressDialog v$dialog;
        private final /* synthetic */ boolean[] v$bail;
        final /* synthetic */ JavaProjectIndexer this$0;

        public void run() {
            this.v$dialog.pack();
            boolean bl = WizardLauncher.runDialog((JDialog)((Object)this.v$dialog));
            boolean bl2 = ProgressDialog.ra$cb_alwaysBackground(this.v$dialog).isSelected() ^ true;
            JavaProjectIndexer.mav$setShowIndexerDialog(this.this$0, bl2);
            this.v$bail[0] = true;
        }

        public 2(JavaProjectIndexer javaProjectIndexer, ProgressDialog progressDialog, boolean[] blArray) {
            this.v$bail = blArray;
            this.v$dialog = progressDialog;
            this.this$0 = javaProjectIndexer;
        }
    }

    public final class oracle.jdevimpl.java.JavaProjectIndexer$1
    implements Runnable {
        private final /* synthetic */ Runnable v$displayRunnable;
        private final /* synthetic */ boolean[] v$bail;
        private final /* synthetic */ ProgressDialog v$dialog;
        final /* synthetic */ JavaProjectIndexer this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            try {
                Thread.sleep(JavaProjectIndexer.ra$DISPLAY_DELAY(this.this$0));
            }
            catch (InterruptedException var1_1) {
                // empty catch block
            }
            JavaProjectIndexer.wa$DISPLAY_DELAY(this.this$0, JavaProjectIndexer.ra$SUBSEQUENT_DELAY(this.this$0));
            var2_2 = false;
            block10: while (true) {
                var10_9 = JavaProjectIndexer.ra$_taskList(this.this$0);
                synchronized (var10_9) {
                    if (JavaProjectIndexer.ra$_taskList(this.this$0).size() > 0) {
                        var3_3 = (IndexTask)JavaProjectIndexer.ra$_taskList(this.this$0).remove(0);
                        if (var3_3.isFinished()) {
                            continue;
                        }
                    } else {
                        JavaProjectIndexer.wa$_trackerRunning(this.this$0, false);
                        break;
                    }
                }
                if (!var2_2) {
                    var2_2 = true;
                    SwingUtilities.invokeLater(this.v$displayRunnable);
                }
                while (true) {
                    if (!var3_3.isFinished()) ** break;
                    continue block10;
                    if (this.v$bail[0]) {
                        var11_10 = JavaProjectIndexer.ra$_taskList(this.this$0);
                        synchronized (var11_10) {
                            JavaProjectIndexer.ra$_taskList(this.this$0).add(0, var3_3);
                            JavaProjectIndexer.wa$_trackerRunning(this.this$0, false);
                        }
                        return;
                    }
                    var4_4 = var3_3.getCurrentProject();
                    if (var4_4 != null) {
                        var5_5 = var3_3.getStatusBarText(var4_4);
                        var6_6 = var3_3.getProgressBarTooltipText(var4_4);
                        var7_7 = new 2(this, var5_5, var6_6);
                        SwingUtilities.invokeLater(var7_7);
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException var8_8) {
                        // empty catch block
                    }
                }
                break;
            }
            if (var2_2) {
                var9_11 = new 1();
                SwingUtilities.invokeLater(var9_11);
            }
        }

        public oracle.jdevimpl.java.JavaProjectIndexer$1(JavaProjectIndexer javaProjectIndexer, Runnable runnable, boolean[] blArray, ProgressDialog progressDialog) {
            this.v$dialog = progressDialog;
            this.v$bail = blArray;
            this.v$displayRunnable = runnable;
            this.this$0 = javaProjectIndexer;
        }

        static ProgressDialog ra$v$dialog(oracle.jdevimpl.java.JavaProjectIndexer$1 var0) {
            return var0.v$dialog;
        }

        public final class 2
        implements Runnable {
            private final /* synthetic */ String v$description;
            private final /* synthetic */ String v$progressText;
            final /* synthetic */ oracle.jdevimpl.java.JavaProjectIndexer$1 this$0;

            public void run() {
                ProgressDialog.ra$label_description(oracle.jdevimpl.java.JavaProjectIndexer$1.ra$v$dialog(this.this$0)).setText(this.v$description);
                ProgressDialog.ra$label_taskProgress(oracle.jdevimpl.java.JavaProjectIndexer$1.ra$v$dialog(this.this$0)).setText(this.v$progressText);
            }

            public 2(oracle.jdevimpl.java.JavaProjectIndexer$1 var1_1, String string, String string2) {
                this.v$progressText = string2;
                this.v$description = string;
                this.this$0 = var1_1;
            }
        }

        public final class 1
        implements Runnable {
            public void run() {
                ProgressDialog.mav$bail(oracle.jdevimpl.java.JavaProjectIndexer$1.ra$v$dialog(1.this));
            }
        }
    }

    private static class ProgressDialog
    extends JEWTDialog {
        private JLabel label_description = new JLabel(JavaArb.getString(353));
        private JProgressBar pb_taskProgress = new JProgressBar(0, 100);
        private JLabel label_taskProgress;
        private JCheckBox cb_alwaysBackground;
        private JPanel panel_progress;

        private void bail() {
            this.dismissDialog(false);
        }

        private ProgressDialog() {
            super((Frame)Ide.getMainWindow(), JavaArb.getString(352), 1);
            this.pb_taskProgress.setIndeterminate(true);
            this.label_taskProgress = new JLabel("");
            this.cb_alwaysBackground = new JCheckBox();
            String string = JavaArb.getString(355);
            ResourceUtils.resButton((AbstractButton)this.cb_alwaysBackground, (String)string);
            this.panel_progress = new JPanel(new GridBagLayout());
            Insets insets = new Insets(2, 5, 2, 5);
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
            this.panel_progress.add((Component)this.label_description, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
            this.panel_progress.add((Component)this.pb_taskProgress, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
            this.panel_progress.add((Component)this.label_taskProgress, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
            this.panel_progress.add(Box.createRigidArea(new Dimension(400, 5)), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
            this.panel_progress.add((Component)this.cb_alwaysBackground, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
            this.panel_progress.add(Box.createVerticalStrut(1), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 17, 1, insets, 0, 0);
            this.panel_progress.add(Box.createGlue(), gridBagConstraints);
            this.setContent(this.panel_progress);
            this.setDefaultButton(1);
            String string2 = JavaArb.getString(354);
            this.setOKButtonText(StringUtils.stripMnemonic((String)string2));
            this.setOKButtonMnemonic(StringUtils.getMnemonicKeyCode((String)string2));
        }

        ProgressDialog(1 var1_1) {
            this();
        }

        static JCheckBox ra$cb_alwaysBackground(ProgressDialog progressDialog) {
            return progressDialog.cb_alwaysBackground;
        }

        static JLabel ra$label_description(ProgressDialog progressDialog) {
            return progressDialog.label_description;
        }

        static JLabel ra$label_taskProgress(ProgressDialog progressDialog) {
            return progressDialog.label_taskProgress;
        }

        static void mav$bail(ProgressDialog progressDialog) {
            progressDialog.bail();
        }

        public final class 1 {
        }
    }
}

