/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.browse;

import java.awt.Component;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeMenuConstants;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.Helpable;
import oracle.ide.help.HelpableProvider;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Node;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.browse.BrowseAddin;
import oracle.jdevimpl.java.browse.BrowseSupport;
import oracle.jdevimpl.java.browse.BrowseSymbolDialog;
import oracle.jdevimpl.java.browse.JavaBrowseSupport2;

final class BrowseController
implements HelpableProvider,
ContextMenuListener,
Controller {
    private static final String canBrowseKey = BrowseController.class.getName();
    private IdeAction browseSymbolAction;
    private JMenuItem browseSymbolMenuItem;
    private IdeAction browseDocAction;
    private JMenuItem browseDocMenuItem;
    private IdeAction browseHierarchyAction;
    private JMenuItem browseHierarchyMenuItem;
    private IdeAction browseDialogAction;

    BrowseController() {
        String string = JavaArb.getString(13);
        int n = StringUtils.getMnemonicKeyCode((String)string);
        this.browseSymbolAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"ojjb.BrowseSymbol"), null, (String)string, (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)new Integer(n), (ArrayResourceBundle)JavaArb.getInstance(), (int)14, null, (boolean)true);
        this.browseSymbolAction.addController((Controller)this);
        this.browseSymbolMenuItem = Ide.getMenubar().createMenuItem((ToggleAction)this.browseSymbolAction, JDeveloperMenuConstants.WEIGHT_NAVIGATE_GO_TO_CLASS);
        String string2 = JavaArb.getString(15);
        int n2 = StringUtils.getMnemonicKeyCode((String)string2);
        this.browseDocAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"ojjb.BrowseJavaDoc"), null, (String)string2, (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)new Integer(n2), (ArrayResourceBundle)JavaArb.getInstance(), (int)16, null, (boolean)true);
        this.browseDocAction.addController((Controller)this);
        this.browseDocMenuItem = Ide.getMenubar().createMenuItem((ToggleAction)this.browseDocAction, JDeveloperMenuConstants.WEIGHT_NAVIGATE_GO_TO_JAVADOC);
        this.browseDialogAction = IdeAction.find((int)32);
        this.browseDialogAction.addController((Controller)this);
        this.browseDialogAction.setEnabled(true);
        String string3 = JavaArb.getString(0);
        int n3 = StringUtils.getMnemonicKeyCode((String)string3);
        this.browseDialogAction.putValue("Name", (Object)StringUtils.stripMnemonic((String)string3));
        this.browseDialogAction.putValue("MnemonicKey", (Object)new Integer(n3));
        String string4 = JavaArb.getString(345);
        int n4 = StringUtils.getMnemonicKeyCode((String)string4);
        this.browseHierarchyAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"ojjb.BrowseHierarchy"), null, (String)string4, (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)new Integer(n4), (ArrayResourceBundle)JavaArb.getInstance(), (int)346, null, (boolean)true);
        this.browseHierarchyAction.addController((Controller)this);
        this.browseHierarchyMenuItem = Ide.getMenubar().createMenuItem((ToggleAction)this.browseHierarchyAction);
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/jdevimpl/java/browse/accelerators.xml");
    }

    void shutdown() {
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == this.browseSymbolAction.getCommandId() || n == this.browseDocAction.getCommandId() || n == this.browseHierarchyAction.getCommandId()) {
            CodeEditor codeEditor;
            Context context2;
            Node node;
            BrowseSupport browseSupport;
            View view = context.getView();
            if (view instanceof CodeEditor && (browseSupport = BrowseAddin.getSupport((node = (context2 = (codeEditor = (CodeEditor)view).getContext()).getNode()).getClass())) != null && browseSupport.canBrowseAtCursor(codeEditor)) {
                if (n == this.browseSymbolAction.getCommandId()) {
                    browseSupport.performBrowseSymbolAtCursor(codeEditor);
                } else if (n == this.browseDocAction.getCommandId()) {
                    browseSupport.performBrowseDocAtCursor(codeEditor);
                } else {
                    browseSupport.performBrowseHierarchyAtCursor(codeEditor);
                }
            }
            return true;
        }
        if (n == this.browseDialogAction.getCommandId()) {
            BrowseSymbolDialog.showDialog(context);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == this.browseSymbolAction.getCommandId() || n == this.browseDocAction.getCommandId() || n == this.browseHierarchyAction.getCommandId()) {
            boolean bl = false;
            if (context != null) {
                Boolean bl2 = (Boolean)context.getProperty(canBrowseKey);
                if (bl2 != null) {
                    bl = bl2;
                } else {
                    View view = context.getView();
                    Node node = context.getNode();
                    if (view instanceof CodeEditor && node != null) {
                        CodeEditor codeEditor = (CodeEditor)view;
                        BrowseSupport browseSupport = BrowseAddin.getSupport(node.getClass());
                        if (browseSupport != null && browseSupport.canBrowseAtCursor(codeEditor)) {
                            bl = true;
                        }
                    }
                    Boolean bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
                    context.setProperty(canBrowseKey, (Object)bl3);
                }
            }
            ideAction.setEnabled(bl);
            return true;
        }
        if (n == this.browseDialogAction.getCommandId()) {
            ideAction.setEnabled(true);
            return true;
        }
        return false;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        CodeEditor codeEditor;
        Context context;
        Node node;
        BrowseSupport browseSupport;
        Context context2 = contextMenu.getContext();
        View view = context2.getView();
        if (view instanceof CodeEditor && (browseSupport = BrowseAddin.getSupport((node = (context = (codeEditor = (CodeEditor)view).getContext()).getNode()).getClass())) != null) {
            float f = CodeMenuConstants.SECTION_SOURCE_CTXT_MENU - 0.001f;
            contextMenu.add((Component)this.browseSymbolMenuItem, f);
            contextMenu.add((Component)this.browseDocMenuItem, f);
            if (JavaBrowseSupport2.canBrowseHierarchy()) {
                contextMenu.add((Component)this.browseHierarchyMenuItem, f);
            }
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public HelpInfo getHelpInfo(Helpable helpable) {
        CodeEditor codeEditor;
        Context context;
        Node node;
        BrowseSupport browseSupport;
        if (helpable instanceof CodeEditor && (browseSupport = BrowseAddin.getSupport((node = (context = (codeEditor = (CodeEditor)helpable).getContext()).getNode()).getClass())) != null && browseSupport.canBrowseAtCursor(codeEditor)) {
            return browseSupport.getHelpInfoAtCursor(codeEditor);
        }
        return null;
    }
}

