/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.browse;

import java.awt.Component;
import java.util.LinkedList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.ModelUtil;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.browse.BrowseHierarchyDialog;
import oracle.jdevimpl.java.browse.BrowseHierarchyDockableFactory;
import oracle.jdevimpl.java.browse.BrowseHierarchyWindow;

public class BrowseHierarchyAddin
implements Controller,
Addin {
    private static final int VIEW_HIERARCHY_CMD_ID = Ide.findOrCreateCmdID((String)"ViewHierarchy");
    private static final int BROWSE_HIERARCHY_DIALOG_CMD_ID = Ide.findOrCreateCmdID((String)"BrowseHierarchyDialog");
    private static final int BROWSE_HIERARCHY_BACK_CMD_ID = Ide.findOrCreateCmdID((String)"BrowseHierarchy.Back");
    private static final int BROWSE_HIERARCHY_FORWARD_CMD_ID = Ide.findOrCreateCmdID((String)"BrowseHierarchy.Forward");
    private static final int BROWSE_HIERARCHY_SUPERTYPE_CMD_ID = Ide.findOrCreateCmdID((String)"BrowseHierarchy.Supertype");
    private static final int BROWSE_HIERARCHY_SUBTYPE_CMD_ID = Ide.findOrCreateCmdID((String)"BrowseHierarchy.Subtype");
    private static final String BROWSE_HIERARCHY_STYLE_GROUP = "BrowseHierarchy.StyleGroup";
    private static BrowseHierarchyAddin INSTANCE;
    private BrowseManager _browseManager;
    private JMenuItem _viewHierarchyMenuItem;
    private JMenuItem _browseHierarchyDialogMenuItem;

    public static void browseTypeHierarchy(Context context, String string) {
        INSTANCE.browseType(context, string);
    }

    public void initialize() {
        IdeAction ideAction;
        INSTANCE = this;
        this._browseManager = new BrowseManager();
        IdeAction ideAction2 = IdeAction.get((int)BROWSE_HIERARCHY_BACK_CMD_ID, null, (String)IdeArb.getString((int)426), null, null, (ArrayResourceBundle)IdeArb.getInstance(), (int)428, null, (boolean)false);
        ideAction2.addController((Controller)this);
        IdeAction ideAction3 = IdeAction.get((int)BROWSE_HIERARCHY_FORWARD_CMD_ID, null, (String)IdeArb.getString((int)430), null, null, (ArrayResourceBundle)IdeArb.getInstance(), (int)432, null, (boolean)false);
        ideAction3.addController((Controller)this);
        IdeAction ideAction4 = IdeAction.get((int)BROWSE_HIERARCHY_SUPERTYPE_CMD_ID, null, (String)JavaArb.getString(334), null, null, (ArrayResourceBundle)JavaArb.getInstance(), (int)335, null, (boolean)true);
        ideAction4.putValue("RadioGroupName", (Object)BROWSE_HIERARCHY_STYLE_GROUP);
        ideAction4.putValue("Radio", (Object)Boolean.TRUE);
        ideAction4.addController((Controller)this);
        ideAction4.setState(true);
        IdeAction ideAction5 = IdeAction.get((int)BROWSE_HIERARCHY_SUBTYPE_CMD_ID, null, (String)JavaArb.getString(336), null, null, (ArrayResourceBundle)JavaArb.getInstance(), (int)337, null, (boolean)true);
        ideAction5.putValue("RadioGroupName", (Object)BROWSE_HIERARCHY_STYLE_GROUP);
        ideAction5.putValue("Radio", (Object)Boolean.TRUE);
        ideAction5.addController((Controller)this);
        String string = JavaArb.getString(340);
        int n = StringUtils.getMnemonicKeyCode((String)string);
        IdeAction ideAction6 = IdeAction.get((int)VIEW_HIERARCHY_CMD_ID, null, (String)string, (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)new Integer(n), (ArrayResourceBundle)JavaArb.getInstance(), (int)341, null, (boolean)true);
        ideAction6.addController((Controller)this);
        String string2 = JavaArb.getString(342);
        int n2 = StringUtils.getMnemonicKeyCode((String)string2);
        IdeAction ideAction7 = IdeAction.get((int)BROWSE_HIERARCHY_DIALOG_CMD_ID, null, (String)string2, (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)new Integer(n2), (ArrayResourceBundle)JavaArb.getInstance(), (int)343, null, (boolean)true);
        ideAction7.addController((Controller)this);
        IdeAction ideAction8 = IdeAction.find((int)51);
        if (ideAction8 != null) {
            ideAction8.addController((Controller)this);
        }
        if ((ideAction = IdeAction.find((int)20)) != null) {
            ideAction.addController((Controller)this);
        }
        Menubar menubar = Ide.getMenubar();
        JMenu jMenu = MenuManager.getJMenu((String)"View");
        JMenu jMenu2 = MenuManager.getJMenu((String)"Navigate");
        this._viewHierarchyMenuItem = menubar.createMenuItem((ToggleAction)ideAction6, MenuConstants.WEIGHT_VIEW_STRUCTURE);
        menubar.add((Component)this._viewHierarchyMenuItem, jMenu, MenuConstants.SECTION_VIEW_SUPPORTING);
        this._browseHierarchyDialogMenuItem = menubar.createMenuItem((ToggleAction)ideAction7);
        menubar.add((Component)this._browseHierarchyDialogMenuItem, jMenu2, JDeveloperMenuConstants.SECTION_NAVIGATE_ADDINS);
        DockStation.getDockStation().registerDockableFactory("BrowseHierarchy", (DockableFactory)new BrowseHierarchyDockableFactory());
    }

    public boolean canShutdown() {
        return true;
    }

    public void shutdown() {
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == VIEW_HIERARCHY_CMD_ID || n == BROWSE_HIERARCHY_DIALOG_CMD_ID) {
            ideAction.setEnabled(true);
            return true;
        }
        if (context.getView() instanceof BrowseHierarchyWindow) {
            if (n == BROWSE_HIERARCHY_SUPERTYPE_CMD_ID || n == BROWSE_HIERARCHY_SUBTYPE_CMD_ID) {
                ideAction.setEnabled(true);
                return true;
            }
            if (n == BROWSE_HIERARCHY_BACK_CMD_ID) {
                ideAction.setEnabled(this._browseManager.canBrowseBackward());
                return true;
            }
            if (n == BROWSE_HIERARCHY_FORWARD_CMD_ID) {
                ideAction.setEnabled(this._browseManager.canBrowseForward());
                return true;
            }
            if (n == 20) {
                ideAction.setEnabled(this._browseManager.canBrowseDelete());
                return true;
            }
            if (n == 51) {
                ideAction.setEnabled(this._browseManager.canBrowseRefresh());
                return true;
            }
        }
        return false;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == VIEW_HIERARCHY_CMD_ID) {
            this._browseManager.showBrowseView(context);
            return true;
        }
        if (n == BROWSE_HIERARCHY_DIALOG_CMD_ID) {
            this._browseManager.showBrowseDialog(context);
            return true;
        }
        if (context.getView() instanceof BrowseHierarchyWindow) {
            if (n == BROWSE_HIERARCHY_SUPERTYPE_CMD_ID) {
                this._browseManager.setBrowseSupertypes();
                return true;
            }
            if (n == BROWSE_HIERARCHY_SUBTYPE_CMD_ID) {
                this._browseManager.setBrowseSubtypes();
                return true;
            }
            if (n == BROWSE_HIERARCHY_BACK_CMD_ID) {
                this._browseManager.browseBackward();
                return true;
            }
            if (n == BROWSE_HIERARCHY_FORWARD_CMD_ID) {
                this._browseManager.browseForward();
                return true;
            }
            if (n == 20) {
                this._browseManager.browseDelete();
                return true;
            }
            if (n == 51) {
                this._browseManager.browseRefresh(context);
                return true;
            }
        }
        return false;
    }

    private void browseType(Context context, String string) {
        this._browseManager.browseType(context, string);
    }

    private static final class BrowseManager {
        private final LinkedList _backHistory;
        private final LinkedList _forwardHistory;
        private Object _browseStyle;

        void $init$() {
            this._backHistory = new LinkedList();
            this._forwardHistory = new LinkedList();
        }

        BrowseManager() {
            this.$init$();
            this._browseStyle = BrowseHierarchyWindow.SUPERTYPE_HIERARCHY_STYLE;
        }

        boolean canBrowseBackward() {
            return this._backHistory.size() > 1;
        }

        boolean canBrowseForward() {
            return this._forwardHistory.isEmpty() ^ true;
        }

        boolean canBrowseDelete() {
            return this._backHistory.isEmpty() ^ true;
        }

        boolean canBrowseRefresh() {
            return this._backHistory.isEmpty() ^ true;
        }

        void showBrowseView(Context context) {
            this.browseType(context, null);
        }

        void showBrowseDialog(Context context) {
            BrowseHierarchyDialog.showDialog(context);
        }

        void setBrowseSupertypes() {
            this._browseStyle = BrowseHierarchyWindow.SUPERTYPE_HIERARCHY_STYLE;
            this.updateExplorer();
        }

        void setBrowseSubtypes() {
            this._browseStyle = BrowseHierarchyWindow.SUBTYPE_HIERARCHY_STYLE;
            this.updateExplorer();
        }

        void browseType(Context context, String string) {
            DockStation dockStation = DockStation.getDockStation();
            BrowseHierarchyWindow browseHierarchyWindow = BrowseHierarchyWindow.getInstance();
            dockStation.activateDockable((Dockable)browseHierarchyWindow);
            if (string != null) {
                HistoryEntry historyEntry = new HistoryEntry(context, string);
                if (this._backHistory.isEmpty() || !historyEntry.equals(this._backHistory.getLast())) {
                    this._backHistory.addLast(historyEntry);
                    this._forwardHistory.clear();
                }
                this.updateExplorer();
            }
        }

        void browseBackward() {
            if (!this.canBrowseBackward()) {
                return;
            }
            Object e = this._backHistory.removeLast();
            this._forwardHistory.addFirst(e);
            this.updateExplorer();
        }

        void browseForward() {
            if (!this.canBrowseForward()) {
                return;
            }
            Object e = this._forwardHistory.removeFirst();
            this._backHistory.addLast(e);
            this.updateExplorer();
        }

        void browseDelete() {
            if (!this.canBrowseDelete()) {
                return;
            }
            this._backHistory.removeLast();
            if (!this._forwardHistory.isEmpty()) {
                Object e = this._forwardHistory.removeFirst();
                this._backHistory.addLast(e);
            }
            this.updateExplorer();
        }

        void browseRefresh(Context context) {
            if (!this.canBrowseRefresh()) {
                return;
            }
            HistoryEntry historyEntry = (HistoryEntry)this._backHistory.removeLast();
            this.browseType(context, historyEntry.getClassName());
        }

        private void updateExplorer() {
            BrowseHierarchyWindow browseHierarchyWindow = BrowseHierarchyWindow.getInstance();
            if (!this._backHistory.isEmpty()) {
                HistoryEntry historyEntry = (HistoryEntry)this._backHistory.getLast();
                browseHierarchyWindow.setExplorer(historyEntry.getExplorer(this._browseStyle), historyEntry.getContext());
            } else {
                browseHierarchyWindow.setExplorer(null, null);
            }
        }

        private static final class HistoryEntry {
            private final Context _context;
            private final String _className;
            private transient TreeExplorer _supertypeExplorer;
            private transient TreeExplorer _subtypeExplorer;

            public HistoryEntry(Context context, String string) {
                this._context = context;
                this._className = string;
            }

            public Context getContext() {
                return this._context;
            }

            public String getClassName() {
                return this._className;
            }

            public TreeExplorer getExplorer(Object object) {
                TreeExplorer treeExplorer;
                boolean bl = object == BrowseHierarchyWindow.SUPERTYPE_HIERARCHY_STYLE;
                TreeExplorer treeExplorer2 = treeExplorer = bl ? this._supertypeExplorer : this._subtypeExplorer;
                if (treeExplorer == null) {
                    treeExplorer = BrowseHierarchyWindow.getInstance().createExplorer(this._context, this._className, object);
                    if (bl) {
                        this._supertypeExplorer = treeExplorer;
                    } else {
                        this._subtypeExplorer = treeExplorer;
                    }
                }
                return treeExplorer;
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (!(object instanceof HistoryEntry)) {
                    return false;
                }
                HistoryEntry historyEntry = (HistoryEntry)object;
                return ModelUtil.areEqual((Object)this._className, (Object)historyEntry._className) && ModelUtil.areEqual((Object)this._context, (Object)historyEntry._context);
            }

            public int hashCode() {
                int n = 17;
                n = 37 * n + this._context.hashCode();
                n = 37 * n + this._className.hashCode();
                return n;
            }
        }
    }
}

