/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.browse;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.UIManager;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableWindow;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.DefaultElement;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.IdeSubject;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.resource.IdeIcons;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.view.View;
import oracle.ideimpl.explorer.BaseTreeExplorer;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.jdeveloper.icons.JavaIcons;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.usage.UsageManager;
import oracle.jdeveloper.usage.UsageQueryTask;
import oracle.jdeveloper.usage.event.ClassUsageEvent;
import oracle.jdeveloper.usage.event.ClassUsageListener;
import oracle.jdeveloper.usage.event.UsageEvent;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.browse.BrowseHierarchyAddin;

final class BrowseHierarchyWindow
extends DockableWindow {
    static final String HIERARCHY_BROWSER_WINDOW_ID = "BrowseHierarchy";
    static final Object SUPERTYPE_HIERARCHY_STYLE = new Integer(0);
    static final Object SUBTYPE_HIERARCHY_STYLE = new Integer(1);
    private static final String INTRO_CARD = "intro";
    private static final String EXPLORER_CARD = "explorer";
    private static final Rectangle EMPTY_RECT = new Rectangle();
    private static BrowseHierarchyWindow INSTANCE;
    private JPanel _gui;
    private Toolbar _toolbar;
    private JPanel _centerPanel;
    private CardLayout _cardLayout;
    private TreeExplorer _explorer;
    private Context _context;

    BrowseHierarchyWindow(String string) {
        super(string);
    }

    static BrowseHierarchyWindow getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BrowseHierarchyWindow(HIERARCHY_BROWSER_WINDOW_ID);
        }
        return INSTANCE;
    }

    static void disposeHierarchyBrowser() {
        if (INSTANCE != null) {
            INSTANCE.dispose();
            INSTANCE = null;
        }
    }

    static Dockable getDockable() {
        return BrowseHierarchyWindow.getInstance();
    }

    TreeExplorer createExplorer(Context context, String string, Object object) {
        DefaultTypeFolder defaultTypeFolder;
        HierarchyTreeExplorer hierarchyTreeExplorer = new HierarchyTreeExplorer();
        Project project = BrowseHierarchyWindow.getProjectFromContext(context);
        JavaManager javaManager = JavaManager.getJavaManager(project);
        JavaClass javaClass = javaManager.getClass(string);
        if (object == SUPERTYPE_HIERARCHY_STYLE) {
            defaultTypeFolder = new SupertypeFolder((JavaType)javaClass);
        } else if (object == SUBTYPE_HIERARCHY_STYLE) {
            defaultTypeFolder = new SubtypeFolder(project, (JavaType)javaClass);
        } else {
            throw new IllegalArgumentException("Invalid browse style");
        }
        RootElement rootElement = new RootElement(defaultTypeFolder);
        hierarchyTreeExplorer.setRootElement((Element)rootElement);
        if (object == SUPERTYPE_HIERARCHY_STYLE) {
            TNode tNode = hierarchyTreeExplorer.getRoot();
            hierarchyTreeExplorer.expand(tNode, true);
        }
        return hierarchyTreeExplorer;
    }

    void setExplorer(TreeExplorer treeExplorer, Context context) {
        if (this._gui != null && this._explorer != null) {
            this._centerPanel.remove(this._explorer.getGUI());
        }
        this._explorer = treeExplorer;
        if (context != null) {
            this._context = new Context(context);
            this._context.setView((View)INSTANCE);
        } else {
            this._context = null;
        }
        if (this._gui != null) {
            this.updateGUI();
        }
    }

    public Context getContext(EventObject eventObject) {
        if (this._context == null) {
            this._context = Context.newIdeContext((View)this);
        }
        this._context.setEvent(eventObject);
        return this._context;
    }

    public Component getGUI() {
        if (this._gui == null) {
            this._gui = new JPanel(new BorderLayout());
            this._toolbar = new Toolbar();
            BrowseHierarchyWindow.loadManifestToolbar((String)"BrowseHierarchy.Toolbar", (Toolbar)this._toolbar, (View)this);
            String string = JavaArb.getString(333);
            LabelPanel labelPanel = new LabelPanel(string);
            this._cardLayout = new CardLayout();
            this._centerPanel = new JPanel(this._cardLayout);
            this._centerPanel.add((Component)labelPanel, INTRO_CARD);
            this._gui.add((Component)this._toolbar, "North");
            this._gui.add((Component)this._centerPanel, "Center");
            this.updateGUI();
        }
        return this._gui;
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_jed_hierarchy_view_html");
    }

    public Toolbar getToolbar() {
        return this._toolbar;
    }

    public String getTitleName() {
        return JavaArb.getString(332);
    }

    public String getTabName() {
        return this.getTitleName();
    }

    public Icon getTabIcon() {
        return JavaArb.getIcon(341);
    }

    private void updateGUI() {
        SubtypeQueryManager.getInstance().cancelAll();
        if (this._explorer != null) {
            TNode tNode = this._explorer.getRoot();
            RootElement rootElement = (RootElement)tNode.getData();
            DefaultTypeFolder defaultTypeFolder = rootElement.getRootFolder();
            TNode tNode2 = this._explorer.searchTNode((Element)defaultTypeFolder, tNode);
            this._explorer.expand(tNode2, false);
            this._explorer.setSelected(tNode2);
            this._explorer.getJTree().scrollRectToVisible(EMPTY_RECT);
            this._centerPanel.add(this._explorer.getGUI(), EXPLORER_CARD);
            this._cardLayout.show(this._centerPanel, EXPLORER_CARD);
        } else {
            this._cardLayout.show(this._centerPanel, INTRO_CARD);
        }
        GraphicsUtils.focusComponentOrChild((Component)this._centerPanel, (boolean)true);
    }

    private void dispose() {
        if (this._explorer instanceof BaseTreeExplorer) {
            ((BaseTreeExplorer)this._explorer).dispose();
        }
        this._gui = null;
        this._toolbar = null;
        this._centerPanel = null;
        this._cardLayout = null;
        this._explorer = null;
        this._context = null;
    }

    private static Project getProjectFromContext(Context context) {
        Project project;
        Project project2 = project = context != null ? context.getProject() : null;
        if (project == null && (project = Ide.getActiveProject()) == null) {
            project = Ide.getDefaultProject();
        }
        return project;
    }

    static Project maS$getProjectFromContext(Context context) {
        return BrowseHierarchyWindow.getProjectFromContext(context);
    }

    private static final class HierarchyTreeExplorer
    extends BaseTreeExplorer
    implements ContextMenuListener,
    Controller {
        private ContextMenu _contextMenu;
        private boolean _menusBuilt;
        private IdeAction _gotoClassAction;
        private JMenuItem _gotoClassMenuItem;
        private IdeAction _browseHierarchyAction;
        private JMenuItem _browseHierarchyMenuItem;

        HierarchyTreeExplorer() {
            this.setContext(null);
            this.setComparator(TreeComparator.getInstance());
        }

        public boolean update(IdeAction ideAction, Context context) {
            View view;
            View view2 = view = context != null ? context.getView() : null;
            if (!(view instanceof HierarchyTreeExplorer)) {
                return false;
            }
            if (ideAction == this._gotoClassAction || ideAction == this._browseHierarchyAction) {
                ideAction.setEnabled(true);
                return true;
            }
            return false;
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            View view;
            View view2 = view = context != null ? context.getView() : null;
            if (!(view instanceof HierarchyTreeExplorer)) {
                return false;
            }
            if (ideAction == this._gotoClassAction) {
                TypeElement typeElement = this.getSelectedType(context);
                if (typeElement != null) {
                    Editor editor;
                    SourceFile sourceFile;
                    URL uRL;
                    String string = typeElement.getClassName();
                    Project project = BrowseHierarchyWindow.maS$getProjectFromContext(context);
                    JavaManager javaManager = JavaManager.getJavaManager(project);
                    SourceClass sourceClass = javaManager.getSourceClass(string);
                    if (sourceClass != null && (uRL = (sourceFile = sourceClass.getOwningSourceFile()).getURL()) != null && (editor = EditorManager.getEditorManager().openDefaultEditorInFrame(uRL)) instanceof CodeEditor) {
                        CodeEditor codeEditor = (CodeEditor)editor;
                        SourceName sourceName = sourceClass.getNameElement();
                        if (sourceName != null) {
                            int n = sourceName.getStartOffset();
                            int n2 = sourceName.getEndOffset();
                            codeEditor.gotoOffset(n, n2 - n);
                        }
                    }
                }
                return true;
            }
            if (ideAction == this._browseHierarchyAction) {
                TypeElement typeElement = this.getSelectedType(context);
                if (typeElement != null) {
                    BrowseHierarchyAddin.browseTypeHierarchy(context, typeElement.getClassName());
                }
                return true;
            }
            return false;
        }

        public ContextMenu getContextMenu() {
            if (this._contextMenu == null) {
                this._contextMenu = new ContextMenu();
                this._contextMenu.addContextMenuListener((ContextMenuListener)this);
            }
            return this._contextMenu;
        }

        public void menuWillShow(ContextMenu contextMenu) {
            TypeElement typeElement;
            TypeElement typeElement2;
            if (!this._menusBuilt) {
                this._menusBuilt = true;
                String string = JavaArb.getString(221);
                int n = StringUtils.getMnemonicKeyCode((String)string);
                String string2 = StringUtils.stripMnemonic((String)string);
                this._gotoClassAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"ojjb.GotoClass"), null, (String)string2, (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)new Integer(n), (ArrayResourceBundle)JavaArb.getInstance(), (int)222, null, (boolean)false);
                this._gotoClassAction.addController((Controller)this);
                this._gotoClassMenuItem = Ide.getMenubar().createMenuItem((ToggleAction)this._gotoClassAction);
                String string3 = JavaArb.getString(345);
                int n2 = StringUtils.getMnemonicKeyCode((String)string3);
                this._browseHierarchyAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"ojjb.BrowseHierarchy"), null, (String)string3, (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)new Integer(n2), (ArrayResourceBundle)JavaArb.getInstance(), (int)346, null, (boolean)false);
                this._browseHierarchyAction.addController((Controller)this);
                this._browseHierarchyMenuItem = Ide.getMenubar().createMenuItem((ToggleAction)this._browseHierarchyAction);
            }
            if (this._gotoClassMenuItem != null && (typeElement2 = this.getSelectedType(contextMenu.getContext())) != null) {
                String string = JavaArb.format(221, typeElement2.getClassName());
                string = StringUtils.stripMnemonic((String)string);
                this._gotoClassAction.putValue("Name", (Object)string);
                this._gotoClassAction.setEnabled(true);
                contextMenu.add((Component)this._gotoClassMenuItem);
            }
            if (this._browseHierarchyMenuItem != null && (typeElement = this.getSelectedType(contextMenu.getContext())) != null) {
                this._browseHierarchyAction.setEnabled(true);
                contextMenu.add((Component)this._browseHierarchyMenuItem);
            }
        }

        public void menuWillHide(ContextMenu contextMenu) {
        }

        public boolean handleDefaultAction(Context context) {
            return this.handleEvent(this._gotoClassAction, context);
        }

        public void dispose() {
            super.dispose();
            if (this._contextMenu != null) {
                this._contextMenu.removeContextMenuListener((ContextMenuListener)this);
                this._contextMenu = null;
            }
        }

        private TypeElement getSelectedType(Context context) {
            Element element;
            TNode tNode = ExplorerContext.getSingleTNode((Context)context);
            if (tNode != null && (element = tNode.getData()) instanceof TypeElement) {
                return (TypeElement)element;
            }
            return null;
        }

        private static class TreeComparator
        implements Comparator {
            private static final TreeComparator INSTANCE = new TreeComparator();

            public static TreeComparator getInstance() {
                return INSTANCE;
            }

            private TreeComparator() {
            }

            public int compare(Object object, Object object2) {
                Comparable comparable = TreeComparator.getComparableFromNode(object);
                Comparable comparable2 = TreeComparator.getComparableFromNode(object2);
                return comparable.compareTo(comparable2);
            }

            private static final Comparable getComparableFromNode(Object object) {
                TNode tNode = (TNode)object;
                Element element = tNode.getData();
                return (Comparable)element;
            }
        }
    }

    private static final class SupertypeFolder
    extends DefaultTypeFolder {
        private static final String JAVA_LANG_OBJECT = "java.lang.Object";

        public SupertypeFolder(JavaType javaType) {
            super(javaType);
            this.initializeChildren(javaType);
        }

        private void initializeChildren(JavaType javaType) {
            JavaType javaType2 = javaType.getSuperclass();
            if (javaType2 != null && !this.isJavaLangObject(javaType2)) {
                SupertypeFolder supertypeFolder = new SupertypeFolder(javaType2);
                this.add((Element)supertypeFolder);
            }
            Collection collection = javaType.getInterfaces();
            for (JavaType javaType3 : collection) {
                if (javaType3 == null) continue;
                SupertypeFolder supertypeFolder = new SupertypeFolder(javaType3);
                this.add((Element)supertypeFolder);
            }
        }

        private boolean isJavaLangObject(JavaType javaType) {
            return javaType.getQualifiedName().equals(JAVA_LANG_OBJECT);
        }
    }

    private static final class SubtypeFolder
    extends DefaultTypeFolder
    implements Subject,
    ActionListener {
        private final Project _project;
        private final boolean _isFinal;
        private LoadingElement _loadingChild;
        private Subject _subject;

        public SubtypeFolder(Project project, JavaType javaType) {
            super(javaType);
            this._project = project;
            this._isFinal = javaType.isFinal();
            if (!this._isFinal) {
                this._loadingChild = new LoadingElement();
                this.add((Element)this._loadingChild);
            }
        }

        public boolean mayHaveChildren() {
            return this.isFinal() ^ true;
        }

        public Iterator getChildren() {
            if (this._loadingChild != null) {
                String string = this.getClassName();
                SubtypeQueryManager.getInstance().querySubtypes(this._project, string, this);
            }
            return super.getChildren();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SubtypeQueryManager.QueryTask queryTask = (SubtypeQueryManager.QueryTask)actionEvent.getSource();
            this._loadingChild.setProgress(queryTask.getProgress());
            if (queryTask.isFinished()) {
                Object[] objectArray = queryTask.getSubtypes();
                if (objectArray != null) {
                    this.remove((Element)this._loadingChild);
                    UpdateMessage.fireChildRemoved((Subject)this, (Element)this._loadingChild);
                    this._loadingChild = null;
                    int n = 0;
                    while (n < objectArray.length) {
                        JavaType javaType = (JavaType)objectArray[n];
                        SubtypeFolder subtypeFolder = new SubtypeFolder(this._project, javaType);
                        this.add((Element)subtypeFolder);
                        ++n;
                    }
                    UpdateMessage.fireChildrenAdded((Subject)this, (Collection)this._children);
                } else {
                    UpdateMessage.fireObjectClosed((Subject)this);
                    this._loadingChild.setShortLabel(JavaArb.getString(338));
                    UpdateMessage.fireObjectRenamed((Subject)this._loadingChild);
                }
            }
        }

        public void attach(Observer observer) {
            this.getSubject().attach(observer);
        }

        public void detach(Observer observer) {
            this.getSubject().detach(observer);
        }

        public void notifyObservers(Object object, UpdateMessage updateMessage) {
            this.getSubject().notifyObservers(object, updateMessage);
        }

        private Subject getSubject() {
            if (this._subject == null) {
                this._subject = new IdeSubject();
            }
            return this._subject;
        }

        private boolean isFinal() {
            return this._isFinal;
        }
    }

    private static class DefaultTypeFolder
    extends TypeElement
    implements Folder {
        protected final List _children;

        void $init$() {
            this._children = new ArrayList();
        }

        protected DefaultTypeFolder(JavaType javaType) {
            super(javaType);
            this.$init$();
        }

        public boolean mayHaveChildren() {
            return true;
        }

        public Iterator getChildren() {
            return this._children.iterator();
        }

        public boolean canAdd(Element element) {
            return true;
        }

        public boolean add(Element element) {
            return this._children.add(element);
        }

        public boolean canRemove(Element element) {
            return true;
        }

        public boolean remove(Element element) {
            return this._children.remove(element);
        }

        public boolean containsChild(Element element) {
            return this._children.contains(element);
        }

        public int size() {
            return this._children.size();
        }

        public void removeAll() {
            this._children.clear();
        }
    }

    private static class TypeElement
    extends DefaultTreeElement {
        private final boolean _isInterface;

        protected TypeElement(JavaType javaType) {
            super(javaType.getQualifiedName());
            this._isInterface = javaType.isInterface();
        }

        public String getClassName() {
            return this.getShortLabel();
        }

        public boolean isInterface() {
            return this._isInterface;
        }

        public Icon getIcon() {
            return JavaIcons.getIcon(this._isInterface ? 1 : 0);
        }

        public int compareTo(Object object) {
            if (object instanceof TypeElement) {
                TypeElement typeElement = (TypeElement)object;
                if (this._isInterface != typeElement._isInterface) {
                    return this._isInterface ? 1 : -1;
                }
                return super.compareTo(object);
            }
            return -1;
        }
    }

    private static final class LoadingElement
    extends DefaultTreeElement
    implements Subject {
        private Subject _subject;

        public LoadingElement() {
            super(JavaArb.getString(338));
        }

        public void setProgress(int n) {
            if ((n = Math.max(Math.min(n, 100), 0)) > 0) {
                this.setShortLabel(JavaArb.format(339, String.valueOf(n)));
                UpdateMessage.fireObjectRenamed((Subject)this);
            }
        }

        public int compareTo(Object object) {
            return object != this ? 1 : 0;
        }

        public void attach(Observer observer) {
            this.getSubject().attach(observer);
        }

        public void detach(Observer observer) {
            this.getSubject().detach(observer);
        }

        public void notifyObservers(Object object, UpdateMessage updateMessage) {
            this.getSubject().notifyObservers(object, updateMessage);
        }

        private Subject getSubject() {
            if (this._subject == null) {
                this._subject = new IdeSubject();
            }
            return this._subject;
        }
    }

    private static class DefaultTreeElement
    extends DefaultElement
    implements Comparable {
        private String _label;

        protected DefaultTreeElement(String string) {
            this.setShortLabel(string);
        }

        public String getShortLabel() {
            return this._label;
        }

        public Icon getIcon() {
            return IdeIcons.getIcon((int)0);
        }

        public int compareTo(Object object) {
            String string = this.getShortLabel();
            String string2 = ((DefaultTreeElement)object).getShortLabel();
            return string.compareTo(string2);
        }

        protected void setShortLabel(String string) {
            this._label = string;
        }
    }

    private static final class RootElement
    extends DefaultElement {
        private final List _children;

        public RootElement(DefaultTypeFolder defaultTypeFolder) {
            this._children = Collections.singletonList(defaultTypeFolder);
        }

        public DefaultTypeFolder getRootFolder() {
            return (DefaultTypeFolder)this._children.get(0);
        }

        public boolean mayHaveChildren() {
            return true;
        }

        public Iterator getChildren() {
            return this._children.iterator();
        }
    }

    private static final class LabelPanel
    extends JPanel {
        LabelPanel(String string) {
            super(new BorderLayout());
            FocusableLabel focusableLabel = new FocusableLabel(string);
            JScrollPane jScrollPane = new JScrollPane((Component)((Object)focusableLabel));
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            jScrollPane.getViewport().setBackground(UIManager.getColor("Tree.background"));
            this.add((Component)jScrollPane, "Center");
        }

        private static final class FocusableLabel
        extends JMultiLineLabel
        implements MouseListener {
            FocusableLabel(String string) {
                super(string);
                this.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
                this.addMouseListener(this);
            }

            public boolean isFocusTraversable() {
                return true;
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (this.isFocusTraversable()) {
                    this.requestFocus();
                    mouseEvent.consume();
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }
        }
    }

    private static final class SubtypeQueryManager {
        private static final SubtypeQueryManager INSTANCE = new SubtypeQueryManager();
        private final List _queryList;

        void $init$() {
            this._queryList = new LinkedList();
        }

        private SubtypeQueryManager() {
            this.$init$();
        }

        public static SubtypeQueryManager getInstance() {
            return INSTANCE;
        }

        public QueryTask querySubtypes(Project project, String string, ActionListener actionListener) {
            QueryTaskImpl queryTaskImpl = new QueryTaskImpl(project, string.replace('$', '.'), actionListener);
            this._queryList.add(queryTaskImpl);
            return queryTaskImpl;
        }

        public void cancelAll() {
            QueryTask[] queryTaskArray = this._queryList.toArray(new QueryTask[this._queryList.size()]);
            this._queryList.clear();
            int n = 0;
            while (n < queryTaskArray.length) {
                queryTaskArray[n].cancel();
                ++n;
            }
        }

        private void remove(QueryTask queryTask) {
            this._queryList.remove(queryTask);
        }

        static void mav$remove(SubtypeQueryManager subtypeQueryManager, QueryTask queryTask) {
            subtypeQueryManager.remove(queryTask);
        }

        public interface QueryTask {
            public int getProgress();

            public boolean isFinished();

            public void cancel();

            public Object[] getSubtypes();
        }

        private static final class QueryTaskImpl
        implements ClassUsageListener,
        ActionListener,
        QueryTask {
            private static final boolean SEARCH_FULL_PROJECT_PATH = true;
            private static final int DEFAULT_PROGRESS_INITIAL_DELAY = 3000;
            private static final int DEFAULT_PROGRESS_DELAY = 750;
            private final Timer _progressTimer;
            private final JavaManager _javaManager;
            private final ActionListener _actionListener;
            private final UsageQueryTask _usageQueryTask;
            private Collection _subtypes;

            void $init$() {
                this._subtypes = new ArrayList();
            }

            public QueryTaskImpl(Project project, String string, ActionListener actionListener) {
                this.$init$();
                this._javaManager = JavaManager.getJavaManager(project);
                this._actionListener = actionListener;
                UsageManager usageManager = new UsageManager(project);
                this._usageQueryTask = usageManager.findClassUsages(string, this);
                this._progressTimer = new Timer(750, this);
                this._progressTimer.setInitialDelay(3000);
                this._progressTimer.start();
            }

            public int getProgress() {
                return this._usageQueryTask.getProgress();
            }

            public boolean isFinished() {
                return this._progressTimer.isRunning() ^ true;
            }

            public void cancel() {
                this._subtypes = null;
                this._usageQueryTask.cancel();
                this.finished();
            }

            public Object[] getSubtypes() {
                if (!this.isFinished()) {
                    throw new IllegalStateException("Query not finished");
                }
                if (this._subtypes == null) {
                    return null;
                }
                return this._subtypes.toArray();
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.fireActionListener();
            }

            public void notifyClassUsage(ClassUsageEvent classUsageEvent) {
                SourceFile sourceFile;
                int n = classUsageEvent.getUsageCode();
                if ((n == 103 || n == 104) && (sourceFile = this._javaManager.getSourceFile(classUsageEvent.getURL())) != null) {
                    int n2 = classUsageEvent.getStartOffset();
                    SourceElement sourceElement = sourceFile.getElementAt(n2);
                    while (sourceElement != null) {
                        if (sourceElement instanceof JavaType) {
                            this._subtypes.add(sourceElement);
                            return;
                        }
                        sourceElement = sourceElement.getParent();
                    }
                }
            }

            public void notifySkipped(UsageEvent usageEvent) {
            }

            public void notifyFinished(UsageEvent usageEvent) {
                this.finished();
            }

            private void finished() {
                if (this._progressTimer.isRunning()) {
                    this._progressTimer.stop();
                    SubtypeQueryManager.mav$remove(SubtypeQueryManager.getInstance(), this);
                    this.fireActionListener();
                }
            }

            private void fireActionListener() {
                ActionEvent actionEvent = new ActionEvent(this, 0, null, System.currentTimeMillis(), 0);
                this._actionListener.actionPerformed(actionEvent);
            }
        }
    }
}

