/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.browse;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeNavigationPoint;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.model.Workspace;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.jdeveloper.java.JavaManager;

final class BrowseNavigationPoint2
extends CodeNavigationPoint {
    private JavaHasType result;
    private JavaManager provider;
    private boolean flag_nooffset;

    BrowseNavigationPoint2(Context context, int n, JavaHasType javaHasType, JavaManager javaManager) {
        super(context, n, 0);
        this.result = javaHasType;
        this.provider = javaManager;
        if (n == -1) {
            this.flag_nooffset = true;
        }
    }

    private BrowseNavigationPoint2() {
    }

    public Object copyTo(Object object) {
        BrowseNavigationPoint2 browseNavigationPoint2 = object != null ? (BrowseNavigationPoint2)((Object)object) : new BrowseNavigationPoint2();
        this.copyToImpl(browseNavigationPoint2);
        return browseNavigationPoint2;
    }

    protected final void copyToImpl(BrowseNavigationPoint2 browseNavigationPoint2) {
        super.copyToImpl((CodeNavigationPoint)browseNavigationPoint2);
        browseNavigationPoint2.result = this.result;
        browseNavigationPoint2.provider = this.provider;
        browseNavigationPoint2.flag_nooffset = this.flag_nooffset;
    }

    protected int navigateImpl() throws Exception {
        try {
            Editor editor = EditorManager.getEditorManager().openDefaultEditorInFrame(this.getContext());
            if (editor == null) {
                int n = 1;
                this.result = null;
                this.provider = null;
                this.done = true;
                return n;
            }
            if (editor instanceof CodeEditor) {
                CodeEditor codeEditor = (CodeEditor)editor;
                codeEditor.setSelectionEnd(0);
                Context context = codeEditor.getContext();
                Node node = context.getNode();
                Project project = context.getProject();
                Workspace workspace = context.getWorkspace();
                this.nodeURL = node != null ? node.getURL() : null;
                this.prjURL = project != null ? project.getURL() : null;
                this.wspURL = workspace != null ? workspace.getURL() : null;
                this.viewClass = codeEditor.getClass();
                this.viewID = codeEditor.getId();
                if (this.flag_nooffset) {
                    TextNode textNode = (TextNode)node;
                    TextBuffer textBuffer = textNode.acquireTextBuffer();
                    try {
                        URL uRL = textNode.getURL();
                        this.start = BrowseNavigationPoint2.helper(textBuffer, uRL, this.result, this.provider);
                    }
                    finally {
                        textNode.releaseTextBuffer();
                    }
                }
                if (this.start != -1) {
                    int n = codeEditor.getLineFromOffset(this.start);
                    codeEditor.gotoLine(n, 0, true);
                }
            }
            int n = 0;
            this.result = null;
            this.provider = null;
            this.done = true;
            return n;
        }
        catch (Throwable throwable) {
            this.result = null;
            this.provider = null;
            this.done = true;
            throw throwable;
        }
    }

    private static int helper(TextBuffer textBuffer, URL uRL, JavaHasType javaHasType, JavaManager javaManager) {
        SourceHasName sourceHasName;
        SourceName sourceName;
        SourceFile sourceFile = javaManager.getSourceFile(uRL);
        SourceElement sourceElement = CommonUtilities.getSourceElement((JavaElement)javaHasType, (SourceFile)sourceFile);
        if (sourceElement == null) {
            return -1;
        }
        if (sourceElement instanceof SourceHasName && (sourceName = (sourceHasName = (SourceHasName)sourceElement).getNameElement()) != null) {
            return sourceName.getStartOffset();
        }
        return sourceElement.getStartOffset();
    }
}

