/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.browse;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.util.ArraySortedSet;
import oracle.javatools.editor.insight.InsightData;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.ListDataItemCellRenderer;
import oracle.javatools.editor.insight.ListDataItemListModel;
import oracle.javatools.editor.insight.ListInsightData;
import oracle.javatools.editor.insight.ListInsightView;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.util.AsyncScheduler;
import oracle.javatools.parser.util.AsyncTask;
import oracle.jdeveloper.icons.JavaIcons;
import oracle.jdeveloper.java.JavaClassLocator;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.JavaArb;

final class BrowsePopupList
implements ListSelectionListener,
KeyListener,
FocusListener,
MouseListener,
CaretListener {
    private Project project;
    private JTextField browseField;
    private ActionListener clientListener;
    private JWindow popupWindow;
    private ListInsightView popupList;
    private BrowseTask browseTask;
    private PopulateTask populateTask;
    private Map brPackageMap;
    private Set brPackageSet;
    private JavaManager brJavaManager;
    private FoundItem lastDefaultItem;
    private boolean pendingLookup;
    private boolean inNavigation;
    private int lastLength;
    private boolean gotLonger;
    private AsyncScheduler brScheduler;
    private static final boolean CHECK_FOR_INTERFACE = false;
    private static final int MIN_PREFIX_LEN = 2;
    private static final int PACKAGE_ITEM = 1;
    private static final int UNQ_CLASS_ITEM = 2;
    private static final int UNQ_INTERFACE_ITEM = 4;
    private static final int FQ_CLASS_ITEM = 3;
    private static final int FQ_INTERFACE_ITEM = 5;

    BrowsePopupList(Project project, JTextField jTextField, ActionListener actionListener) {
        this.$init$();
        this.browseField = jTextField;
        Caret caret = jTextField.getCaret();
        DefaultCaret defaultCaret = new DefaultCaret();
        defaultCaret.setBlinkRate(caret.getBlinkRate());
        jTextField.setCaret(defaultCaret);
        this.project = project;
        this.brJavaManager = JavaManager.getJavaManager(project);
        this.clientListener = actionListener;
        this.schedulePopulate();
        this.browseField.addCaretListener(this);
        this.browseField.addKeyListener(this);
        this.browseField.addFocusListener(this);
    }

    void $init$() {
        this.pendingLookup = false;
        this.inNavigation = false;
        this.lastLength = 0;
        this.gotLonger = false;
        this.brScheduler = new AsyncScheduler("BrowseDialogBrowser", 10000);
    }

    public void dispose() {
        this.cancelLookup();
        this.cancelPopulate();
        if (this.popupList != null) {
            this.popupList.removeListSelectionListener((ListSelectionListener)this);
            this.popupList.removeMouseListener((MouseListener)this);
            this.popupList = null;
        }
        if (this.popupWindow != null) {
            this.popupWindow.setVisible(false);
            this.popupWindow.dispose();
            this.popupWindow = null;
        }
        if (this.browseField != null) {
            this.browseField.removeCaretListener(this);
            this.browseField.removeKeyListener(this);
            this.browseField.removeFocusListener(this);
            this.browseField = null;
        }
    }

    public String getSelectedClass() {
        return this.lastDefaultItem != null ? FoundItem.ra$name(this.lastDefaultItem) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleLookup(String string) {
        if (!this.populateTask.isFinished()) {
            return;
        }
        BrowseTask browseTask = new BrowseTask(string, null);
        BrowsePopupList browsePopupList = this;
        synchronized (browsePopupList) {
            if (this.browseTask != null) {
                this.brScheduler.cancelTask((AsyncTask)this.browseTask);
            }
            this.browseTask = browseTask;
        }
        this.brScheduler.scheduleTask((AsyncTask)browseTask);
        this.pendingLookup = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelLookup() {
        BrowseTask browseTask;
        BrowsePopupList browsePopupList = this;
        synchronized (browsePopupList) {
            browseTask = this.browseTask;
            this.browseTask = null;
        }
        if (browseTask != null) {
            this.brScheduler.cancelTask((AsyncTask)browseTask);
        }
        this.pendingLookup = false;
    }

    private void schedulePopulate() {
        this.populateTask = new PopulateTask(null);
        this.brScheduler.scheduleTask((AsyncTask)this.populateTask);
    }

    private void cancelPopulate() {
        this.brScheduler.cancelTask((AsyncTask)this.populateTask);
    }

    private void updatePopup() {
        if (this.browseField == null || !this.browseField.isVisible()) {
            return;
        }
        int n = this.browseField.getCaretPosition();
        if (n >= 2) {
            String string = this.browseField.getText().substring(0, n);
            this.scheduleLookup(string);
        } else {
            this.hidePopup();
        }
    }

    private void hidePopup() {
        if (this.popupWindow != null) {
            this.popupWindow.setVisible(false);
        }
    }

    private void displayResults(FoundData foundData) {
        if (this.browseField == null || !this.browseField.isVisible()) {
            return;
        }
        if (this.popupWindow == null) {
            this.popupList = new ListInsightView((ListCellRenderer)((Object)new FoundRenderer(null)));
            this.popupList.addListSelectionListener((ListSelectionListener)this);
            this.popupList.addMouseListener((MouseListener)this);
            this.popupList.setData((InsightData)foundData);
            JScrollPane jScrollPane = new JScrollPane((Component)this.popupList);
            jScrollPane.setHorizontalScrollBarPolicy(31);
            Window window = SwingUtilities.getWindowAncestor(this.browseField);
            this.popupWindow = new JWindow(window);
            this.popupWindow.getContentPane().add(jScrollPane);
            this.popupWindow.setFocusableWindowState(false);
        } else {
            this.popupList.setData((InsightData)foundData);
        }
        if (!this.popupWindow.isVisible()) {
            Point point = this.browseField.getLocationOnScreen();
            point.y += this.browseField.getHeight() + 2;
            this.popupWindow.setLocation(point);
        }
        if (foundData.getData().length == 0) {
            this.lastDefaultItem = null;
            this.popupWindow.setVisible(false);
        } else {
            this.inNavigation = true;
            this.popupList.selectDefault();
            this.inNavigation = false;
            this.lastDefaultItem = (FoundItem)((Object)foundData.getDefault());
            if (this.gotLonger) {
                String string = this.browseField.getText();
                String string2 = this.lastDefaultItem.getName();
                this.inNavigation = true;
                int n = Math.min(string.length(), string2.length());
                int n2 = string2.length();
                this.browseField.setText(string2);
                this.browseField.setCaretPosition(n2);
                this.browseField.moveCaretPosition(n);
                this.inNavigation = false;
            }
            this.popupWindow.pack();
            this.popupWindow.setVisible(true);
        }
        this.pendingLookup = false;
    }

    private void waitForCompletedTask(AsyncTask asyncTask) {
        asyncTask.waitUntilFinished(50);
    }

    private void populateFinished(Map map, Set set) {
        this.brPackageMap = map;
        this.brPackageSet = set;
        1 var3_3 = new 1();
        SwingUtilities.invokeLater(var3_3);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            FoundItem foundItem;
            if (this.popupList != null && (foundItem = (FoundItem)((Object)this.popupList.getSelectedValue())) != null && FoundItem.ra$type(foundItem) == 1) {
                String string = this.lastDefaultItem.getName() + ".";
                this.browseField.setText(string);
                return;
            }
            if (this.clientListener != null) {
                ActionEvent actionEvent = new ActionEvent(this, 1001, null);
                this.clientListener.actionPerformed(actionEvent);
            }
            mouseEvent.consume();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!this.inNavigation && this.popupList != null) {
            this.lastDefaultItem = (FoundItem)((Object)this.popupList.getSelectedValue());
            if (this.lastDefaultItem != null) {
                this.inNavigation = true;
                String string = this.lastDefaultItem.getName();
                if (!this.browseField.getText().equals(string)) {
                    this.browseField.setText(string);
                }
                this.inNavigation = false;
            }
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.popupWindow != null && !this.popupWindow.isVisible()) {
            this.updatePopup();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            this.hidePopup();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (!(this.pendingLookup || this.popupWindow != null && this.popupWindow.isVisible())) {
            return;
        }
        switch (n) {
            case 10: {
                if (this.pendingLookup) {
                    keyEvent.consume();
                }
                return;
            }
            default: {
                return;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
        }
        if (this.pendingLookup) {
            keyEvent.consume();
            return;
        }
        try {
            this.inNavigation = true;
            switch (n) {
                default: {
                    throw new IllegalStateException("unexpected key: " + n);
                }
                case 40: {
                    this.popupList.down();
                    break;
                }
                case 38: {
                    this.popupList.up();
                    break;
                }
                case 34: {
                    this.popupList.pageDown();
                    break;
                }
                case 33: {
                    this.popupList.pageUp();
                    break;
                }
                case 36: {
                    this.popupList.begin();
                    break;
                }
                case 35: {
                    this.popupList.end();
                    break;
                }
            }
        }
        finally {
            this.inNavigation = false;
        }
        this.lastDefaultItem = (FoundItem)((Object)this.popupList.getSelectedValue());
        this.inNavigation = true;
        String string = this.lastDefaultItem.getName();
        this.browseField.setText(string);
        this.inNavigation = false;
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void caretUpdate(CaretEvent caretEvent) {
        if (!this.inNavigation) {
            this.caretChanged();
        }
    }

    private void caretChanged() {
        if (this.browseField != null) {
            int n = this.browseField.getText().length();
            this.gotLonger = n > this.lastLength;
            this.lastLength = n;
            this.updatePopup();
        }
    }

    static void mav$updatePopup(BrowsePopupList browsePopupList) {
        browsePopupList.updatePopup();
    }

    static Map ra$brPackageMap(BrowsePopupList browsePopupList) {
        return browsePopupList.brPackageMap;
    }

    static JavaManager ra$brJavaManager(BrowsePopupList browsePopupList) {
        return browsePopupList.brJavaManager;
    }

    static Set ra$brPackageSet(BrowsePopupList browsePopupList) {
        return browsePopupList.brPackageSet;
    }

    static void mav$displayResults(BrowsePopupList browsePopupList, FoundData foundData) {
        browsePopupList.displayResults(foundData);
    }

    static void mav$populateFinished(BrowsePopupList browsePopupList, Map map, Set set) {
        browsePopupList.populateFinished(map, set);
    }

    final class 1
    implements Runnable {
        public void run() {
            try {
                Thread.sleep(25);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            BrowsePopupList.mav$updatePopup(BrowsePopupList.this);
        }
    }

    private final class BrowseTask
    extends AsyncTask {
        private String brText;
        private boolean brCancelled;

        private BrowseTask(String string) {
            this.$init$();
            this.brText = string;
        }

        void $init$() {
            this.brCancelled = false;
        }

        protected void requestCancelImpl() {
            this.brCancelled = true;
        }

        protected boolean isCancelledImpl() {
            return this.brCancelled;
        }

        public Object runImpl() throws AsyncTask.CancelledException {
            boolean bl;
            if (this.brText == null || this.brText.length() == 0) {
                return null;
            }
            BrowseTask.sleep((int)10);
            this.bailIfCancelled();
            Map map = BrowsePopupList.ra$brPackageMap(BrowsePopupList.this);
            if (map == null) {
                return null;
            }
            long l = System.currentTimeMillis();
            ArrayList arrayList = new ArrayList();
            boolean bl2 = bl = this.brText.indexOf(46) != -1;
            if (bl) {
                this.taskMatchAnyPackages(this.brText, arrayList);
                this.taskMatchFQClasses(this.brText, arrayList);
            } else {
                this.taskMatchTopPackages(this.brText, arrayList);
                this.taskMatchUQClasses(this.brText, arrayList);
            }
            long l2 = System.currentTimeMillis() - l;
            int n = arrayList.size();
            int n2 = arrayList.size();
            FoundItem[] foundItemArray = arrayList.toArray(new FoundItem[n2]);
            FoundData foundData = new FoundData(foundItemArray, this.brText, null);
            1 var12_10 = new 1(this, foundData);
            SwingUtilities.invokeLater(var12_10);
            return foundData;
        }

        private void taskMatchTopPackages(String string, List list) throws AsyncTask.CancelledException {
            int n = string.length();
            Set set = BrowsePopupList.ra$brPackageSet(BrowsePopupList.this);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.bailIfCancelled();
                String string2 = iterator.next().toString();
                if (string2.indexOf(46) != -1 || !string2.regionMatches(true, 0, string, 0, n)) continue;
                list.add(new FoundItem(string2, 1, null));
            }
        }

        private void taskMatchAnyPackages(String string, List list) throws AsyncTask.CancelledException {
            int n = string.length();
            Set set = BrowsePopupList.ra$brPackageSet(BrowsePopupList.this);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.bailIfCancelled();
                String string2 = iterator.next().toString();
                if (!string2.regionMatches(true, 0, string, 0, n)) continue;
                list.add(new FoundItem(string2, 1, null));
            }
        }

        private void taskMatchUQClasses(String string, List list) throws AsyncTask.CancelledException {
            int n = string.length();
            Map map = BrowsePopupList.ra$brPackageMap(BrowsePopupList.this);
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.bailIfCancelled();
                String string2 = iterator.next().toString();
                String[] stringArray = (String[])map.get(string2);
                int n2 = stringArray != null ? stringArray.length : 0;
                int n3 = 0;
                while (n3 < n2) {
                    this.bailIfCancelled();
                    String string3 = stringArray[n3];
                    if (string3.regionMatches(true, 0, string, 0, n)) {
                        String string4 = string2 + "." + string3;
                        int n4 = this.isInterface(string4) ? 4 : 2;
                        list.add(new FoundItem(string4, n4, null));
                    }
                    ++n3;
                }
            }
        }

        private boolean checkForInterface() {
            return false;
        }

        private boolean isInterface(String string) {
            if (!this.checkForInterface()) {
                return false;
            }
            JavaManager javaManager = BrowsePopupList.ra$brJavaManager(BrowsePopupList.this);
            JavaClass javaClass = javaManager.getClass(string);
            if (javaClass != null) {
                return javaClass.isInterface();
            }
            return false;
        }

        private void taskMatchFQClasses(String string, List list) throws AsyncTask.CancelledException {
            Map map = BrowsePopupList.ra$brPackageMap(BrowsePopupList.this);
            int n = string.lastIndexOf(46);
            if (n != -1) {
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                int n2 = string3.length();
                String[] stringArray = (String[])map.get(string2);
                int n3 = stringArray != null ? stringArray.length : 0;
                int n4 = 0;
                while (n4 < n3) {
                    this.bailIfCancelled();
                    String string4 = stringArray[n4];
                    if (string4.regionMatches(true, 0, string3, 0, n2)) {
                        String string5 = string2 + "." + string4;
                        int n5 = this.isInterface(string5) ? 5 : 3;
                        list.add(new FoundItem(string5, n5, null));
                    }
                    ++n4;
                }
            }
        }

        BrowseTask(String string, 1 var3_3) {
            this(string);
        }

        static boolean ra$brCancelled(BrowseTask browseTask) {
            return browseTask.brCancelled;
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ FoundData v$data;
            final /* synthetic */ BrowseTask this$0;

            public void run() {
                if (!BrowseTask.ra$brCancelled(this.this$0)) {
                    BrowsePopupList.mav$displayResults(this.this$0.BrowsePopupList.this, this.v$data);
                }
            }

            public 1(BrowseTask browseTask, FoundData foundData) {
                this.v$data = foundData;
                this.this$0 = browseTask;
            }
        }
    }

    private final class PopulateTask
    extends AsyncTask {
        private boolean popCancelled;

        void $init$() {
            this.popCancelled = false;
        }

        protected void requestCancelImpl() {
            this.popCancelled = true;
        }

        protected boolean isCancelledImpl() {
            return this.popCancelled;
        }

        public Object runImpl() throws AsyncTask.CancelledException {
            JavaManager javaManager = BrowsePopupList.ra$brJavaManager(BrowsePopupList.this);
            String string = JavaArb.getString(12);
            Ide.getStatusBar().setText(string);
            try {
                long l = System.currentTimeMillis();
                JavaClassLocator javaClassLocator = javaManager.getJavaClassLocator();
                Collection collection = javaClassLocator.getAllClasses();
                HashMap<String, Set> hashMap = new HashMap<String, Set>(500);
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    String string2;
                    this.bailIfCancelled();
                    String string3 = iterator.next().toString();
                    int n = string3.lastIndexOf(46);
                    String string4 = n == -1 ? "" : string3.substring(0, n);
                    String string5 = string2 = n == -1 ? string3 : string3.substring(n + 1);
                    if (string2.length() <= 0) continue;
                    Set set = (Set)hashMap.get(string4);
                    if (set == null) {
                        set = new ArraySortedSet(100);
                        hashMap.put(string4, set);
                    }
                    set.add(string2);
                }
                HashMap<String, String[]> hashMap2 = new HashMap<String, String[]>(hashMap.size());
                Iterator iterator2 = hashMap.keySet().iterator();
                while (iterator2.hasNext()) {
                    int n;
                    String string6 = iterator2.next().toString();
                    Set set = (Set)hashMap.get(string6);
                    int n2 = n = set == null ? 0 : set.size();
                    if (n <= 0) continue;
                    String[] stringArray = set.toArray(new String[n]);
                    hashMap2.put(string6, stringArray);
                }
                long l2 = System.currentTimeMillis() - l;
                BrowsePopupList.mav$populateFinished(BrowsePopupList.this, hashMap2, hashMap2.keySet());
                HashMap<String, String[]> hashMap3 = hashMap2;
                String string7 = Ide.getStatusBar().getText();
                if (string7.equals(string)) {
                    Ide.getStatusBar().setText("");
                }
                return hashMap3;
            }
            catch (Throwable throwable) {
                String string8 = Ide.getStatusBar().getText();
                if (string8.equals(string)) {
                    Ide.getStatusBar().setText("");
                }
                throw throwable;
            }
        }

        private PopulateTask() {
            this.$init$();
        }

        PopulateTask(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class FoundItem
    extends ListDataItem {
        private int type;
        private String name;
        private String display;

        private FoundItem(String string, int n) {
            this.type = n;
            this.name = string;
        }

        public Icon getIcon() {
            switch (this.type) {
                case 1: {
                    return JavaIcons.getIcon(5);
                }
                case 2: 
                case 3: {
                    return JavaIcons.getIcon(0);
                }
                case 4: 
                case 5: {
                    return JavaIcons.getIcon(1);
                }
            }
            return null;
        }

        public String getDisplayText() {
            switch (this.type) {
                default: {
                    return this.name;
                }
                case 2: 
                case 4: 
            }
            if (this.display == null) {
                String string;
                String string2;
                int n = this.name.lastIndexOf(46);
                if (n == -1) {
                    string2 = "";
                    string = this.name;
                } else {
                    string2 = this.name.substring(0, n);
                    string = this.name.substring(n + 1);
                }
                this.display = string + " (" + string2 + ")";
            }
            return this.display;
        }

        public String getName() {
            switch (this.type) {
                default: {
                    return this.name;
                }
                case 2: 
                case 4: 
            }
            int n = this.name.lastIndexOf(46);
            return n != -1 ? this.name.substring(n + 1) : this.name;
        }

        public int compareTo(Object object) {
            String string;
            FoundItem foundItem = (FoundItem)((Object)object);
            String string2 = this.getName();
            if (string2.equalsIgnoreCase(string = foundItem.getName())) {
                int n = this.type;
                int n2 = foundItem.type;
                if ((n == 1 || n2 == 1) && n != n2) {
                    return n - n2;
                }
            }
            String string3 = this.getDisplayText();
            String string4 = foundItem.getDisplayText();
            return FoundItem.compareInsensitive((String)string3, (String)string4);
        }

        static int ra$type(FoundItem foundItem) {
            return foundItem.type;
        }

        static String ra$name(FoundItem foundItem) {
            return foundItem.name;
        }

        FoundItem(String string, int n, 1 var3_3) {
            this(string, n);
        }

        public final class 1 {
        }
    }

    private static final class FoundData
    implements ListInsightData {
        private FoundItem[] items;
        private ListDataItemListModel model;
        private String prefix;

        private FoundData(FoundItem[] foundItemArray, String string) {
            this.items = foundItemArray;
            this.prefix = string;
        }

        public ListModel getListModel() {
            if (this.model == null) {
                this.model = new ListDataItemListModel((ListDataItem[])this.items);
            }
            return this.model;
        }

        public Object[] getData() {
            return this.items;
        }

        public Object[] getMatchingData() {
            return this.items;
        }

        public int getMatchingDataCount() {
            return this.items.length;
        }

        public Object getDefault() {
            this.getListModel();
            return this.model.findClosestDataItem(this.prefix);
        }

        public boolean complete(Object object) {
            return false;
        }

        public void partialComplete() {
        }

        FoundData(FoundItem[] foundItemArray, String string, 1 var3_3) {
            this(foundItemArray, string);
        }

        public final class 1 {
        }
    }

    private static final class FoundRenderer
    extends ListDataItemCellRenderer {
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            Dimension dimension2 = new Dimension(Math.max(dimension.width, 200), dimension.height);
            return dimension2;
        }

        private FoundRenderer() {
        }

        FoundRenderer(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

