/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.browse;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.layout.IdeProperties;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.jdeveloper.dialogs.BrowseHandler;
import oracle.jdeveloper.dialogs.ClassPackageBrowserFilterV2;
import oracle.jdeveloper.dialogs.ClassPackageBrowserV2;
import oracle.jdeveloper.java.CacheSupport;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.JavaArb;

final class BrowseSymbolDialog
extends JEWTDialog
implements DocumentListener {
    private static final String SOURCE_OR_DOC_PROPERTY = "GoToJavaClassOpenSource";

    static void showDialog(Context context) {
        Project project = context.getProject() != null ? context.getProject() : Ide.getDefaultProject();
        BSPanel bSPanel = new BSPanel(project, null);
        HelpSystem.getHelpSystem().registerTopic((JComponent)bSPanel, "f1_idedbrowsesymbol_html");
        JTextField jTextField = BSPanel.ra$field_browse(bSPanel);
        Document document = null;
        if (jTextField instanceof JTextComponent) {
            document = ((JTextComponent)jTextField).getDocument();
        }
        String string = JavaArb.getString(1);
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        IdeProperties ideProperties = Ide.getIdeProperties();
        String string2 = ideProperties.getProperty(SOURCE_OR_DOC_PROPERTY, "true");
        boolean bl = Boolean.valueOf(string2);
        BSPanel.mav$setSourceSelected(bSPanel, bl);
        try {
            boolean bl2 = false;
            while (!bl2) {
                BrowseSymbolDialog browseSymbolDialog = new BrowseSymbolDialog((Frame)ideMainWindow, bSPanel, jTextField, string);
                2 var12_12 = new 2(browseSymbolDialog);
                JavaManager javaManager = JavaManager.getJavaManager(project);
                BrowseHandler browseHandler = BrowseHandler.createClassPackageBrowserPopup(javaManager, BSPanel.ra$field_browse(bSPanel), var12_12);
                document.addDocumentListener(browseSymbolDialog);
                browseSymbolDialog.updateButtonStatus(document);
                BSPanel.mav$selectBrowseText(bSPanel);
                boolean bl3 = WizardLauncher.runDialog((JDialog)((Object)browseSymbolDialog));
                String string3 = browseHandler.getSelectedItem();
                browseHandler.dispose();
                document.removeDocumentListener(browseSymbolDialog);
                if (!bl3) {
                    bl2 = true;
                    continue;
                }
                String string4 = string3 != null ? string3 : BSPanel.mav$getBrowseText(bSPanel);
                boolean bl4 = BSPanel.mav$isSourceSelected(bSPanel);
                String string5 = Boolean.toString(bl4);
                ideProperties.setProperty(SOURCE_OR_DOC_PROPERTY, string5);
                if (bl4) {
                    if (string4.length() <= 0) continue;
                    bl2 = BrowseSymbolDialog.performBrowse(project, string4);
                    continue;
                }
                HelpInfo helpInfo = new HelpInfo(string4, 1);
                helpInfo.setContext(context);
                HelpSystem.getHelpSystem().showHelp(helpInfo);
                bl2 = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean performBrowse(Project project, String string) {
        boolean bl = false;
        URL uRL = BrowseSymbolDialog.findSymbol(project, string);
        if (uRL != null) {
            try {
                Node node = NodeFactory.findOrCreate((URL)uRL);
                Context context = Context.newIdeContext((Node)node);
                context.setProject(project);
                SwingUtilities.invokeLater(new 1(context));
                bl = true;
            }
            catch (Exception exception) {
                BrowseSymbolDialog.showUnableToOpenError(string);
            }
        } else {
            BrowseSymbolDialog.showNotFoundError(string);
        }
        return bl;
    }

    private static void showUnableToOpenError(String string) {
        String string2 = JavaArb.format(3, string);
        BrowseSymbolDialog.showErrorDialog(string2);
    }

    private static void showNotFoundError(String string) {
        String string2 = JavaArb.format(4, string);
        BrowseSymbolDialog.showErrorDialog(string2);
    }

    static void showErrorDialog(String string) {
        String string2 = JavaArb.getString(2);
        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), string, string2, 0);
    }

    private static URL findSymbol(Project project, String string) {
        boolean bl;
        URL uRL = null;
        boolean bl2 = bl = string.indexOf(46) != -1;
        if (bl && project != null) {
            JavaManager javaManager = JavaManager.getJavaManager(project);
            CacheSupport cacheSupport = javaManager.getCacheSupport();
            cacheSupport.beginCacheUse();
            try {
                SourceClass sourceClass = javaManager.getSourceClass(string);
                if (sourceClass != null) {
                    URL uRL2;
                    URL uRL3 = uRL2 = sourceClass.getURL();
                    cacheSupport.endCacheUse();
                    return uRL3;
                }
                JavaClass javaClass = javaManager.getClass(string);
                if (javaClass != null) {
                    URL uRL4;
                    URL uRL5 = uRL4 = javaClass.getURL();
                    cacheSupport.endCacheUse();
                    return uRL5;
                }
            }
            finally {
                cacheSupport.endCacheUse();
            }
        }
        return uRL;
    }

    private BrowseSymbolDialog(Frame frame, Component component, Component component2, String string) {
        super(frame, string, 7);
        this.setContent(component);
        if (component2 != null) {
            this.setInitialFocus(component2);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateButtonStatus(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateButtonStatus(documentEvent);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateButtonStatus(documentEvent);
    }

    private void updateButtonStatus(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        this.updateButtonStatus(document);
    }

    private void updateButtonStatus(Document document) {
        boolean bl = document.getLength() != 0;
        this.setOKButtonEnabled(bl);
    }

    static void mav$dismissDialog(BrowseSymbolDialog browseSymbolDialog, boolean bl) {
        browseSymbolDialog.dismissDialog(bl);
    }

    static final class 2
    implements ActionListener {
        private final /* synthetic */ BrowseSymbolDialog v$dialog;

        public void actionPerformed(ActionEvent actionEvent) {
            BrowseSymbolDialog.mav$dismissDialog(this.v$dialog, false);
        }

        public 2(BrowseSymbolDialog browseSymbolDialog) {
            this.v$dialog = browseSymbolDialog;
        }
    }

    static final class 1
    implements Runnable {
        private final /* synthetic */ Context v$newContext;

        public void run() {
            EditorManager editorManager = EditorManager.getEditorManager();
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(this.v$newContext);
            openEditorOptions.setFlags(8, true);
            editorManager.openEditor(openEditorOptions);
        }

        public 1(Context context) {
            this.v$newContext = context;
        }
    }

    private static final class BSPanel
    extends JPanel
    implements ClassPackageBrowserFilterV2,
    ActionListener {
        private Project project;
        private JTextField field_browse;
        private JButton button_browse;
        private JRadioButton radio_source;
        private JRadioButton radio_doc;

        private BSPanel(Project project) {
            super(new GridBagLayout());
            this.project = project;
            this.initializeUI();
        }

        private void initializeUI() {
            String string = JavaArb.getString(5);
            JLabel jLabel = new JLabel();
            1 var3_3 = new 1();
            this.field_browse = new JTextField(var3_3, "", 0);
            ResourceUtils.resLabel((JLabel)jLabel, (Component)this.field_browse, (String)string);
            String string2 = JavaArb.getString(8);
            this.button_browse = new JButton();
            ResourceUtils.resButton((AbstractButton)this.button_browse, (String)string2);
            this.button_browse.addActionListener(this);
            String string3 = JavaArb.getString(6);
            JLabel jLabel2 = new JLabel(string3);
            String string4 = JavaArb.getString(7);
            JLabel jLabel3 = new JLabel(string4);
            String string5 = JavaArb.getString(9);
            JLabel jLabel4 = new JLabel(string5);
            String string6 = JavaArb.getString(11);
            String string7 = JavaArb.getString(10);
            this.radio_doc = new JRadioButton();
            this.radio_source = new JRadioButton();
            ResourceUtils.resButton((AbstractButton)this.radio_doc, (String)string6);
            ResourceUtils.resButton((AbstractButton)this.radio_source, (String)string7);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.radio_doc);
            buttonGroup.add(this.radio_source);
            Insets insets = new Insets(0, 0, 0, 0);
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 17, 0, insets, 0, 0);
            this.add((Component)jLabel2, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 8), 0, 0);
            this.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 0, 8), 0, 0);
            this.add((Component)this.field_browse, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0);
            this.add((Component)this.button_browse, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 5, 0), 0, 0);
            this.add((Component)jLabel3, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 8), 0, 0);
            this.add((Component)jLabel4, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 8), 0, 0);
            this.add((Component)this.radio_source, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 8), 0, 0);
            this.add((Component)this.radio_doc, gridBagConstraints);
        }

        private boolean isSourceSelected() {
            return this.radio_source.isSelected();
        }

        private void setSourceSelected(boolean bl) {
            JRadioButton jRadioButton = bl ? this.radio_source : this.radio_doc;
            jRadioButton.setSelected(true);
        }

        private String getBrowseText() {
            return this.field_browse.getText();
        }

        private void setBrowseText(String string) {
            this.field_browse.setText(string);
            this.selectBrowseText();
        }

        private void selectBrowseText() {
            this.field_browse.selectAll();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.getBrowseText();
            String[] stringArray = ClassPackageBrowserV2.browseClassOrPackage((Component)this.button_browse, this.project, 3, false, this, string);
            if (stringArray != null && stringArray.length > 0) {
                this.setBrowseText(stringArray[0]);
            }
        }

        public boolean acceptPackage(String string) {
            return true;
        }

        public boolean acceptClass(JavaClass javaClass) {
            return javaClass.isSourceElement() || javaClass.getSourceElement() != null || javaClass.getSourceElement() == null && javaClass.getName().indexOf(36) == -1;
        }

        BSPanel(Project project, 1 var2_2) {
            this(project);
        }

        static JTextField ra$field_browse(BSPanel bSPanel) {
            return bSPanel.field_browse;
        }

        static void mav$setSourceSelected(BSPanel bSPanel, boolean bl) {
            bSPanel.setSourceSelected(bl);
        }

        static void mav$selectBrowseText(BSPanel bSPanel) {
            bSPanel.selectBrowseText();
        }

        static String mav$getBrowseText(BSPanel bSPanel) {
            return bSPanel.getBrowseText();
        }

        static boolean mav$isSourceSelected(BSPanel bSPanel) {
            return bSPanel.isSourceSelected();
        }

        final class 1
        extends PlainDocument {
            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                String string2 = string.replace('/', '.').replace('\\', '.');
                super.insertString(n, string2, attributeSet);
            }
        }
    }
}

