/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.browse;

import java.awt.Point;
import oracle.ide.Context;
import oracle.ide.ceditor.AbstractBrowseClickPlugin;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.model.Node;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.language.LexerDocumentRenderer;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.jdevimpl.java.browse.BrowseAddin;
import oracle.jdevimpl.java.browse.BrowseSupport;
import oracle.jdevimpl.java.browse.JavaBrowseSupport2;

public class JavaBrowseClickPlugin
extends AbstractBrowseClickPlugin {
    protected BrowseSupport getBrowseSupport() {
        Node node;
        Context context;
        BrowseSupport browseSupport = null;
        BasicEditorPane basicEditorPane = this.getEditorPane();
        if (basicEditorPane != null && (context = CodeEditor.getContext((BasicEditorPane)basicEditorPane)) != null && (node = context.getNode()) != null) {
            browseSupport = BrowseAddin.getSupport(node.getClass());
        }
        if (browseSupport == null) {
            browseSupport = this.getDefaultBrowseSupport();
        }
        return browseSupport;
    }

    protected BrowseSupport getDefaultBrowseSupport() {
        return new JavaBrowseSupport2();
    }

    protected void performDeclarationClick(Point point) {
        CodeEditor codeEditor;
        BasicEditorPane basicEditorPane = this.getEditorPane();
        if (basicEditorPane != null && (codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)basicEditorPane)) != null) {
            BrowseSupport browseSupport = this.getBrowseSupport();
            browseSupport.performBrowseSymbolAtCursor(codeEditor);
        }
    }

    protected NumberRange getIdentifierAtOffset(int n) {
        BasicDocument basicDocument = this.getDocument();
        TextBuffer textBuffer = this.getTextBuffer();
        textBuffer.readLock();
        try {
            JavaLexer javaLexer = new JavaLexer();
            javaLexer.setSkipComments(true);
            javaLexer.setRecognizeSQLJ(true);
            LexerToken lexerToken = javaLexer.createLexerToken();
            LexerDocumentRenderer lexerDocumentRenderer = (LexerDocumentRenderer)basicDocument.getDocumentRenderer();
            LexerDocumentRenderer.LexerOffsetsCache lexerOffsetsCache = lexerDocumentRenderer.getOffsetsCache();
            int n2 = lexerOffsetsCache.findClosestOffset((Lexer)javaLexer, lexerToken, n);
            javaLexer.setTextBuffer((ReadTextBuffer)textBuffer);
            javaLexer.setPosition(n2);
            int n3 = n2;
            int n4 = textBuffer.getLength();
            while (n3 < n4) {
                int n5 = javaLexer.lex(lexerToken);
                if (n5 == 0) {
                } else {
                    int n6 = lexerToken.getStartOffset();
                    int n7 = lexerToken.getEndOffset();
                    if (n6 <= n && n < n7) {
                        if (n5 == 4) {
                            NumberRange numberRange = new NumberRange(n6, n7);
                            textBuffer.readUnlock();
                            return numberRange;
                        }
                    } else if (n >= n6) continue;
                }
                break;
            }
        }
        finally {
            textBuffer.readUnlock();
        }
        return null;
    }
}

