/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.browse;

import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.java.JavaBraceProvider;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.Context2ParserHelper;
import oracle.jdevimpl.java.browse.JavaBrowseContext;

public class JavaBrowseContextImpl
extends Context2ParserHelper
implements JavaBrowseContext {
    private final CodeEditor _editor;
    private final Context _context;
    private TextNode _node;
    private int startOffset;
    private int endOffset;
    private SourceFile _sourceFile;
    private JavaBraceProvider _braceProvider;

    public static JavaBrowseContextImpl createContext(CodeEditor codeEditor) {
        Context context = codeEditor.getContext();
        Node node = context.getNode();
        if (!(node instanceof TextNode)) {
            return null;
        }
        TextNode textNode = (TextNode)node;
        return new JavaBrowseContextImpl(codeEditor, context, textNode);
    }

    public static JavaBrowseContextImpl createContext(Context context, int n) {
        Node node = context.getNode();
        if (!(node instanceof TextNode)) {
            return null;
        }
        TextNode textNode = (TextNode)node;
        return new JavaBrowseContextImpl(context, textNode, n);
    }

    protected JavaBrowseContextImpl(CodeEditor codeEditor, Context context, TextNode textNode) {
        this._editor = codeEditor;
        this._context = context;
        this._node = textNode;
        this.startOffset = codeEditor.getSelectionStart();
        this.endOffset = codeEditor.getSelectionEnd();
    }

    protected JavaBrowseContextImpl(Context context, TextNode textNode, int n) {
        this._editor = null;
        this._context = context;
        this._node = textNode;
        this.startOffset = n;
        this.endOffset = n;
    }

    public int getSelectionStart() {
        return this.startOffset;
    }

    public int getSelectionEnd() {
        return this.endOffset;
    }

    public void setSelection(int n, int n2) {
        this.startOffset = n;
        this.endOffset = n2;
    }

    public CodeEditor getCodeEditor() {
        return this._editor;
    }

    public Context getContext() {
        return this._context;
    }

    protected void finalize() {
        this.release();
    }

    public void acquire() {
        this.acquireLock();
    }

    public void release() {
        this.releaseLock();
    }

    protected JavaBraceProvider getBraceProviderImpl() {
        if (this._editor != null) {
            BasicDocument basicDocument = (BasicDocument)this._editor.getFocusedEditorPane().getDocument();
            LanguageSupport languageSupport = basicDocument.getLanguageSupport();
            return (JavaBraceProvider)languageSupport.getBraceProvider();
        }
        TextBuffer textBuffer = this.getTextBuffer();
        return new JavaBraceProvider(textBuffer);
    }

    public final JavaBraceProvider getBraceProvider() {
        if (this._braceProvider == null) {
            this._braceProvider = this.getBraceProviderImpl();
        }
        return this._braceProvider;
    }

    protected SourceFile getSourceFileImpl() {
        SourceFile sourceFile = super.getSourceFile();
        if (sourceFile != null) {
            return sourceFile;
        }
        TextBuffer textBuffer = this.getTextBuffer();
        if (textBuffer == null) {
            return null;
        }
        JavaManager javaManager = this.getJavaManager();
        return javaManager.getSourceFile(textBuffer);
    }

    public final SourceFile getSourceFile() {
        if (this._sourceFile == null) {
            this._sourceFile = this.getSourceFileImpl();
        }
        return this._sourceFile;
    }
}

