/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.browse;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.expression.CompiledInvokeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.Context2ParserHelper;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.browse.BrowseSymbolDialog;
import oracle.jdevimpl.java.browse.JavaBrowseContext;
import oracle.jdevimpl.java.util.ExpressionFinder;
import oracle.jdevimpl.java.util.FoundSymbol;

public final class JavaBrowseHelper
extends Context2ParserHelper
implements JavaConstants {
    private final JavaBrowseContext browseContext;
    private int errorCode;
    private static final int kSearchBackwardsGuess = 500;
    private static final int ERROR_UNKNOWN = 0;
    private static final int ERROR_DECL = 1;
    private static final int ERROR_PARSE = 2;
    private static final int ERROR_RESOLVE = 3;

    public JavaBrowseHelper(JavaBrowseContext javaBrowseContext) {
        this.browseContext = javaBrowseContext;
    }

    public JavaBrowseContext getBrowseContext() {
        return this.browseContext;
    }

    public CodeEditor getCodeEditor() {
        return this.browseContext.getCodeEditor();
    }

    public Context getContext() {
        return this.browseContext.getContext();
    }

    public URL getURL() {
        return this.browseContext.getURL();
    }

    public JavaManager getProvider() {
        return this.browseContext.getJavaManager();
    }

    public void acquire() {
        this.browseContext.acquire();
    }

    public void release() {
        this.browseContext.release();
    }

    private static boolean isBrowseableToken(int n) {
        return n == 4 || n == 136 || n == 133;
    }

    protected boolean isBrowseable() {
        int n;
        int n2;
        TextBuffer textBuffer = this.browseContext.getTextBuffer();
        if (textBuffer == null) {
            return false;
        }
        int n3 = this.browseContext.getSelectionStart();
        if (n3 != (n2 = this.browseContext.getSelectionEnd())) {
            char c = textBuffer.getChar(n3);
            return Character.isJavaIdentifierStart(c) || c == '(';
        }
        int n4 = n3;
        int n5 = n3 - 500;
        if (n5 < 0) {
            n5 = 0;
        }
        JavaLexer javaLexer = new JavaLexer();
        javaLexer.setTextBuffer((ReadTextBuffer)textBuffer);
        javaLexer.setPosition(n5);
        LexerToken lexerToken = javaLexer.createLexerToken();
        do {
            n = javaLexer.lex(lexerToken);
            int n6 = lexerToken.getStartOffset();
            int n7 = lexerToken.getEndOffset();
            if (n6 <= n4 && n4 <= n7) {
                if (JavaBrowseHelper.isBrowseableToken(n)) {
                    return true;
                }
                int n8 = javaLexer.lex(lexerToken);
                if (lexerToken.getStartOffset() != n4) {
                    return false;
                }
                return JavaBrowseHelper.isBrowseableToken(n8);
            }
            if (n4 >= n6) continue;
            return false;
        } while (n != 0);
        return false;
    }

    private String analyzeTarget(FoundSymbol foundSymbol) {
        int n;
        int n2;
        TextBuffer textBuffer = this.browseContext.getTextBuffer();
        if (textBuffer == null) {
            return null;
        }
        int n3 = this.browseContext.getSelectionStart();
        int n4 = this.browseContext.getSelectionEnd();
        if (n3 < 0 || n4 < 0 || n4 < n3) {
            return null;
        }
        if (n3 != n4) {
            n2 = n3;
            n = n4;
        } else {
            ExpressionFinder expressionFinder = new ExpressionFinder((ReadTextBuffer)textBuffer, this.browseContext.getBraceProvider());
            FoundSymbol foundSymbol2 = expressionFinder.determinePrimaryStart(n4);
            if (foundSymbol2 == null) {
                foundSymbol.string = null;
                foundSymbol.startOffset = -1;
                foundSymbol.endOffset = -1;
                return null;
            }
            n2 = foundSymbol2.startOffset;
            n = foundSymbol2.endOffset;
        }
        int n5 = n - n2;
        String string = textBuffer.getString(n2, n5);
        foundSymbol.startOffset = n2;
        foundSymbol.endOffset = n;
        foundSymbol.string = string;
        return string;
    }

    private JavaHasType analyzeSearch(FoundSymbol foundSymbol, boolean bl) {
        try {
            CompiledInvokeExpression compiledInvokeExpression;
            JavaMethod javaMethod;
            int n = foundSymbol.startOffset;
            SourceFile sourceFile = this.browseContext.getSourceFile();
            SourceElement sourceElement = sourceFile.getElementAt(n);
            SourceMethod sourceMethod = JavaBrowseHelper.determineDeclaration(sourceElement);
            if (sourceMethod != null) {
                if (bl) {
                    SourceMethod sourceMethod2 = sourceMethod;
                    return sourceMethod2;
                }
                this.errorCode = 1;
                JavaHasType javaHasType = null;
                return javaHasType;
            }
            int n2 = foundSymbol.endOffset;
            TextBuffer textBuffer = sourceFile.getTextBuffer();
            if (textBuffer == null) {
                JavaHasType javaHasType = null;
                return javaHasType;
            }
            String string = textBuffer.getString(n, n2 - n);
            SourceFactory sourceFactory = sourceFile.getFactory();
            SourceExpression sourceExpression = sourceFactory.createExpression(string);
            if (sourceExpression == null) {
                this.errorCode = 2;
                JavaHasType javaHasType = null;
                return javaHasType;
            }
            SourceElement sourceElement2 = sourceElement;
            CallerContext callerContext = CallerContext.createContext((SourceElement)sourceElement2, (boolean)true);
            sourceExpression.setContext(callerContext);
            JavaHasType javaHasType = sourceExpression.getResolvedObject();
            if (javaHasType == null) {
                this.errorCode = 3;
                JavaHasType javaHasType2 = null;
                return javaHasType2;
            }
            if (sourceExpression instanceof CompiledInvokeExpression && (javaMethod = (compiledInvokeExpression = (CompiledInvokeExpression)sourceExpression).getResolvedMethod()) != null) {
                JavaMethod javaMethod2 = javaMethod;
                return javaMethod2;
            }
            JavaHasType javaHasType3 = javaHasType;
            return javaHasType3;
        }
        catch (Exception exception) {
            this.errorCode = 0;
            JavaHasType javaHasType = null;
            return javaHasType;
        }
    }

    private JavaHasType analyzeDoc(FoundSymbol foundSymbol) {
        SourceElement sourceElement;
        int n;
        TextBuffer textBuffer = this.browseContext.getTextBuffer();
        if (textBuffer == null) {
            return null;
        }
        int n2 = this.browseContext.getSelectionStart();
        if (n2 != (n = this.browseContext.getSelectionEnd())) {
            return null;
        }
        SourceFile sourceFile = this.browseContext.getSourceFile();
        SourceElement sourceElement2 = sourceElement = sourceFile.getElementAt(n2);
        while (sourceElement2 != null) {
            switch (sourceElement2.getSymbolKind()) {
                case 67: {
                    SourceDocReference sourceDocReference = (SourceDocReference)sourceElement2;
                    return sourceDocReference.getResolvedObject();
                }
            }
            sourceElement2 = sourceElement2.getParent();
        }
        return null;
    }

    protected JavaHasType analyze(FoundSymbol foundSymbol, boolean bl, boolean bl2) {
        int n;
        String string = this.analyzeTarget(foundSymbol);
        if (string == null) {
            JavaHasType javaHasType = this.analyzeDoc(foundSymbol);
            if (javaHasType != null) {
                return javaHasType;
            }
            if (bl2) {
                JavaBrowseHelper.reportError(17);
            }
            return null;
        }
        if (string.indexOf(46) != -1 && string.indexOf(91) == -1 && string.indexOf(40) == -1 && string.indexOf(123) == -1) {
            long l = System.currentTimeMillis();
            JavaClass javaClass = this.browseContext.getJavaManager().getClass(string);
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            if (javaClass != null) {
                return javaClass;
            }
        }
        long l = System.currentTimeMillis();
        JavaHasType javaHasType = this.analyzeSearch(foundSymbol, bl);
        long l4 = System.currentTimeMillis();
        long l5 = l4 - l;
        if (javaHasType != null) {
            return javaHasType;
        }
        int n2 = this.browseContext.getSelectionStart();
        if (n2 != (n = this.browseContext.getSelectionEnd())) {
            this.browseContext.setSelection(n, n);
            return this.analyze(foundSymbol, bl, bl2);
        }
        if (bl2) {
            switch (this.errorCode) {
                case 1: {
                    JavaBrowseHelper.reportError(21);
                    break;
                }
                case 2: {
                    JavaBrowseHelper.reportError(22);
                    break;
                }
                default: {
                    Object var22_16 = null;
                    if (var22_16 == null) {
                        String string2 = JavaArb.format(18, string);
                        JavaBrowseHelper.reportError(string2);
                        break;
                    }
                    String string3 = JavaArb.format(19, string, var22_16);
                    JavaBrowseHelper.reportError(string3);
                }
            }
        }
        return null;
    }

    protected static SourceMethod determineDeclaration(SourceElement sourceElement) {
        SourceElement sourceElement2 = sourceElement;
        while (sourceElement2 != null) {
            switch (sourceElement2.getSymbolKind()) {
                case 6: 
                case 19: {
                    return (SourceMethod)sourceElement2;
                }
                case 12: 
                case 21: 
                case 25: {
                    break;
                }
                default: {
                    return null;
                }
            }
            sourceElement2 = sourceElement2.getParent();
        }
        return null;
    }

    static void reportError(int n) {
        String string = JavaArb.getString(n);
        JavaBrowseHelper.reportError(string);
    }

    private static void reportError(String string) {
        BrowseSymbolDialog.showErrorDialog(string);
    }
}

