/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.browse;

import java.net.URL;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.LineNavigationPoint;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.browse.BrowseHierarchyAddin;
import oracle.jdevimpl.java.browse.BrowseNavigationPoint2;
import oracle.jdevimpl.java.browse.BrowseSupport;
import oracle.jdevimpl.java.browse.BrowseSymbolDialog;
import oracle.jdevimpl.java.browse.JavaBrowseContext;
import oracle.jdevimpl.java.browse.JavaBrowseContextImpl;
import oracle.jdevimpl.java.browse.JavaBrowseHelper;
import oracle.jdevimpl.java.util.FoundSymbol;

public class JavaBrowseSupport2
implements JavaConstants,
BrowseSupport {
    private static JavaBrowseSupport2 singleton = null;

    protected JavaBrowseSupport2() {
    }

    static JavaBrowseSupport2 getSingleton() {
        if (singleton == null) {
            singleton = new JavaBrowseSupport2();
        }
        return singleton;
    }

    protected JavaBrowseContext getJavaBrowseContext(CodeEditor codeEditor) {
        return JavaBrowseContextImpl.createContext(codeEditor);
    }

    protected JavaBrowseContext getJavaBrowseContext(Context context, int n) {
        return JavaBrowseContextImpl.createContext(context, n);
    }

    protected JavaBrowseHelper getJavaBrowseHelper(CodeEditor codeEditor) {
        JavaBrowseContext javaBrowseContext = this.getJavaBrowseContext(codeEditor);
        return new JavaBrowseHelper(javaBrowseContext);
    }

    protected JavaBrowseHelper getJavaBrowseHelper(Context context, int n) {
        JavaBrowseContext javaBrowseContext = this.getJavaBrowseContext(context, n);
        return new JavaBrowseHelper(javaBrowseContext);
    }

    public boolean canBrowseAtCursor(CodeEditor codeEditor) {
        JavaBrowseHelper javaBrowseHelper = this.getJavaBrowseHelper(codeEditor);
        javaBrowseHelper.acquire();
        try {
            boolean bl = javaBrowseHelper.isBrowseable();
            javaBrowseHelper.release();
            return bl;
        }
        catch (Throwable throwable) {
            javaBrowseHelper.release();
            throw throwable;
        }
    }

    public void performBrowseSymbolAtCursor(CodeEditor codeEditor) {
        JavaBrowseHelper javaBrowseHelper = this.getJavaBrowseHelper(codeEditor);
        javaBrowseHelper.acquire();
        try {
            this.performBrowseSymbolImpl(javaBrowseHelper);
        }
        finally {
            javaBrowseHelper.release();
        }
    }

    public void performBrowseHierarchyAtCursor(CodeEditor codeEditor) {
        JavaBrowseHelper javaBrowseHelper = this.getJavaBrowseHelper(codeEditor);
        javaBrowseHelper.acquire();
        try {
            this.performBrowseHierarchyImpl(javaBrowseHelper);
        }
        finally {
            javaBrowseHelper.release();
        }
    }

    public void performBrowseDocAtCursor(CodeEditor codeEditor) {
        HelpInfo helpInfo = this.getHelpInfoAtCursor(codeEditor);
        if (helpInfo != null) {
            HelpSystem.getHelpSystem().showHelp(helpInfo);
        }
    }

    public HelpInfo getHelpInfoAtCursor(CodeEditor codeEditor) {
        JavaBrowseHelper javaBrowseHelper = this.getJavaBrowseHelper(codeEditor);
        javaBrowseHelper.acquire();
        try {
            HelpInfo helpInfo = this.getHelpInfoImpl(javaBrowseHelper);
            javaBrowseHelper.release();
            return helpInfo;
        }
        catch (Throwable throwable) {
            javaBrowseHelper.release();
            throw throwable;
        }
    }

    public static final JavaHasType getSymbolAtOffset(CodeEditor codeEditor) {
        JavaBrowseSupport2 javaBrowseSupport2 = JavaBrowseSupport2.getSingleton();
        if (javaBrowseSupport2 != null) {
            return javaBrowseSupport2.getSymbolAtCursor(codeEditor);
        }
        return null;
    }

    private JavaHasType getSymbolAtCursor(CodeEditor codeEditor) {
        JavaBrowseHelper javaBrowseHelper = this.getJavaBrowseHelper(codeEditor);
        javaBrowseHelper.acquire();
        try {
            FoundSymbol foundSymbol = new FoundSymbol();
            JavaHasType javaHasType = javaBrowseHelper.analyze(foundSymbol, true, false);
            javaBrowseHelper.release();
            return javaHasType;
        }
        catch (Throwable throwable) {
            javaBrowseHelper.release();
            throw throwable;
        }
    }

    public static boolean canBrowseHierarchy() {
        return AddinManager.getAddinManager().getAddin(BrowseHierarchyAddin.class) != null;
    }

    public static void performBrowseSymbolAtOffset(Context context, int n) {
        JavaBrowseSupport2 javaBrowseSupport2 = JavaBrowseSupport2.getSingleton();
        if (javaBrowseSupport2 != null) {
            JavaBrowseHelper javaBrowseHelper = javaBrowseSupport2.getJavaBrowseHelper(context, n);
            javaBrowseHelper.acquire();
            try {
                javaBrowseSupport2.performBrowseSymbolImpl(javaBrowseHelper);
            }
            finally {
                javaBrowseHelper.release();
            }
        }
    }

    public static void performBrowseDocAtOffset(Context context, int n) {
        JavaBrowseSupport2 javaBrowseSupport2 = JavaBrowseSupport2.getSingleton();
        if (javaBrowseSupport2 != null) {
            HelpInfo helpInfo = null;
            JavaBrowseHelper javaBrowseHelper = javaBrowseSupport2.getJavaBrowseHelper(context, n);
            javaBrowseHelper.acquire();
            try {
                helpInfo = javaBrowseSupport2.getHelpInfoImpl(javaBrowseHelper);
            }
            finally {
                javaBrowseHelper.release();
            }
            if (helpInfo != null) {
                HelpSystem.getHelpSystem().showHelp(helpInfo);
            }
        }
    }

    public static void performBrowseHierarchyAtOffset(Context context, int n) {
        JavaBrowseSupport2 javaBrowseSupport2 = JavaBrowseSupport2.getSingleton();
        if (javaBrowseSupport2 != null) {
            JavaBrowseHelper javaBrowseHelper = javaBrowseSupport2.getJavaBrowseHelper(context, n);
            javaBrowseHelper.acquire();
            try {
                javaBrowseSupport2.performBrowseHierarchyImpl(javaBrowseHelper);
            }
            finally {
                javaBrowseHelper.release();
            }
        }
    }

    private static JavaHasType getBrowseableResult(JavaHasType javaHasType) {
        int n = javaHasType.getElementKind();
        switch (n) {
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                return javaHasType;
            }
            case 10: {
                return null;
            }
            case 14: 
            case 16: {
                return javaHasType.getResolvedType();
            }
        }
        throw new RuntimeException("getBrowseableResult: " + n);
    }

    private static URL determineGotoURL(JavaHasType javaHasType, URL uRL) {
        int n = javaHasType.getElementKind();
        switch (n) {
            case 7: {
                return uRL;
            }
            case 10: {
                return null;
            }
            case 4: 
            case 5: 
            case 8: {
                JavaMember javaMember = (JavaMember)javaHasType;
                JavaClass javaClass = javaMember.getOwningClass();
                SourceClass sourceClass = (SourceClass)javaClass.getSourceElement();
                if (sourceClass != null) {
                    return sourceClass.getOwningSourceFile().getURL();
                }
                return javaClass.getURL();
            }
            case 3: {
                JavaType javaType = (JavaType)javaHasType;
                SourceClass sourceClass = (SourceClass)javaHasType.getSourceElement();
                if (sourceClass != null) {
                    return sourceClass.getOwningSourceFile().getURL();
                }
                return javaType.getURL();
            }
        }
        throw new RuntimeException("determineGotoURL: " + n);
    }

    private static int determineGotoOffset(JavaHasType javaHasType) {
        SourceHasName sourceHasName;
        SourceName sourceName;
        SourceElement sourceElement;
        JavaMethod javaMethod;
        if (javaHasType.getElementKind() == 8 && (javaMethod = (JavaMethod)javaHasType).isSynthetic() && javaMethod.isConstructor()) {
            javaHasType = javaMethod.getOwningClass();
        }
        if ((sourceElement = javaHasType.getSourceElement()) == null) {
            return -1;
        }
        if (sourceElement instanceof SourceHasName && (sourceName = (sourceHasName = (SourceHasName)sourceElement).getNameElement()) != null) {
            return sourceName.getStartOffset();
        }
        return sourceElement.getStartOffset();
    }

    private void performBrowseSymbolImpl(JavaBrowseHelper javaBrowseHelper) {
        block5: {
            FoundSymbol foundSymbol = new FoundSymbol();
            JavaHasType javaHasType = javaBrowseHelper.analyze(foundSymbol, false, true);
            CodeEditor codeEditor = javaBrowseHelper.getCodeEditor();
            if (codeEditor != null && foundSymbol.startOffset != -1) {
                int n = foundSymbol.startOffset;
                int n2 = foundSymbol.endOffset;
                this.hiliteTargetInCurrentFile(javaBrowseHelper, n, n2);
            }
            while (javaHasType != null) {
                JavaHasType javaHasType2 = JavaBrowseSupport2.getBrowseableResult(javaHasType);
                if (javaHasType2 == javaHasType) break;
                javaHasType = javaHasType2;
            }
            if (javaHasType == null) break block5;
            URL uRL = javaBrowseHelper.getURL();
            URL uRL2 = JavaBrowseSupport2.determineGotoURL(javaHasType, uRL);
            if (uRL2 == null) {
                // empty if block
            }
            int n = JavaBrowseSupport2.determineGotoOffset(javaHasType);
            if (uRL != null && uRL.equals(uRL2)) {
                this.browseInCurrentFile(javaBrowseHelper, n);
            } else {
                this.browseInOtherFile(uRL2, n, javaHasType, javaBrowseHelper.getProvider());
            }
        }
    }

    private void performBrowseHierarchyImpl(JavaBrowseHelper javaBrowseHelper) {
        FoundSymbol foundSymbol = new FoundSymbol();
        JavaHasType javaHasType = javaBrowseHelper.analyze(foundSymbol, false, true);
        CodeEditor codeEditor = javaBrowseHelper.getCodeEditor();
        if (codeEditor != null && foundSymbol.startOffset != -1) {
            int n = foundSymbol.startOffset;
            int n2 = foundSymbol.endOffset;
            this.hiliteTargetInCurrentFile(javaBrowseHelper, n, n2);
        }
        if (javaHasType != null) {
            JavaType javaType = javaHasType.getResolvedType();
            if (javaType != null && javaType.getElementKind() == 3) {
                JavaClass javaClass = (JavaClass)javaType;
                String string = javaClass.getQualifiedName();
                Context context = javaBrowseHelper.getContext();
                BrowseHierarchyAddin.browseTypeHierarchy(context, string);
                return;
            }
            JavaBrowseSupport2.reportError(351);
        }
    }

    protected HelpInfo getHelpInfoImpl(JavaBrowseHelper javaBrowseHelper) {
        HelpInfo helpInfo;
        block8: {
            JavaType javaType;
            helpInfo = null;
            FoundSymbol foundSymbol = new FoundSymbol();
            JavaHasType javaHasType = javaBrowseHelper.analyze(foundSymbol, true, true);
            if (foundSymbol.startOffset != -1) {
                int n = foundSymbol.startOffset;
                int n2 = foundSymbol.endOffset;
                CodeEditor codeEditor = javaBrowseHelper.getCodeEditor();
                this.hiliteTargetInCurrentFile(javaBrowseHelper, n, n2);
            }
            if (javaHasType == null) break block8;
            int n = javaHasType.getElementKind();
            switch (n) {
                case 3: 
                case 7: 
                case 14: 
                case 16: {
                    javaType = javaHasType.getResolvedType();
                    break;
                }
                case 5: 
                case 8: {
                    JavaMember javaMember = (JavaMember)javaHasType;
                    javaType = javaMember.getOwningClass();
                    break;
                }
                default: {
                    throw new RuntimeException("performBrowseSymbolImpl: " + n);
                }
            }
            JavaClass javaClass = null;
            if (javaType != null && javaType.getElementKind() == 3) {
                javaClass = (JavaClass)javaType;
            }
            if (javaClass != null) {
                helpInfo = this.helpInfoFor(javaBrowseHelper.getContext(), javaClass);
            } else {
                JavaBrowseSupport2.reportError(20);
            }
        }
        return helpInfo;
    }

    protected HelpInfo helpInfoFor(Context context, JavaClass javaClass) {
        try {
            String string = javaClass.getQualifiedName();
            HelpInfo helpInfo = new HelpInfo(string, 1);
            helpInfo.setContext(context);
            HelpInfo helpInfo2 = helpInfo;
            return helpInfo2;
        }
        catch (Exception exception) {
            JavaBrowseSupport2.reportError(20);
            return null;
        }
    }

    protected static void gotoOffset(CodeEditor codeEditor, int n) {
        NavigationManager navigationManager = NavigationManager.getNavigationManager();
        LineNavigationPoint lineNavigationPoint = new LineNavigationPoint(codeEditor.getContext(), n, true);
        try {
            if (navigationManager != null) {
                navigationManager.navigateTo((NavigationPoint)lineNavigationPoint);
            } else {
                lineNavigationPoint.navigate();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void hiliteTargetInCurrentFile(JavaBrowseHelper javaBrowseHelper, int n, int n2) {
        CodeEditor codeEditor = javaBrowseHelper.getCodeEditor();
        if (codeEditor != null) {
            codeEditor.setSelectionEnd(n2);
            codeEditor.setSelectionStart(n);
        }
    }

    protected void browseInCurrentFile(JavaBrowseHelper javaBrowseHelper, int n) {
        CodeEditor codeEditor = javaBrowseHelper.getCodeEditor();
        if (codeEditor != null) {
            JavaBrowseSupport2.gotoOffset(codeEditor, n);
        }
    }

    private void browseInOtherFile(URL uRL, int n, JavaHasType javaHasType, JavaManager javaManager) {
        try {
            Node node = NodeFactory.findOrCreate((URL)uRL);
            Context context = Context.newIdeContext((Node)node);
            NavigationManager navigationManager = NavigationManager.getNavigationManager();
            BrowseNavigationPoint2 browseNavigationPoint2 = new BrowseNavigationPoint2(context, n, javaHasType, javaManager);
            if (navigationManager != null) {
                navigationManager.navigateTo((NavigationPoint)browseNavigationPoint2);
            } else {
                browseNavigationPoint2.navigate();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static void reportError(int n) {
        String string = JavaArb.getString(n);
        JavaBrowseSupport2.reportError(string);
    }

    protected static void reportError(String string) {
        BrowseSymbolDialog.showErrorDialog(string);
    }
}

