/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.editing;

import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.ActionHookInvoker;
import oracle.javatools.editor.ActionPostInvoker;
import oracle.javatools.editor.BasicAction;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.CharacterTypedListener;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.Utilities;
import oracle.javatools.editor.language.BraceProvider;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.LexerDocumentRenderer;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.editing.JavaSmartClipboard;
import oracle.jdevimpl.javadoc.audit.DocCommenter;

public final class JavaEditingPlugin
implements EditorPlugin,
CharacterTypedListener,
CaretListener,
ActionPostInvoker,
ActionHookInvoker {
    private static final EditDescriptor asteriskDescriptor;
    private static final EditDescriptor commentEndDescriptor;
    private static final EditDescriptor moveOpenBraceDescriptor;
    private static final EditDescriptor braceEndDescriptor;
    private static final EditDescriptor autoIndentBlockDescriptor;
    private static final EditDescriptor alignBraceDescriptor;
    private static final EditDescriptor quoteEndDescriptor;
    private static final EditDescriptor quoteExtendDescriptor;
    private static final EditDescriptor parenEndDescriptor;
    protected static final String PROPERTY_AUTO_ASTERISK = "java-auto-asterisk";
    protected static final String PROPERTY_AUTO_COMMENT_END = "java-auto-comment-end";
    protected static final String PROPERTY_AUTO_GEN_DOC_COMMENTS = "java-auto-gen-doc-comments";
    protected static final String PROPERTY_AUTO_BRACE_END = "java-auto-brace-end";
    public static final String PROPERTY_OPEN_BRACE_SAME_LINE = "java-open-brace-same-line";
    protected static final String PROPERTY_MOVE_OPEN_BRACE = "java-move-open-brace";
    protected static final String PROPERTY_ALIGN_CLOSE_BRACE = "java-align-close-brace";
    protected static final String PROPERTY_AUTO_QUOTE_END = "java-auto-quote-end";
    protected static final String PROPERTY_AUTO_QUOTE_EXTEND = "java-auto-quote-extend";
    protected static final String PROPERTY_AUTO_PAREN_END = "java-auto-paren-end";
    private boolean autoAsteriskEnabled;
    private boolean autoCommentEndEnabled;
    private boolean autoGenDocCommentsEnabled;
    private boolean moveOpenBraceEnabled;
    private boolean autoBraceEndEnabled;
    private boolean alignCloseBraceEnabled;
    private boolean autoQuoteEndEnabled;
    private boolean autoQuoteExtendEnabled;
    private boolean autoParenEndEnabled;
    private boolean lastBackspace;
    private int lastInvokedOffset;
    private int lastInvokedLine;
    private int lastInvokedToken;
    private BasicEditorPane editor;
    private static final int IN_PLAIN = 0;
    private static final int IN_ML_COMMENT_BODY = 1;
    private static final int IN_ML_COMMENT_HEADER = 2;
    private static final int IN_SL_COMMENT = 3;
    private static final int IN_STRING = 4;
    private static final int IN_CHARS = 5;
    private int caretToken;
    private int caretTokenStart;
    private JavaLexer lexer;
    private LexerToken lexerToken;
    private static final int LAST_TYPED_CHARS_SIZE = 8;
    private char[] lastTypedChars;
    private int lastTypedOffset;
    private int numLastChars;
    private boolean isEmptyQuotes;
    private boolean shouldExtendQuotes;
    private boolean isEmptyParens;
    private List _trackerList;

    public JavaEditingPlugin() {
        this.$init$();
    }

    static {
        String string = JavaArb.getString(105);
        asteriskDescriptor = new EditDescriptor(string);
        string = JavaArb.getString(106);
        commentEndDescriptor = new EditDescriptor(string);
        string = JavaArb.getString(107);
        moveOpenBraceDescriptor = new EditDescriptor(string);
        string = JavaArb.getString(108);
        braceEndDescriptor = new EditDescriptor(string);
        string = JavaArb.getString(109);
        autoIndentBlockDescriptor = new EditDescriptor(string);
        string = JavaArb.getString(110);
        alignBraceDescriptor = new EditDescriptor(string);
        string = JavaArb.getString(111);
        quoteEndDescriptor = new EditDescriptor(string);
        string = JavaArb.getString(112);
        quoteExtendDescriptor = new EditDescriptor(string);
        string = JavaArb.getString(113);
        parenEndDescriptor = new EditDescriptor(string);
    }

    public void install(BasicEditorPane basicEditorPane) {
        this.editor = basicEditorPane;
        basicEditorPane.addActionHookInvoker((ActionHookInvoker)this);
        basicEditorPane.addActionPostInvoker((ActionPostInvoker)this);
        basicEditorPane.addCaretListener((CaretListener)this);
        basicEditorPane.addCharacterTypedListener((CharacterTypedListener)this);
        this.lexer = new JavaLexer();
        this.lexer.setSkipComments(false);
        this.lexer.setRecognizeSQLJ(true);
        this.lexerToken = this.lexer.createLexerToken();
        this.numLastChars = 0;
        this.updatePropertyStatus();
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        this.removeAllTrackers();
        basicEditorPane.removeActionHookInvoker((ActionHookInvoker)this);
        basicEditorPane.removeActionPostInvoker((ActionPostInvoker)this);
        basicEditorPane.removeCaretListener((CaretListener)this);
        basicEditorPane.removeCharacterTypedListener((CharacterTypedListener)this);
        this.editor = null;
        this.lexer = null;
        this.lexerToken = null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals(PROPERTY_AUTO_ASTERISK) || string.equals(PROPERTY_AUTO_COMMENT_END) || string.equals(PROPERTY_AUTO_GEN_DOC_COMMENTS) || string.equals(PROPERTY_MOVE_OPEN_BRACE) || string.equals(PROPERTY_AUTO_BRACE_END) || string.equals(PROPERTY_ALIGN_CLOSE_BRACE) || string.equals(PROPERTY_AUTO_QUOTE_END) || string.equals(PROPERTY_AUTO_QUOTE_EXTEND) || string.equals(PROPERTY_AUTO_PAREN_END)) {
            this.updatePropertyStatus();
        }
    }

    private void updatePropertyStatus() {
        this.autoAsteriskEnabled = this.editor.getBooleanProperty(PROPERTY_AUTO_ASTERISK);
        this.autoCommentEndEnabled = this.editor.getBooleanProperty(PROPERTY_AUTO_COMMENT_END);
        this.autoGenDocCommentsEnabled = this.editor.getBooleanProperty(PROPERTY_AUTO_GEN_DOC_COMMENTS);
        this.autoQuoteEndEnabled = this.editor.getBooleanProperty(PROPERTY_AUTO_QUOTE_END);
        this.autoQuoteExtendEnabled = this.editor.getBooleanProperty(PROPERTY_AUTO_QUOTE_EXTEND);
        this.autoParenEndEnabled = this.editor.getBooleanProperty(PROPERTY_AUTO_PAREN_END);
        this.moveOpenBraceEnabled = this.editor.getBooleanProperty(PROPERTY_MOVE_OPEN_BRACE);
        this.autoBraceEndEnabled = this.editor.getBooleanProperty(PROPERTY_AUTO_BRACE_END);
        this.alignCloseBraceEnabled = this.editor.getBooleanProperty(PROPERTY_ALIGN_CLOSE_BRACE);
        this.updateTokenStatus();
    }

    private boolean isAutoAsteriskEnabled() {
        return this.autoAsteriskEnabled;
    }

    private boolean isAutoCommentEndEnabled() {
        return this.autoCommentEndEnabled;
    }

    private boolean isAutoGenDocCommentsEnabled() {
        return this.autoGenDocCommentsEnabled;
    }

    private boolean isMoveOpenBraceEnabled() {
        return this.moveOpenBraceEnabled;
    }

    private boolean isAutoBraceEndEnabled() {
        return this.autoBraceEndEnabled;
    }

    private boolean isAlignCloseBraceEnabled() {
        return this.alignCloseBraceEnabled;
    }

    private boolean isAutoQuoteEndEnabled() {
        return this.autoQuoteEndEnabled;
    }

    private boolean isAutoQuoteExtendEnabled() {
        return this.autoQuoteExtendEnabled;
    }

    private boolean isAutoParenEndEnabled() {
        return this.autoParenEndEnabled;
    }

    private boolean shouldRecordInvokedOffset() {
        return this.isAutoAsteriskEnabled() || this.isAutoCommentEndEnabled() || this.isMoveOpenBraceEnabled() || this.isAutoBraceEndEnabled() || this.isAutoQuoteEndEnabled();
    }

    private boolean shouldUpdateTokenStatus() {
        return this.isAutoAsteriskEnabled() || this.isAutoCommentEndEnabled() || this.isMoveOpenBraceEnabled() || this.isAutoBraceEndEnabled() || this.isAlignCloseBraceEnabled() || this.isAutoQuoteEndEnabled();
    }

    private boolean shouldUpdateLastTypedChars() {
        return this.isAutoCommentEndEnabled() || this.isMoveOpenBraceEnabled() || this.isAutoBraceEndEnabled() || this.isAutoQuoteEndEnabled();
    }

    public boolean invokeAction(String string) {
        if (string.equals("insert-break")) {
            this.recordInvokedOffset();
            this.enterKey_preAutoQuoteExtend();
        } else if (string.equals("delete-previous")) {
            this.lastBackspace = this.editor.hasSelection() ^ true;
            if (this.lastBackspace) {
                this.recordInvokedOffset();
                this.delete_preAutoRemoveQuoteEnd();
                this.delete_preAutoRemoveParenEnd();
            }
        } else if (string.equals("cut-to-clipboard") || string.equals("copy-to-clipboard") || string.equals("extended-paste-from-clipboard") || string.equals("paste-from-clipboard")) {
            return JavaSmartClipboard.invokeAction(this.editor, string);
        }
        return false;
    }

    void $init$() {
        this.lastBackspace = false;
        this.editor = null;
        this.caretToken = 0;
        this.lexer = null;
        this.lexerToken = null;
        this.lastTypedChars = new char[8];
        this.lastTypedOffset = 0;
        this.numLastChars = 0;
        this.isEmptyQuotes = false;
        this.shouldExtendQuotes = false;
        this.isEmptyParens = false;
        this._trackerList = new ArrayList();
    }

    private void recordInvokedOffset() {
        if (!this.shouldRecordInvokedOffset()) {
            return;
        }
        this.lastInvokedOffset = this.editor.getCaretPosition();
        this.lastInvokedLine = this.editor.getLineFromOffset(this.lastInvokedOffset);
        this.lastInvokedToken = this.getCaretToken();
    }

    private int getLastInvokedOffset() {
        return this.lastInvokedOffset;
    }

    private int getLastInvokedLine() {
        return this.lastInvokedLine;
    }

    private int getLastInvokedToken() {
        return this.lastInvokedToken;
    }

    public void invokedAction(String string) {
        if (string.equals("insert-break")) {
            this.enterKey_doAutoAsterisk();
            this.enterKey_doAutoEndComment();
            this.enterKey_doOpenBraceTasks();
            this.enterKey_doAutoQuoteExtend();
        } else if (string.equals("delete-previous") && this.lastBackspace) {
            this.lastBackspace = false;
            this.deleteLastTypedChar(this.getLastInvokedOffset());
            this.delete_doAutoRemoveQuoteEnd();
            this.delete_doAutoRemoveParenEnd();
            return;
        }
        this.clearLastTypedChars();
    }

    public void caretUpdate(CaretEvent caretEvent) {
        this.updateTokenStatus();
    }

    public void characterTyped(BasicEditorPane basicEditorPane, int n, char c) {
        this.updateLastTypedChars(n, c);
        this.charTyped_doAlignCloseBrace(n, c);
        this.charTyped_doAutoQuoteEnd(n, c);
        this.charTyped_doAutoParenEnd(n, c);
    }

    private TextBuffer getTextBuffer() {
        BasicDocument basicDocument = this.getDocument();
        return basicDocument.getTextBuffer();
    }

    private BasicDocument getDocument() {
        BasicDocument basicDocument = (BasicDocument)this.editor.getDocument();
        return basicDocument;
    }

    private void updateTokenStatus() {
        if (!this.shouldUpdateTokenStatus()) {
            return;
        }
        int n = this.editor.getCaretPosition();
        this.caretToken = this.getTokenForOffset(n);
    }

    private int getTokenForOffset(int n) {
        int n2 = 0;
        BasicDocument basicDocument = this.getDocument();
        TextBuffer textBuffer = this.getTextBuffer();
        textBuffer.readLock();
        try {
            LexerDocumentRenderer lexerDocumentRenderer = (LexerDocumentRenderer)basicDocument.getDocumentRenderer();
            LexerDocumentRenderer.LexerOffsetsCache lexerOffsetsCache = lexerDocumentRenderer.getOffsetsCache();
            int n3 = lexerOffsetsCache.findClosestOffset((Lexer)this.lexer, this.lexerToken, n);
            this.lexer.setTextBuffer((ReadTextBuffer)textBuffer);
            this.lexer.setPosition(n3);
            int n4 = n3;
            int n5 = textBuffer.getLength();
            while (n4 < n5) {
                int n6 = this.lexer.lex(this.lexerToken);
                if (n6 == 0) {
                } else {
                    int n7 = this.lexerToken.getStartOffset();
                    int n8 = this.lexerToken.getEndOffset();
                    this.caretTokenStart = n7;
                    if (n7 == n) {
                    } else if (n7 < n && n < n8) {
                        if (n6 == 25 || n6 == 26) {
                            n2 = 1;
                            int n9 = 2;
                            if (n < n7 + n9) {
                                n2 = 2;
                            }
                        } else if (n6 == 24) {
                            n2 = 3;
                        } else if (n6 == 13) {
                            n2 = 5;
                        } else if (n6 == 14) {
                            n2 = 4;
                        }
                    } else if (n8 == n) {
                        if (n6 == 25 || n6 == 26) {
                            if (textBuffer.getChar(n8 - 2) != '*' || textBuffer.getChar(n8 - 1) != '/') {
                                n2 = 1;
                            }
                        } else if (n6 == 24) {
                            n2 = 3;
                        } else if (n6 == 13) {
                            if (!this.isCharLiteralTerminated(textBuffer, n7, n8)) {
                                n2 = 5;
                            }
                        } else if (n6 == 14 && !this.isStringLiteralTerminated(textBuffer, n7, n8)) {
                            n2 = 4;
                        }
                    } else if (n >= n7) continue;
                }
                break;
            }
        }
        finally {
            textBuffer.readUnlock();
        }
        return n2;
    }

    private boolean isCharLiteralTerminated(TextBuffer textBuffer, int n, int n2) {
        int n3 = 2;
        int n4 = n;
        while (n4 < n2) {
            char c = textBuffer.getChar(n4);
            switch (c) {
                case '\'': {
                    --n3;
                    break;
                }
                case '\\': {
                    ++n4;
                }
            }
            ++n4;
        }
        return n3 == 0;
    }

    private boolean isStringLiteralTerminated(TextBuffer textBuffer, int n, int n2) {
        int n3 = 2;
        int n4 = n;
        while (n4 < n2) {
            char c = textBuffer.getChar(n4);
            switch (c) {
                case '\"': {
                    --n3;
                    break;
                }
                case '\\': {
                    ++n4;
                }
            }
            ++n4;
        }
        return n3 == 0;
    }

    private int getCaretToken() {
        return this.caretToken;
    }

    private int getCaretTokenStart() {
        return this.caretTokenStart;
    }

    private void enterKey_doAutoAsterisk() {
        block16: {
            if (!this.isAutoAsteriskEnabled()) {
                return;
            }
            if (this.getCaretToken() == 1) {
                BasicDocument basicDocument = this.getDocument();
                basicDocument.readLock();
                try {
                    int n = this.getLastInvokedOffset();
                    int n2 = this.getLastInvokedLine();
                    int n3 = this.getCaretTokenStart();
                    TextBuffer textBuffer = this.getTextBuffer();
                    LineMap lineMap = textBuffer.getLineMap();
                    int n4 = this.editor.getCaretPosition();
                    int n5 = this.editor.getLineFromOffset(n4);
                    if (n2 + 1 != n5) {
                        break block16;
                    }
                    int n6 = this.editor.getLineStartOffset(n5);
                    int n7 = this.firstNonWhitespaceOffset(textBuffer, n6, n4);
                    if (n7 != n4) {
                        break block16;
                    }
                    int n8 = BasicAction.getTabSizeProperty((BasicEditorPane)this.editor);
                    boolean bl = BasicAction.getUseTabsProperty((BasicEditorPane)this.editor);
                    int n9 = this.editor.getLineFromOffset(n3);
                    int n10 = 0;
                    int n11 = 0;
                    int n12 = 0;
                    if (n9 == n2) {
                        int n13 = n3 + 1;
                        n10 = Utilities.getColumnFromOffset((TextBuffer)textBuffer, (int)n9, (int)n13, (int)n8);
                        n11 = 1;
                        n12 = 1;
                    } else {
                        int n14;
                        int n15 = lineMap.getLineStartOffset(n2);
                        int n16 = BasicAction.skipLeadingIndent((TextBuffer)textBuffer, (int)n15, (int)(n14 = lineMap.getLineEndOffset(n2)));
                        if (n16 != -1) {
                            n10 = Utilities.getColumnFromOffset((TextBuffer)textBuffer, (int)n2, (int)n16, (int)n8);
                            n11 = this.countAsterisks(textBuffer, n16, n14);
                            int n17 = n16 + n11;
                            n7 = this.firstNonWhitespaceOffset(textBuffer, n17, n14);
                            n12 = 1;
                            if (n7 > n17) {
                                int n18 = Utilities.getColumnFromOffset((TextBuffer)textBuffer, (int)n2, (int)n7, (int)n8);
                                n12 = n18 - (n10 + n11);
                            }
                        }
                    }
                    if (n11 <= false) break block16;
                    String string = this.buildAsterisks(bl, n8, n10, n11, n12);
                    int n19 = n4 - n6;
                    this.editor.beginEdit(asteriskDescriptor);
                    try {
                        try {
                            basicDocument.remove(n6, n19);
                            basicDocument.insertString(n6, string, null);
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                    finally {
                        this.editor.endEdit(true);
                    }
                }
                finally {
                    basicDocument.readUnlock();
                }
            }
        }
    }

    private String buildAsterisks(boolean bl, int n, int n2, int n3, int n4) {
        String string = BasicAction.buildIndent((boolean)bl, (int)n, (int)n2);
        while (n3-- > 0) {
            string = string + "*";
        }
        while (n4-- > 0) {
            string = string + " ";
        }
        return string;
    }

    private int countAsterisks(TextBuffer textBuffer, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            char c = textBuffer.getChar(n3);
            if (c != '*') {
                return n3 - n;
            }
            ++n3;
        }
        return n2 - n;
    }

    private int firstNonWhitespaceOffset(TextBuffer textBuffer, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            char c = textBuffer.getChar(n3);
            if (!Character.isWhitespace(c)) {
                return n3;
            }
            ++n3;
        }
        return n2;
    }

    private void clearLastTypedChars() {
        this.numLastChars = 0;
        this.lastTypedOffset = 0;
    }

    private void deleteLastTypedChar(int n) {
        if (!this.shouldUpdateLastTypedChars()) {
            // empty if block
        }
        if (this.numLastChars == 0) {
            return;
        }
        if (n != this.lastTypedOffset + 1) {
            this.clearLastTypedChars();
            return;
        }
        --this.numLastChars;
        this.lastTypedOffset = Math.max(0, this.lastTypedOffset - 1);
    }

    private void updateLastTypedChars(int n, char c) {
        if (!this.shouldUpdateLastTypedChars()) {
            // empty if block
        }
        if (n != this.lastTypedOffset + 1) {
            this.numLastChars = 0;
        }
        if (this.numLastChars == 8) {
            --this.numLastChars;
            System.arraycopy(this.lastTypedChars, 1, this.lastTypedChars, 0, this.numLastChars);
        }
        this.lastTypedChars[this.numLastChars++] = c;
        this.lastTypedOffset = n;
    }

    private boolean matchLastTypedChars(String string, int n) {
        if (this.numLastChars < string.length()) {
            return false;
        }
        if (this.lastTypedOffset + 1 != n) {
            return false;
        }
        int n2 = string.length();
        int n3 = 0;
        int n4 = this.numLastChars - n2;
        while (n3 < n2) {
            if (this.lastTypedChars[n4] != string.charAt(n3)) {
                return false;
            }
            ++n3;
            ++n4;
        }
        return true;
    }

    private void enterKey_doAutoEndComment() {
        block17: {
            if (!this.isAutoCommentEndEnabled()) {
                return;
            }
            boolean bl = false;
            if (this.getCaretToken() == 1) {
                BasicDocument basicDocument = this.getDocument();
                basicDocument.readLock();
                try {
                    int n = this.getLastInvokedOffset();
                    int n2 = this.getLastInvokedLine();
                    int n3 = this.getCaretTokenStart();
                    TextBuffer textBuffer = this.getTextBuffer();
                    int n4 = this.editor.getCaretPosition();
                    int n5 = this.editor.getLineFromOffset(n4);
                    if (this.matchLastTypedChars("/**", n)) {
                        bl = true;
                    } else if (!this.matchLastTypedChars("/*", n)) {
                        break block17;
                    }
                    if (n2 + 1 != n5) {
                        break block17;
                    }
                    if (n - 3 > n3) {
                        break block17;
                    }
                    int n6 = this.editor.getLineEndOffset(n5);
                    int n7 = this.firstNonWhitespaceOffset(textBuffer, n4, n6);
                    if (n7 != n6) {
                        break block17;
                    }
                    int n8 = BasicAction.getTabSizeProperty((BasicEditorPane)this.editor);
                    boolean bl2 = BasicAction.getUseTabsProperty((BasicEditorPane)this.editor);
                    int n9 = this.editor.getLineFromOffset(n3);
                    int n10 = n3 + 1;
                    int n11 = Utilities.getColumnFromOffset((TextBuffer)textBuffer, (int)n9, (int)n10, (int)n8);
                    String string = BasicAction.buildIndent((boolean)bl2, (int)n8, (int)n11);
                    this.editor.beginEdit(commentEndDescriptor);
                    try {
                        try {
                            String string2 = "\n" + string + "*/";
                            basicDocument.insertString(n4, string2, null);
                            this.editor.setCaretPosition(n4);
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                    finally {
                        this.editor.endEdit(true);
                    }
                }
                finally {
                    if (this.isAutoGenDocCommentsEnabled() && bl) {
                        this.addJavadocCommentsAtOffset();
                    }
                    basicDocument.readUnlock();
                }
            }
        }
    }

    private void addJavadocCommentsAtOffset() {
        Context context = CodeEditor.getContext((BasicEditorPane)this.editor);
        DocCommenter.addJavadocComments(null, (Context)context);
        DocCommenter.gotoCommentStart((SourceMember)DocCommenter.getMemberAt((Context)context), (Context)context);
    }

    private boolean isOpenBraceAlone() {
        return this.editor.getBooleanProperty(PROPERTY_OPEN_BRACE_SAME_LINE) ^ true;
    }

    private void enterKey_doOpenBraceTasks() {
        block24: {
            boolean bl = this.isAutoBraceEndEnabled();
            boolean bl2 = this.isMoveOpenBraceEnabled();
            if (this.getCaretToken() == 0) {
                BasicDocument basicDocument = this.getDocument();
                basicDocument.readLock();
                try {
                    int n;
                    int n2 = this.getLastInvokedOffset();
                    int n3 = this.getLastInvokedLine();
                    int n4 = this.getLastInvokedToken();
                    TextBuffer textBuffer = this.getTextBuffer();
                    LineMap lineMap = textBuffer.getLineMap();
                    int n5 = this.editor.getCaretPosition();
                    int n6 = this.editor.getLineFromOffset(n5);
                    if (!this.matchLastTypedChars("{", n2)) {
                        break block24;
                    }
                    if (n4 != 0) {
                        break block24;
                    }
                    if (n3 + 1 != n6) {
                        break block24;
                    }
                    if (n2 == 0) break block24;
                    if (textBuffer.getChar(n2 - 1) != '{') {
                        break block24;
                    }
                    int n7 = this.editor.getLineEndOffset(n6);
                    int n8 = this.firstNonWhitespaceOffset(textBuffer, n5, n7);
                    if (n8 != n7) {
                        break block24;
                    }
                    int n9 = BasicAction.getIndentSizeProperty((BasicEditorPane)this.editor);
                    int n10 = BasicAction.getTabSizeProperty((BasicEditorPane)this.editor);
                    boolean bl3 = BasicAction.getUseTabsProperty((BasicEditorPane)this.editor);
                    int n11 = n2 - 1;
                    int n12 = n3;
                    int n13 = lineMap.getLineStartOffset(n12);
                    int n14 = BasicAction.skipLeadingIndent((TextBuffer)textBuffer, (int)n13, (int)(n = lineMap.getLineEndOffset(n12)));
                    if (n14 == -1) {
                        throw new IllegalStateException("unexpected empty line");
                    }
                    int n15 = Utilities.getColumnFromOffset((TextBuffer)textBuffer, (int)n12, (int)n14, (int)n10);
                    boolean bl4 = n14 == n2 - 1;
                    boolean bl5 = bl2 && bl4 != this.isOpenBraceAlone();
                    int n16 = n15 + n9;
                    int n17 = lineMap.getLineStartOffset(n6);
                    EditDescriptor editDescriptor = bl ? braceEndDescriptor : (bl2 ? moveOpenBraceDescriptor : autoIndentBlockDescriptor);
                    this.editor.beginEdit(editDescriptor);
                    try {
                        try {
                            String string = BasicAction.buildIndent((boolean)bl3, (int)n10, (int)n16);
                            int n18 = n5 - n17;
                            basicDocument.remove(n17, n18);
                            basicDocument.insertString(n17, string, null);
                            int n19 = this.editor.getCaretPosition();
                            String string2 = BasicAction.buildIndent((boolean)bl3, (int)n10, (int)n15);
                            String string3 = "\n" + string2 + "}";
                            if (bl) {
                                basicDocument.insertString(n19, string3, null);
                                this.editor.setCaretPosition(n19);
                                Rectangle rectangle = new Rectangle();
                                this.editor.computeVisibleRect(rectangle);
                                try {
                                    int n20 = n19 + 2;
                                    Rectangle rectangle2 = this.editor.modelToView(n20);
                                    if (!rectangle.contains(rectangle2) && rectangle.y <= rectangle2.y) {
                                        int n21 = rectangle2.y - (rectangle.y + rectangle.height);
                                        rectangle.y += n21 + rectangle2.height * 2;
                                        rectangle.y = Math.min(rectangle.y, this.editor.getHeight() - rectangle.height);
                                        this.editor.scrollRectToVisible(rectangle);
                                    }
                                }
                                catch (BadLocationException badLocationException) {
                                    // empty catch block
                                }
                            }
                            if (bl5) {
                                if (this.isOpenBraceAlone()) {
                                    String string4 = "\n" + string2;
                                    basicDocument.insertString(n2 - 1, string4, null);
                                } else {
                                    int n22 = n12 - 1;
                                    if (n22 >= 0) {
                                        int n23 = lineMap.getLineEndOffset(n22);
                                        int n24 = lineMap.getLineStartOffset(n22);
                                        int n25 = BasicAction.skipLeadingIndent((TextBuffer)textBuffer, (int)n24, (int)n23);
                                        if (n25 != -1 && this.getTokenForOffset(n23 - 1) == 0) {
                                            basicDocument.remove(n13, n - n13);
                                            char c = textBuffer.getChar(n23 - 2);
                                            String string5 = c != ' ' ? " {" : "{";
                                            basicDocument.insertString(n23 - 1, string5, null);
                                        }
                                    }
                                }
                            }
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                    finally {
                        this.editor.endEdit(true);
                    }
                }
                finally {
                    basicDocument.readUnlock();
                }
            }
        }
    }

    private void charTyped_doAlignCloseBrace(int n, char c) {
        block18: {
            if (!this.isAlignCloseBraceEnabled()) {
                return;
            }
            if (c == '}' && this.getCaretToken() == 0) {
                BasicDocument basicDocument = this.getDocument();
                basicDocument.readLock();
                try {
                    int n2;
                    TextBuffer textBuffer = this.getTextBuffer();
                    LineMap lineMap = textBuffer.getLineMap();
                    int n3 = this.editor.getCaretPosition();
                    int n4 = this.editor.getLineFromOffset(n3);
                    if (n3 != n + 1) {
                        break block18;
                    }
                    if (n >= textBuffer.getLength()) break block18;
                    if (textBuffer.getChar(n) != '}') {
                        break block18;
                    }
                    int n5 = lineMap.getLineStartOffset(n4);
                    int n6 = this.firstNonWhitespaceOffset(textBuffer, n5, n);
                    if (n6 != n) {
                        break block18;
                    }
                    LanguageSupport languageSupport = basicDocument.getLanguageSupport();
                    BraceProvider braceProvider = languageSupport.getBraceProvider();
                    if (braceProvider == null) {
                        break block18;
                    }
                    NumberRange numberRange = new NumberRange(0, 0);
                    NumberRange numberRange2 = new NumberRange(0, 0);
                    int n7 = braceProvider.isPartOfBrace(n, numberRange);
                    if (n7 == -1) {
                        throw new IllegalStateException("could not get brace");
                    }
                    int n8 = braceProvider.findMatchingBrace(n7, numberRange, numberRange2);
                    if (n8 == 3) {
                        break block18;
                    }
                    int n9 = numberRange2.start;
                    int n10 = lineMap.getLineFromOffset(n9);
                    int n11 = lineMap.getLineStartOffset(n10);
                    int n12 = lineMap.getLineEndOffset(n10);
                    int n13 = BasicAction.getTabSizeProperty((BasicEditorPane)this.editor);
                    boolean bl = BasicAction.getUseTabsProperty((BasicEditorPane)this.editor);
                    int n14 = BasicAction.skipLeadingIndent((TextBuffer)textBuffer, (int)n11, (int)n12);
                    if (n14 == -1) {
                        throw new IllegalStateException("unexpected empty line");
                    }
                    int n15 = Utilities.getColumnFromOffset((TextBuffer)textBuffer, (int)n10, (int)n14, (int)n13);
                    if (n15 == (n2 = Utilities.getColumnFromOffset((TextBuffer)textBuffer, (int)n4, (int)n, (int)n13))) {
                        break block18;
                    }
                    String string = BasicAction.buildIndent((boolean)bl, (int)n13, (int)n15);
                    this.editor.beginEdit(alignBraceDescriptor);
                    try {
                        try {
                            int n16 = n - n5;
                            basicDocument.remove(n5, n16);
                            basicDocument.insertString(n5, string, null);
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                    finally {
                        this.editor.endEdit(true);
                    }
                }
                finally {
                    basicDocument.readUnlock();
                }
            }
        }
    }

    private void delete_preAutoRemoveQuoteEnd() {
        this.isEmptyQuotes = false;
        if (!this.isAutoQuoteEndEnabled()) {
            return;
        }
        BasicDocument basicDocument = this.getDocument();
        TextBuffer textBuffer = this.getTextBuffer();
        basicDocument.readLock();
        try {
            int n = this.getCaretToken();
            if (n == 5 || n == 4) {
                char c;
                char c2;
                int n2 = this.getCaretTokenStart();
                int n3 = this.editor.getCaretPosition();
                if (n3 - 1 == n2 && n3 < textBuffer.getLength() && (c2 = textBuffer.getChar(n2)) == (c = textBuffer.getChar(n3))) {
                    this.isEmptyQuotes = true;
                }
            }
        }
        finally {
            basicDocument.readUnlock();
        }
    }

    private void delete_doAutoRemoveQuoteEnd() {
        if (!this.isAutoQuoteEndEnabled()) {
            return;
        }
        if (this.isEmptyQuotes) {
            this.isEmptyQuotes = false;
            BasicDocument basicDocument = this.getDocument();
            TextBuffer textBuffer = this.getTextBuffer();
            this.editor.beginEdit(quoteEndDescriptor);
            try {
                try {
                    int n = this.editor.getCaretPosition();
                    if (n < textBuffer.getLength()) {
                        basicDocument.remove(n, 1);
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            finally {
                this.editor.endEdit(true);
            }
        }
    }

    private void charTyped_doAutoQuoteEnd(int n, char c) {
        block17: {
            if (!this.isAutoQuoteEndEnabled()) {
                return;
            }
            BasicDocument basicDocument = this.getDocument();
            TextBuffer textBuffer = this.getTextBuffer();
            basicDocument.readLock();
            try {
                int n2;
                int n3 = this.getCaretToken();
                if (c == '\'' && n3 == 5 || c == '\"' && n3 == 4) {
                    char c2;
                    int n4 = this.getCaretTokenStart();
                    if (n4 != n) {
                        basicDocument.readUnlock();
                        return;
                    }
                    int n5 = this.editor.getCaretPosition();
                    boolean bl = false;
                    if (n5 < textBuffer.getLength() && Character.isJavaIdentifierPart(c2 = textBuffer.getChar(n5))) {
                        bl = true;
                    }
                    if (bl) break block17;
                    this.editor.beginEdit(quoteEndDescriptor);
                    try {
                        try {
                            basicDocument.insertString(n5, Character.toString(c), null);
                            this.editor.setCaretPosition(n5);
                        }
                        catch (BadLocationException badLocationException) {}
                        break block17;
                    }
                    finally {
                        this.editor.endEdit(true);
                    }
                }
                if (n3 != 0 || c != '\'' && c != '\"' || (n2 = this.editor.getCaretPosition()) >= textBuffer.getLength() || textBuffer.getChar(n2) != c) break block17;
                this.editor.beginEdit(quoteEndDescriptor);
                try {
                    try {
                        basicDocument.remove(n2, 1);
                    }
                    catch (BadLocationException badLocationException) {}
                }
                finally {
                    this.editor.endEdit(true);
                }
            }
            finally {
                basicDocument.readUnlock();
            }
        }
    }

    private void enterKey_preAutoQuoteExtend() {
        this.shouldExtendQuotes = false;
        if (!this.isAutoQuoteExtendEnabled()) {
            return;
        }
        BasicDocument basicDocument = this.getDocument();
        TextBuffer textBuffer = this.getTextBuffer();
        basicDocument.readLock();
        try {
            int n = this.getCaretToken();
            if (n == 4) {
                this.shouldExtendQuotes = true;
            }
        }
        finally {
            basicDocument.readUnlock();
        }
    }

    private void enterKey_doAutoQuoteExtend() {
        if (!this.isAutoQuoteEndEnabled()) {
            return;
        }
        if (this.shouldExtendQuotes) {
            this.shouldExtendQuotes = false;
            BasicDocument basicDocument = this.getDocument();
            TextBuffer textBuffer = this.getTextBuffer();
            LineMap lineMap = textBuffer.getLineMap();
            this.editor.beginEdit(quoteExtendDescriptor);
            try {
                try {
                    int n = this.editor.getCaretPosition();
                    int n2 = this.lastInvokedOffset;
                    basicDocument.insertString(n, "\"", null);
                    basicDocument.insertString(n2, "\" +", null);
                }
                catch (BadLocationException badLocationException) {}
            }
            finally {
                this.editor.endEdit(true);
            }
        }
    }

    private void delete_preAutoRemoveParenEnd() {
        this.isEmptyParens = false;
        if (!this.isAutoParenEndEnabled()) {
            return;
        }
        BasicDocument basicDocument = this.getDocument();
        TextBuffer textBuffer = this.getTextBuffer();
        basicDocument.readLock();
        try {
            int n;
            int n2;
            int n3 = this.getCaretToken();
            if (n3 == 0 && (n2 = (n = this.editor.getCaretPosition()) - 1) >= 0 && n < textBuffer.getLength()) {
                char c = textBuffer.getChar(n2);
                char c2 = textBuffer.getChar(n);
                if (c == '(' && c2 == ')' || c == '[' && c2 == ']') {
                    this.isEmptyParens = true;
                }
            }
        }
        finally {
            basicDocument.readUnlock();
        }
    }

    private void delete_doAutoRemoveParenEnd() {
        if (!this.isAutoParenEndEnabled()) {
            return;
        }
        if (this.isEmptyParens) {
            this.isEmptyParens = false;
            BasicDocument basicDocument = this.getDocument();
            TextBuffer textBuffer = this.getTextBuffer();
            this.editor.beginEdit(quoteEndDescriptor);
            try {
                try {
                    int n = this.editor.getCaretPosition();
                    if (n < textBuffer.getLength()) {
                        char c = textBuffer.getChar(n);
                        basicDocument.remove(n, 1);
                        this.removeTracker(n, c);
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            finally {
                this.editor.endEdit(true);
            }
        }
    }

    private void charTyped_doAutoParenEnd(int n, char c) {
        block28: {
            if (!this.isAutoParenEndEnabled()) {
                return;
            }
            BasicDocument basicDocument = this.getDocument();
            TextBuffer textBuffer = this.getTextBuffer();
            LineMap lineMap = textBuffer.getLineMap();
            basicDocument.readLock();
            try {
                boolean bl;
                int n2;
                block30: {
                    NumberRange numberRange;
                    NumberRange numberRange2;
                    int n3;
                    int n4;
                    if (this.caretToken != 0) break block28;
                    if (c == '(' || c == '[') {
                        int n5 = this.editor.getCaretPosition();
                        if (c == '(') {
                            int n6 = lineMap.getLineFromOffset(n5);
                            int n7 = lineMap.getLineEndOffset(n6);
                            this.lexer.setTextBuffer((ReadTextBuffer)textBuffer);
                            this.lexer.setPosition(n5);
                            int n8 = this.lexer.lex(this.lexerToken);
                            int n9 = this.lexerToken.getStartOffset();
                            if (n9 < n7) {
                                switch (n8) {
                                    case 4: 
                                    case 8: 
                                    case 10: 
                                    case 12: 
                                    case 13: 
                                    case 14: 
                                    case 15: 
                                    case 35: 
                                    case 37: 
                                    case 40: 
                                    case 48: 
                                    case 53: 
                                    case 55: 
                                    case 59: {
                                        basicDocument.readUnlock();
                                        return;
                                    }
                                }
                            }
                        }
                        char c2 = c == '(' ? (char)')' : ']';
                        this.editor.beginEdit(parenEndDescriptor);
                        try {
                            try {
                                basicDocument.insertString(n5, Character.toString(c2), null);
                                this.editor.setCaretPosition(n5);
                                this.addTracker(n5, c2);
                            }
                            catch (BadLocationException badLocationException) {}
                            break block28;
                        }
                        finally {
                            this.editor.endEdit(true);
                        }
                    }
                    if (c != ')' && c != ']' || (n2 = this.editor.getCaretPosition()) >= textBuffer.getLength() || textBuffer.getChar(n2) != c) break block28;
                    boolean bl2 = this.hasTracker(n2, c);
                    if (bl2) {
                        this.editor.beginEdit(quoteEndDescriptor);
                        try {
                            try {
                                basicDocument.remove(n2, 1);
                            }
                            catch (BadLocationException badLocationException) {}
                        }
                        finally {
                            this.editor.endEdit(true);
                        }
                        basicDocument.readUnlock();
                        return;
                    }
                    LanguageSupport languageSupport = basicDocument.getLanguageSupport();
                    BraceProvider braceProvider = languageSupport.getBraceProvider();
                    if (braceProvider == null) {
                        basicDocument.readUnlock();
                        return;
                    }
                    this.lexer.setTextBuffer((ReadTextBuffer)textBuffer);
                    this.lexer.setPosition(n2);
                    int n10 = c == ')' ? 72 : 71;
                    bl = true;
                    do {
                        int n11 = this.lexer.lex(this.lexerToken);
                        int n12 = this.lexerToken.getStartOffset();
                        int n13 = this.lexerToken.getEndOffset();
                        if (n11 != n10) break block30;
                        numberRange2 = new NumberRange(0, 0);
                        numberRange = new NumberRange(0, 0);
                        n3 = braceProvider.isPartOfBrace(n12, numberRange2);
                        if (n3 != -1) continue;
                        throw new IllegalStateException("could not get brace");
                    } while ((n4 = braceProvider.findMatchingBrace(n3, numberRange2, numberRange)) != 3);
                    bl = false;
                }
                if (bl) break block28;
                this.editor.beginEdit(quoteEndDescriptor);
                try {
                    try {
                        basicDocument.remove(n2, 1);
                    }
                    catch (BadLocationException badLocationException) {}
                }
                finally {
                    this.editor.endEdit(true);
                }
            }
            finally {
                basicDocument.readUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTracker(int n, char c) {
        TextBuffer textBuffer = this.getTextBuffer();
        OffsetMark offsetMark = textBuffer.addOffsetMark(n, true);
        OffsetMark offsetMark2 = textBuffer.addOffsetMark(n + 1, false);
        EndTracker endTracker = new EndTracker(c, offsetMark, offsetMark2, null);
        List list = this._trackerList;
        synchronized (list) {
            this._trackerList.add(endTracker);
        }
    }

    private boolean hasTracker(int n, char c) {
        EndTracker endTracker = this.findTracker(n, c);
        boolean bl = endTracker != null;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTracker(int n, char c) {
        EndTracker endTracker = this.findTracker(n, c);
        if (endTracker != null) {
            List list = this._trackerList;
            synchronized (list) {
                this._trackerList.remove(endTracker);
                this.freeTracker(endTracker);
            }
        }
    }

    private void freeTracker(EndTracker endTracker) {
        TextBuffer textBuffer = this.getTextBuffer();
        if (endTracker != null) {
            textBuffer.removeOffsetMark(EndTracker.ra$front(endTracker));
            textBuffer.removeOffsetMark(EndTracker.ra$back(endTracker));
            EndTracker.wa$back(endTracker, null);
            EndTracker.wa$front(endTracker, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EndTracker findTracker(int n, char c) {
        TextBuffer textBuffer = this.getTextBuffer();
        textBuffer.readLock();
        try {
            List list = this._trackerList;
            synchronized (list) {
                Iterator iterator = this._trackerList.iterator();
                while (iterator.hasNext()) {
                    int n2;
                    EndTracker endTracker = (EndTracker)iterator.next();
                    int n3 = EndTracker.ra$front(endTracker).getOffset();
                    if (n3 == (n2 = EndTracker.ra$back(endTracker).getOffset())) {
                        iterator.remove();
                        this.freeTracker(endTracker);
                        continue;
                    }
                    if (n3 != n || EndTracker.ra$closeChar(endTracker) != c) continue;
                    EndTracker endTracker2 = endTracker;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 6] lbl17 : MonitorExitStatement: MONITOREXIT : var8_4
                    textBuffer.readUnlock();
                    return endTracker2;
                }
            }
        }
        finally {
            textBuffer.readUnlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllTrackers() {
        TextBuffer textBuffer = this.getTextBuffer();
        textBuffer.readLock();
        try {
            List list = this._trackerList;
            synchronized (list) {
                for (EndTracker endTracker : this._trackerList) {
                    this.freeTracker(endTracker);
                }
                this._trackerList.clear();
            }
        }
        finally {
            textBuffer.readUnlock();
        }
    }

    private static class EndTracker {
        private OffsetMark front;
        private OffsetMark back;
        private char closeChar;

        private EndTracker(char c, OffsetMark offsetMark, OffsetMark offsetMark2) {
            this.front = offsetMark;
            this.back = offsetMark2;
            this.closeChar = c;
        }

        static OffsetMark ra$front(EndTracker endTracker) {
            return endTracker.front;
        }

        static OffsetMark ra$back(EndTracker endTracker) {
            return endTracker.back;
        }

        static char ra$closeChar(EndTracker endTracker) {
            return endTracker.closeChar;
        }

        static void wa$back(EndTracker endTracker, OffsetMark offsetMark) {
            endTracker.back = offsetMark;
        }

        static void wa$front(EndTracker endTracker, OffsetMark offsetMark) {
            endTracker.front = offsetMark;
        }

        EndTracker(char c, OffsetMark offsetMark, OffsetMark offsetMark2, 1 var4_4) {
            this(c, offsetMark, offsetMark2);
        }

        public final class 1 {
        }
    }
}

