/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.editing;

import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.util.IntHashMap;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.GutterColumn;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaIsGeneric;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.util.AsyncScheduler;
import oracle.javatools.parser.util.AsyncTask;
import oracle.jdeveloper.java.CacheSupport;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.audit.java.BindingContext;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.JavaParserPlugin;

public final class JavaImplOverPlugin
implements GutterColumnListener,
JavaParserPlugin.HelperClient,
EditorPlugin {
    private static final String PLUGIN_KEY = JavaImplOverPlugin.class.getName();
    public static final String COLUMN_NAME = "implements-overrides-column";
    private static final ImplOverItem[] EMPTY_ITEMS = new ImplOverItem[0];
    private BasicEditorPane editor;
    private GutterColumn column;
    private List itemList;
    private UpdaterTask updTask;
    private static AsyncScheduler updScheduler = new AsyncScheduler("ImplementsOverrideGutterUpdater", 30000);
    private static Icon IMPLEMENTS_ICON = null;
    private static Icon OVERRIDES_ICON = null;

    public JavaImplOverPlugin() {
        this.$init$();
    }

    public void notifyCompileScheduled() {
        this.cancelUpdater();
    }

    public void notifyParseFinished(JavaManager javaManager, SourceFile sourceFile, int n, int n2) {
    }

    public void notifyCompileFinished(JavaManager javaManager, SourceFile sourceFile, int n, int n2) {
        this.scheduleUpdater(javaManager, sourceFile);
    }

    public static ImplOverItem getImplOverItem(BasicEditorPane basicEditorPane, int n, boolean bl) {
        JavaImplOverPlugin javaImplOverPlugin = JavaImplOverPlugin.lookupPlugin(basicEditorPane);
        if (javaImplOverPlugin == null) {
            return null;
        }
        ImplOverItem[] implOverItemArray = javaImplOverPlugin.findItems(n);
        int n2 = 0;
        while (n2 < implOverItemArray.length) {
            ImplOverItem implOverItem = implOverItemArray[n2];
            if (!ImplOverItem.ra$isClass(implOverItem) && bl == ImplOverItem.ra$isImpl(implOverItem)) {
                return implOverItem;
            }
            ++n2;
        }
        return null;
    }

    private static JavaImplOverPlugin lookupPlugin(BasicEditorPane basicEditorPane) {
        return (JavaImplOverPlugin)basicEditorPane.getProperty(PLUGIN_KEY);
    }

    public void install(BasicEditorPane basicEditorPane) {
        this.editor = basicEditorPane;
        basicEditorPane.putProperty(PLUGIN_KEY, (Object)this);
        CodeEditorGutter codeEditorGutter = CodeEditor.getCodeEditor((BasicEditorPane)basicEditorPane).getGutter();
        this.column = codeEditorGutter.createGutterColumn(COLUMN_NAME, (GutterColumnListener)this);
        this.column.setReservedWidth(Math.max(JavaImplOverPlugin.getImplementsIcon().getIconWidth(), JavaImplOverPlugin.getOverridesIcon().getIconWidth()));
        this.column.setLayoutConstraint("breakpoint", 1);
        JavaParserPlugin.attachHelperClient(basicEditorPane, this);
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        this.cancelUpdater();
        JavaParserPlugin.detachHelperClient(basicEditorPane, this);
        CodeEditorGutter codeEditorGutter = CodeEditor.getCodeEditor((BasicEditorPane)basicEditorPane).getGutter();
        if (codeEditorGutter != null) {
            codeEditorGutter.removeGutterColumn(this.column);
        }
        this.column = null;
        basicEditorPane.putProperty(PLUGIN_KEY, null);
        this.editor = null;
    }

    private void clearGutterColumns() {
        if (this.column != null) {
            this.column.removeAllGutterMarks();
        }
        this.clearItemList();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
    }

    void $init$() {
        this.itemList = null;
        this.updTask = null;
    }

    private TextBuffer getTextBuffer() {
        return this.getDocument().getTextBuffer();
    }

    private BasicDocument getDocument() {
        return (BasicDocument)this.editor.getDocument();
    }

    private Project getProject() {
        Context context = CodeEditor.getContext((BasicEditorPane)this.editor);
        if (context != null) {
            return context.getProject();
        }
        return null;
    }

    private static Icon getImplementsIcon() {
        if (IMPLEMENTS_ICON == null) {
            IMPLEMENTS_ICON = JavaArb.getIcon(31);
        }
        return IMPLEMENTS_ICON;
    }

    private static Icon getOverridesIcon() {
        if (OVERRIDES_ICON == null) {
            OVERRIDES_ICON = JavaArb.getIcon(34);
        }
        return OVERRIDES_ICON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleUpdater(JavaManager javaManager, SourceFile sourceFile) {
        UpdaterTask updaterTask = new UpdaterTask(javaManager, sourceFile, null);
        JavaImplOverPlugin javaImplOverPlugin = this;
        synchronized (javaImplOverPlugin) {
            if (this.updTask != null) {
                updScheduler.cancelTask((AsyncTask)this.updTask);
            }
            this.updTask = updaterTask;
        }
        updScheduler.scheduleTask((AsyncTask)updaterTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelUpdater() {
        UpdaterTask updaterTask;
        JavaImplOverPlugin javaImplOverPlugin = this;
        synchronized (javaImplOverPlugin) {
            updaterTask = this.updTask;
            this.updTask = null;
        }
        if (updaterTask != null) {
            updScheduler.cancelTask((AsyncTask)updaterTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishUpdater(UpdaterTask updaterTask) {
        JavaImplOverPlugin javaImplOverPlugin = this;
        synchronized (javaImplOverPlugin) {
            if (this.updTask == updaterTask) {
                this.updTask = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setItemList(List list) {
        JavaImplOverPlugin javaImplOverPlugin = this;
        synchronized (javaImplOverPlugin) {
            this.itemList = list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearItemList() {
        JavaImplOverPlugin javaImplOverPlugin = this;
        synchronized (javaImplOverPlugin) {
            this.itemList = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImplOverItem[] findItems(int n) {
        ArrayList<ImplOverItem> arrayList = null;
        JavaImplOverPlugin javaImplOverPlugin = this;
        synchronized (javaImplOverPlugin) {
            if (this.itemList != null) {
                int n2 = this.itemList.size();
                int n3 = 0;
                while (n3 < n2) {
                    ImplOverItem implOverItem = (ImplOverItem)this.itemList.get(n3);
                    boolean bl = false;
                    if (ImplOverItem.ra$mark(implOverItem) != null) {
                        int n4 = ImplOverItem.ra$mark(implOverItem).getLine();
                        if (n4 == n) {
                            bl = true;
                        }
                    } else if (ImplOverItem.ra$line(implOverItem) == n) {
                        bl = true;
                    }
                    if (bl) {
                        if (arrayList == null) {
                            arrayList = new ArrayList<ImplOverItem>();
                        }
                        arrayList.add(implOverItem);
                    }
                    ++n3;
                }
            }
        }
        if (arrayList == null) {
            return EMPTY_ITEMS;
        }
        return arrayList.toArray(new ImplOverItem[arrayList.size()]);
    }

    public void markMoved(GutterMark gutterMark, int n, int n2) {
    }

    public void markRemoved(GutterMark gutterMark, int n) {
    }

    public void markClicked(GutterMark gutterMark, int n, MouseEvent mouseEvent) {
        Object object = gutterMark.getUserData();
        if (object instanceof ImplOverItem) {
            ((ImplOverItem)object).gotoImplOverItem();
        }
    }

    public String getMarkToolTip(GutterMark gutterMark, MouseEvent mouseEvent) {
        Object object = gutterMark.getUserData();
        if (object != null && (object instanceof List || object instanceof ImplOverItem)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html>");
            if (object instanceof List) {
                List list = (List)object;
                int n = 0;
                while (n < list.size()) {
                    if (n > 0) {
                        stringBuffer.append("<br>");
                    }
                    ImplOverItem implOverItem = (ImplOverItem)list.get(n);
                    stringBuffer.append(this.getMarkToolTip(implOverItem));
                    ++n;
                }
            } else {
                stringBuffer.append(this.getMarkToolTip((ImplOverItem)object));
            }
            stringBuffer.append("</html>");
            return stringBuffer.toString();
        }
        return null;
    }

    protected String getMarkToolTip(ImplOverItem implOverItem) {
        int n = ImplOverItem.ra$isClass(implOverItem) ? (ImplOverItem.ra$isImpl(implOverItem) ? 324 : 325) : (ImplOverItem.ra$isImpl(implOverItem) ? 326 : 327);
        return JavaArb.format(n, ImplOverItem.ra$className(implOverItem));
    }

    static Icon maS$getImplementsIcon() {
        return JavaImplOverPlugin.getImplementsIcon();
    }

    static Icon maS$getOverridesIcon() {
        return JavaImplOverPlugin.getOverridesIcon();
    }

    static Project mav$getProject(JavaImplOverPlugin javaImplOverPlugin) {
        return javaImplOverPlugin.getProject();
    }

    static void mav$finishUpdater(JavaImplOverPlugin javaImplOverPlugin, UpdaterTask updaterTask) {
        javaImplOverPlugin.finishUpdater(updaterTask);
    }

    static GutterColumn ra$column(JavaImplOverPlugin javaImplOverPlugin) {
        return javaImplOverPlugin.column;
    }

    static TextBuffer mav$getTextBuffer(JavaImplOverPlugin javaImplOverPlugin) {
        return javaImplOverPlugin.getTextBuffer();
    }

    static void mav$clearGutterColumns(JavaImplOverPlugin javaImplOverPlugin) {
        javaImplOverPlugin.clearGutterColumns();
    }

    static void mav$setItemList(JavaImplOverPlugin javaImplOverPlugin, List list) {
        javaImplOverPlugin.setItemList(list);
    }

    private final class UpdaterTask
    extends AsyncTask {
        private boolean updCancelled = false;
        private JavaManager updJavaManager;
        private SourceFile updSourceFile;

        private UpdaterTask(JavaManager javaManager, SourceFile sourceFile) {
            this.updJavaManager = javaManager;
            this.updSourceFile = sourceFile;
        }

        protected void requestCancelImpl() {
            this.updCancelled = true;
        }

        protected boolean isCancelledImpl() {
            return this.updCancelled;
        }

        protected Object runImpl() throws AsyncTask.CancelledException {
            try {
                this.bailIfCancelled();
                ArrayList arrayList = new ArrayList();
                Project project = JavaImplOverPlugin.mav$getProject(JavaImplOverPlugin.this);
                if (project == null) {
                    Object var7_3 = null;
                    JavaImplOverPlugin.mav$finishUpdater(JavaImplOverPlugin.this, this);
                    this.updSourceFile = null;
                    return var7_3;
                }
                CacheSupport cacheSupport = this.updJavaManager.getCacheSupport();
                try {
                    cacheSupport.beginCacheUse();
                    List list = this.updSourceFile.getSourceClasses();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        this.bailIfCancelled();
                        this.processClass(this.updJavaManager, (SourceClass)iterator.next(), arrayList);
                    }
                }
                finally {
                    cacheSupport.endCacheUse();
                }
                this.bailIfCancelled();
                1 var6_8 = new 1(this, arrayList);
                SwingUtilities.invokeLater(var6_8);
                Object var9_9 = null;
                JavaImplOverPlugin.mav$finishUpdater(JavaImplOverPlugin.this, this);
                this.updSourceFile = null;
                return var9_9;
            }
            catch (Throwable throwable) {
                JavaImplOverPlugin.mav$finishUpdater(JavaImplOverPlugin.this, this);
                this.updSourceFile = null;
                throw throwable;
            }
        }

        private void processClass(JavaManager javaManager, SourceClass sourceClass, List list) throws AsyncTask.CancelledException {
            if (sourceClass == null) {
                return;
            }
            JavaClass javaClass = javaManager.getClass("java.lang.Object");
            Set set = sourceClass.getHierarchy();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.bailIfCancelled();
                JavaType javaType = (JavaType)iterator.next();
                if (javaType.equals((Object)javaClass)) continue;
                this.addItem((SourceMember)sourceClass, (JavaMember)javaType, list);
            }
            Map map = this.collectHierarchy(sourceClass, javaManager);
            List list2 = sourceClass.getSourceMethods();
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                this.bailIfCancelled();
                this.processMethod(javaManager, map, (SourceMethod)iterator2.next(), list);
            }
            Collection collection = sourceClass.getDeclaredClasses();
            Iterator iterator3 = collection.iterator();
            while (iterator3.hasNext()) {
                this.bailIfCancelled();
                this.processClass(javaManager, (SourceClass)iterator3.next(), list);
            }
        }

        private Map collectHierarchy(SourceClass sourceClass, JavaProvider javaProvider) throws AsyncTask.CancelledException {
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            BindingContext bindingContext = new BindingContext(javaProvider);
            Iterator iterator = sourceClass.getMethods().iterator();
            while (iterator.hasNext()) {
                this.bailIfCancelled();
                JavaMethod javaMethod = (JavaMethod)iterator.next();
                if (javaMethod.getOwningClass() == sourceClass || javaMethod.isPrivate() || javaMethod.isStatic() || javaMethod.isConstructor()) continue;
                bindingContext.setContext((JavaIsGeneric)javaMethod, (JavaType)sourceClass);
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                this.signatures(javaMethod, stringBuffer, stringBuffer2, bindingContext);
                String string = stringBuffer.toString();
                String string2 = stringBuffer2.toString();
                this.collectHierarchyMethod(linkedHashMap, string, javaMethod);
                if (string.equals(string2)) continue;
                this.collectHierarchyMethod(linkedHashMap, string2, javaMethod);
            }
            return linkedHashMap;
        }

        private void signatures(JavaMethod javaMethod, StringBuffer stringBuffer, StringBuffer stringBuffer2, BindingContext bindingContext) {
            bindingContext.appendDescription(javaMethod, false, null, null, stringBuffer, stringBuffer2);
        }

        private void collectHierarchyMethod(Map map, String string, JavaMethod javaMethod) {
            ArrayList<JavaMethod> arrayList;
            Object v = map.get(string);
            if (v != null) {
                arrayList = (ArrayList<JavaMethod>)v;
            } else {
                arrayList = new ArrayList<JavaMethod>(4);
                map.put(string, arrayList);
            }
            arrayList.add(javaMethod);
        }

        private void processMethod(JavaManager javaManager, Map map, SourceMethod sourceMethod, List list) throws AsyncTask.CancelledException {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            BindingContext bindingContext = new BindingContext((JavaProvider)javaManager);
            bindingContext.setContext((JavaIsGeneric)sourceMethod, (JavaType)sourceMethod.getEnclosingClass());
            this.signatures((JavaMethod)sourceMethod, stringBuffer, stringBuffer2, bindingContext);
            Collection collection = (Collection)map.get(stringBuffer.toString());
            if (collection != null) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    this.bailIfCancelled();
                    JavaMethod javaMethod = (JavaMethod)iterator.next();
                    this.addItem((SourceMember)sourceMethod, (JavaMember)javaMethod, list);
                }
            }
            this.processLocalAndAnonymousClasses(javaManager, (SourceElement)sourceMethod.getBlock(), list);
        }

        private void processLocalAndAnonymousClasses(JavaManager javaManager, SourceElement sourceElement, List list) throws AsyncTask.CancelledException {
            if (sourceElement == null) {
                return;
            }
            List list2 = sourceElement.getChildren();
            int n = 0;
            while (n < list2.size()) {
                this.bailIfCancelled();
                SourceElement sourceElement2 = (SourceElement)list2.get(n);
                if (sourceElement2.getSymbolKind() == 3) {
                    this.processClass(javaManager, (SourceClass)sourceElement2, list);
                } else {
                    this.processLocalAndAnonymousClasses(javaManager, sourceElement2, list);
                }
                ++n;
            }
        }

        private void addItem(SourceMember sourceMember, JavaMember javaMember, List list) {
            JavaType javaType;
            JavaMethod javaMethod;
            SourceClass sourceClass;
            SourceMethod sourceMethod;
            if (javaMember instanceof JavaType) {
                sourceMethod = null;
                sourceClass = (SourceClass)sourceMember;
                javaMethod = null;
                javaType = (JavaType)javaMember;
            } else {
                sourceMethod = (SourceMethod)sourceMember;
                sourceClass = sourceMember.getEnclosingClass();
                javaMethod = (JavaMethod)javaMember;
                javaType = javaMember.getOwningClass();
            }
            this.addResult(sourceMethod, sourceClass, javaMethod, javaType, list);
        }

        private void addResult(SourceMethod sourceMethod, SourceClass sourceClass, JavaMethod javaMethod, JavaType javaType, List list) {
            boolean bl;
            String string = javaType.getRawName();
            int n = sourceClass.getStartOffset();
            SourceName sourceName = sourceClass.getNameElement();
            if (sourceName != null) {
                n = sourceName.getStartOffset();
            }
            String string2 = null;
            String string3 = null;
            if (javaMethod != null) {
                n = sourceMethod.getStartOffset();
                SourceName sourceName2 = sourceMethod.getNameElement();
                string3 = sourceMethod.getName();
                if (sourceName2 != null) {
                    n = sourceName2.getStartOffset();
                }
                string2 = javaMethod.getDescriptor();
            }
            boolean bl2 = bl = !sourceClass.isInterface() && javaType.isInterface();
            if (n != -1) {
                ImplOverItem implOverItem = new ImplOverItem(string, string3, string2, n, bl, bl ? JavaImplOverPlugin.maS$getImplementsIcon() : JavaImplOverPlugin.maS$getOverridesIcon());
                list.add(implOverItem);
            }
        }

        UpdaterTask(JavaManager javaManager, SourceFile sourceFile, 1 var4_4) {
            this(javaManager, sourceFile);
        }

        public final class 1
        implements Runnable {
            private final /* synthetic */ List v$foundList;
            final /* synthetic */ UpdaterTask this$0;

            public void run() {
                if (this.this$0.isCancelledImpl() || JavaImplOverPlugin.ra$column(this.this$0.JavaImplOverPlugin.this) == null) {
                    return;
                }
                int n = this.v$foundList.size();
                IntHashMap intHashMap = new IntHashMap();
                TextBuffer textBuffer = JavaImplOverPlugin.mav$getTextBuffer(this.this$0.JavaImplOverPlugin.this);
                LineMap lineMap = textBuffer.getLineMap();
                textBuffer.readLock();
                try {
                    int n2 = 0;
                    while (n2 < n) {
                        ImplOverItem implOverItem = (ImplOverItem)this.v$foundList.get(n2);
                        int n3 = ImplOverItem.ra$offset(implOverItem);
                        n3 = Math.min(n3, textBuffer.getLength());
                        n3 = Math.max(n3, 0);
                        int n4 = lineMap.getLineFromOffset(n3) + 1;
                        ImplOverItem.wa$line(implOverItem, n4);
                        ArrayList<ImplOverItem> arrayList = (ArrayList<ImplOverItem>)intHashMap.get(n4);
                        if (arrayList == null) {
                            arrayList = new ArrayList<ImplOverItem>();
                            intHashMap.put(n4, arrayList);
                            arrayList.add(implOverItem);
                        } else if (!ImplOverItem.ra$isImpl(implOverItem)) {
                            int n5 = 0;
                            while (n5 < arrayList.size()) {
                                if (ImplOverItem.ra$isImpl((ImplOverItem)arrayList.get(n5))) {
                                    arrayList.add(n5, implOverItem);
                                    break;
                                }
                                ++n5;
                            }
                        } else {
                            arrayList.add(implOverItem);
                        }
                        ++n2;
                    }
                }
                finally {
                    textBuffer.readUnlock();
                }
                JavaImplOverPlugin.mav$clearGutterColumns(this.this$0.JavaImplOverPlugin.this);
                for (List list : intHashMap) {
                    ImplOverItem implOverItem = (ImplOverItem)list.get(0);
                    int n6 = 1;
                    Object object = implOverItem;
                    if (list.size() > 1) {
                        n6 |= 0x10000;
                        object = list;
                    }
                    GutterMark gutterMark = JavaImplOverPlugin.ra$column(this.this$0.JavaImplOverPlugin.this).addGutterMark(ImplOverItem.ra$line(implOverItem), ImplOverItem.ra$icon(implOverItem), null, 3000, n6);
                    gutterMark.setUserData(object);
                    ImplOverItem.wa$mark(implOverItem, gutterMark);
                    int n7 = 1;
                    while (n7 < list.size()) {
                        ImplOverItem implOverItem2 = (ImplOverItem)list.get(n7);
                        ImplOverItem.wa$mark(implOverItem2, gutterMark);
                        if (!ImplOverItem.ra$isImpl(implOverItem2)) {
                            gutterMark.setIcon(ImplOverItem.ra$icon(implOverItem2));
                        }
                        ++n7;
                    }
                }
                JavaImplOverPlugin.mav$setItemList(this.this$0.JavaImplOverPlugin.this, this.v$foundList);
            }

            public 1(UpdaterTask updaterTask, List list) {
                this.v$foundList = list;
                this.this$0 = updaterTask;
            }
        }
    }

    public final class ImplOverItem {
        private String className;
        private String methodName;
        private String descriptor;
        private GutterMark mark;
        private int offset;
        private int line;
        private boolean isClass;
        private boolean isImpl;
        private Icon icon;

        public ImplOverItem(String string, String string2, String string3, int n, boolean bl, Icon icon) {
            this.className = string;
            this.methodName = string2;
            this.descriptor = string3;
            this.offset = n;
            this.isClass = string3 == null;
            this.isImpl = bl;
            this.icon = icon;
        }

        public void gotoImplOverItem() {
            SourceName sourceName = null;
            Node node = null;
            JavaManager javaManager = JavaManager.getJavaManager(JavaImplOverPlugin.mav$getProject(JavaImplOverPlugin.this));
            CacheSupport cacheSupport = javaManager.getCacheSupport();
            try {
                cacheSupport.beginCacheUse();
                SourceClass sourceClass = javaManager.getSourceClass(this.className);
                if (sourceClass == null) {
                    cacheSupport.endCacheUse();
                    return;
                }
                URL uRL = sourceClass.getOwningSourceFile().getURL();
                if (this.descriptor == null || this.methodName == null) {
                    sourceName = sourceClass.getNameElement();
                } else {
                    for (SourceMethod sourceMethod : sourceClass.getDeclaredMethods()) {
                        String string = sourceMethod.getDescriptor();
                        String string2 = sourceMethod.getName();
                        if (!this.descriptor.equals(string) || !this.methodName.equals(string2)) continue;
                        sourceName = sourceMethod.getNameElement();
                        break;
                    }
                }
                if (sourceName == null) {
                    cacheSupport.endCacheUse();
                    return;
                }
                try {
                    node = NodeFactory.findOrCreate((URL)uRL);
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            finally {
                cacheSupport.endCacheUse();
            }
            if (node != null) {
                Context context = Context.newIdeContext((Node)node);
                NavigationManager navigationManager = NavigationManager.getNavigationManager();
                int n = sourceName.getStartOffset();
                int n2 = sourceName.getEndOffset() - n;
                OffsetNavigationPoint offsetNavigationPoint = new OffsetNavigationPoint(context, n, n2);
                try {
                    if (navigationManager != null) {
                        navigationManager.navigateTo((NavigationPoint)offsetNavigationPoint);
                    } else {
                        offsetNavigationPoint.navigate();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        protected String getMarkToolTip() {
            int n = this.isClass ? (this.isImpl ? 324 : 325) : (this.isImpl ? 326 : 327);
            return JavaArb.format(n, this.className);
        }

        public ToggleAction createGotoSourceAction() {
            String string = this.className;
            int n = string.lastIndexOf(46);
            String string2 = string.substring(n + 1);
            String string3 = string.substring(0, Math.max(0, n));
            String string4 = string2 + " (" + string3 + ")";
            1 var6_6 = new 1(string4, this.icon);
            return var6_6;
        }

        public String toString() {
            String string = this.isImpl ? "implements" : "overrides";
            return string + ": " + this.className + ", offset = " + this.offset;
        }

        static boolean ra$isClass(ImplOverItem implOverItem) {
            return implOverItem.isClass;
        }

        static boolean ra$isImpl(ImplOverItem implOverItem) {
            return implOverItem.isImpl;
        }

        static String ra$className(ImplOverItem implOverItem) {
            return implOverItem.className;
        }

        static GutterMark ra$mark(ImplOverItem implOverItem) {
            return implOverItem.mark;
        }

        static int ra$line(ImplOverItem implOverItem) {
            return implOverItem.line;
        }

        static int ra$offset(ImplOverItem implOverItem) {
            return implOverItem.offset;
        }

        static void wa$line(ImplOverItem implOverItem, int n) {
            implOverItem.line = n;
        }

        static Icon ra$icon(ImplOverItem implOverItem) {
            return implOverItem.icon;
        }

        static void wa$mark(ImplOverItem implOverItem, GutterMark gutterMark) {
            implOverItem.mark = gutterMark;
        }

        public final class 1
        extends ToggleAction {
            public void actionPerformed(ActionEvent actionEvent) {
                ImplOverItem.this.gotoImplOverItem();
            }

            public 1(String string, Icon icon) {
                super(string, icon);
            }
        }
    }
}

