/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.editing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.EditorProperties;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.editing.JavaOptions;

public final class JavaOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private JCheckBox checkbox_autoAsterisk;
    private JCheckBox checkbox_autoCommentEnd;
    private JCheckBox checkbox_autoGenDocComments;
    private JCheckBox checkbox_autoQuoteEnd;
    private JCheckBox checkbox_autoQuoteExtend;
    private JCheckBox checkbox_autoParenEnd;
    private JCheckBox checkbox_autoBraceEnd;
    private JCheckBox checkbox_moveOpenBrace;
    private JCheckBox checkbox_alignCloseBrace;

    public JavaOptionsPanel() {
        this.setHelpID("f1_idedidesetjava_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext traversableContext) {
        JavaOptions javaOptions = this.findOptions(traversableContext);
        this.loadSettingsFrom(javaOptions);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        JavaOptions javaOptions = this.findOptions(traversableContext);
        this.saveSettingsTo(javaOptions);
    }

    private JavaOptions findOptions(TraversableContext traversableContext) {
        JavaOptions javaOptions = (JavaOptions)traversableContext.find("JavaEditingOptions");
        return javaOptions;
    }

    public void apply(ApplyEvent applyEvent) {
        TraversableContext traversableContext = (TraversableContext)applyEvent.getSource();
        JavaOptions javaOptions = this.findOptions(traversableContext);
        JavaOptionsPanel.applyOptions(javaOptions);
    }

    public void cancel(ApplyEvent applyEvent) {
    }

    public static void applyOptions(JavaOptions javaOptions) {
        EditorProperties editorProperties = EditorProperties.getProperties();
        boolean bl = javaOptions.getAutoAsterisk();
        editorProperties.putBooleanProperty("java-auto-asterisk", bl);
        boolean bl2 = javaOptions.getAutoCommentEnd();
        editorProperties.putBooleanProperty("java-auto-comment-end", bl2);
        boolean bl3 = javaOptions.getAutoGenDocComments();
        editorProperties.putBooleanProperty("java-auto-gen-doc-comments", bl3);
        boolean bl4 = javaOptions.getAutoBraceEnd();
        editorProperties.putBooleanProperty("java-auto-brace-end", bl4);
        boolean bl5 = javaOptions.getMoveOpenBrace();
        editorProperties.putBooleanProperty("java-move-open-brace", bl5);
        boolean bl6 = javaOptions.getAlignCloseBrace();
        editorProperties.putBooleanProperty("java-align-close-brace", bl6);
        boolean bl7 = javaOptions.getAutoQuoteEnd();
        editorProperties.putBooleanProperty("java-auto-quote-end", bl7);
        boolean bl8 = javaOptions.getAutoQuoteExtend();
        editorProperties.putBooleanProperty("java-auto-quote-extend", bl8);
        boolean bl9 = javaOptions.getAutoParenEnd();
        editorProperties.putBooleanProperty("java-auto-paren-end", bl9);
    }

    void loadSettingsFrom(JavaOptions javaOptions) {
        boolean bl = javaOptions.getAutoAsterisk();
        boolean bl2 = javaOptions.getAutoCommentEnd();
        boolean bl3 = javaOptions.getAutoGenDocComments();
        boolean bl4 = javaOptions.getAutoBraceEnd();
        boolean bl5 = javaOptions.getMoveOpenBrace();
        boolean bl6 = javaOptions.getAlignCloseBrace();
        boolean bl7 = javaOptions.getAutoQuoteEnd();
        boolean bl8 = javaOptions.getAutoQuoteExtend();
        boolean bl9 = javaOptions.getAutoParenEnd();
        this.checkbox_autoAsterisk.setSelected(bl);
        this.checkbox_autoCommentEnd.setSelected(bl2);
        this.checkbox_autoGenDocComments.setSelected(bl3);
        this.checkbox_autoGenDocComments.setEnabled(bl2);
        this.checkbox_autoBraceEnd.setSelected(bl4);
        this.checkbox_moveOpenBrace.setSelected(bl5);
        this.checkbox_alignCloseBrace.setSelected(bl6);
        this.checkbox_autoQuoteEnd.setSelected(bl7);
        this.checkbox_autoQuoteExtend.setSelected(bl8);
        this.checkbox_autoParenEnd.setSelected(bl9);
    }

    void saveSettingsTo(JavaOptions javaOptions) throws TraversalException {
        boolean bl = this.checkbox_autoAsterisk.isSelected();
        boolean bl2 = this.checkbox_autoCommentEnd.isSelected();
        boolean bl3 = bl2 && this.checkbox_autoGenDocComments.isSelected();
        boolean bl4 = this.checkbox_autoBraceEnd.isSelected();
        boolean bl5 = this.checkbox_moveOpenBrace.isSelected();
        boolean bl6 = this.checkbox_alignCloseBrace.isSelected();
        boolean bl7 = this.checkbox_autoQuoteEnd.isSelected();
        boolean bl8 = this.checkbox_autoQuoteExtend.isSelected();
        boolean bl9 = this.checkbox_autoParenEnd.isSelected();
        javaOptions.setAutoAsterisk(bl);
        javaOptions.setAutoCommentEnd(bl2);
        javaOptions.setAutoGenDocComments(bl3);
        javaOptions.setAutoBraceEnd(bl4);
        javaOptions.setMoveOpenBrace(bl5);
        javaOptions.setAlignCloseBrace(bl6);
        javaOptions.setAutoQuoteEnd(bl7);
        javaOptions.setAutoQuoteExtend(bl8);
        javaOptions.setAutoParenEnd(bl9);
    }

    private void initializeComponent() {
        String string = JavaArb.getString(121);
        this.checkbox_autoAsterisk = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_autoAsterisk, (String)string);
        String string2 = JavaArb.getString(122);
        this.checkbox_autoCommentEnd = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_autoCommentEnd, (String)string2);
        String string3 = JavaArb.getString(123);
        this.checkbox_autoGenDocComments = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_autoGenDocComments, (String)string3);
        Component[] componentArray = new Component[]{this.checkbox_autoGenDocComments};
        ItemSelectableTracker itemSelectableTracker = new ItemSelectableTracker((ItemSelectable)this.checkbox_autoCommentEnd, componentArray);
        String string4 = JavaArb.getString(124);
        this.checkbox_autoQuoteEnd = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_autoQuoteEnd, (String)string4);
        String string5 = JavaArb.getString(125);
        this.checkbox_autoQuoteExtend = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_autoQuoteExtend, (String)string5);
        String string6 = JavaArb.getString(126);
        this.checkbox_autoParenEnd = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_autoParenEnd, (String)string6);
        String string7 = JavaArb.getString(127);
        String string8 = JavaArb.getString(128);
        JLabel jLabel = new JLabel(string7);
        this.checkbox_autoBraceEnd = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_autoBraceEnd, (String)string8);
        String string9 = JavaArb.getString(129);
        this.checkbox_moveOpenBrace = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_moveOpenBrace, (String)string9);
        String string10 = JavaArb.getString(130);
        this.checkbox_alignCloseBrace = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_alignCloseBrace, (String)string10);
        Insets insets = new Insets(2, 5, 2, 5);
        Insets insets2 = new Insets(0, 30, 2, 5);
        Insets insets3 = new Insets(0, 0, 0, 0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel.add((Component)this.checkbox_autoAsterisk, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel.add((Component)this.checkbox_autoCommentEnd, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel.add((Component)this.checkbox_autoGenDocComments, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel2.add((Component)this.checkbox_autoParenEnd, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel2.add((Component)this.checkbox_autoQuoteEnd, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel2.add((Component)this.checkbox_autoQuoteExtend, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel3.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel3.add((Component)this.checkbox_autoBraceEnd, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel3.add((Component)this.checkbox_moveOpenBrace, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel3.add(Box.createVerticalStrut(5), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 8, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel3.add((Component)this.checkbox_alignCloseBrace, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, insets, 0, 0);
        this.add(jPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, insets, 0, 0);
        this.add(Box.createVerticalStrut(5), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 1, insets, 0, 0);
        this.add(jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 1, insets, 0, 0);
        this.add(Box.createVerticalStrut(5), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 1, insets, 0, 0);
        this.add(jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 17, 1, insets3, 0, 0);
        this.add(Box.createGlue(), gridBagConstraints);
    }
}

