/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.editing;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.text.BadLocationException;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditDescriptor;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.resource.BundleHelper;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceLexicalComment;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceLiteralExpression;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.audit.java.JavaTransformContext;
import oracle.jdeveloper.audit.transform.UndoableEditCommand;
import oracle.jdevimpl.java.Context2ParserHelper;
import oracle.jdevimpl.refactoring.util.RichBuffer;
import oracle.jdevimpl.refactoring.util.SourceFormatUtilities;

final class JavaSmartClipboard {
    private static final EditDescriptor cutDescriptor;
    private static final int LOC_OUTSIDE_COMMENT = 0;
    private static final int LOC_IN_LINE_COMMENT = 1;
    private static final int LOC_IN_REGULAR_COMMENT = 2;

    static {
        BundleHelper bundleHelper = EditorProperties.getEditorBundle();
        String string = bundleHelper.getString("UNDO_CUT");
        cutDescriptor = new EditDescriptor(string);
    }

    static boolean invokeAction(BasicEditorPane basicEditorPane, String string) {
        if (basicEditorPane != null && (string.equals("copy-to-clipboard") || string.equals("cut-to-clipboard") || string.equals("extended-paste-from-clipboard") || string.equals("paste-from-clipboard"))) {
            BasicDocument basicDocument = (BasicDocument)basicEditorPane.getDocument();
            basicDocument.readLock();
            try {
                try {
                    if (string.equals("cut-to-clipboard")) {
                        if (basicEditorPane.makeEditable()) {
                            JavaSmartClipboard.cut(basicEditorPane, basicDocument);
                        }
                        boolean bl = true;
                        basicDocument.readUnlock();
                        return bl;
                    }
                    if (string.equals("copy-to-clipboard")) {
                        JavaSmartClipboard.copy(basicEditorPane, basicDocument);
                        boolean bl = true;
                        basicDocument.readUnlock();
                        return bl;
                    }
                    if (string.equals("paste-from-clipboard")) {
                        if (basicEditorPane.makeEditable()) {
                            JavaSmartClipboard.paste(basicEditorPane, basicDocument);
                        }
                        boolean bl = true;
                        basicDocument.readUnlock();
                        return bl;
                    }
                    if (string.equals("extended-paste-from-clipboard")) {
                        if (ClipboardStack.adjustCurrentClipboard() && basicEditorPane.makeEditable()) {
                            JavaSmartClipboard.paste(basicEditorPane, basicDocument);
                        }
                        boolean bl = true;
                        basicDocument.readUnlock();
                        return bl;
                    }
                    boolean bl = false;
                    basicDocument.readUnlock();
                    return bl;
                }
                catch (RuntimeException runtimeException) {
                    System.out.println("Warning, runtime exception caught: " + runtimeException);
                    runtimeException.printStackTrace();
                }
            }
            finally {
                basicDocument.readUnlock();
            }
        }
        return false;
    }

    private static boolean isCutCopyLineEnabled(BasicEditorPane basicEditorPane) {
        return basicEditorPane.getBooleanProperty("cut-copy-line");
    }

    private static boolean isImportsEnabled(BasicEditorPane basicEditorPane) {
        return basicEditorPane.getBooleanProperty("smart-copy-paste");
    }

    private static boolean isIndentEnabled(BasicEditorPane basicEditorPane) {
        return basicEditorPane.getBooleanProperty("autoindent-copy-paste");
    }

    private static boolean isEscapeStringEnabled(BasicEditorPane basicEditorPane) {
        return basicEditorPane.getBooleanProperty("escape-string-paste");
    }

    private static SourceFile getSourceFile(BasicEditorPane basicEditorPane) {
        Context context = CodeEditor.getContext((BasicEditorPane)basicEditorPane);
        Context2ParserHelper context2ParserHelper = Context2ParserHelper.createHelper(context);
        return context2ParserHelper.getSourceFile();
    }

    private static void copy(BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
        basicDocument.readLock();
        try {
            boolean bl;
            int n = basicEditorPane.getSelectionStart();
            int n2 = basicEditorPane.getSelectionEnd();
            boolean bl2 = bl = n != n2;
            if (n == n2 && JavaSmartClipboard.isCutCopyLineEnabled(basicEditorPane)) {
                int n3 = basicEditorPane.getCaretPosition();
                LineMap lineMap = basicDocument.getLineMap();
                int n4 = lineMap.getLineFromOffset(n3);
                n = lineMap.getLineStartOffset(n4);
                n2 = lineMap.getLineEndOffset(n4);
            }
            if (n != n2) {
                JavaSmartClipboard.fillClipboard(basicEditorPane, basicDocument, n, n2);
                if (!bl) {
                    basicEditorPane.setCaretPosition(n2);
                    basicEditorPane.moveCaretPosition(n);
                }
            }
        }
        finally {
            basicDocument.readUnlock();
        }
    }

    private static void fillClipboard(BasicEditorPane basicEditorPane, BasicDocument basicDocument, int n, int n2) {
        SourceFile sourceFile;
        if (JavaSmartClipboard.isIndentEnabled(basicEditorPane)) {
            String string = "";
            try {
                string = basicDocument.getText(n, n2 - n);
                if (string.indexOf(10) != -1) {
                    String string2 = SourceFormatUtilities.getIndentation(basicEditorPane, n);
                    n -= string2.length();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean bl = JavaSmartClipboard.isEscapeStringEnabled(basicEditorPane) && JavaSmartClipboard.isInStringLiteral(basicEditorPane, n, n2, true);
        boolean bl2 = true;
        if (JavaSmartClipboard.isImportsEnabled(basicEditorPane) && (sourceFile = JavaSmartClipboard.getSourceFile(basicEditorPane)) != null) {
            RichBuffer richBuffer = RichBuffer.createJotRichBuffer(sourceFile, n, n2);
            if (bl) {
                richBuffer.setText(JavaSmartClipboard.unEscapeString(richBuffer.getText()));
            }
            JavaSmartClipboard.setClipboardContents(basicEditorPane, richBuffer);
            bl2 = false;
        }
        if (bl2) {
            String string = "";
            try {
                string = basicDocument.getText(n, n2 - n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl) {
                string = JavaSmartClipboard.unEscapeString(string);
            }
            StringSelection stringSelection = new StringSelection(string);
            JavaSmartClipboard.setClipboardContents(basicEditorPane, stringSelection);
        }
    }

    private static void cut(BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
        Toolkit toolkit = basicEditorPane.getToolkit();
        if (basicEditorPane.isEditable() && basicEditorPane.isEnabled()) {
            try {
                int n = basicEditorPane.getSelectionStart();
                int n2 = basicEditorPane.getSelectionEnd();
                if (n == n2 && JavaSmartClipboard.isCutCopyLineEnabled(basicEditorPane)) {
                    int n3 = basicEditorPane.getCaretPosition();
                    LineMap lineMap = basicDocument.getLineMap();
                    int n4 = lineMap.getLineFromOffset(n3);
                    n = lineMap.getLineStartOffset(n4);
                    n2 = lineMap.getLineEndOffset(n4);
                }
                if (n != n2) {
                    JavaSmartClipboard.fillClipboard(basicEditorPane, basicDocument, n, n2);
                    basicEditorPane.beginEdit(cutDescriptor);
                    basicDocument.remove(n, n2 - n);
                    basicEditorPane.endEdit();
                }
            }
            catch (BadLocationException badLocationException) {}
        } else {
            toolkit.beep();
        }
    }

    private static SourceElement findDeepestChild(int n, SourceElement sourceElement, boolean bl) {
        if (bl ? n < sourceElement.getStartOffset() || n > sourceElement.getEndOffset() : n <= sourceElement.getStartOffset() || n >= sourceElement.getEndOffset()) {
            return null;
        }
        SourceElement sourceElement2 = sourceElement;
        Iterator iterator = sourceElement.getChildren(196608).iterator();
        while (iterator.hasNext()) {
            SourceElement sourceElement3 = JavaSmartClipboard.findDeepestChild(n, (SourceElement)iterator.next(), bl);
            if (sourceElement3 == null) continue;
            sourceElement2 = sourceElement3;
            break;
        }
        return sourceElement2;
    }

    private static SourceElement findDeepestChild(int n, SourceElement sourceElement) {
        return JavaSmartClipboard.findDeepestChild(n, sourceElement, false);
    }

    private static boolean isStringLiteral(SourceElement sourceElement) {
        SourceLiteralExpression sourceLiteralExpression;
        return sourceElement != null && sourceElement.getSymbolKind() == 53 && (sourceLiteralExpression = (SourceLiteralExpression)sourceElement).getTokenValue() == 14;
    }

    private static boolean isInStringLiteral(BasicEditorPane basicEditorPane, int n, int n2, boolean bl) {
        SourceFile sourceFile = JavaSmartClipboard.getSourceFile(basicEditorPane);
        if (sourceFile != null) {
            SourceElement sourceElement = JavaSmartClipboard.findDeepestChild(n, (SourceElement)sourceFile);
            SourceElement sourceElement2 = JavaSmartClipboard.findDeepestChild(n2, (SourceElement)sourceFile);
            if (JavaSmartClipboard.isStringLiteral(sourceElement) && JavaSmartClipboard.isStringLiteral(sourceElement2)) {
                if (sourceElement == sourceElement2) {
                    return true;
                }
                if (!bl) {
                    SourceExpression sourceExpression;
                    SourceElement sourceElement3 = sourceElement.getParent();
                    if (sourceElement2.getParent() == sourceElement3 && sourceElement3.getSymbolKind() == 51 && (sourceExpression = (SourceExpression)sourceElement3).getOperatorCode() == 1) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static int isInComment(BasicEditorPane basicEditorPane, int n) {
        SourceElement sourceElement;
        SourceFile sourceFile = JavaSmartClipboard.getSourceFile(basicEditorPane);
        int n2 = 0;
        if (sourceFile != null && (sourceElement = JavaSmartClipboard.findDeepestChild(n, (SourceElement)sourceFile, true)) != null && sourceElement.getSymbolKind() == 70) {
            SourceLexicalComment sourceLexicalComment = (SourceLexicalComment)sourceElement;
            switch (sourceLexicalComment.getTokenValue()) {
                case 24: {
                    if (n < sourceLexicalComment.getStartOffset() + 2) break;
                    n2 = 1;
                    break;
                }
                case 25: {
                    if (n < sourceLexicalComment.getStartOffset() + 2 || n > sourceLexicalComment.getEndOffset() - 2) break;
                    n2 = 2;
                }
            }
        }
        return n2;
    }

    private static String escapeString(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\\r");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    if (n == string.length() - 1) break;
                    stringBuffer.append("\" + \n");
                    stringBuffer.append(string2);
                    stringBuffer.append("\"");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String unEscapeString(String string) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (bl) {
                switch (c) {
                    case '\\': {
                        stringBuffer.append('\\');
                        break;
                    }
                    case '\"': {
                        stringBuffer.append('\"');
                        break;
                    }
                    case 'r': {
                        stringBuffer.append('\r');
                        break;
                    }
                    case 'n': {
                        stringBuffer.append('\n');
                        break;
                    }
                    default: {
                        stringBuffer.append('\\');
                        stringBuffer.append(c);
                    }
                }
                bl = false;
            } else if (c == '\\') {
                bl = true;
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String singleLineComment(String string, String string2, String string3) {
        int n = string2.length();
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r", true);
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("\n") || string4.equals("\r")) {
                stringBuffer.append(string4);
            } else {
                if (!bl) {
                    stringBuffer.append(string3);
                    stringBuffer.append("// ");
                }
                if (string4.startsWith(string2)) {
                    stringBuffer.append(string4.substring(n));
                } else {
                    stringBuffer.append(string4.trim());
                }
            }
            bl = false;
        }
        return stringBuffer.toString();
    }

    private static void paste(BasicEditorPane basicEditorPane, BasicDocument basicDocument) {
        int n = basicEditorPane.getSelectionStart();
        int n2 = basicEditorPane.getSelectionEnd();
        Toolkit toolkit = basicEditorPane.getToolkit();
        if (basicEditorPane.isEditable() && basicEditorPane.isEnabled()) {
            Clipboard clipboard = toolkit.getSystemClipboard();
            Transferable transferable = clipboard.getContents(basicEditorPane);
            if (transferable != null) {
                try {
                    Object object = transferable.getTransferData(DataFlavor.stringFlavor);
                    String string = (String)object;
                    int n3 = JavaSmartClipboard.isInComment(basicEditorPane, n);
                    boolean bl = JavaSmartClipboard.isEscapeStringEnabled(basicEditorPane) && JavaSmartClipboard.isInStringLiteral(basicEditorPane, n, n2, false);
                    int n4 = string.indexOf(10);
                    boolean bl2 = JavaSmartClipboard.isIndentEnabled(basicEditorPane);
                    if (bl2 && n4 == -1) {
                        TextBuffer textBuffer = basicDocument.getTextBuffer();
                        int n5 = basicDocument.getLength();
                        int n6 = n2;
                        while (bl2 && n6 < n5) {
                            char c = textBuffer.getChar(n6);
                            if (c == '\n') break;
                            if (!Character.isSpaceChar(c)) {
                                bl2 = false;
                            }
                            ++n6;
                        }
                    }
                    BundleHelper bundleHelper = EditorProperties.getEditorBundle();
                    UndoableEditCommand undoableEditCommand = new UndoableEditCommand(bundleHelper.getString("UNDO_PASTE"), CodeEditor.getContext((BasicEditorPane)basicEditorPane));
                    TextBuffer textBuffer = basicDocument.getTextBuffer();
                    textBuffer.writeLock();
                    try {
                        UndoableEdit undoableEdit;
                        String string2;
                        if (n3 == 0 && JavaSmartClipboard.isImportsEnabled(basicEditorPane)) {
                            String[] stringArray = new String[1];
                            n = JavaSmartClipboard.checkAddImports(basicEditorPane, basicDocument, n, n2, transferable, undoableEditCommand, stringArray);
                            if (stringArray[0] != null) {
                                string = stringArray[0];
                            }
                        }
                        if (bl2 && (string2 = SourceFormatUtilities.getSmartIndentation(JavaSmartClipboard.getSourceFile(basicEditorPane), basicEditorPane, n)).length() != 0) {
                            String string3 = JavaSmartClipboard.getOldIndent(basicEditorPane, string);
                            n = basicEditorPane.getLineStartOffset(basicEditorPane.getLineFromOffset(n));
                            string = SourceFormatUtilities.reIndent(basicEditorPane, string, string3, string2);
                            basicEditorPane.setSelectionStart(n);
                        }
                        if (n3 == 1) {
                            int n7 = basicEditorPane.getLineStartOffset(basicEditorPane.getLineFromOffset(n));
                            String string4 = basicDocument.getText(n7, n - n7);
                            int n8 = 0;
                            while (Character.isSpaceChar(string4.charAt(n8))) {
                                ++n8;
                            }
                            int n9 = 0;
                            while (n9 < string.length() && string.charAt(n9) == ' ') {
                                ++n9;
                            }
                            String string5 = string.substring(0, n9);
                            string = JavaSmartClipboard.singleLineComment(string, string5, string4.substring(0, n8));
                        }
                        if (bl) {
                            string = JavaSmartClipboard.escapeString(string, SourceFormatUtilities.getIdentFromOffset(basicEditorPane, n));
                        }
                        n = basicEditorPane.getSelectionStart();
                        n2 = basicEditorPane.getSelectionEnd();
                        if (n2 > n && (undoableEdit = textBuffer.remove(n, n2 - n)) != null) {
                            undoableEditCommand.addEdit(undoableEdit);
                        }
                        undoableEdit = textBuffer.insert(n, string.toCharArray());
                        undoableEditCommand.addEdit(undoableEdit);
                    }
                    finally {
                        textBuffer.writeUnlock();
                    }
                    if (undoableEditCommand.hasEdits()) {
                        CommandProcessor commandProcessor = CommandProcessor.getInstance();
                        commandProcessor.invoke((Command)undoableEditCommand);
                    }
                }
                catch (Exception exception) {
                    toolkit.beep();
                }
            }
        } else {
            toolkit.beep();
        }
    }

    private static String getOldIndent(BasicEditorPane basicEditorPane, String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length() && (string.charAt(n2) == ' ' || string.charAt(n2) == '\t' || string.charAt(n2) == '\n')) {
            if (string.charAt(n2) == '\n') {
                n = ++n2;
                continue;
            }
            ++n2;
        }
        int n3 = n;
        while (n3 < string.length() && (string.charAt(n3) == ' ' || string.charAt(n3) == '\t')) {
            ++n3;
        }
        int n4 = (Integer)basicEditorPane.getProperty("tab-size");
        String string2 = SourceFormatUtilities.tabToSpace(string.substring(n, n3), n4);
        return string2;
    }

    private static int checkAddImports(BasicEditorPane basicEditorPane, BasicDocument basicDocument, int n, int n2, Transferable transferable, UndoableEditCommand undoableEditCommand, String[] stringArray) {
        block11: {
            try {
                SourceFile sourceFile;
                RichBuffer richBuffer = (RichBuffer)transferable.getTransferData(RichBuffer.FLAVOR);
                String[] stringArray2 = richBuffer.getFQClassNames();
                if (stringArray2.length == 0 || JavaSmartClipboard.isInImportRegion(sourceFile = JavaSmartClipboard.getSourceFile(basicEditorPane), n)) break block11;
                HashSet hashSet = new HashSet();
                HashSet hashSet2 = new HashSet();
                RichBuffer.getAddedImports(basicDocument, stringArray2, sourceFile, hashSet, hashSet2);
                if (hashSet2.size() != 0) {
                    String[] stringArray3 = hashSet2.toArray(new String[hashSet2.size()]);
                    stringArray[0] = richBuffer.getFqText(stringArray3);
                }
                if (hashSet.size() <= 0) break block11;
                TextBuffer textBuffer = sourceFile.getTextBuffer();
                OffsetMark offsetMark = textBuffer.addOffsetMark(n);
                OffsetMark offsetMark2 = textBuffer.addOffsetMark(n2);
                boolean bl = false;
                SourceTransaction sourceTransaction = sourceFile.beginTransaction();
                try {
                    for (String string : hashSet) {
                        JavaTransformContext.addImport((SourceFile)sourceFile, (String)string);
                    }
                    bl = true;
                }
                finally {
                    if (bl) {
                        UndoableEdit undoableEdit = sourceTransaction.commit();
                        if (undoableEdit != null) {
                            undoableEditCommand.addEdit(undoableEdit);
                        }
                    } else {
                        sourceTransaction.abort();
                    }
                }
                n = offsetMark.getOffset();
                n2 = offsetMark2.getOffset();
                textBuffer.removeOffsetMark(offsetMark);
                textBuffer.removeOffsetMark(offsetMark2);
                basicEditorPane.setSelectionStart(n);
                basicEditorPane.setSelectionEnd(n2);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return n;
    }

    private static boolean isInImportRegion(SourceFile sourceFile, int n) {
        List list = sourceFile.getSourceClasses();
        int n2 = 0;
        while (n2 < list.size()) {
            SourceElement sourceElement = (SourceElement)list.get(n2);
            if (n >= sourceElement.getStartOffset()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static void setClipboardContents(BasicEditorPane basicEditorPane, Transferable transferable) {
        Toolkit toolkit = basicEditorPane.getToolkit();
        Clipboard clipboard = toolkit.getSystemClipboard();
        ClipboardStack.pushCurrentClipboard();
        int n = 0;
        while (n < 5) {
            try {
                clipboard.setContents(transferable, null);
                return;
            }
            catch (IllegalStateException illegalStateException) {
                try {
                    Thread.sleep(50);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n;
            }
        }
    }

    JavaSmartClipboard() {
    }
}

