/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.editing;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.text.NumberFormat;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.controls.CustomColorChoice;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.EditorProperties;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.editing.JavaUnderlinesOptions;

public final class JavaUnderlinesOptionsPanel
extends DefaultTraversablePanel
implements ChangeListener,
ApplyListener {
    private JCheckBox checkbox_underlineErrors;
    private CustomColorChoice colorChoice_syntaxErrors;
    private JCheckBox checkbox_underlineSemantic;
    private CustomColorChoice colorChoice_semanticErrors;
    private JCheckBox checkbox_classSeparators;
    private CustomColorChoice colorChoice_classSeparators;
    private JCheckBox checkbox_memberSeparators;
    private CustomColorChoice colorChoice_memberSeparators;
    private JCheckBox checkbox_exceptAdjacentFields;
    private JSlider slider_smallFileDelay;
    private JLabel label_smallFileDelayFeedback;
    private JSlider slider_largeFileDelay;
    private JLabel label_largeFileDelayFeedback;
    private NumberFormat numberFormatter;

    public JavaUnderlinesOptionsPanel() {
        this.setHelpID("f1_idedidesetunderlines_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext traversableContext) {
        JavaUnderlinesOptions javaUnderlinesOptions = this.findOptions(traversableContext);
        this.loadSettingsFrom(javaUnderlinesOptions);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        JavaUnderlinesOptions javaUnderlinesOptions = this.findOptions(traversableContext);
        this.saveSettingsTo(javaUnderlinesOptions);
    }

    private JavaUnderlinesOptions findOptions(TraversableContext traversableContext) {
        JavaUnderlinesOptions javaUnderlinesOptions = (JavaUnderlinesOptions)traversableContext.find("JavaUnderlinesOptions");
        return javaUnderlinesOptions;
    }

    public void apply(ApplyEvent applyEvent) {
        TraversableContext traversableContext = (TraversableContext)applyEvent.getSource();
        JavaUnderlinesOptions javaUnderlinesOptions = this.findOptions(traversableContext);
        JavaUnderlinesOptionsPanel.applyOptions(javaUnderlinesOptions);
    }

    public void cancel(ApplyEvent applyEvent) {
    }

    public static void applyOptions(JavaUnderlinesOptions javaUnderlinesOptions) {
        EditorProperties editorProperties = EditorProperties.getProperties();
        int n = javaUnderlinesOptions.getSyntaxErrorColor();
        int n2 = javaUnderlinesOptions.getSemanticErrorColor();
        int n3 = javaUnderlinesOptions.getClassSeparatorColor();
        int n4 = javaUnderlinesOptions.getMemberSeparatorColor();
    }

    void loadSettingsFrom(JavaUnderlinesOptions javaUnderlinesOptions) {
        boolean bl = javaUnderlinesOptions.getUnderlineErrors();
        int n = javaUnderlinesOptions.getSyntaxErrorColor();
        boolean bl2 = javaUnderlinesOptions.getUnderlineSemantic();
        int n2 = javaUnderlinesOptions.getSemanticErrorColor();
        boolean bl3 = javaUnderlinesOptions.getShowClassSeparators();
        int n3 = javaUnderlinesOptions.getClassSeparatorColor();
        boolean bl4 = javaUnderlinesOptions.getShowMemberSeparators();
        int n4 = javaUnderlinesOptions.getMemberSeparatorColor();
        boolean bl5 = javaUnderlinesOptions.getSkipAdjacentFields();
        int n5 = javaUnderlinesOptions.getSmallFileUpdateDelay();
        int n6 = javaUnderlinesOptions.getLargeFileUpdateDelay();
        this.checkbox_underlineErrors.setSelected(bl);
        this.colorChoice_syntaxErrors.setClosestSelectedColor(new Color(n));
        this.checkbox_underlineSemantic.setSelected(bl2);
        this.colorChoice_semanticErrors.setClosestSelectedColor(new Color(n2));
        this.checkbox_classSeparators.setSelected(bl3);
        this.colorChoice_classSeparators.setClosestSelectedColor(new Color(n3));
        this.checkbox_memberSeparators.setSelected(bl4);
        this.colorChoice_memberSeparators.setClosestSelectedColor(new Color(n4));
        this.checkbox_exceptAdjacentFields.setSelected(bl5);
        int n7 = Math.min(Math.max(n5 / 100, 1), 50);
        this.slider_smallFileDelay.setValue(n7);
        n7 = Math.min(Math.max(n6 / 100, 1), 50);
        this.slider_largeFileDelay.setValue(n7);
    }

    void saveSettingsTo(JavaUnderlinesOptions javaUnderlinesOptions) throws TraversalException {
        boolean bl = this.checkbox_underlineErrors.isSelected();
        int n = this.colorChoice_syntaxErrors.getSelectedColor().getRGB();
        boolean bl2 = this.checkbox_underlineSemantic.isSelected();
        int n2 = this.colorChoice_semanticErrors.getSelectedColor().getRGB();
        boolean bl3 = this.checkbox_classSeparators.isSelected();
        int n3 = this.colorChoice_classSeparators.getSelectedColor().getRGB();
        boolean bl4 = this.checkbox_memberSeparators.isSelected();
        int n4 = this.colorChoice_memberSeparators.getSelectedColor().getRGB();
        boolean bl5 = this.checkbox_exceptAdjacentFields.isSelected();
        int n5 = this.slider_smallFileDelay.getValue() * 100;
        int n6 = this.slider_largeFileDelay.getValue() * 100;
        javaUnderlinesOptions.setUnderlineErrors(bl);
        javaUnderlinesOptions.setSyntaxErrorColor(n);
        javaUnderlinesOptions.setUnderlineSemantic(bl2);
        javaUnderlinesOptions.setSemanticErrorColor(n2);
        javaUnderlinesOptions.setShowClassSeparators(bl3);
        javaUnderlinesOptions.setClassSeparatorColor(n3);
        javaUnderlinesOptions.setShowMemberSeparators(bl4);
        javaUnderlinesOptions.setMemberSeparatorColor(n4);
        javaUnderlinesOptions.setSkipAdjacentFields(bl5);
        javaUnderlinesOptions.setSmallFileUpdateDelay(n5);
        javaUnderlinesOptions.setLargeFileUpdateDelay(n6);
    }

    private void initializeComponent() {
        this.numberFormatter = NumberFormat.getNumberInstance();
        this.numberFormatter.setMinimumFractionDigits(1);
        this.numberFormatter.setMaximumFractionDigits(1);
        String string = JavaArb.getString(224);
        this.checkbox_underlineErrors = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_underlineErrors, (String)string);
        string = JavaArb.getString(225);
        JLabel jLabel = new JLabel();
        this.colorChoice_syntaxErrors = new CustomColorChoice();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.colorChoice_syntaxErrors, (String)string);
        Component[] componentArray = new Component[]{jLabel, this.colorChoice_syntaxErrors};
        ItemSelectableTracker itemSelectableTracker = new ItemSelectableTracker((ItemSelectable)this.checkbox_underlineErrors, componentArray);
        string = JavaArb.getString(226);
        this.checkbox_underlineSemantic = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_underlineSemantic, (String)string);
        string = JavaArb.getString(227);
        JLabel jLabel2 = new JLabel();
        this.colorChoice_semanticErrors = new CustomColorChoice();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.colorChoice_semanticErrors, (String)string);
        componentArray = new Component[]{jLabel2, this.colorChoice_semanticErrors};
        itemSelectableTracker = new ItemSelectableTracker((ItemSelectable)this.checkbox_underlineSemantic, componentArray);
        string = JavaArb.getString(228);
        JLabel jLabel3 = new JLabel(string);
        string = JavaArb.getString(229);
        this.checkbox_classSeparators = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_classSeparators, (String)string);
        string = JavaArb.getString(230);
        JLabel jLabel4 = new JLabel();
        this.colorChoice_classSeparators = new CustomColorChoice();
        ResourceUtils.resLabel((JLabel)jLabel4, (Component)this.colorChoice_classSeparators, (String)string);
        string = JavaArb.getString(231);
        this.checkbox_memberSeparators = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_memberSeparators, (String)string);
        string = JavaArb.getString(232);
        JLabel jLabel5 = new JLabel();
        this.colorChoice_memberSeparators = new CustomColorChoice();
        ResourceUtils.resLabel((JLabel)jLabel5, (Component)this.colorChoice_memberSeparators, (String)string);
        string = JavaArb.getString(233);
        this.checkbox_exceptAdjacentFields = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_exceptAdjacentFields, (String)string);
        componentArray = new Component[]{jLabel4, this.colorChoice_classSeparators};
        itemSelectableTracker = new ItemSelectableTracker((ItemSelectable)this.checkbox_classSeparators, componentArray);
        componentArray = new Component[]{jLabel5, this.colorChoice_memberSeparators, this.checkbox_exceptAdjacentFields};
        itemSelectableTracker = new ItemSelectableTracker((ItemSelectable)this.checkbox_memberSeparators, componentArray);
        string = JavaArb.getString(234);
        JLabel jLabel6 = new JLabel(string);
        string = JavaArb.getString(235);
        JLabel jLabel7 = new JLabel();
        this.slider_smallFileDelay = new JSlider(1, 50, 1);
        ResourceUtils.resLabel((JLabel)jLabel7, (Component)this.slider_smallFileDelay, (String)string);
        this.label_smallFileDelayFeedback = new JLabel();
        this.slider_smallFileDelay.addChangeListener(this);
        string = JavaArb.getString(236);
        JLabel jLabel8 = new JLabel();
        this.slider_largeFileDelay = new JSlider(1, 50, 1);
        ResourceUtils.resLabel((JLabel)jLabel8, (Component)this.slider_largeFileDelay, (String)string);
        this.label_largeFileDelayFeedback = new JLabel();
        this.slider_largeFileDelay.addChangeListener(this);
        String string2 = this.numberFormatter.format(0.1);
        String string3 = this.numberFormatter.format(5.0);
        JLabel jLabel9 = new JLabel(string2);
        JLabel jLabel10 = new JLabel(string3);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>(5);
        hashtable.put(new Integer(1), jLabel9);
        hashtable.put(new Integer(50), jLabel10);
        this.slider_largeFileDelay.setLabelTable(hashtable);
        this.slider_largeFileDelay.setPaintLabels(true);
        this.slider_largeFileDelay.setPaintTicks(true);
        this.slider_largeFileDelay.setMajorTickSpacing(10);
        this.slider_largeFileDelay.setMinorTickSpacing(1);
        this.slider_largeFileDelay.setSnapToTicks(true);
        jLabel9 = new JLabel(string2);
        jLabel10 = new JLabel(string3);
        hashtable = new Hashtable(5);
        hashtable.put(new Integer(1), jLabel9);
        hashtable.put(new Integer(50), jLabel10);
        this.slider_smallFileDelay.setLabelTable(hashtable);
        this.slider_smallFileDelay.setPaintLabels(true);
        this.slider_smallFileDelay.setPaintTicks(true);
        this.slider_smallFileDelay.setMajorTickSpacing(10);
        this.slider_smallFileDelay.setMinorTickSpacing(1);
        this.slider_smallFileDelay.setSnapToTicks(true);
        this.slider_smallFileDelay.setValue(10);
        this.slider_largeFileDelay.setValue(10);
        Insets insets = new Insets(2, 5, 2, 5);
        Insets insets2 = new Insets(2, 30, 2, 5);
        Insets insets3 = new Insets(2, 55, 2, 5);
        Insets insets4 = new Insets(0, 0, 0, 0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, insets, 0, 0);
        jPanel.add((Component)this.checkbox_underlineErrors, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0);
        jPanel.add((Component)this.colorChoice_syntaxErrors, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, insets4, 0, 0);
        jPanel.add(Box.createGlue(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0);
        jPanel.add((Component)this.checkbox_underlineSemantic, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0);
        jPanel.add((Component)this.colorChoice_semanticErrors, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel2.add((Component)this.checkbox_classSeparators, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel2.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0);
        jPanel2.add((Component)this.colorChoice_classSeparators, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(3, 1, 1, 2, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel2.add(Box.createGlue(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel2.add((Component)this.checkbox_memberSeparators, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel2.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0);
        jPanel2.add((Component)this.colorChoice_memberSeparators, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 17, 0, insets3, 0, 0);
        jPanel2.add((Component)this.checkbox_exceptAdjacentFields, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 1, insets, 0, 0);
        jPanel3.add((Component)jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel3.add((Component)jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, insets3, 0, 0);
        jPanel3.add((Component)this.label_smallFileDelayFeedback, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 1, 1, 2, 1.0, 0.0, 17, 2, insets, 0, 0);
        jPanel3.add((Component)this.slider_smallFileDelay, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel3.add((Component)jLabel8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, insets3, 0, 0);
        jPanel3.add((Component)this.label_largeFileDelayFeedback, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 3, 1, 2, 1.0, 0.0, 17, 2, insets, 0, 0);
        jPanel3.add((Component)this.slider_largeFileDelay, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, insets4, 0, 0);
        this.add(jPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, insets4, 0, 0);
        this.add(Box.createVerticalStrut(10), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 1, insets4, 0, 0);
        this.add(jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 1, insets4, 0, 0);
        this.add(Box.createVerticalStrut(10), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 1, insets4, 0, 0);
        this.add(jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 17, 1, insets4, 0, 0);
        this.add(Box.createGlue(), gridBagConstraints);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JLabel jLabel;
        JSlider jSlider;
        Object object = changeEvent.getSource();
        if (object == this.slider_smallFileDelay) {
            jSlider = this.slider_smallFileDelay;
            jLabel = this.label_smallFileDelayFeedback;
        } else if (object == this.slider_largeFileDelay) {
            jSlider = this.slider_largeFileDelay;
            jLabel = this.label_largeFileDelayFeedback;
        } else {
            throw new IllegalStateException("unknown source");
        }
        float f = (float)jSlider.getValue() / 10.0f;
        String string = JavaArb.format(237, this.numberFormatter.format(f));
        jLabel.setText(string);
        jSlider.setToolTipText(string);
    }
}

