/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.editing;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import java.util.Comparator;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.config.ClientSetting;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.JavaParserPlugin;
import oracle.jdevimpl.java.editing.JavaUnderlinesOptions;

public final class JavaUnderlinesPlugin
implements JavaParserPlugin.HelperClient,
JavaConstants,
EditorPlugin {
    private BasicEditorPane editor;
    private HighlightLayer highlightLayer;
    protected static final String PROPERTY_UNDERLINES = "java-underlines";
    protected static final String CLASS_SEPARATOR_STYLE = "java-class-separator-style";
    protected static final String MEMBER_SEPARATOR_STYLE = "java-member-separator-style";
    private static final HighlightStyle classStyle;
    private static final HighlightStyle memberStyle;
    private static final Comparator MEMBER_SYMBOL_COMPARATOR;

    public void notifyCompileScheduled() {
    }

    public void notifyParseFinished(JavaManager javaManager, SourceFile sourceFile, int n, int n2) {
    }

    public void notifyCompileFinished(JavaManager javaManager, SourceFile sourceFile, int n, int n2) {
        this.performHighlights(n, sourceFile);
    }

    public void install(BasicEditorPane basicEditorPane) {
        this.editor = basicEditorPane;
        JavaParserPlugin.attachHelperClient(basicEditorPane, this);
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
        JavaParserPlugin.detachHelperClient(basicEditorPane, this);
        if (this.highlightLayer != null) {
            basicEditorPane.destroyHighlightLayer(this.highlightLayer);
            this.highlightLayer = null;
        }
        this.editor = null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("highlight-registry") || string.equals("highlight-changed")) {
            // empty if block
        }
    }

    private TextBuffer getTextBuffer() {
        return this.getDocument().getTextBuffer();
    }

    private BasicDocument getDocument() {
        return (BasicDocument)this.editor.getDocument();
    }

    public static JavaUnderlinesOptions getOptions() {
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)"oracle.jdeveloper");
        JavaUnderlinesOptions javaUnderlinesOptions = (JavaUnderlinesOptions)clientSetting.getData("JavaUnderlinesOptions");
        return javaUnderlinesOptions;
    }

    private void performHighlights(int n, SourceFile sourceFile) {
        TextBuffer textBuffer = this.getTextBuffer();
        textBuffer.readLock();
        try {
            int n2 = textBuffer.getChangeId();
            if (n != n2) {
                textBuffer.readUnlock();
                return;
            }
            this.clearHighlights();
            this.addSeparators(sourceFile);
        }
        finally {
            textBuffer.readUnlock();
        }
    }

    private void clearHighlights() {
        if (this.highlightLayer != null) {
            this.highlightLayer.removeAllHighlights();
        }
    }

    private HighlightLayer getHighlightLayer() {
        if (this.highlightLayer == null) {
            this.highlightLayer = this.editor.createHighlightLayer();
        }
        return this.highlightLayer;
    }

    private void addSeparators(SourceFile sourceFile) {
        boolean bl = JavaUnderlinesPlugin.getOptions().getShowClassSeparators();
        boolean bl2 = JavaUnderlinesPlugin.getOptions().getShowMemberSeparators();
        if (!bl && !bl2) {
            return;
        }
        if (sourceFile != null) {
            HighlightLayer highlightLayer = this.getHighlightLayer();
            SourceClass[] sourceClassArray = sourceFile.getSourceClasses().toArray(SourceClass.EMPTY_ARRAY);
            int n = sourceClassArray != null ? sourceClassArray.length : 0;
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                SourceClass sourceClass = sourceClassArray[n2];
                if (bl2 && sourceClass != null) {
                    this.addSeparators(sourceClass);
                }
                nArray[n2] = JavaUnderlinesPlugin.getStartOffset((SourceElement)sourceClass);
                ++n2;
            }
            if (!bl) {
                return;
            }
            Arrays.sort(nArray);
            TextBuffer textBuffer = this.getTextBuffer();
            LineMap lineMap = textBuffer.getLineMap();
            boolean bl3 = true;
            int n3 = -1;
            int n4 = 0;
            while (n4 < n) {
                if (nArray[n4] != -1) {
                    if (bl3) {
                        bl3 = false;
                    } else if (n3 != nArray[n4]) {
                        n3 = nArray[n4];
                        int n5 = nArray[n4];
                        int n6 = lineMap.getLineFromOffset(n5) - 1;
                        if (n6 > 0) {
                            highlightLayer.addLineHighlight(classStyle, n6);
                        }
                    }
                }
                ++n4;
            }
        }
    }

    private void addSeparators(SourceClass sourceClass) {
        boolean bl = JavaUnderlinesPlugin.getOptions().getSkipAdjacentFields();
        if (sourceClass != null) {
            HighlightLayer highlightLayer = this.getHighlightLayer();
            SourceMember[] sourceMemberArray = sourceClass.getSourceMembers().toArray(SourceMember.EMPTY_ARRAY);
            int n = sourceMemberArray == null ? 0 : sourceMemberArray.length;
            int n2 = 0;
            while (n2 < n) {
                SourceMember sourceMember = sourceMemberArray[n2];
                if (sourceMember != null && sourceMember.getSymbolKind() == 3) {
                    this.addSeparators((SourceClass)sourceMember);
                }
                ++n2;
            }
            Arrays.sort(sourceMemberArray, MEMBER_SYMBOL_COMPARATOR);
            TextBuffer textBuffer = this.getTextBuffer();
            LineMap lineMap = textBuffer.getLineMap();
            boolean bl2 = true;
            SourceMember sourceMember = null;
            int n3 = 0;
            while (n3 < n) {
                int n4;
                SourceMember sourceMember2 = sourceMemberArray[n3];
                if (sourceMember2 != null && (n4 = JavaUnderlinesPlugin.getStartOffset((SourceElement)sourceMember2)) != -1) {
                    if (bl2) {
                        bl2 = false;
                        sourceMember = sourceMember2;
                    } else if (sourceMember2 instanceof SourceFieldDeclaration && sourceMember instanceof SourceFieldDeclaration && bl) {
                        sourceMember = sourceMember2;
                    } else {
                        int n5 = lineMap.getLineFromOffset(n4) - 1;
                        if (n5 > 0) {
                            highlightLayer.addLineHighlight(memberStyle, n5);
                        }
                        sourceMember = sourceMember2;
                    }
                }
                ++n3;
            }
        }
    }

    private static int getStartOffset(SourceElement sourceElement) {
        if (sourceElement != null) {
            return sourceElement.getStartOffset();
        }
        return -1;
    }

    static {
        MEMBER_SYMBOL_COMPARATOR = new 1();
        String string = JavaArb.getString(117);
        classStyle = CodeEditor.createHighlightStyle((String)CLASS_SEPARATOR_STYLE, (String)string, (int)50, null, null, (int)0, (int)5, (Color)Color.LIGHT_GRAY);
        string = JavaArb.getString(116);
        memberStyle = CodeEditor.createHighlightStyle((String)MEMBER_SEPARATOR_STYLE, (String)string, (int)50, null, null, (int)0, (int)9, (Color)Color.LIGHT_GRAY);
    }

    static int maS$getStartOffset(SourceElement sourceElement) {
        return JavaUnderlinesPlugin.getStartOffset(sourceElement);
    }

    public static final class 1
    implements Comparator {
        public int compare(Object object, Object object2) {
            SourceMember sourceMember = (SourceMember)object;
            SourceMember sourceMember2 = (SourceMember)object2;
            int n = JavaUnderlinesPlugin.maS$getStartOffset((SourceElement)sourceMember);
            int n2 = JavaUnderlinesPlugin.maS$getStartOffset((SourceElement)sourceMember2);
            return n - n2;
        }

        public boolean equals(Object object) {
            return false;
        }
    }
}

