/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.explorer;

import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.util.FastStringWriter;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceHasModifiers;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.jdeveloper.icons.JavaIcons;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.explorer.AccessComparator;
import oracle.jdevimpl.java.explorer.ConstructorElement;
import oracle.jdevimpl.java.explorer.ElementTypeComparator;
import oracle.jdevimpl.java.explorer.ExtendsElement;
import oracle.jdevimpl.java.explorer.FieldElement;
import oracle.jdevimpl.java.explorer.FolderElement;
import oracle.jdevimpl.java.explorer.GroupFolder;
import oracle.jdevimpl.java.explorer.ImplementsElement;
import oracle.jdevimpl.java.explorer.JavaCodeElement;
import oracle.jdevimpl.java.explorer.JavaExplorerOptions;
import oracle.jdevimpl.java.explorer.LeafElement;
import oracle.jdevimpl.java.explorer.LeafElementComparator;
import oracle.jdevimpl.java.explorer.MethodElement;
import oracle.jdevimpl.java.explorer.ModifierElement;

public class ClassElement
extends ModifierElement {
    private String packageName;

    ClassElement(SourceClass sourceClass, JavaExplorerOptions javaExplorerOptions) {
        super((SourceHasModifiers)sourceClass, javaExplorerOptions);
        this.$init$();
        LeafElement[] leafElementArray = this.buildChildren(sourceClass, javaExplorerOptions);
        this.setChildren(leafElementArray);
        if (sourceClass.isMemberClass()) {
            this.setExpandedDefault(false);
        } else {
            int n = this.getModifiers();
            boolean bl = Modifier.isPublic(n);
            int n2 = javaExplorerOptions.getExpandedFolders();
            int n3 = bl ? 4 : 8;
            boolean bl2 = (n2 & n3) != 0;
            this.setExpandedDefault(bl2);
        }
    }

    public String getPackageName() {
        ClassElement classElement = this.getEnclosingClass();
        if (classElement != null) {
            return classElement.getPackageName();
        }
        return this.packageName;
    }

    void $init$() {
        this.packageName = null;
    }

    protected void setPackageName(String string) {
        this.packageName = string;
    }

    protected LeafElement[] buildChildren(SourceClass sourceClass, JavaExplorerOptions javaExplorerOptions) {
        int n = javaExplorerOptions.getShowFilter();
        boolean bl = ClassElement.isBitSet(n, 8);
        boolean bl2 = ClassElement.isBitSet(n, 32);
        boolean bl3 = ClassElement.isBitSet(n, 128);
        boolean bl4 = ClassElement.isBitSet(n, 64);
        boolean bl5 = ClassElement.isBitSet(n, 256);
        int n2 = javaExplorerOptions.getHideFilter();
        boolean bl6 = ClassElement.isBitSet(n2, 1);
        boolean bl7 = ClassElement.isBitSet(n2, 2);
        boolean bl8 = ClassElement.isBitSet(n2, 4);
        boolean bl9 = ClassElement.isBitSet(n2, 8);
        boolean bl10 = ClassElement.isBitSet(n2, 16);
        boolean bl11 = ClassElement.isBitSet(n2, 32);
        boolean bl12 = ClassElement.isBitSet(n2, 64);
        ArrayList<ModifierElement> arrayList = new ArrayList<ModifierElement>();
        try {
            block10: for (SourceMember sourceMember : sourceClass.getSourceMembers()) {
                if (sourceMember == null || sourceMember instanceof SourceHasName && ClassElement.getName((SourceHasName)sourceMember).equals("")) continue;
                int n3 = ClassElement.getModifiers((SourceHasModifiers)sourceMember);
                if (bl6 && Modifier.isPublic(n3) || bl7 && Modifier.isProtected(n3) || bl8 && Modifier.isPrivate(n3) || bl10 && Modifier.isFinal(n3) || bl12 && Modifier.isStatic(n3) || bl9 && !Modifier.isPublic(n3) && !Modifier.isProtected(n3) && !Modifier.isPrivate(n3) || bl11 && !Modifier.isStatic(n3)) continue;
                int n4 = sourceMember.getSymbolKind();
                try {
                    switch (n4) {
                        case 6: {
                            if (!bl2) continue block10;
                            arrayList.add(new ConstructorElement((SourceMethod)sourceMember, javaExplorerOptions));
                            break;
                        }
                        case 19: {
                            if (!bl3) continue block10;
                            arrayList.add(new MethodElement((SourceMethod)sourceMember, javaExplorerOptions));
                            break;
                        }
                        case 7: 
                        case 9: {
                            if (!bl4) continue block10;
                            for (SourceFieldVariable sourceFieldVariable : ((SourceFieldDeclaration)sourceMember).getVariables()) {
                                if (sourceFieldVariable == null || ClassElement.getName((SourceHasName)sourceFieldVariable).equals("")) continue;
                                arrayList.add(new FieldElement(sourceFieldVariable, javaExplorerOptions));
                            }
                            continue block10;
                        }
                        case 3: {
                            if (!bl5) continue block10;
                            arrayList.add(new ClassElement((SourceClass)sourceMember, javaExplorerOptions));
                            break;
                        }
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        for (Object e : arrayList) {
            if (!(e instanceof JavaCodeElement)) continue;
            ((JavaCodeElement)e).setEnclosingClass(this);
        }
        Comparator comparator = ClassElement.getSorter(javaExplorerOptions);
        if (comparator != null) {
            Collections.sort(arrayList, comparator);
        }
        List list = this.buildGroups(arrayList, javaExplorerOptions);
        ArrayList<JavaCodeElement> arrayList2 = new ArrayList<JavaCodeElement>();
        if (bl) {
            if (sourceClass.isClass()) {
                SourceTypeReference sourceTypeReference = sourceClass.getSourceSuperclass();
                if (sourceTypeReference != null) {
                    ExtendsElement extendsElement = new ExtendsElement(sourceTypeReference);
                    extendsElement.setEnclosingClass(this);
                    arrayList2.add(extendsElement);
                }
                for (SourceTypeReference sourceTypeReference2 : sourceClass.getSourceInterfaces()) {
                    if (sourceTypeReference2 == null) continue;
                    ImplementsElement implementsElement = new ImplementsElement(sourceTypeReference2);
                    implementsElement.setEnclosingClass(this);
                    arrayList2.add(implementsElement);
                }
            } else {
                for (SourceTypeReference sourceTypeReference : sourceClass.getSourceInterfaces()) {
                    if (sourceTypeReference == null) continue;
                    ExtendsElement extendsElement = new ExtendsElement(sourceTypeReference);
                    extendsElement.setEnclosingClass(this);
                    arrayList2.add(extendsElement);
                }
            }
            if (javaExplorerOptions.getSortOrder() != 0) {
                Collections.sort(arrayList2, new LeafElementComparator());
            }
        }
        arrayList2.addAll(list);
        int n5 = arrayList2.size();
        return arrayList2.toArray(new LeafElement[n5]);
    }

    private List buildGroups(List list, JavaExplorerOptions javaExplorerOptions) {
        return this.buildGroups(list, javaExplorerOptions, javaExplorerOptions.getGroupOrder(), 0);
    }

    private List buildGroups(List list, JavaExplorerOptions javaExplorerOptions, int[] nArray, int n) {
        int n2;
        int n3 = n2 = nArray != null ? nArray.length : 0;
        if (n2 == 0 || n >= n2) {
            return list;
        }
        int n4 = nArray[n];
        int n5 = n + 1;
        List list2 = list;
        switch (n4) {
            case 1: {
                list2 = this.buildStaticInstanceGroups(list, javaExplorerOptions);
                break;
            }
            case 2: {
                list2 = this.buildTypeGroups(list, javaExplorerOptions);
                break;
            }
            case 3: {
                list2 = this.buildAccessGroups(list, javaExplorerOptions);
                break;
            }
            default: {
                return this.buildGroups(list, javaExplorerOptions, nArray, n5);
            }
        }
        int n6 = list2.size();
        int n7 = 0;
        while (n7 < n6) {
            FolderElement folderElement = (FolderElement)list2.get(n7);
            LeafElement[] leafElementArray = folderElement.getChildrenArray();
            List<LeafElement> list3 = Arrays.asList(leafElementArray);
            List list4 = this.buildGroups(list3, javaExplorerOptions, nArray, n5);
            int n8 = list4.size();
            LeafElement[] leafElementArray2 = list4.toArray(new LeafElement[n8]);
            folderElement.setChildren(leafElementArray2);
            ++n7;
        }
        return list2;
    }

    private List buildStaticInstanceGroups(List list, JavaExplorerOptions javaExplorerOptions) {
        ArrayList<ModifierElement> arrayList = new ArrayList<ModifierElement>();
        ArrayList<ModifierElement> arrayList2 = new ArrayList<ModifierElement>();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            ModifierElement modifierElement = (ModifierElement)list.get(n2);
            int n3 = modifierElement.getModifiers();
            if (Modifier.isStatic(n3)) {
                arrayList.add(modifierElement);
            } else {
                arrayList2.add(modifierElement);
            }
            ++n2;
        }
        GroupFolder groupFolder = this.buildGroupFolder(77, arrayList, javaExplorerOptions, 1);
        GroupFolder groupFolder2 = this.buildGroupFolder(78, arrayList2, javaExplorerOptions, 2);
        arrayList.clear();
        this.addIfNotNull(groupFolder2, arrayList);
        this.addIfNotNull(groupFolder, arrayList);
        return arrayList;
    }

    private List buildTypeGroups(List list, JavaExplorerOptions javaExplorerOptions) {
        ArrayList<ModifierElement> arrayList = new ArrayList<ModifierElement>();
        ArrayList<ModifierElement> arrayList2 = new ArrayList<ModifierElement>();
        ArrayList<ModifierElement> arrayList3 = new ArrayList<ModifierElement>();
        ArrayList<ModifierElement> arrayList4 = new ArrayList<ModifierElement>();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            ModifierElement modifierElement = (ModifierElement)list.get(n2);
            if (modifierElement instanceof ConstructorElement) {
                arrayList.add(modifierElement);
            } else if (modifierElement instanceof MethodElement) {
                arrayList2.add(modifierElement);
            } else if (modifierElement instanceof FieldElement) {
                arrayList3.add(modifierElement);
            } else if (modifierElement instanceof ClassElement) {
                arrayList4.add(modifierElement);
            }
            ++n2;
        }
        GroupFolder groupFolder = this.buildGroupFolder(79, arrayList, javaExplorerOptions, 256);
        GroupFolder groupFolder2 = this.buildGroupFolder(80, arrayList2, javaExplorerOptions, 512);
        GroupFolder groupFolder3 = this.buildGroupFolder(81, arrayList3, javaExplorerOptions, 1024);
        GroupFolder groupFolder4 = this.buildGroupFolder(82, arrayList4, javaExplorerOptions, 2048);
        arrayList.clear();
        this.addIfNotNull(groupFolder, arrayList);
        this.addIfNotNull(groupFolder2, arrayList);
        this.addIfNotNull(groupFolder3, arrayList);
        this.addIfNotNull(groupFolder4, arrayList);
        return arrayList;
    }

    private List buildAccessGroups(List list, JavaExplorerOptions javaExplorerOptions) {
        ArrayList<ModifierElement> arrayList = new ArrayList<ModifierElement>();
        ArrayList<ModifierElement> arrayList2 = new ArrayList<ModifierElement>();
        ArrayList<ModifierElement> arrayList3 = new ArrayList<ModifierElement>();
        ArrayList<ModifierElement> arrayList4 = new ArrayList<ModifierElement>();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            ModifierElement modifierElement = (ModifierElement)list.get(n2);
            int n3 = modifierElement.getModifiers();
            if (Modifier.isPublic(n3)) {
                arrayList.add(modifierElement);
            } else if (Modifier.isProtected(n3)) {
                arrayList2.add(modifierElement);
            } else if (Modifier.isPrivate(n3)) {
                arrayList3.add(modifierElement);
            } else {
                arrayList4.add(modifierElement);
            }
            ++n2;
        }
        GroupFolder groupFolder = this.buildGroupFolder(83, arrayList, javaExplorerOptions, 16);
        GroupFolder groupFolder2 = this.buildGroupFolder(84, arrayList2, javaExplorerOptions, 32);
        GroupFolder groupFolder3 = this.buildGroupFolder(85, arrayList3, javaExplorerOptions, 64);
        GroupFolder groupFolder4 = this.buildGroupFolder(86, arrayList4, javaExplorerOptions, 128);
        arrayList4.clear();
        this.addIfNotNull(groupFolder, arrayList4);
        this.addIfNotNull(groupFolder2, arrayList4);
        this.addIfNotNull(groupFolder4, arrayList4);
        this.addIfNotNull(groupFolder3, arrayList4);
        return arrayList4;
    }

    private void addIfNotNull(Object object, List list) {
        if (object != null) {
            list.add(object);
        }
    }

    private GroupFolder buildGroupFolder(int n, List list, JavaExplorerOptions javaExplorerOptions, int n2) {
        int n3 = list.size();
        if (n3 == 0) {
            return null;
        }
        LeafElement[] leafElementArray = list.toArray(new LeafElement[n3]);
        boolean bl = ClassElement.isBitSet(javaExplorerOptions.getExpandedGroups(), n2);
        String string = JavaArb.getString(n);
        GroupFolder groupFolder = new GroupFolder(string, string, null, leafElementArray, bl);
        return groupFolder;
    }

    private static Comparator getSorter(JavaExplorerOptions javaExplorerOptions) {
        int n = javaExplorerOptions.getSortOrder();
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return new LeafElementComparator();
            }
            case 3: {
                return new AccessComparator();
            }
        }
        return new ElementTypeComparator();
    }

    protected String getDisplayText(SourceElement sourceElement) {
        FastStringWriter fastStringWriter = ClassElement.allocFastStringBuffer();
        sourceElement.print((PrintWriter)fastStringWriter, 1);
        String string = fastStringWriter.toString();
        ClassElement.freeFastStringBuffer(fastStringWriter);
        return string;
    }

    protected String getTooltipText(SourceElement sourceElement) {
        FastStringWriter fastStringWriter = ClassElement.allocFastStringBuffer();
        sourceElement.print((PrintWriter)fastStringWriter, 2);
        String string = fastStringWriter.toString();
        ClassElement.freeFastStringBuffer(fastStringWriter);
        return string;
    }

    protected Icon getIcon(SourceElement sourceElement) {
        SourceClass sourceClass = (SourceClass)sourceElement;
        return JavaIcons.getIcon(sourceClass.isClass() ? 0 : 1);
    }

    public boolean mayHaveChildren() {
        return true;
    }
}

