/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.explorer;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.swing.JMenuItem;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.util.AccessibleUtils;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.ideimpl.explorer.BaseTreeExplorer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.WeakPropertyChangeSupport;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.explorer.CodeElement;
import oracle.jdevimpl.java.explorer.ExpansionTracker;
import oracle.jdevimpl.java.explorer.LeafElement;

public abstract class CodeExplorer
extends BaseTreeExplorer
implements PropertyChangeListener,
Observer,
Controller,
ContextMenuListener {
    protected LeafElement rootElement;
    protected Node node;
    protected Project project;
    protected TextBuffer textBuffer;
    protected boolean isObserving;
    protected ExpansionTracker tracker;
    private static IdeAction gotoSourceAction;
    private static JMenuItem gotoSourceMenuItem;
    private boolean rebuildScheduled;
    private static WeakPropertyChangeSupport changeSupport;

    public CodeExplorer() {
        this.$init$();
        this.rootElement = this.getEmptyRootElement();
        this.node = null;
        CodeExplorer.initializeActions();
        CodeExplorer.addPropertyChangeListener(this);
    }

    void $init$() {
        this.isObserving = false;
        this.rebuildScheduled = false;
    }

    protected LeafElement getEmptyRootElement() {
        return new LeafElement("", "", null);
    }

    private static void initializeActions() {
        if (gotoSourceAction == null) {
            String string = JavaArb.getString(219);
            int n = StringUtils.getMnemonicKeyCode((String)string);
            string = StringUtils.stripMnemonic((String)string);
            gotoSourceAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"ojje.GotoSource"), null, (String)string, (String)IdeMainWindow.ACTION_CATEGORY_SEARCH, (Integer)new Integer(n), (ArrayResourceBundle)JavaArb.getInstance(), (int)220, null, (boolean)false);
            gotoSourceMenuItem = Ide.getMenubar().createMenuItem((ToggleAction)gotoSourceAction);
        }
    }

    public void setContext(Context context) {
        super.setContext(context);
        if (context != null && context.getNode() != null) {
            Node node = context.getNode();
            String string = node.getShortLabel();
            String string2 = this.getAccessibleTitle(string);
            if (this.tree != null) {
                AccessibleUtils.updateAccessibleName((Accessible)this.tree, (String)string2, (boolean)true);
            }
        }
    }

    protected abstract String getAccessibleTitle(String var1);

    public synchronized Element annotate(Context context) {
        if (context == null || context.getNode() == null) {
            this.rootElement = this.getEmptyRootElement();
            this.node = null;
            this.project = null;
        }
        if (context.getNode() == this.node && context.getProject() == this.project) {
            return this.rootElement;
        }
        this.stopObserving();
        this.node = context.getNode();
        this.project = context.getProject();
        if (this.tracker != null) {
            this.tracker.clearExpansionState();
        }
        this.rootElement = this.getEmptyRootElement();
        this.scheduleRebuild();
        return this.rootElement;
    }

    public void stateChanged(int n) {
        View view = this.owner();
        ContextMenu contextMenu = view != null ? view.getContextMenu() : null;
        switch (n) {
            case 0: {
                if (!this.isObserving()) {
                    this.startObserving();
                }
                this.scheduleRebuild();
                if (contextMenu == null) break;
                contextMenu.addContextMenuListener((ContextMenuListener)this);
                break;
            }
            case 2: {
                CodeExplorer.removePropertyChangeListener(this);
            }
            case 1: {
                if (contextMenu != null) {
                    contextMenu.removeContextMenuListener((ContextMenuListener)this);
                }
                this.stopObserving();
            }
        }
    }

    private boolean isObserving() {
        return this.isObserving;
    }

    private void startObserving() {
        if (!this.isObserving && this.node != null) {
            if (this.node instanceof TextNode) {
                this.textBuffer = ((TextNode)this.node).acquireTextBuffer();
            }
            this.node.attach((Observer)this);
            this.isObserving = true;
        }
    }

    private void stopObserving() {
        if (this.isObserving && this.node != null) {
            this.node.detach((Observer)this);
            this.isObserving = false;
            if (this.node instanceof TextNode) {
                ((TextNode)this.node).releaseTextBuffer();
                this.textBuffer = null;
            }
        }
    }

    public void update(Object object, UpdateMessage updateMessage) {
        int n;
        if (this.isObserving() && this.node != null && object == this.node && (n = updateMessage.getMessageID()) != UpdateMessage.CHILD_REMOVED && n != UpdateMessage.CHILD_ADDED && n != UpdateMessage.PROPERTY_SET && n != UpdateMessage.OBJECT_RENAMED && n != UpdateMessage.CHILD_RENAMED && n != UpdateMessage.OBJECT_OPENED && n != UpdateMessage.OBJECT_CLOSED && n != UpdateMessage.OBJECT_CLOSING && n != UpdateMessage.ATTRIBUTE_CHANGED) {
            this.scheduleRebuild();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleRebuild() {
        CodeExplorer codeExplorer = this;
        synchronized (codeExplorer) {
            if (this.rebuildScheduled) {
                return;
            }
            this.rebuildScheduled = true;
        }
        1 var1_2 = new 1();
        SwingUtilities.invokeLater(var1_2);
    }

    protected void buildElementTree(Node node) {
        if (this.tracker == null) {
            this.tracker = new ExpansionTracker((JTree)this.tree);
        }
        this.tracker.stopTracking();
        Object object = this.tracker.getExpansionState();
        this.tracker.clearExpansionState();
        this.rootElement = this.buildElementTreeImpl(node);
        this.setRoot(this.rootElement);
        TNode tNode = this.getRoot();
        this.populateNodes(tNode);
        this.tracker.expandDefaultExpansion();
        this.tracker.startTracking();
        this.tracker.restoreExpansion(object);
    }

    protected abstract LeafElement buildElementTreeImpl(Node var1);

    protected void populateNodes(TNode tNode) {
        this.addChildren(tNode);
        int n = tNode.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            TNode tNode2 = (TNode)tNode.getChildAt(n2);
            if (!tNode2.isLeaf()) {
                this.populateNodes(tNode2);
            }
            ++n2;
        }
    }

    public void menuWillShow(ContextMenu contextMenu) {
        CodeElement codeElement;
        Context context = contextMenu.getContext();
        Element element = context.getElement();
        if (element == null) {
            return;
        }
        if (element instanceof CodeElement && (codeElement = (CodeElement)element).getStartOffset() != -1) {
            gotoSourceAction.addController((Controller)this);
            gotoSourceAction.setEnabled(true);
            contextMenu.add((Component)gotoSourceMenuItem, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        Element element;
        if (context != null && context.getView() == this.owner() && (element = context.getElement()) instanceof CodeElement) {
            CodeElement codeElement = (CodeElement)element;
            int n = codeElement.getStartOffset();
            int n2 = codeElement.getEndOffset();
            if (n != -1 && n2 != -1) {
                Context context2 = this.getContext();
                Context context3 = new Context(context2);
                Node node = context3.getNode();
                context3.setElement((Element)node);
                context3.setSelection(new Element[]{node});
                context3.setEvent(null);
                NavigationManager navigationManager = NavigationManager.getNavigationManager();
                OffsetNavigationPoint offsetNavigationPoint = new OffsetNavigationPoint(context3, n, n2 - n);
                try {
                    if (navigationManager != null) {
                        navigationManager.navigateTo((NavigationPoint)offsetNavigationPoint);
                    } else {
                        offsetNavigationPoint.navigate();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    public Controller getController() {
        return this;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction == gotoSourceAction) {
            this.handleDefaultAction(context);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return ideAction == gotoSourceAction;
    }

    protected static void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    protected static void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    static {
        changeSupport = new WeakPropertyChangeSupport(CodeExplorer.class);
    }

    public static void firePropertyChange(String string) {
        changeSupport.firePropertyChange(string, (Object)Boolean.TRUE, (Object)Boolean.FALSE);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.propertyChange(propertyChangeEvent.getPropertyName());
    }

    protected void propertyChange(String string) {
    }

    static void wa$rebuildScheduled(CodeExplorer codeExplorer, boolean bl) {
        codeExplorer.rebuildScheduled = bl;
    }

    public final class 1
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                CodeExplorer.this.buildElementTree(CodeExplorer.this.node);
            }
            catch (Throwable throwable) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    CodeExplorer.wa$rebuildScheduled(CodeExplorer.this, false);
                }
                throw throwable;
            }
            1 var3_3 = this;
            synchronized (var3_3) {
                CodeExplorer.wa$rebuildScheduled(CodeExplorer.this, false);
            }
        }
    }
}

