/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.explorer;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreePath;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Element;
import oracle.jdevimpl.java.explorer.FolderElement;
import oracle.jdevimpl.java.explorer.LeafElement;

public class ExpansionTracker
implements TreeExpansionListener {
    private List collapsedList = new ArrayList();
    private List expandedList = new ArrayList();
    private JTree tree;
    private boolean isTracking = false;

    public ExpansionTracker(JTree jTree) {
        this.tree = jTree;
    }

    public void startTracking() {
        if (!this.isTracking) {
            this.tree.addTreeExpansionListener(this);
            this.isTracking = true;
        }
    }

    public void stopTracking() {
        if (this.isTracking) {
            this.tree.removeTreeExpansionListener(this);
            this.isTracking = false;
        }
    }

    protected void handleExpansionChange(TreeExpansionEvent treeExpansionEvent, boolean bl) {
        Element element;
        TreePath treePath = treeExpansionEvent.getPath();
        if (treePath.getPathCount() == 1) {
            return;
        }
        TNode tNode = (TNode)treePath.getLastPathComponent();
        if (tNode != null && (element = tNode.getData()) instanceof FolderElement) {
            FolderElement folderElement = (FolderElement)element;
            boolean bl2 = folderElement.getExpandedDefault();
            if (bl2) {
                if (bl) {
                    this.removeRepresentationFrom(treePath, this.collapsedList);
                } else {
                    this.addRepresentationTo(treePath, this.collapsedList);
                }
            } else if (bl) {
                this.addRepresentationTo(treePath, this.expandedList);
                this.removeRepresentationFrom(treePath, this.collapsedList);
            } else {
                this.removeRepresentationFrom(treePath, this.expandedList);
                this.addRepresentationTo(treePath, this.collapsedList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearExpansionState() {
        ExpansionTracker expansionTracker = this;
        synchronized (expansionTracker) {
            this.collapsedList = new ArrayList();
            this.expandedList = new ArrayList();
        }
    }

    public Object getExpansionState() {
        return new List[]{this.collapsedList, this.expandedList};
    }

    public void restoreExpansion(Object object) {
        if (object instanceof List[]) {
            List[] listArray = (List[])object;
            List list = listArray[1];
            List list2 = listArray[0];
            this.restoreState(true, list);
            this.restoreState(false, list2);
        }
    }

    private void restoreState(boolean bl, List list) {
        int n = list != null ? list.size() : 0;
        int n2 = 0;
        while (n2 < n) {
            String[] stringArray = (String[])list.get(n2);
            TreePath treePath = this.locateMatchingPath(stringArray);
            if (treePath != null) {
                if (bl) {
                    this.tree.expandPath(treePath);
                } else {
                    this.tree.collapsePath(treePath);
                }
            }
            ++n2;
        }
    }

    private TreePath locateMatchingPath(String[] stringArray) {
        TNode tNode = (TNode)this.tree.getModel().getRoot();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            TNode tNode2;
            block3: {
                String string = stringArray[n2];
                int n3 = tNode.getChildCount();
                int n4 = 0;
                while (n4 < n3) {
                    tNode2 = (TNode)tNode.getChildAt(n4);
                    LeafElement leafElement = (LeafElement)tNode2.getData();
                    if (!leafElement.getShortLabel().equals(string)) {
                        ++n4;
                        continue;
                    }
                    break block3;
                }
                return null;
            }
            tNode = tNode2;
            ++n2;
        }
        return new TreePath(tNode.getPath());
    }

    private void addRepresentationTo(TreePath treePath, List list) {
        String[] stringArray = this.getRepresentationFor(treePath);
        list.add(stringArray);
    }

    private void removeRepresentationFrom(TreePath treePath, List list) {
        String[] stringArray = this.getRepresentationFor(treePath);
        int n = stringArray.length;
        int n2 = list.size();
        int n3 = 0;
        while (n3 < n2) {
            String[] stringArray2 = (String[])list.get(n3);
            if (stringArray2.length == n) {
                boolean bl = true;
                int n4 = 0;
                while (n4 < n) {
                    if (!stringArray[n4].equals(stringArray2[n4])) {
                        bl = false;
                        break;
                    }
                    ++n4;
                }
                if (bl) {
                    list.remove(n3);
                    break;
                }
            }
            ++n3;
        }
    }

    private String[] getRepresentationFor(TreePath treePath) {
        Object[] objectArray = treePath.getPath();
        int n = objectArray.length;
        String[] stringArray = new String[n - 1];
        int n2 = 1;
        while (n2 < n) {
            TNode tNode = (TNode)objectArray[n2];
            stringArray[n2 - 1] = ((LeafElement)tNode.getData()).getShortLabel();
            ++n2;
        }
        return stringArray;
    }

    public void expandDefaultExpansion() {
        TNode tNode = (TNode)this.tree.getModel().getRoot();
        this.expandDefaultExpansion(tNode);
    }

    protected boolean expandDefaultExpansion(TNode tNode) {
        boolean bl = false;
        int n = tNode.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            TNode tNode2 = (TNode)tNode.getChildAt(n2);
            boolean bl2 = this.expandDefaultExpansion(tNode2);
            Element element = tNode2.getData();
            if (element != null && element instanceof FolderElement) {
                FolderElement folderElement = (FolderElement)element;
                boolean bl3 = folderElement.getExpandedDefault();
                if (!bl2) {
                    if (bl3) {
                        TreePath treePath = new TreePath(tNode2.getPath());
                        this.tree.expandPath(treePath);
                        bl = true;
                    }
                } else {
                    if (!bl3) {
                        TreePath treePath = new TreePath(tNode2.getPath());
                        this.tree.collapsePath(treePath);
                    }
                    bl = true;
                }
            }
            ++n2;
        }
        return bl;
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        this.handleExpansionChange(treeExpansionEvent, true);
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        this.handleExpansionChange(treeExpansionEvent, false);
    }
}

