/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.explorer;

import java.io.PrintWriter;
import javax.swing.Icon;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.FastStringWriter;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.jdevimpl.java.explorer.ClassElement;
import oracle.jdevimpl.java.explorer.CodeElement;

public abstract class JavaCodeElement
extends CodeElement
implements JavaConstants {
    private static FastStringWriter sharedStringBuffer = null;
    private String symbolName;
    private ClassElement enclosingClass;

    JavaCodeElement(SourceElement sourceElement) {
        this.$init$();
        this.setSymbolName(this.getSymbolName(sourceElement));
        this.setDisplayText(this.getDisplayText(sourceElement));
        this.setTooltipText(this.getTooltipText(sourceElement));
        this.setIcon(this.getIcon(sourceElement));
        this.setStartOffset(this.getStartOffset(sourceElement));
        this.setEndOffset(this.getEndOffset(sourceElement));
    }

    protected static synchronized FastStringWriter allocFastStringBuffer() {
        if (sharedStringBuffer == null) {
            return new FastStringWriter(100);
        }
        FastStringWriter fastStringWriter = sharedStringBuffer;
        sharedStringBuffer = null;
        return fastStringWriter;
    }

    protected static synchronized void freeFastStringBuffer(FastStringWriter fastStringWriter) {
        if (fastStringWriter != null && sharedStringBuffer == null) {
            fastStringWriter.getBuffer().setLength(0);
            sharedStringBuffer = fastStringWriter;
        }
    }

    protected static String format(String string, String string2) {
        int n = string.indexOf("{0}");
        if (n == -1) {
            return string;
        }
        FastStringWriter fastStringWriter = JavaCodeElement.allocFastStringBuffer();
        FastStringBuffer fastStringBuffer = fastStringWriter.getBuffer();
        fastStringBuffer.append(string);
        fastStringBuffer.removeCharsAt(n, 3);
        fastStringBuffer.insert(n, string2);
        String string3 = fastStringBuffer.toString();
        JavaCodeElement.freeFastStringBuffer(fastStringWriter);
        return string3;
    }

    public String getSymbolName() {
        return this.symbolName;
    }

    protected void setSymbolName(String string) {
        this.symbolName = string;
    }

    protected static String getName(SourceHasName sourceHasName) {
        if (sourceHasName != null) {
            return sourceHasName.getName();
        }
        return "";
    }

    protected static String getName(SourceName sourceName) {
        if (sourceName != null) {
            String string = sourceName.getValue();
            return string;
        }
        return "";
    }

    protected static void print(SourceElement sourceElement, PrintWriter printWriter) {
        if (sourceElement == null) {
            return;
        }
        sourceElement.print(printWriter, 0);
    }

    protected static void print(SourceElement sourceElement, PrintWriter printWriter, int n) {
        if (sourceElement == null) {
            return;
        }
        sourceElement.print(printWriter, n);
    }

    protected static boolean isBitSet(int n, int n2) {
        return (n & n2) == n2;
    }

    protected String getSymbolName(SourceElement sourceElement) {
        if (sourceElement == null) {
            return "";
        }
        if (sourceElement instanceof SourceTypeReference) {
            SourceTypeReference sourceTypeReference = (SourceTypeReference)sourceElement;
            FastStringWriter fastStringWriter = JavaCodeElement.allocFastStringBuffer();
            JavaCodeElement.print((SourceElement)sourceTypeReference, (PrintWriter)fastStringWriter);
            String string = fastStringWriter.toString();
            JavaCodeElement.freeFastStringBuffer(fastStringWriter);
            return string;
        }
        if (sourceElement instanceof SourceHasName) {
            SourceHasName sourceHasName = (SourceHasName)sourceElement;
            return JavaCodeElement.getName(sourceHasName);
        }
        if (sourceElement instanceof SourceName) {
            SourceName sourceName = (SourceName)sourceElement;
            return JavaCodeElement.getName(sourceName);
        }
        return "";
    }

    protected String getDisplayText(SourceElement sourceElement) {
        String string = this.getSymbolName(sourceElement);
        if (string != null) {
            return string;
        }
        throw new IllegalStateException("unnameable: " + sourceElement.toString());
    }

    protected abstract String getTooltipText(SourceElement var1);

    protected abstract Icon getIcon(SourceElement var1);

    protected int getStartOffset(SourceElement sourceElement) {
        SourceHasName sourceHasName;
        SourceName sourceName;
        if (sourceElement == null) {
            return -1;
        }
        if (sourceElement instanceof SourceHasName && (sourceName = (sourceHasName = (SourceHasName)sourceElement).getNameElement()) != null) {
            sourceElement = sourceName;
        }
        return sourceElement.getStartOffset();
    }

    protected int getEndOffset(SourceElement sourceElement) {
        SourceHasName sourceHasName;
        SourceName sourceName;
        if (sourceElement == null) {
            return -1;
        }
        if (sourceElement instanceof SourceHasName && (sourceName = (sourceHasName = (SourceHasName)sourceElement).getNameElement()) != null) {
            sourceElement = sourceName;
        }
        return sourceElement.getEndOffset();
    }

    public ClassElement getEnclosingClass() {
        return this.enclosingClass;
    }

    void setEnclosingClass(ClassElement classElement) {
        this.enclosingClass = classElement;
    }

    void $init$() {
        this.enclosingClass = null;
    }

    public boolean mayHaveChildren() {
        return false;
    }
}

