/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.explorer;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.config.ClientSetting;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.icons.JavaIcons;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.browse.JavaBrowseSupport2;
import oracle.jdevimpl.java.explorer.ClassElement;
import oracle.jdevimpl.java.explorer.CodeElement;
import oracle.jdevimpl.java.explorer.CodeExplorer;
import oracle.jdevimpl.java.explorer.ExtendsElement;
import oracle.jdevimpl.java.explorer.ImplementsElement;
import oracle.jdevimpl.java.explorer.ImportElement;
import oracle.jdevimpl.java.explorer.JavaCodeElement;
import oracle.jdevimpl.java.explorer.JavaExplorerOptions;
import oracle.jdevimpl.java.explorer.JavaRootFolder;
import oracle.jdevimpl.java.explorer.LeafElement;

public class JavaExplorer
extends CodeExplorer {
    private static IdeAction gotoClassAction;
    private static JMenuItem gotoClassMenuItem;
    private static IdeAction browseHierarchyAction;
    private static JMenuItem browseHierarchyMenuItem;
    private static IdeAction sortLocationAction;
    private static IdeAction sortAlphaAction;
    private static IdeAction sortTypeAction;
    private static IdeAction sortAccessAction;
    private static final String SORT_GROUP_NAME = "JavaExplorerSortGroup";
    public static int SORT_LOCATION_CMD_ID;
    public static int SORT_ALPHA_CMD_ID;
    public static int SORT_TYPE_CMD_ID;
    public static int SORT_ACCESS_CMD_ID;
    private static IdeAction showMethodsAction;
    private static IdeAction showFieldsAction;
    private static IdeAction showStaticsAction;
    private static IdeAction showPublicOnlyAction;
    public static int SHOW_METHODS_CMD_ID;
    public static int SHOW_FIELDS_CMD_ID;
    public static int SHOW_STATICS_CMD_ID;
    public static int SHOW_PUBLIC_ONLY_CMD_ID;
    private IdeAction[] localSortActions;
    private IdeAction localShowMethodsAction;
    private IdeAction localShowFieldsAction;
    private IdeAction localShowStaticsAction;
    private IdeAction localShowPublicOnlyAction;
    private List localButtons;

    public JavaExplorer() {
        this.initializeJavaActions();
    }

    private static void initializeToolbarActions() {
        SORT_LOCATION_CMD_ID = Ide.findOrCreateCmdID((String)"JavaExplorerSortLocation");
        sortLocationAction = IdeAction.get((int)SORT_LOCATION_CMD_ID, null, (String)JavaArb.getString(87), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, null, (ArrayResourceBundle)JavaArb.getInstance(), (int)91, null, (boolean)true);
        SORT_ALPHA_CMD_ID = Ide.findOrCreateCmdID((String)"JavaExplorerSortAlpha");
        sortAlphaAction = IdeAction.get((int)SORT_ALPHA_CMD_ID, null, (String)JavaArb.getString(88), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, null, (ArrayResourceBundle)JavaArb.getInstance(), (int)92, null, (boolean)true);
        SORT_TYPE_CMD_ID = Ide.findOrCreateCmdID((String)"JavaExplorerSortType");
        sortTypeAction = IdeAction.get((int)SORT_TYPE_CMD_ID, null, (String)JavaArb.getString(89), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, null, (ArrayResourceBundle)JavaArb.getInstance(), (int)93, null, (boolean)true);
        SORT_ACCESS_CMD_ID = Ide.findOrCreateCmdID((String)"JavaExplorerSortAccess");
        sortAccessAction = IdeAction.get((int)SORT_ACCESS_CMD_ID, null, (String)JavaArb.getString(90), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, null, (ArrayResourceBundle)JavaArb.getInstance(), (int)94, null, (boolean)true);
        sortLocationAction.setState(false);
        sortAlphaAction.setState(false);
        sortTypeAction.setState(false);
        sortAccessAction.setState(false);
        sortLocationAction.putValue("Radio", (Object)Boolean.TRUE);
        sortAlphaAction.putValue("Radio", (Object)Boolean.TRUE);
        sortTypeAction.putValue("Radio", (Object)Boolean.TRUE);
        sortAccessAction.putValue("Radio", (Object)Boolean.TRUE);
        sortLocationAction.putValue("RadioGroupName", (Object)SORT_GROUP_NAME);
        sortAlphaAction.putValue("RadioGroupName", (Object)SORT_GROUP_NAME);
        sortTypeAction.putValue("RadioGroupName", (Object)SORT_GROUP_NAME);
        sortAccessAction.putValue("RadioGroupName", (Object)SORT_GROUP_NAME);
        SHOW_METHODS_CMD_ID = Ide.findOrCreateCmdID((String)"JavaExplorerShowMethods");
        showMethodsAction = IdeAction.get((int)SHOW_METHODS_CMD_ID, null, (String)JavaArb.getString(96), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, null, (ArrayResourceBundle)JavaIcons.getInstance(), (int)3, null, (boolean)true);
        SHOW_FIELDS_CMD_ID = Ide.findOrCreateCmdID((String)"JavaExplorerShowFields");
        showFieldsAction = IdeAction.get((int)SHOW_FIELDS_CMD_ID, null, (String)JavaArb.getString(97), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, null, (ArrayResourceBundle)JavaIcons.getInstance(), (int)2, null, (boolean)true);
        SHOW_STATICS_CMD_ID = Ide.findOrCreateCmdID((String)"JavaExplorerShowStatics");
        showStaticsAction = IdeAction.get((int)SHOW_STATICS_CMD_ID, null, (String)JavaArb.getString(98), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, null, (ArrayResourceBundle)JavaArb.getInstance(), (int)103, null, (boolean)true);
        SHOW_PUBLIC_ONLY_CMD_ID = Ide.findOrCreateCmdID((String)"JavaExplorerShowPublicOnly");
        showPublicOnlyAction = IdeAction.get((int)SHOW_PUBLIC_ONLY_CMD_ID, null, (String)JavaArb.getString(99), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, null, (ArrayResourceBundle)JavaArb.getInstance(), (int)104, null, (boolean)true);
    }

    private synchronized void initializeJavaActions() {
        if (gotoClassMenuItem == null) {
            String string = JavaArb.getString(221);
            int n = StringUtils.getMnemonicKeyCode((String)string);
            string = StringUtils.stripMnemonic((String)string);
            gotoClassAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"ojje.GotoClass"), null, (String)string, (String)IdeMainWindow.ACTION_CATEGORY_SEARCH, (Integer)new Integer(n), (ArrayResourceBundle)JavaArb.getInstance(), (int)222, null, (boolean)false);
            gotoClassMenuItem = Ide.getMenubar().createMenuItem((ToggleAction)gotoClassAction);
            String string2 = JavaArb.getString(347);
            int n2 = StringUtils.getMnemonicKeyCode((String)string2);
            browseHierarchyAction = IdeAction.get((int)Ide.findOrCreateCmdID((String)"ojje.BrowseHierarchy"), null, (String)string2, (String)IdeMainWindow.ACTION_CATEGORY_NAVIGATE, (Integer)new Integer(n2), (ArrayResourceBundle)JavaArb.getInstance(), (int)348, null, (boolean)false);
            browseHierarchyAction.addController((Controller)this);
            browseHierarchyMenuItem = Ide.getMenubar().createMenuItem((ToggleAction)browseHierarchyAction);
            JavaExplorer.initializeToolbarActions();
        }
    }

    protected String getAccessibleTitle(String string) {
        String string2 = JavaArb.format(60, string);
        return string2;
    }

    private static SourceFile parse(TextBuffer textBuffer) {
        SourceFile sourceFile;
        textBuffer.readLock();
        try {
            sourceFile = JavaParser.parse((ReadTextBuffer)textBuffer);
        }
        finally {
            textBuffer.readUnlock();
        }
        return sourceFile;
    }

    private SourceFile getRootSymbol(Node node) {
        Project project = this.project == null ? Ide.getDefaultProject() : this.project;
        JavaManager javaManager = JavaManager.getJavaManager(project);
        SourceFile sourceFile = javaManager.getSourceFile(node.getURL());
        if (sourceFile == null) {
            TextNode textNode = (TextNode)node;
            TextBuffer textBuffer = textNode.acquireTextBuffer();
            sourceFile = JavaExplorer.parse(textBuffer);
        }
        return sourceFile;
    }

    private static JavaExplorerOptions getOptions() {
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)"oracle.jdeveloper");
        JavaExplorerOptions javaExplorerOptions = (JavaExplorerOptions)clientSetting.getData("JavaExplorerOptions");
        if (javaExplorerOptions == null) {
            javaExplorerOptions = new JavaExplorerOptions();
        }
        return javaExplorerOptions;
    }

    protected LeafElement buildElementTreeImpl(Node node) {
        SourceFile sourceFile = this.getRootSymbol(node);
        JavaRootFolder javaRootFolder = new JavaRootFolder(sourceFile, JavaExplorer.getOptions());
        return javaRootFolder;
    }

    private void updateToolbarActions() {
        JavaExplorerOptions javaExplorerOptions = JavaExplorer.getOptions();
        int n = javaExplorerOptions.getSortOrder();
        int n2 = SORT_LOCATION_CMD_ID;
        switch (n) {
            case 1: {
                n2 = SORT_ALPHA_CMD_ID;
                break;
            }
            case 2: {
                n2 = SORT_TYPE_CMD_ID;
                break;
            }
            case 3: {
                n2 = SORT_ACCESS_CMD_ID;
            }
        }
        if (this.localSortActions != null) {
            int n3 = this.localSortActions.length;
            int n4 = 0;
            while (n4 < n3) {
                if (this.localSortActions[n4].getCommandId() == n2) {
                    this.localSortActions[n4].setState(true);
                    break;
                }
                ++n4;
            }
        }
        int n5 = javaExplorerOptions.getShowFilter();
        int n6 = javaExplorerOptions.getHideFilter();
        if (this.localShowMethodsAction != null) {
            int n7 = 160;
            boolean bl = (n5 & n7) == n7;
            this.localShowMethodsAction.setState(bl);
        }
        if (this.localShowFieldsAction != null) {
            int n8 = 64;
            boolean bl = (n5 & n8) == n8;
            this.localShowFieldsAction.setState(bl);
        }
        if (this.localShowStaticsAction != null) {
            int n9 = 64;
            boolean bl = (n6 & n9) == n9 ^ true;
            this.localShowStaticsAction.setState(bl);
        }
        if (this.localShowPublicOnlyAction != null) {
            int n10 = 1;
            int n11 = 14;
            boolean bl = (n6 & n10) == n10 ^ true;
            boolean bl2 = (n6 & n11) == n11;
            this.localShowPublicOnlyAction.setState(bl && bl2);
        }
    }

    private void addToolbarItems() {
        Toolbar toolbar = this.owner().getToolbar();
        if (toolbar != null) {
            if (this.localButtons == null) {
                this.localButtons = new ArrayList();
                IdeAction[] ideActionArray = IdeAction.findGroup((String)SORT_GROUP_NAME);
                int n = ideActionArray.length;
                this.localSortActions = new IdeAction[n];
                int n2 = 0;
                while (n2 < n) {
                    this.localSortActions[n2] = ideActionArray[n2].newLocalAction((View)this);
                    ++n2;
                }
                toolbar.addSeparator();
                this.localButtons.add(toolbar.addMenuButton((ToggleAction[])this.localSortActions));
                this.localShowMethodsAction = showMethodsAction.newLocalAction((View)this);
                this.localShowFieldsAction = showFieldsAction.newLocalAction((View)this);
                this.localShowStaticsAction = showStaticsAction.newLocalAction((View)this);
                this.localShowPublicOnlyAction = showPublicOnlyAction.newLocalAction((View)this);
                this.localButtons.add(toolbar.addToggleButton((ToggleAction)this.localShowMethodsAction));
                this.localButtons.add(toolbar.addToggleButton((ToggleAction)this.localShowFieldsAction));
                this.localButtons.add(toolbar.addToggleButton((ToggleAction)this.localShowStaticsAction));
                this.localButtons.add(toolbar.addToggleButton((ToggleAction)this.localShowPublicOnlyAction));
            } else {
                toolbar.addSeparator();
                int n = this.localButtons.size();
                int n3 = 0;
                while (n3 < n) {
                    toolbar.add((Component)this.localButtons.get(n3));
                    ++n3;
                }
            }
        }
    }

    private void hideToolbarItems() {
        Toolbar toolbar = this.owner().getToolbar();
        if (toolbar != null && this.localButtons != null) {
            int n = this.localButtons.size();
            int n2 = 0;
            while (n2 < n) {
                toolbar.remove((Component)this.localButtons.get(n2));
                ++n2;
            }
        }
    }

    private void removeToolbarItems() {
        this.hideToolbarItems();
        if (this.localButtons != null) {
            int n = this.localButtons.size();
            int n2 = 0;
            while (n2 < n) {
                Object e = this.localButtons.get(n2);
                if (e instanceof AbstractButton) {
                    ((AbstractButton)e).setAction(null);
                }
                ++n2;
            }
            this.localButtons = null;
        }
        this.localSortActions = null;
        this.localShowMethodsAction = null;
        this.localShowFieldsAction = null;
        this.localShowStaticsAction = null;
        this.localShowPublicOnlyAction = null;
    }

    public void stateChanged(int n) {
        super.stateChanged(n);
        switch (n) {
            case 0: {
                this.addToolbarItems();
                this.updateToolbarActions();
                break;
            }
            case 1: {
                this.hideToolbarItems();
                break;
            }
            case 2: {
                this.removeToolbarItems();
            }
        }
    }

    public void menuWillShow(ContextMenu contextMenu) {
        super.menuWillShow(contextMenu);
        Context context = contextMenu.getContext();
        Element element = context.getElement();
        if (element == null) {
            return;
        }
        if (element instanceof CodeElement) {
            boolean bl = element instanceof ExtendsElement || element instanceof ImplementsElement;
            boolean bl2 = element instanceof ImportElement;
            boolean bl3 = element instanceof ClassElement;
            if (bl || bl2) {
                JavaCodeElement javaCodeElement = (JavaCodeElement)element;
                String string = javaCodeElement.getSymbolName();
                if (string.endsWith("*")) {
                    return;
                }
                String string2 = JavaArb.format(221, string);
                string2 = StringUtils.stripMnemonic((String)string2);
                gotoClassAction.putValue("Name", (Object)string2);
                gotoClassAction.addController((Controller)this);
                gotoClassAction.setEnabled(true);
                contextMenu.add((Component)gotoClassMenuItem, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
            }
            if ((bl3 || bl || bl2) && JavaBrowseSupport2.canBrowseHierarchy()) {
                browseHierarchyAction.setEnabled(true);
                contextMenu.add((Component)browseHierarchyMenuItem, JDeveloperMenuConstants.SECTION_NAVIGATE_CTXT_MENU);
            }
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (ideAction == gotoClassAction) {
            Element element = context.getElement();
            if (element instanceof CodeElement) {
                CodeElement codeElement = (CodeElement)element;
                int n2 = codeElement.getEndOffset();
                try {
                    JavaBrowseSupport2.performBrowseSymbolAtOffset(context, n2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }
        if (ideAction == browseHierarchyAction) {
            Element element = context.getElement();
            if (element instanceof CodeElement) {
                CodeElement codeElement = (CodeElement)element;
                int n3 = codeElement.getEndOffset();
                try {
                    JavaBrowseSupport2.performBrowseHierarchyAtOffset(context, n3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }
        if (n == SORT_LOCATION_CMD_ID || n == SORT_ALPHA_CMD_ID || n == SORT_TYPE_CMD_ID || n == SORT_ACCESS_CMD_ID) {
            int n4 = 0;
            if (n == SORT_ALPHA_CMD_ID) {
                n4 = 1;
            } else if (n == SORT_TYPE_CMD_ID) {
                n4 = 2;
            } else if (n == SORT_ACCESS_CMD_ID) {
                n4 = 3;
            }
            JavaExplorerOptions javaExplorerOptions = JavaExplorer.getOptions();
            javaExplorerOptions.setSortOrder(n4);
            this.modifyOptions(javaExplorerOptions);
            return true;
        }
        if (n == SHOW_METHODS_CMD_ID || n == SHOW_FIELDS_CMD_ID) {
            int n5;
            JavaExplorerOptions javaExplorerOptions = JavaExplorer.getOptions();
            int n6 = javaExplorerOptions.getShowFilter();
            boolean bl = ideAction.getState();
            int n7 = n5 = n == SHOW_FIELDS_CMD_ID ? 64 : 160;
            n6 = bl ? (n6 |= n5) : (n6 &= ~n5);
            javaExplorerOptions.setShowFilter(n6);
            this.modifyOptions(javaExplorerOptions);
            return true;
        }
        if (n == SHOW_STATICS_CMD_ID) {
            JavaExplorerOptions javaExplorerOptions = JavaExplorer.getOptions();
            int n8 = javaExplorerOptions.getHideFilter();
            boolean bl = ideAction.getState();
            int n9 = 64;
            n8 = bl ? (n8 &= ~n9) : (n8 |= n9);
            javaExplorerOptions.setHideFilter(n8);
            this.modifyOptions(javaExplorerOptions);
            return true;
        }
        if (n == SHOW_PUBLIC_ONLY_CMD_ID) {
            JavaExplorerOptions javaExplorerOptions = JavaExplorer.getOptions();
            int n10 = javaExplorerOptions.getHideFilter();
            boolean bl = ideAction.getState();
            int n11 = 1;
            int n12 = 14;
            if (bl) {
                n10 &= ~n11;
                n10 |= n12;
            } else {
                n10 &= ~n12;
            }
            javaExplorerOptions.setHideFilter(n10);
            this.modifyOptions(javaExplorerOptions);
            return true;
        }
        return super.handleEvent(ideAction, context);
    }

    public boolean update(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (ideAction == gotoClassAction) {
            return true;
        }
        if (ideAction == browseHierarchyAction) {
            return true;
        }
        if (n == SORT_LOCATION_CMD_ID || n == SORT_ALPHA_CMD_ID || n == SORT_TYPE_CMD_ID || n == SORT_ACCESS_CMD_ID || n == SHOW_METHODS_CMD_ID || n == SHOW_FIELDS_CMD_ID || n == SHOW_STATICS_CMD_ID || n == SHOW_PUBLIC_ONLY_CMD_ID) {
            return true;
        }
        return super.update(ideAction, context);
    }

    protected static void notifyOptionsChanged() {
        2 var0 = new 2();
        IdeUtil.invokeAfterRepaint((Runnable)var0);
    }

    private void modifyOptions(JavaExplorerOptions javaExplorerOptions) {
        if (javaExplorerOptions != null) {
            ClientSetting clientSetting = ClientSetting.findOrCreate((String)"oracle.jdeveloper");
            clientSetting.putData("JavaExplorerOptions", (Copyable)javaExplorerOptions);
        }
        JavaExplorer.notifyOptionsChanged();
    }

    protected void propertyChange(String string) {
        if (string.equals("JavaExplorerOptions")) {
            this.scheduleRebuild();
            1 var2_2 = new 1();
            SwingUtilities.invokeLater(var2_2);
        }
    }

    static void mav$updateToolbarActions(JavaExplorer javaExplorer) {
        javaExplorer.updateToolbarActions();
    }

    public static final class 2
    implements Runnable {
        public void run() {
            CodeExplorer.firePropertyChange("JavaExplorerOptions");
        }
    }

    public final class 1
    implements Runnable {
        public void run() {
            JavaExplorer.mav$updateToolbarActions(JavaExplorer.this);
        }
    }
}

