/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.explorer;

import oracle.javatools.util.Copyable;

public final class JavaExplorerOptions
implements Copyable {
    public static final String KEY_SETTINGS = "JavaExplorerOptions";
    public static final int SORT_NONE = 0;
    public static final int SORT_ALPHABETICAL = 1;
    public static final int SORT_TYPE = 2;
    public static final int SORT_ACCESS = 3;
    private static final int SORT_DEFAULT = 2;
    private int sortOrderOption = 2;
    public static final int FOLDER_ERRORS = 1;
    public static final int FOLDER_IMPORTS = 2;
    public static final int FOLDER_PUBLIC_CLASS = 4;
    public static final int FOLDER_PACKAGE_CLASS = 8;
    public static final int FOLDER_INNER_CLASS = 16;
    private static final int FOLDER_ALL = 31;
    private static final int FOLDER_DEFAULT = 12;
    private int expandedFoldersOption = 12;
    public static final int SHOW_ERRORS = 1;
    public static final int SHOW_PACKAGE = 2;
    public static final int SHOW_IMPORT = 4;
    public static final int SHOW_EXTENDS_IMPLEMENTS = 8;
    public static final int SHOW_CLASS = 16;
    public static final int SHOW_CONSTRUCTOR = 32;
    public static final int SHOW_FIELD = 64;
    public static final int SHOW_METHOD = 128;
    public static final int SHOW_INNER_CLASS = 256;
    private static final int SHOW_ALL = 511;
    private static final int SHOW_DEFAULT = 511;
    private int showFilterOption = 511;
    public static final int HIDE_PUBLIC = 1;
    public static final int HIDE_PROTECTED = 2;
    public static final int HIDE_PRIVATE = 4;
    public static final int HIDE_PACKAGE = 8;
    public static final int HIDE_FINAL = 16;
    public static final int HIDE_INSTANCE = 32;
    public static final int HIDE_STATIC = 64;
    private static final int HIDE_ALL = 127;
    private static final int HIDE_DEFAULT = 0;
    private int hideFilterOption = 0;
    public static final int GROUP_STATIC_INSTANCE = 1;
    public static final int GROUP_TYPE = 2;
    public static final int GROUP_ACCESS = 3;
    private static final int[] GROUP_DEFAULT = new int[0];
    private int[] groupOrderOption = GROUP_DEFAULT;
    public static final int GROUPS_STATIC = 1;
    public static final int GROUPS_INSTANCE = 2;
    public static final int GROUPS_PUBLIC = 16;
    public static final int GROUPS_PROTECTED = 32;
    public static final int GROUPS_PRIVATE = 64;
    public static final int GROUPS_PACKAGE = 128;
    public static final int GROUPS_CONSTRUCTORS = 256;
    public static final int GROUPS_METHODS = 512;
    public static final int GROUPS_FIELDS = 1024;
    public static final int GROUPS_INNER_CLASSES = 2048;
    private static final int GROUPS_ALL = 4083;
    private static final int GROUPS_DEFAULT = 1842;
    private int expandedGroupsOption = 1842;
    private boolean showAccessIconsOption = true;

    public Object copyTo(Object object) {
        JavaExplorerOptions javaExplorerOptions = object != null ? (JavaExplorerOptions)object : new JavaExplorerOptions();
        javaExplorerOptions.sortOrderOption = this.sortOrderOption;
        javaExplorerOptions.expandedFoldersOption = this.expandedFoldersOption;
        javaExplorerOptions.showFilterOption = this.showFilterOption;
        javaExplorerOptions.hideFilterOption = this.hideFilterOption;
        javaExplorerOptions.groupOrderOption = this.groupOrderOption;
        javaExplorerOptions.expandedGroupsOption = this.expandedGroupsOption;
        javaExplorerOptions.showAccessIconsOption = this.showAccessIconsOption;
        return javaExplorerOptions;
    }

    public int getSortOrder() {
        return this.sortOrderOption;
    }

    public void setSortOrder(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            n = 2;
        }
        this.sortOrderOption = n;
    }

    public int getExpandedFolders() {
        return this.expandedFoldersOption;
    }

    public void setExpandedFolders(int n) {
        this.expandedFoldersOption = n & 0x1F;
    }

    public int getShowFilter() {
        return this.showFilterOption;
    }

    public void setShowFilter(int n) {
        this.showFilterOption = n & 0x1FF;
    }

    public int getHideFilter() {
        return this.hideFilterOption;
    }

    public void setHideFilter(int n) {
        this.hideFilterOption = n & 0x7F;
    }

    public int[] getGroupOrder() {
        return this.groupOrderOption;
    }

    public void setGroupOrder(int[] nArray) {
        this.groupOrderOption = nArray;
    }

    public int getExpandedGroups() {
        return this.expandedGroupsOption;
    }

    public void setExpandedGroups(int n) {
        this.expandedGroupsOption = n & 0xFF3;
    }

    public boolean getShowAccessIcons() {
        return this.showAccessIconsOption;
    }

    public void setShowAccessIcons(boolean bl) {
        this.showAccessIconsOption = bl;
    }
}

