/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.explorer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.explorer.JavaExplorer;
import oracle.jdevimpl.java.explorer.JavaExplorerOptions;

public final class JavaExplorerOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private JRadioButton radio_sortNone;
    private JRadioButton radio_sortAlphabetically;
    private JRadioButton radio_sortType;
    private JRadioButton radio_sortAccess;
    private JCheckBox checkbox_expandErrors;
    private JCheckBox checkbox_expandImports;
    private JCheckBox checkbox_expandPublicClasses;
    private JCheckBox checkbox_expandPackageClasses;
    private JCheckBox checkbox_expandInnerClasses;
    private JCheckBox checkbox_showAccessIcons;

    public JavaExplorerOptionsPanel() {
        this.setHelpID("f1_idedidesetjavastructure_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext traversableContext) {
        JavaExplorerOptions javaExplorerOptions = this.findOptions(traversableContext);
        this.loadSettingsFrom(javaExplorerOptions);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        JavaExplorerOptions javaExplorerOptions = this.findOptions(traversableContext);
        this.saveSettingsTo(javaExplorerOptions);
    }

    private JavaExplorerOptions findOptions(TraversableContext traversableContext) {
        JavaExplorerOptions javaExplorerOptions = (JavaExplorerOptions)traversableContext.find("JavaExplorerOptions");
        return javaExplorerOptions;
    }

    public void apply(ApplyEvent applyEvent) {
        TraversableContext traversableContext = (TraversableContext)applyEvent.getSource();
        JavaExplorerOptions javaExplorerOptions = this.findOptions(traversableContext);
        JavaExplorerOptionsPanel.applyOptions(javaExplorerOptions);
    }

    public void cancel(ApplyEvent applyEvent) {
    }

    public static void applyOptions(JavaExplorerOptions javaExplorerOptions) {
        JavaExplorer.notifyOptionsChanged();
    }

    protected static boolean isBitSet(int n, int n2) {
        return (n & n2) == n2;
    }

    void loadSettingsFrom(JavaExplorerOptions javaExplorerOptions) {
        int n = javaExplorerOptions.getSortOrder();
        int n2 = javaExplorerOptions.getExpandedFolders();
        boolean bl = JavaExplorerOptionsPanel.isBitSet(n2, 1);
        boolean bl2 = JavaExplorerOptionsPanel.isBitSet(n2, 2);
        boolean bl3 = JavaExplorerOptionsPanel.isBitSet(n2, 4);
        boolean bl4 = JavaExplorerOptionsPanel.isBitSet(n2, 8);
        boolean bl5 = JavaExplorerOptionsPanel.isBitSet(n2, 16);
        boolean bl6 = javaExplorerOptions.getShowAccessIcons();
        this.checkbox_showAccessIcons.setSelected(bl6);
        JRadioButton jRadioButton = null;
        switch (n) {
            case 0: {
                jRadioButton = this.radio_sortNone;
                break;
            }
            case 1: {
                jRadioButton = this.radio_sortAlphabetically;
                break;
            }
            case 3: {
                jRadioButton = this.radio_sortAccess;
                break;
            }
            default: {
                jRadioButton = this.radio_sortType;
            }
        }
        jRadioButton.setSelected(true);
        this.checkbox_expandErrors.setSelected(bl);
        this.checkbox_expandImports.setSelected(bl2);
        this.checkbox_expandPublicClasses.setSelected(bl3);
        this.checkbox_expandPackageClasses.setSelected(bl4);
        this.checkbox_expandInnerClasses.setSelected(bl5);
    }

    void saveSettingsTo(JavaExplorerOptions javaExplorerOptions) throws TraversalException {
        int n = 0;
        if (this.checkbox_expandErrors.isSelected()) {
            n |= 1;
        }
        if (this.checkbox_expandImports.isSelected()) {
            n |= 2;
        }
        if (this.checkbox_expandPublicClasses.isSelected()) {
            n |= 4;
        }
        if (this.checkbox_expandPackageClasses.isSelected()) {
            n |= 8;
        }
        if (this.checkbox_expandInnerClasses.isSelected()) {
            n |= 0x10;
        }
        int n2 = 2;
        if (this.radio_sortNone.isSelected()) {
            n2 = 0;
        } else if (this.radio_sortAlphabetically.isSelected()) {
            n2 = 1;
        } else if (this.radio_sortAccess.isSelected()) {
            n2 = 3;
        }
        boolean bl = this.checkbox_showAccessIcons.isSelected();
        javaExplorerOptions.setSortOrder(n2);
        javaExplorerOptions.setExpandedFolders(n);
        javaExplorerOptions.setShowAccessIcons(bl);
    }

    private void initializeComponent() {
        String string = JavaArb.getString(239);
        JLabel jLabel = new JLabel(string);
        String string2 = JavaArb.getString(240);
        this.radio_sortNone = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.radio_sortNone, (String)string2);
        String string3 = JavaArb.getString(241);
        this.radio_sortAlphabetically = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.radio_sortAlphabetically, (String)string3);
        String string4 = JavaArb.getString(243);
        this.radio_sortAccess = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.radio_sortAccess, (String)string4);
        String string5 = JavaArb.getString(242);
        this.radio_sortType = new JRadioButton();
        ResourceUtils.resButton((AbstractButton)this.radio_sortType, (String)string5);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radio_sortNone);
        buttonGroup.add(this.radio_sortAlphabetically);
        buttonGroup.add(this.radio_sortAccess);
        buttonGroup.add(this.radio_sortType);
        String string6 = JavaArb.getString(244);
        JLabel jLabel2 = new JLabel(string6);
        String string7 = JavaArb.getString(245);
        this.checkbox_expandErrors = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_expandErrors, (String)string7);
        String string8 = JavaArb.getString(246);
        this.checkbox_expandImports = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_expandImports, (String)string8);
        String string9 = JavaArb.getString(247);
        this.checkbox_expandPublicClasses = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_expandPublicClasses, (String)string9);
        String string10 = JavaArb.getString(248);
        this.checkbox_expandPackageClasses = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_expandPackageClasses, (String)string10);
        String string11 = JavaArb.getString(249);
        this.checkbox_expandInnerClasses = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_expandInnerClasses, (String)string11);
        String string12 = JavaArb.getString(250);
        this.checkbox_showAccessIcons = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_showAccessIcons, (String)string12);
        Insets insets = new Insets(2, 5, 2, 5);
        Insets insets2 = new Insets(2, 30, 2, 5);
        Insets insets3 = new Insets(0, 0, 0, 0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel.add((Component)this.radio_sortNone, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel.add((Component)this.radio_sortAlphabetically, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel.add((Component)this.radio_sortType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel.add((Component)this.radio_sortAccess, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel2.add((Component)this.checkbox_expandErrors, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel2.add((Component)this.checkbox_expandImports, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel2.add((Component)this.checkbox_expandPublicClasses, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel2.add((Component)this.checkbox_expandPackageClasses, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel2.add((Component)this.checkbox_expandInnerClasses, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, insets3, 0, 0);
        this.add(jPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, insets3, 0, 0);
        this.add(Box.createVerticalStrut(10), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, insets3, 0, 0);
        this.add(jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 0, insets3, 0, 0);
        this.add(Box.createVerticalStrut(8), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add(this.checkbox_showAccessIcons, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 17, 1, insets3, 0, 0);
        this.add(Box.createGlue(), gridBagConstraints);
    }
}

