/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.explorer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.explorer.JavaExplorer;
import oracle.jdevimpl.java.explorer.JavaExplorerOptions;

public final class JavaFilterOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private JCheckBox checkbox_showErrors;
    private JCheckBox checkbox_showPackage;
    private JCheckBox checkbox_showImports;
    private JCheckBox checkbox_showExtendsImplements;
    private JCheckBox checkbox_showClasses;
    private JCheckBox checkbox_showConstructors;
    private JCheckBox checkbox_showMethods;
    private JCheckBox checkbox_showFields;
    private JCheckBox checkbox_showInnerClasses;
    private JCheckBox checkbox_hidePublic;
    private JCheckBox checkbox_hideProtected;
    private JCheckBox checkbox_hidePrivate;
    private JCheckBox checkbox_hidePackage;
    private JCheckBox checkbox_hideStatic;
    private JCheckBox checkbox_hideInstance;
    private JCheckBox checkbox_hideFinal;

    public JavaFilterOptionsPanel() {
        this.setHelpID("f1_idedidesetjavafilters_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext traversableContext) {
        JavaExplorerOptions javaExplorerOptions = this.findOptions(traversableContext);
        this.loadSettingsFrom(javaExplorerOptions);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        JavaExplorerOptions javaExplorerOptions = this.findOptions(traversableContext);
        this.saveSettingsTo(javaExplorerOptions);
    }

    private JavaExplorerOptions findOptions(TraversableContext traversableContext) {
        JavaExplorerOptions javaExplorerOptions = (JavaExplorerOptions)traversableContext.find("JavaExplorerOptions");
        return javaExplorerOptions;
    }

    public void apply(ApplyEvent applyEvent) {
        TraversableContext traversableContext = (TraversableContext)applyEvent.getSource();
        JavaExplorerOptions javaExplorerOptions = this.findOptions(traversableContext);
        JavaFilterOptionsPanel.applyOptions(javaExplorerOptions);
    }

    public void cancel(ApplyEvent applyEvent) {
    }

    public static void applyOptions(JavaExplorerOptions javaExplorerOptions) {
        JavaExplorer.notifyOptionsChanged();
    }

    protected static boolean isBitSet(int n, int n2) {
        return (n & n2) == n2;
    }

    void loadSettingsFrom(JavaExplorerOptions javaExplorerOptions) {
        int n = javaExplorerOptions.getShowFilter();
        int n2 = javaExplorerOptions.getHideFilter();
        boolean bl = JavaFilterOptionsPanel.isBitSet(n, 1);
        boolean bl2 = JavaFilterOptionsPanel.isBitSet(n, 2);
        boolean bl3 = JavaFilterOptionsPanel.isBitSet(n, 4);
        boolean bl4 = JavaFilterOptionsPanel.isBitSet(n, 8);
        boolean bl5 = JavaFilterOptionsPanel.isBitSet(n, 16);
        boolean bl6 = JavaFilterOptionsPanel.isBitSet(n, 32);
        boolean bl7 = JavaFilterOptionsPanel.isBitSet(n, 128);
        boolean bl8 = JavaFilterOptionsPanel.isBitSet(n, 64);
        boolean bl9 = JavaFilterOptionsPanel.isBitSet(n, 256);
        boolean bl10 = JavaFilterOptionsPanel.isBitSet(n2, 1);
        boolean bl11 = JavaFilterOptionsPanel.isBitSet(n2, 2);
        boolean bl12 = JavaFilterOptionsPanel.isBitSet(n2, 4);
        boolean bl13 = JavaFilterOptionsPanel.isBitSet(n2, 8);
        boolean bl14 = JavaFilterOptionsPanel.isBitSet(n2, 64);
        boolean bl15 = JavaFilterOptionsPanel.isBitSet(n2, 32);
        boolean bl16 = JavaFilterOptionsPanel.isBitSet(n2, 16);
        this.checkbox_showErrors.setSelected(bl);
        this.checkbox_showPackage.setSelected(bl2);
        this.checkbox_showImports.setSelected(bl3);
        this.checkbox_showExtendsImplements.setSelected(bl4);
        this.checkbox_showClasses.setSelected(bl5);
        this.checkbox_showConstructors.setSelected(bl6);
        this.checkbox_showMethods.setSelected(bl7);
        this.checkbox_showFields.setSelected(bl8);
        this.checkbox_showInnerClasses.setSelected(bl9);
        this.checkbox_hidePublic.setSelected(bl10);
        this.checkbox_hideProtected.setSelected(bl11);
        this.checkbox_hidePrivate.setSelected(bl12);
        this.checkbox_hidePackage.setSelected(bl13);
        this.checkbox_hideStatic.setSelected(bl14);
        this.checkbox_hideInstance.setSelected(bl15);
        this.checkbox_hideFinal.setSelected(bl16);
    }

    void saveSettingsTo(JavaExplorerOptions javaExplorerOptions) throws TraversalException {
        int n = 0;
        if (this.checkbox_showErrors.isSelected()) {
            n |= 1;
        }
        if (this.checkbox_showPackage.isSelected()) {
            n |= 2;
        }
        if (this.checkbox_showImports.isSelected()) {
            n |= 4;
        }
        if (this.checkbox_showExtendsImplements.isSelected()) {
            n |= 8;
        }
        if (this.checkbox_showClasses.isSelected()) {
            n |= 0x10;
        }
        if (this.checkbox_showConstructors.isSelected()) {
            n |= 0x20;
        }
        if (this.checkbox_showMethods.isSelected()) {
            n |= 0x80;
        }
        if (this.checkbox_showFields.isSelected()) {
            n |= 0x40;
        }
        if (this.checkbox_showInnerClasses.isSelected()) {
            n |= 0x100;
        }
        int n2 = 0;
        if (this.checkbox_hidePublic.isSelected()) {
            n2 |= 1;
        }
        if (this.checkbox_hideProtected.isSelected()) {
            n2 |= 2;
        }
        if (this.checkbox_hidePrivate.isSelected()) {
            n2 |= 4;
        }
        if (this.checkbox_hidePackage.isSelected()) {
            n2 |= 8;
        }
        if (this.checkbox_hideStatic.isSelected()) {
            n2 |= 0x40;
        }
        if (this.checkbox_hideInstance.isSelected()) {
            n2 |= 0x20;
        }
        if (this.checkbox_hideFinal.isSelected()) {
            n2 |= 0x10;
        }
        javaExplorerOptions.setShowFilter(n);
        javaExplorerOptions.setHideFilter(n2);
    }

    private void initializeComponent() {
        String string = JavaArb.getString(252);
        JWrappedLabel jWrappedLabel = new JWrappedLabel(string);
        String string2 = JavaArb.getString(253);
        this.checkbox_showErrors = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_showErrors, (String)string2);
        String string3 = JavaArb.getString(254);
        this.checkbox_showPackage = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_showPackage, (String)string3);
        String string4 = JavaArb.getString(255);
        this.checkbox_showImports = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_showImports, (String)string4);
        String string5 = JavaArb.getString(256);
        this.checkbox_showExtendsImplements = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_showExtendsImplements, (String)string5);
        String string6 = JavaArb.getString(257);
        this.checkbox_showClasses = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_showClasses, (String)string6);
        String string7 = JavaArb.getString(258);
        this.checkbox_showConstructors = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_showConstructors, (String)string7);
        String string8 = JavaArb.getString(259);
        this.checkbox_showMethods = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_showMethods, (String)string8);
        String string9 = JavaArb.getString(260);
        this.checkbox_showFields = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_showFields, (String)string9);
        String string10 = JavaArb.getString(261);
        this.checkbox_showInnerClasses = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_showInnerClasses, (String)string10);
        String string11 = JavaArb.getString(262);
        JWrappedLabel jWrappedLabel2 = new JWrappedLabel(string11);
        String string12 = JavaArb.getString(263);
        this.checkbox_hidePublic = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_hidePublic, (String)string12);
        String string13 = JavaArb.getString(264);
        this.checkbox_hideProtected = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_hideProtected, (String)string13);
        String string14 = JavaArb.getString(265);
        this.checkbox_hidePrivate = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_hidePrivate, (String)string14);
        String string15 = JavaArb.getString(266);
        this.checkbox_hidePackage = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_hidePackage, (String)string15);
        String string16 = JavaArb.getString(267);
        this.checkbox_hideStatic = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_hideStatic, (String)string16);
        String string17 = JavaArb.getString(268);
        this.checkbox_hideInstance = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_hideInstance, (String)string17);
        String string18 = JavaArb.getString(269);
        this.checkbox_hideFinal = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_hideFinal, (String)string18);
        Insets insets = new Insets(2, 5, 2, 5);
        Insets insets2 = new Insets(2, 30, 2, 5);
        Insets insets3 = new Insets(0, 0, 0, 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 1, insets, 0, 0);
        this.add((Component)jWrappedLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.3, 0.0, 17, 0, insets2, 0, 0);
        this.add(this.checkbox_showErrors, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 0.3, 0.0, 17, 0, insets2, 0, 0);
        this.add(this.checkbox_showPackage, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 1, 1, 0.3, 0.0, 17, 0, insets2, 0, 0);
        this.add(this.checkbox_showImports, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 4, 1, 1, 0.3, 0.0, 17, 0, insets2, 0, 0);
        this.add(this.checkbox_showExtendsImplements, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 5, 1, 1, 0.3, 0.0, 17, 0, insets2, 0, 0);
        this.add(this.checkbox_showClasses, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 1, 1, 1, 0.7, 0.0, 17, 0, insets, 0, 0);
        this.add(this.checkbox_showConstructors, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 2, 1, 1, 0.7, 0.0, 17, 0, insets, 0, 0);
        this.add(this.checkbox_showMethods, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 3, 1, 1, 0.7, 0.0, 17, 0, insets, 0, 0);
        this.add(this.checkbox_showFields, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 4, 1, 1, 0.7, 0.0, 17, 0, insets, 0, 0);
        this.add(this.checkbox_showInnerClasses, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 17, 0, insets3, 0, 0);
        this.add(Box.createVerticalStrut(10), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 17, 1, insets, 0, 0);
        this.add((Component)jWrappedLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 7, 1, 1, 0.3, 0.0, 17, 0, insets2, 0, 0);
        this.add(this.checkbox_hidePublic, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 8, 1, 1, 0.3, 0.0, 17, 0, insets2, 0, 0);
        this.add(this.checkbox_hideProtected, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 9, 1, 1, 0.3, 0.0, 17, 0, insets2, 0, 0);
        this.add(this.checkbox_hidePrivate, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 10, 1, 1, 0.3, 0.0, 17, 0, insets2, 0, 0);
        this.add(this.checkbox_hidePackage, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 7, 1, 1, 0.7, 0.0, 17, 0, insets, 0, 0);
        this.add(this.checkbox_hideInstance, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 8, 1, 1, 0.7, 0.0, 17, 0, insets, 0, 0);
        this.add(this.checkbox_hideStatic, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 9, 1, 1, 0.7, 0.0, 17, 0, insets, 0, 0);
        this.add(this.checkbox_hideFinal, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 11, 2, 1, 1.0, 1.0, 17, 1, insets3, 0, 0);
        this.add(Box.createGlue(), gridBagConstraints);
    }
}

