/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.explorer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListModel;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.ReorderableListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.explorer.JavaExplorer;
import oracle.jdevimpl.java.explorer.JavaExplorerOptions;

public final class JavaGroupOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private Shuttle shuttle_groups;
    private JList list_available;
    private JList list_selected;
    private String group_staticInstance;
    private String group_access;
    private String group_type;
    private JCheckBox checkbox_expandConstructors;
    private JCheckBox checkbox_expandMethods;
    private JCheckBox checkbox_expandFields;
    private JCheckBox checkbox_expandInnerClasses;
    private JCheckBox checkbox_expandPublic;
    private JCheckBox checkbox_expandProtected;
    private JCheckBox checkbox_expandPrivate;
    private JCheckBox checkbox_expandPackage;
    private JCheckBox checkbox_expandStatic;
    private JCheckBox checkbox_expandInstance;
    private int[] lastGroupOrder;

    public JavaGroupOptionsPanel() {
        this.$init$();
        this.setHelpID("f1_idedidesetjavagroups_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext traversableContext) {
        JavaExplorerOptions javaExplorerOptions = this.findOptions(traversableContext);
        this.loadSettingsFrom(javaExplorerOptions);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        JavaExplorerOptions javaExplorerOptions = this.findOptions(traversableContext);
        this.saveSettingsTo(javaExplorerOptions);
    }

    private JavaExplorerOptions findOptions(TraversableContext traversableContext) {
        JavaExplorerOptions javaExplorerOptions = (JavaExplorerOptions)traversableContext.find("JavaExplorerOptions");
        return javaExplorerOptions;
    }

    public void apply(ApplyEvent applyEvent) {
        TraversableContext traversableContext = (TraversableContext)applyEvent.getSource();
        JavaExplorerOptions javaExplorerOptions = this.findOptions(traversableContext);
        JavaGroupOptionsPanel.applyOptions(javaExplorerOptions);
    }

    public void cancel(ApplyEvent applyEvent) {
    }

    public static void applyOptions(JavaExplorerOptions javaExplorerOptions) {
        JavaExplorer.notifyOptionsChanged();
    }

    protected static boolean isBitSet(int n, int n2) {
        return (n & n2) == n2;
    }

    void loadSettingsFrom(JavaExplorerOptions javaExplorerOptions) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        boolean bl7;
        boolean bl8;
        boolean bl9;
        boolean bl10;
        block6: {
            int n = javaExplorerOptions.getExpandedGroups();
            bl10 = JavaGroupOptionsPanel.isBitSet(n, 256);
            bl9 = JavaGroupOptionsPanel.isBitSet(n, 512);
            bl8 = JavaGroupOptionsPanel.isBitSet(n, 1024);
            bl7 = JavaGroupOptionsPanel.isBitSet(n, 2048);
            bl6 = JavaGroupOptionsPanel.isBitSet(n, 16);
            bl5 = JavaGroupOptionsPanel.isBitSet(n, 32);
            bl4 = JavaGroupOptionsPanel.isBitSet(n, 64);
            bl3 = JavaGroupOptionsPanel.isBitSet(n, 128);
            bl2 = JavaGroupOptionsPanel.isBitSet(n, 1);
            bl = JavaGroupOptionsPanel.isBitSet(n, 2);
            int[] nArray = javaExplorerOptions.getGroupOrder();
            if (this.matchingGroups(nArray, this.lastGroupOrder)) break block6;
            DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
            defaultListModel.addElement(this.group_access);
            defaultListModel.addElement(this.group_type);
            defaultListModel.addElement(this.group_staticInstance);
            DefaultListModel<String> defaultListModel2 = new DefaultListModel<String>();
            int n2 = nArray != null ? nArray.length : 0;
            int n3 = 0;
            while (n3 < n2) {
                block7: {
                    int n4 = nArray[n3];
                    String string = null;
                    switch (n4) {
                        case 3: {
                            string = this.group_access;
                            break;
                        }
                        case 2: {
                            string = this.group_type;
                            break;
                        }
                        case 1: {
                            string = this.group_staticInstance;
                            break;
                        }
                        default: {
                            break block7;
                        }
                    }
                    defaultListModel.removeElement(string);
                    defaultListModel2.addElement(string);
                }
                ++n3;
            }
            this.list_available.setModel(defaultListModel);
            this.list_selected.setModel(defaultListModel2);
            this.lastGroupOrder = nArray;
            this.shuttle_groups.setEnabled(true);
        }
        this.checkbox_expandConstructors.setSelected(bl10);
        this.checkbox_expandMethods.setSelected(bl9);
        this.checkbox_expandFields.setSelected(bl8);
        this.checkbox_expandInnerClasses.setSelected(bl7);
        this.checkbox_expandPublic.setSelected(bl6);
        this.checkbox_expandProtected.setSelected(bl5);
        this.checkbox_expandPrivate.setSelected(bl4);
        this.checkbox_expandPackage.setSelected(bl3);
        this.checkbox_expandStatic.setSelected(bl2);
        this.checkbox_expandInstance.setSelected(bl);
    }

    private boolean matchingGroups(int[] nArray, int[] nArray2) {
        int n;
        int n2 = nArray != null ? nArray.length : 0;
        int n3 = n = nArray2 != null ? nArray2.length : 0;
        if (n2 != n) {
            return false;
        }
        int n4 = 0;
        while (n4 < n2) {
            if (nArray[n4] != nArray2[n4]) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    void saveSettingsTo(JavaExplorerOptions javaExplorerOptions) throws TraversalException {
        int n = 0;
        if (this.checkbox_expandConstructors.isSelected()) {
            n |= 0x100;
        }
        if (this.checkbox_expandMethods.isSelected()) {
            n |= 0x200;
        }
        if (this.checkbox_expandFields.isSelected()) {
            n |= 0x400;
        }
        if (this.checkbox_expandInnerClasses.isSelected()) {
            n |= 0x800;
        }
        if (this.checkbox_expandPublic.isSelected()) {
            n |= 0x10;
        }
        if (this.checkbox_expandProtected.isSelected()) {
            n |= 0x20;
        }
        if (this.checkbox_expandPrivate.isSelected()) {
            n |= 0x40;
        }
        if (this.checkbox_expandPackage.isSelected()) {
            n |= 0x80;
        }
        if (this.checkbox_expandStatic.isSelected()) {
            n |= 1;
        }
        if (this.checkbox_expandInstance.isSelected()) {
            n |= 2;
        }
        ListModel listModel = this.list_selected.getModel();
        int n2 = listModel.getSize();
        int[] nArray = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            Object e = listModel.getElementAt(n3);
            if (e == this.group_access) {
                nArray[n3] = 3;
            } else if (e == this.group_staticInstance) {
                nArray[n3] = 1;
            } else if (e == this.group_type) {
                nArray[n3] = 2;
            } else {
                throw new IllegalStateException("unknown group: " + e.toString());
            }
            ++n3;
        }
        javaExplorerOptions.setExpandedGroups(n);
        javaExplorerOptions.setGroupOrder(nArray);
    }

    private void initializeComponent() {
        String string = JavaArb.getString(277);
        JLabel jLabel = new JLabel(string);
        String string2 = JavaArb.getString(282);
        this.checkbox_expandConstructors = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_expandConstructors, (String)string2);
        String string3 = JavaArb.getString(283);
        this.checkbox_expandMethods = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_expandMethods, (String)string3);
        String string4 = JavaArb.getString(284);
        this.checkbox_expandFields = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_expandFields, (String)string4);
        String string5 = JavaArb.getString(285);
        this.checkbox_expandInnerClasses = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_expandInnerClasses, (String)string5);
        String string6 = JavaArb.getString(278);
        this.checkbox_expandPublic = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_expandPublic, (String)string6);
        String string7 = JavaArb.getString(279);
        this.checkbox_expandProtected = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_expandProtected, (String)string7);
        String string8 = JavaArb.getString(280);
        this.checkbox_expandPrivate = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_expandPrivate, (String)string8);
        String string9 = JavaArb.getString(281);
        this.checkbox_expandPackage = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_expandPackage, (String)string9);
        String string10 = JavaArb.getString(287);
        this.checkbox_expandStatic = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_expandStatic, (String)string10);
        String string11 = JavaArb.getString(286);
        this.checkbox_expandInstance = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_expandInstance, (String)string11);
        String string12 = JavaArb.getString(271);
        JMultiLineLabel jMultiLineLabel = new JMultiLineLabel(string12);
        jMultiLineLabel.setMinimumRows(2);
        this.group_access = JavaArb.getString(274);
        this.group_type = JavaArb.getString(275);
        this.group_staticInstance = JavaArb.getString(276);
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        defaultListModel.addElement(this.group_access);
        defaultListModel.addElement(this.group_type);
        defaultListModel.addElement(this.group_staticInstance);
        String string13 = JavaArb.getString(272);
        JLabel jLabel2 = new JLabel();
        this.list_available = new JList(defaultListModel);
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.list_available, (String)string13);
        String string14 = JavaArb.getString(273);
        JLabel jLabel3 = new JLabel();
        this.list_selected = new JList();
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this.list_selected, (String)string14);
        ListPicker listPicker = new ListPicker(this.list_available);
        listPicker.setItemsSorted(true);
        ReorderableListPicker reorderableListPicker = new ReorderableListPicker(this.list_selected);
        this.shuttle_groups = new Shuttle();
        this.shuttle_groups.setFromPicker((ItemPicker)listPicker);
        this.shuttle_groups.setToPicker((ItemPicker)reorderableListPicker);
        this.shuttle_groups.add((Component)jLabel2, (Object)"FromHeader");
        this.shuttle_groups.add((Component)jLabel3, (Object)"ToHeader");
        this.shuttle_groups.setNextFocusableComponent((Component)this.checkbox_expandConstructors);
        Insets insets = new Insets(2, 5, 2, 5);
        Insets insets2 = new Insets(2, 30, 2, 5);
        Insets insets3 = new Insets(0, 0, 0, 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 1, insets, 0, 0);
        this.add((Component)jMultiLineLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add(Box.createVerticalStrut(5), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 17, 2, insets, 0, 0);
        this.add((Component)this.shuttle_groups, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add(Box.createVerticalStrut(10), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add(jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 5, 1, 1, 0.2, 0.0, 17, 0, insets2, 0, 0);
        this.add(this.checkbox_expandConstructors, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 6, 1, 1, 0.2, 0.0, 17, 0, insets2, 0, 0);
        this.add(this.checkbox_expandMethods, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 7, 1, 1, 0.2, 0.0, 17, 0, insets2, 0, 0);
        this.add(this.checkbox_expandFields, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 8, 1, 1, 0.2, 0.0, 17, 0, insets2, 0, 0);
        this.add(this.checkbox_expandInnerClasses, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 5, 1, 1, 0.2, 0.0, 17, 0, insets, 0, 0);
        this.add(this.checkbox_expandPublic, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 6, 1, 1, 0.2, 0.0, 17, 0, insets, 0, 0);
        this.add(this.checkbox_expandProtected, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 7, 1, 1, 0.2, 0.0, 17, 0, insets, 0, 0);
        this.add(this.checkbox_expandPrivate, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 8, 1, 1, 0.2, 0.0, 17, 0, insets, 0, 0);
        this.add(this.checkbox_expandPackage, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(2, 5, 1, 1, 0.6, 0.0, 17, 0, insets, 0, 0);
        this.add(this.checkbox_expandInstance, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(2, 6, 1, 1, 0.6, 0.0, 17, 0, insets, 0, 0);
        this.add(this.checkbox_expandStatic, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(2, 7, 1, 2, 0.6, 0.0, 17, 1, insets, 0, 0);
        this.add(Box.createGlue(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 9, 3, 1, 1.0, 1.0, 17, 1, insets3, 0, 0);
        this.add(Box.createGlue(), gridBagConstraints);
    }

    void $init$() {
        this.lastGroupOrder = null;
    }
}

