/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.explorer;

import java.util.ArrayList;
import java.util.Collections;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceError;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.jdevimpl.java.explorer.ClassElement;
import oracle.jdevimpl.java.explorer.ErrorFolder;
import oracle.jdevimpl.java.explorer.FolderElement;
import oracle.jdevimpl.java.explorer.ImportFolder;
import oracle.jdevimpl.java.explorer.JavaCodeElement;
import oracle.jdevimpl.java.explorer.JavaExplorerOptions;
import oracle.jdevimpl.java.explorer.LeafElement;
import oracle.jdevimpl.java.explorer.LeafElementComparator;
import oracle.jdevimpl.java.explorer.PackageElement;

public final class JavaRootFolder
extends FolderElement {
    JavaRootFolder(SourceFile sourceFile, JavaExplorerOptions javaExplorerOptions) {
        super("Java Root", "Java Root", null);
        LeafElement[] leafElementArray = this.buildChildren(sourceFile, javaExplorerOptions);
        this.setChildren(leafElementArray);
        this.setExpandedDefault(true);
    }

    protected LeafElement[] buildChildren(SourceFile sourceFile, JavaExplorerOptions javaExplorerOptions) {
        if (sourceFile == null) {
            return new LeafElement[0];
        }
        int n = javaExplorerOptions.getShowFilter();
        boolean bl = JavaCodeElement.isBitSet(n, 1);
        boolean bl2 = JavaCodeElement.isBitSet(n, 2);
        boolean bl3 = JavaCodeElement.isBitSet(n, 4);
        boolean bl4 = JavaCodeElement.isBitSet(n, 16);
        boolean bl5 = javaExplorerOptions.getSortOrder() != 0;
        LeafElementComparator leafElementComparator = bl5 ? new LeafElementComparator() : null;
        SourcePackage sourcePackage = sourceFile.getSourcePackage();
        String string = JavaCodeElement.getName((SourceHasName)sourcePackage);
        if (string != null && string.length() == 0) {
            string = null;
        }
        ArrayList<FolderElement> arrayList = new ArrayList<FolderElement>();
        if (bl4) {
            for (SourceClass sourceClass : sourceFile.getSourceClasses()) {
                if (sourceClass == null) continue;
                ClassElement classElement = new ClassElement(sourceClass, javaExplorerOptions);
                classElement.setPackageName(string);
                arrayList.add(classElement);
            }
            if (leafElementComparator != null) {
                Collections.sort(arrayList, leafElementComparator);
            }
        }
        if (bl3) {
            int n2;
            SourceImport[] sourceImportArray = sourceFile.getSourceImports().toArray(SourceImport.EMPTY_ARRAY);
            int n3 = n2 = sourceImportArray != null ? sourceImportArray.length : 0;
            if (n2 > 0) {
                ImportFolder importFolder = new ImportFolder(sourceImportArray, javaExplorerOptions);
                arrayList.add(0, importFolder);
            }
        }
        if (bl2 && string != null) {
            PackageElement packageElement = new PackageElement(sourcePackage);
            arrayList.add(0, packageElement);
        }
        if (bl) {
            int n4;
            SourceError[] sourceErrorArray = sourceFile.getParseErrors().toArray(SourceError.EMPTY_ARRAY);
            int n5 = n4 = sourceErrorArray != null ? sourceErrorArray.length : 0;
            if (n4 > 0) {
                ErrorFolder errorFolder = new ErrorFolder(sourceErrorArray, javaExplorerOptions);
                arrayList.add(0, errorFolder);
            }
        }
        int n6 = arrayList.size();
        return arrayList.toArray(new LeafElement[n6]);
    }
}

