/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.explorer;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public final class SideBySideIcon
implements Icon {
    private Icon leftIcon;
    private Icon rightIcon;
    private int padding;
    private static final int DEFAULT_PADDING = 2;

    public SideBySideIcon(Icon icon, Icon icon2) {
        this(icon, icon2, 2);
    }

    public SideBySideIcon(Icon icon, Icon icon2, int n) {
        this.leftIcon = icon;
        this.rightIcon = icon2;
        this.padding = n;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        int n3 = this.getIconHeight();
        if (this.leftIcon != null) {
            int n4 = (n3 - this.leftIcon.getIconHeight()) / 2;
            this.leftIcon.paintIcon(component, graphics, n, n2 + n4);
            n += this.getMiddlePadding() + this.leftIcon.getIconWidth();
        }
        if (this.rightIcon != null) {
            int n5 = (n3 - this.rightIcon.getIconHeight()) / 2;
            this.rightIcon.paintIcon(component, graphics, n, n2 + n5);
        }
    }

    private int getMiddlePadding() {
        boolean bl = this.leftIcon == null || this.rightIcon == null;
        return bl ? 0 : this.padding;
    }

    public int getIconWidth() {
        int n = this.getMiddlePadding();
        if (this.leftIcon != null) {
            n += this.leftIcon.getIconWidth();
        }
        if (this.rightIcon != null) {
            n += this.rightIcon.getIconWidth();
        }
        return n;
    }

    public int getIconHeight() {
        int n = 0;
        if (this.leftIcon != null) {
            n = this.leftIcon.getIconHeight();
        }
        if (this.rightIcon != null) {
            n = Math.max(n, this.rightIcon.getIconHeight());
        }
        return n;
    }
}

